/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class GtyYnApiUtil {
    @Autowired
    private RedisTemplate redisTemplate;
    @Value(value="${gty.yn.url:''}")
    public String gtyUrl;
    @Value(value="${gty.yn.appKey:''}")
    private String appKey;
    @Value(value="${gty.yn.appSecret:''}")
    private String appSecret;
    @Value(value="${gty.yn.projectId.lx:20240600000000006}")
    private Long projectIdLx;
    @Value(value="${gty.yn.projectId.ys:20241200000000001}")
    private Long projectIdYs;
    @Value(value="${gty.yn.download.url:''}")
    public String downloadUrl;
    @Value(value="${gty.yn.download.userKey:dk_dev:dk_dev@123}")
    public String downloadUserKey;
    @Value(value="${gty.yn.download.index:survey-paas-file}")
    public String downloadIndex;

    public String httpGetToken() {
        BoundValueOperations ops = this.redisTemplate.boundValueOps((Object)"gty-yn-token");
        if (ops.get() != null) {
            return (String)ops.get();
        }
        HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put("appKey", GtyYnApiUtil.this.appKey);
                this.put("appSecret", GtyYnApiUtil.this.appSecret);
            }
        };
        HttpRequest request = this.createHttp("/jw/zbph/token", Method.POST, null);
        request.body(JSON.toJSONString((Object)map));
        JSONObject result = this.getResult(request.execute());
        String token = result.getString("token");
        Long expireTime = result.getLong("expireTime");
        Long nowTime = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        Long times = expireTime - nowTime;
        if (times < 0L) {
            return token;
        }
        ops.set((Object)token);
        ops.expire(times - 5000L, TimeUnit.MILLISECONDS);
        return token;
    }

    public String httpPushGty(File file, String type) {
        HttpRequest request = this.createHttp("/jw/zbph/upload-file", Method.POST, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("token", GtyYnApiUtil.this.httpGetToken());
            }
        });
        request.form("file", file);
        request.form("projectId", (Object)(type.equals(XmxxType.LX.type) ? this.projectIdLx : this.projectIdYs));
        JSONObject result = this.getResult(request.execute());
        return result.getString("id");
    }

    public JSONObject httpGetInfo(String logId) {
        String path = String.format("/jw/zbph/upload/info/%s", logId);
        HttpRequest request = this.createHttp(path, Method.GET, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("token", GtyYnApiUtil.this.httpGetToken());
            }
        });
        return this.getResult(request.execute());
    }

    public JSONArray httpGetFj(String logId, String bsm, String type) {
        String path = String.format("/jw/zbph/survey/files/%s/%s/%s", logId, bsm, type.equals(XmxxType.LX.type) ? this.projectIdLx : this.projectIdYs);
        HttpRequest request = this.createHttp(path, Method.GET, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("token", GtyYnApiUtil.this.httpGetToken());
            }
        });
        return this.getResultArray(request.execute());
    }

    public JSONArray httpGetSuccess(String logId, String type) {
        String path = String.format("/jw/zbph/self-check/%s/%s", type.equals(XmxxType.LX.type) ? this.projectIdLx : this.projectIdYs, logId);
        HttpRequest request = this.createHttp(path, Method.GET, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("token", GtyYnApiUtil.this.httpGetToken());
            }
        });
        return this.getResultArray(request.execute());
    }

    private HttpRequest createHttp(String path, Method method, Map<String, String> headers) {
        HttpRequest request = HttpUtil.createRequest((Method)method, (String)(this.gtyUrl + path));
        if (headers != null) {
            request.addHeaders(headers);
        }
        return request;
    }

    private JSONObject getResult(HttpResponse execute) {
        if (execute.getStatus() != 200) {
            throw new RuntimeException("\u4e13\u9879\u76d1\u7ba1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + execute.body());
        }
        JSONObject object = JSON.parseObject((String)execute.body());
        if (object.getIntValue("code") != 200) {
            throw new RuntimeException("\u4e13\u9879\u76d1\u7ba1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + object.getString("msg"));
        }
        return object.getJSONObject("data");
    }

    private JSONArray getResultArray(HttpResponse execute) {
        if (execute.getStatus() != 200) {
            throw new RuntimeException("\u4e13\u9879\u76d1\u7ba1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + execute.body());
        }
        JSONObject object = JSON.parseObject((String)execute.body());
        if (object.getIntValue("code") != 200) {
            throw new RuntimeException("\u4e13\u9879\u76d1\u7ba1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + object.getString("msg"));
        }
        return object.getJSONArray("data");
    }
}

