/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PFWHUtil {
    private static final Pattern PFWH_PATTERN = Pattern.compile("^([^ \u3014\u3015]+)\u3014(\\d{4})\u3015([^\u3014\u3015]+)$");

    public static ValidationResult validate(String pfwh, Integer year) {
        int approvalYear;
        if (pfwh == null || pfwh.trim().isEmpty()) {
            return new ValidationResult(false, "\u6279\u590d\u6587\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Matcher matcher = PFWH_PATTERN.matcher(pfwh);
        if (!matcher.find()) {
            return new ValidationResult(false, "\u6279\u590d\u6587\u53f7\u683c\u5f0f\u4e0d\u7b26\u5408***\u3014\u5e74\u4efd\u3015***\u8981\u6c42");
        }
        try {
            approvalYear = Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException e) {
            return new ValidationResult(false, "\u6279\u590d\u6587\u53f7\u4e2d\u7684\u5e74\u4efd\u683c\u5f0f\u65e0\u6548");
        }
        if (approvalYear < 1900 || approvalYear > 2099) {
            return new ValidationResult(false, "\u6279\u590d\u6587\u53f7\u4e2d\u7684\u5e74\u4efd\u8d85\u51fa\u6709\u6548\u8303\u56f4\uff081900-2099\uff09");
        }
        if (year != null && approvalYear != year) {
            return new ValidationResult(false, String.format(" \u6279\u590d\u6587\u53f7\u4e2d\u7684\u5e74\u4efd%d\u4e0e\u9879\u76ee\u5e74\u4efd%d\u4e0d\u4e00\u81f4", approvalYear, year));
        }
        return new ValidationResult(true, "\u6821\u9a8c\u901a\u8fc7");
    }

    public static class ValidationResult {
        private final boolean valid;
        private final String message;

        public ValidationResult(boolean valid, String message) {
            this.valid = valid;
            this.message = message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValidationResult)) {
                return false;
            }
            ValidationResult other = (ValidationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isValid() != other.isValid()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValidationResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isValid() ? 79 : 97);
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "PFWHUtil.ValidationResult(valid=" + this.isValid() + ", message=" + this.getMessage() + ")";
        }
    }
}

