/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import cn.hutool.core.io.FileUtil;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PdfManageUtil {
    public static String uploadDir;
    public static String templateDir;

    @Value(value="${project.uploadDir:''}")
    public void setUploadDir(String uploadDir) {
        PdfManageUtil.uploadDir = uploadDir;
    }

    @Value(value="${project.templateDir:''}")
    public void setTemplateDir(String templateDir) {
        PdfManageUtil.templateDir = templateDir;
    }

    public static String fillPdf(Map<String, String> map, String fileName, String pdfPath, String tempName) {
        if (map.size() < 1) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new RuntimeException("\u6587\u4ef6\u547d\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)pdfPath)) {
            pdfPath = templateDir + File.separator + "pdf" + File.separator + "pdf\u9ed8\u8ba4\u6a21\u677f.pdf";
        }
        if (StringUtils.isNotEmpty((CharSequence)tempName)) {
            pdfPath = templateDir + File.separator + "pdf" + File.separator + tempName + ".pdf";
        }
        String outPath = uploadDir + File.separator + "pdf" + File.separator + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + File.separator + "\u8865\u5145\u8015\u5730\u4fe1\u606f\u786e\u8ba4\u5355-" + fileName + ".pdf";
        try {
            if (FileUtil.exist((String)outPath)) {
                return outPath;
            }
            File file = new File(outPath);
            File parentFile = file.getParentFile();
            if (!FileUtil.exist((File)parentFile)) {
                parentFile.mkdirs();
            }
            if (!FileUtil.exist((File)file)) {
                file = FileUtil.file((String)outPath);
            }
            BaseFont bf = BaseFont.createFont((String)(templateDir + File.separator + "pdf" + File.separator + "font.ttf"), (String)"Identity-H", (boolean)true);
            PdfReader pdfReader = new PdfReader(pdfPath);
            PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(file));
            AcroFields formFields = pdfStamper.getAcroFields();
            ArrayList<BaseFont> fontList = new ArrayList<BaseFont>(1);
            fontList.add(bf);
            formFields.setSubstitutionFonts(fontList);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                formFields.setField(entry.getKey(), entry.getValue());
            }
            pdfStamper.setFormFlattening(true);
            pdfStamper.close();
            pdfReader.close();
        }
        catch (Exception e) {
            throw new RuntimeException("PDF\u586b\u5145\u5931\u8d25\uff1a" + e.getMessage());
        }
        return outPath;
    }

    public static String fillImage(String pdfPath, String imgPath) {
        Path pdf = Paths.get(pdfPath, new String[0]);
        Path simple = Paths.get(pdfPath, new String[0]);
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(pdf, new OpenOption[0]));){
            PdfReader reader = new PdfReader(IOUtils.toByteArray((InputStream)is));
            PdfStamper stamper = new PdfStamper(reader, Files.newOutputStream(simple, new OpenOption[0]));
            stamper.setFormFlattening(true);
            Image image = Image.getInstance((String)imgPath);
            PdfContentByte contentByte = stamper.getOverContent(1);
            Rectangle pageSize = reader.getPageSize(1);
            image.setAbsolutePosition(pageSize.getRight() - 220.0f, pageSize.getTop() - 100.0f);
            image.scalePercent(15.0f);
            BufferedImage bufferedImage = ImageIO.read(new FileInputStream(imgPath));
            image.scaleAbsolute((float)bufferedImage.getWidth(), (float)bufferedImage.getHeight());
            contentByte.addImage(image);
            stamper.flush();
            stamper.close();
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return "";
    }
}

