/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.biz.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import javax.measure.unit.Unit;
import org.geotools.referencing.CRS;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Projection;

public class GeoUtil {
    public static CoordinateReferenceSystem createCRSByPrjFile(String filePath) {
        String prjFilePath = filePath.replace(".shp", ".prj");
        String wkt = GeoUtil.txt2String(new File(prjFilePath));
        String wkt2 = wkt.replaceAll("[',']+", ",").replaceAll(",]", "]");
        String[] split = wkt2.split("PARAMETER");
        ArrayList<String> params = new ArrayList<String>();
        for (String par : split) {
            if (par.contains("standard_parallel")) continue;
            params.add(par);
        }
        wkt2 = String.join((CharSequence)"PARAMETER", params);
        System.out.println(wkt2);
        CoordinateReferenceSystem sCRS = null;
        try {
            sCRS = CRS.parseWKT((String)wkt2);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        return sCRS;
    }

    public static String txt2String(File file) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String s = null;
            while ((s = br.readLine()) != null) {
                result.append(s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static Boolean isEqual(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        if (crs1 == null && crs2 == null) {
            return true;
        }
        if (crs1 == null || crs2 == null) {
            return false;
        }
        if (crs1 instanceof GeographicCRS && crs2 instanceof GeographicCRS) {
            GeographicCRS gcs1 = (GeographicCRS)crs1;
            GeographicCRS gcs2 = (GeographicCRS)crs2;
            return GeoUtil.isEqual(gcs1, gcs2);
        }
        if (crs1 instanceof ProjectedCRS && crs2 instanceof ProjectedCRS) {
            GeographicCRS gcs2;
            ProjectedCRS pcs1 = (ProjectedCRS)crs1;
            ProjectedCRS pcs2 = (ProjectedCRS)crs2;
            GeographicCRS gcs1 = pcs1.getBaseCRS();
            if (!GeoUtil.isEqual(gcs1, gcs2 = pcs2.getBaseCRS()).booleanValue()) {
                return false;
            }
            Projection p1 = pcs1.getConversionFromBase();
            Projection p2 = pcs2.getConversionFromBase();
            return GeoUtil.isEqual(p1, p2);
        }
        return CRS.equalsIgnoreMetadata((Object)crs1, (Object)crs2);
    }

    public static Boolean isEqual(Projection p1, Projection p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        ParameterValueGroup pv1 = p1.getParameterValues();
        ParameterValueGroup pv2 = p2.getParameterValues();
        try {
            if (!GeoUtil.isEqual(pv1.parameter("semi_major").doubleValue(), pv2.parameter("semi_major").doubleValue()).booleanValue()) {
                return false;
            }
            if (!GeoUtil.isEqual(pv1.parameter("semi_minor").doubleValue(), pv2.parameter("semi_minor").doubleValue()).booleanValue()) {
                return false;
            }
            if (!GeoUtil.isEqual(pv1.parameter("central_meridian").doubleValue(), pv2.parameter("central_meridian").doubleValue()).booleanValue()) {
                return false;
            }
            if (!GeoUtil.isEqual(pv1.parameter("latitude_of_origin").doubleValue(), pv2.parameter("latitude_of_origin").doubleValue()).booleanValue()) {
                return false;
            }
            if (!GeoUtil.isEqual(pv1.parameter("scale_factor").doubleValue(), pv2.parameter("scale_factor").doubleValue()).booleanValue()) {
                return false;
            }
            if (!GeoUtil.isEqual(pv1.parameter("false_easting").doubleValue(), pv2.parameter("false_easting").doubleValue()).booleanValue()) {
                return false;
            }
            if (!GeoUtil.isEqual(pv1.parameter("false_northing").doubleValue(), pv2.parameter("false_northing").doubleValue()).booleanValue()) {
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Boolean isEqual(GeographicCRS gcs1, GeographicCRS gcs2) {
        if (gcs1 == null && gcs2 == null) {
            return true;
        }
        if (gcs1 == null || gcs2 == null) {
            return false;
        }
        GeodeticDatum datum1 = gcs1.getDatum();
        GeodeticDatum datum2 = gcs2.getDatum();
        return GeoUtil.isEqual(datum1, datum2);
    }

    public static Boolean isEqual(GeodeticDatum datum1, GeodeticDatum datum2) {
        if (datum1 == null && datum2 == null) {
            return true;
        }
        if (datum1 == null || datum2 == null) {
            return false;
        }
        Unit units1 = datum1.getEllipsoid().getAxisUnit();
        Unit units2 = datum1.getEllipsoid().getAxisUnit();
        if (units1.getDimension() != units2.getDimension()) {
            return false;
        }
        Ellipsoid e1 = datum1.getEllipsoid();
        Ellipsoid e2 = datum2.getEllipsoid();
        if (e1.getInverseFlattening() != e2.getInverseFlattening()) {
            return false;
        }
        if (!GeoUtil.isEqual(e1.getSemiMajorAxis(), e2.getSemiMajorAxis()).booleanValue()) {
            return false;
        }
        if (!GeoUtil.isEqual(e1.getSemiMinorAxis(), e2.getSemiMinorAxis()).booleanValue()) {
            return false;
        }
        PrimeMeridian p1 = datum1.getPrimeMeridian();
        PrimeMeridian p2 = datum2.getPrimeMeridian();
        if (p1.getAngularUnit().getDimension() != p2.getAngularUnit().getDimension()) {
            return false;
        }
        return GeoUtil.isEqual(p1.getGreenwichLongitude(), p2.getGreenwichLongitude());
    }

    public static Boolean isEqual(double d1, double d2, double tolerance) {
        return Math.abs(d1 - d2) <= tolerance;
    }

    public static Boolean isEqual(double d1, double d2) {
        return GeoUtil.isEqual(d1, d2, 1.0E-10);
    }
}

