/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.constant;

import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.stxf.utils.ShpUtils;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LandShpParser {
    public static JSONObject parse(String shpPath) {
        JSONObject result = new JSONObject();
        try {
            List<Map<String, Object>> shpInfo = ShpUtils.getShpGCSProperties(shpPath);
            int cordCount = 0;
            WKTReader wktReader = new WKTReader();
            ArrayList rows = new ArrayList();
            for (Map<String, Object> map : shpInfo) {
                HashMap<String, Object> gd = new HashMap<String, Object>();
                gd.put("f_dikuai_no", map.get("DIKUAI_NO"));
                gd.put("f_pl_name", map.get("PL_NAME"));
                gd.put("f_dikuai_area", map.get("DIKUAIAREA"));
                gd.put("f_purpose", map.get("PURPOSE"));
                gd.put("f_map_no", map.get("MAP_NO"));
                gd.put("f_patchtype", map.get("PATCHTYPE"));
                gd.put("f_landtype", map.get("LANDTYPE"));
                gd.put("f_avggrade1", map.get("AVGGRADE1"));
                gd.put("f_avggrade2", map.get("AVGGRADE2"));
                gd.put("f_shp_name", new File(shpPath).getName());
                gd.put("f_shap", map.get("the_geom").toString());
                rows.add(gd);
                Geometry geometry = wktReader.read(map.get("the_geom").toString());
                int np = geometry.getNumPoints();
                cordCount += np;
            }
            Map<String, Object> crs = ShpUtils.getShpCRSInfo(shpPath);
            result.put("dkzb", rows);
            result.put("spatialInfo", crs);
            result.put("cordCount", (Object)cordCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

