/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.stxf.dto.TaskStatDTO;
import com.geoway.onemap.stxf.dto.TaskXmxxDTO;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.supoort.GeoserverUtil;
import com.geoway.zhgd.dao.ProjectGdbhCbbcgdYjkRepository;
import com.geoway.zhgd.dao.VerifyTaskDao;
import com.geoway.zhgd.domain.VerifyTask;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class VerifyTaskService {
    @Value(value="${project.verify.default:true}")
    private Boolean verifyDefault;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private VerifyTaskDao verifyTaskDao;
    @Autowired
    private ProjectGdbhCbbcgdYjkRepository yjkRepository;
    @Autowired
    private ModelManageService modelManageService;
    @Autowired
    private GeoserverUtil geoserverUtil;

    public Object queryResult(String projectId, String type, String limitType, Boolean result, Integer verify) {
        VerifyTask task = this.verifyTaskDao.findByPidAndType(projectId, type);
        if (task == null) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4efb\u52a1");
        }
        String taskId = task.getTaskId();
        return this.geoserverUtil.httpFindResult(task.getServiceName(), limitType, result, taskId, verify);
    }

    public Object queryAnalysResult(String projectId, String type) {
        VerifyTask task = this.verifyTaskDao.findByPidAndType(projectId, type);
        if (task == null) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u4efb\u52a1\uff01");
        }
        HashMap map = new HashMap();
        JSONArray infoArray = this.geoserverUtil.httpFindInfo(task.getServiceName());
        for (Object o : infoArray) {
            JSONObject obj = (JSONObject)o;
            List services = obj.getJSONArray("services").toJavaList(JSONObject.class);
            services.forEach(f -> map.put(f.getString("serviceId"), f.getString("chartData")));
        }
        JSONArray array = this.geoserverUtil.httpFindAnalysResult(task.getTaskId());
        array.stream().forEach(f -> {
            JSONObject obj = (JSONObject)f;
            int status = obj.getIntValue("status");
            String result = obj.getString("result");
            if (status == 1) {
                obj.put("result", (Object)JSON.parseObject((String)result));
            }
            obj.put("charJson", map.get(obj.getString("serviceId")));
        });
        return array;
    }

    public Object stat(TaskStatDTO statDTO) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ApplicationGUID", ConfigConstant.GeoServerConfig.Service_Key);
        param.put("analysisResult", statDTO.getResult());
        param.put("statType", statDTO.getTableType());
        return this.geoserverUtil.httpStat(statDTO.getServiceName(), JSON.toJSONString(param));
    }

    private void updateXmStatus(String projectId, String type, String state, Boolean result) {
        String sql = "";
        if (XmxxType.LX.type.equals(type)) {
            sql = " update tb_project_gdbh_cbbcgd_jhk set f_check_state='" + state + "' where f_id = '" + projectId + "' ";
        } else if (XmxxType.YS.type.equals(type)) {
            sql = " update tb_project_gdbh_cbbcgd_fhk set f_check_state='" + state + "' where f_id = '" + projectId + "' ";
        } else if (result != null) {
            this.yjkRepository.updateRuleStatus(projectId, Integer.valueOf(result != false ? 1 : 2));
        }
        this.jdbcTemplate.execute(sql);
    }

    private TaskXmxxDTO findXmxx(String projectId, String type) {
        TaskXmxxDTO xmxx = new TaskXmxxDTO();
        StringBuilder sbr = new StringBuilder();
        if (XmxxType.LX.type.equals(type)) {
            sbr.append(" select ");
            sbr.append(" f_type as xmsblx, ");
            sbr.append(" f_jhjszgm as xmjszgm, ");
            sbr.append(" f_pf_pfrq as lxsj , ");
            sbr.append(" f_jhxzgdmj as xzgdmj , ");
            sbr.append(" f_jhxzstmj as xzstmj , ");
            sbr.append(" f_jhtzgzgdmj as tzgzgdmj , ");
            sbr.append(" f_jhtzgzstmj as tzgzstmj ");
            sbr.append(" from ").append("tb_project_gdbh_cbbcgd_jhk");
            sbr.append(" where f_id = '").append(projectId).append("';");
            xmxx.setXmlx("LX");
        } else if (XmxxType.YS.type.equals(type)) {
            sbr.append(" select ");
            sbr.append(" f_type as xmsblx , ");
            sbr.append(" f_ys_gm_zgm as xmjszgm , ");
            sbr.append(" to_char(f_pf_pfrq,'YYYY/MM/DD') as lxsj , ");
            sbr.append(" to_char(f_ys_ysrq,'YYYY/MM/DD') as yssj , ");
            sbr.append(" f_bcgdmj as bcgdmj , ");
            sbr.append(" f_jzgdmj as jzgdmj , ");
            sbr.append(" f_bcstmj as bcstmj , ");
            sbr.append(" f_jzstmj as jzstmj , ");
            sbr.append(" f_bcgdpjzldb as bcgdpjzldb , ");
            sbr.append(" f_tzgzgdmj as tzgzgdmj , ");
            sbr.append(" f_tzgzstmj as tzgzstmj , ");
            sbr.append(" f_tzgzqzldb as gzqgdzldb , ");
            sbr.append(" f_tzgzhzldb as gzhgdzldb , ");
            sbr.append(" f_tzjzgdmj as tzjzgdmj , ");
            sbr.append(" f_tzjzstmj as tzjzstmj ");
            sbr.append(" from ").append("tb_project_gdbh_cbbcgd_fhk");
            sbr.append(" where f_id = '").append(projectId).append("';");
            xmxx.setXmlx("YS");
        } else {
            sbr.append(" select ");
            sbr.append(" f_type as xmsblx , ");
            sbr.append(" to_char(f_xmnf,'YYYY/MM/DD') as lxsj ");
            sbr.append(" from ").append("tb_project_gdbh_cbbcgd_yjk");
            sbr.append(" where f_id = '").append(projectId).append("';");
            xmxx.setXmlx("CY");
        }
        Map map = this.jdbcTemplate.queryForMap(sbr.toString());
        xmxx.setXmsblx(this.toString(map.get("xmsblx")));
        xmxx.setXmjszgm(this.toDouble(map.get("xmjszgm")));
        xmxx.setLxsj(this.toString(map.get("lxsj")));
        xmxx.setYssj(this.toString(map.get("yssj")));
        xmxx.setXzgdmj(this.toDouble(map.get("xzgdmj")));
        xmxx.setXzstmj(this.toDouble(map.get("xzstmj")));
        xmxx.setTzgzgdmj(this.toDouble(map.get("tzgzgdmj")));
        xmxx.setTzgzstmj(this.toDouble(map.get("tzgzstmj")));
        xmxx.setRk_bcgdmj(this.toDouble(map.get("bcgdmj")));
        xmxx.setRk_jzgdmj((double)this.toDouble(map.get("jzgdmj")));
        xmxx.setRk_bcstmj((double)this.toDouble(map.get("bcstmj")));
        xmxx.setRk_jzstmj((double)this.toDouble(map.get("jzstmj")));
        xmxx.setRk_bcgdpjzldb((double)this.toDouble(map.get("bcgdpjzldb")));
        xmxx.setRk_tzgzgdmj((double)this.toDouble(map.get("tzgzgdmj")));
        xmxx.setRk_tzgzstmj((double)this.toDouble(map.get("tzgzstmj")));
        xmxx.setRk_gzqgdzldb((double)this.toDouble(map.get("gzqgdzldb")));
        xmxx.setRk_gzhgdzldb((double)this.toDouble(map.get("gzhgdzldb")));
        xmxx.setRk_tzjzgdmj((double)this.toDouble(map.get("tzjzgdmj")));
        xmxx.setRk_tzjzstmj((double)this.toDouble(map.get("tzjzstmj")));
        return xmxx;
    }

    private Double toDouble(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof String) {
            return Double.valueOf((String)obj);
        }
        return ((BigDecimal)obj).doubleValue();
    }

    private String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    private List<TaskBlockDTO> findBlocks(String tableName, String projectId) {
        String sql = "select st_astext(f_shape) as wkt,f_dkbh as dkbh, f_dkmj as dkmj,f_dkmc as dkmc, f_dkyt as dkyt,f_tfh as tfh,f_tblx as tblx, f_dlbm as dlbm,f_gzqpjzldb as gzqpjzldb, f_gzhpjzldb as gzhpjzldb , f_yuliu as yuliu from " + tableName + " where f_project_id = '" + projectId + "' ";
        List list = this.jdbcTemplate.queryForList(sql);
        return list.stream().map(m -> {
            TaskBlockDTO dto = TaskBlockDTO.builder().wkt(m.get("wkt").toString()).wkid("4490").build();
            m.remove("wkt");
            m.put("isImage", false);
            dto.setAttributes((Map<String, Object>)m);
            return dto;
        }).collect(Collectors.toList());
    }

    private List<TaskBlockDTO> findXmqBlocks(String tableName, String projectId) {
        String sql = "select st_astext(f_shape) as wkt,f_ys_xmbh as dkbh,f_dkmj as dkmj,'\u9879\u76ee\u533a' as dkyt,'xmq' as xmdklx from " + tableName + " where f_project_id = '" + projectId + "' ";
        List list = this.jdbcTemplate.queryForList(sql);
        return list.stream().map(m -> {
            TaskBlockDTO dto = TaskBlockDTO.builder().wkt(m.get("wkt").toString()).wkid("4490").build();
            m.remove("wkt");
            m.put("isAnalysis", false);
            dto.setAttributes((Map<String, Object>)m);
            return dto;
        }).collect(Collectors.toList());
    }
}

