/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import java.util.concurrent.ConcurrentHashMap;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CoordinateReferenceUtil {
    private static final ConcurrentHashMap<Integer, CoordinateReferenceSystem> crsMap = new ConcurrentHashMap(100);
    private static final ConcurrentHashMap<Integer, Integer> mapDH_SRID = new ConcurrentHashMap(100);

    public static CoordinateReferenceSystem getCoordinateReferenceSystemForSRID(int srid) {
        CoordinateReferenceSystem crs = crsMap.get(srid);
        return crs;
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystemForDH(int dh) {
        int srid = mapDH_SRID.get(dh);
        CoordinateReferenceSystem crs = crsMap.get(srid);
        return crs;
    }

    public static int getSRID(int dh) {
        return mapDH_SRID.get(dh);
    }

    static {
        try {
            CoordinateReferenceSystem crs2000 = CRS.parseWKT((String)"GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4490]]");
            crsMap.put(4490, crs2000);
            CoordinateReferenceSystem crs25 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_25\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",25500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4513, crs25);
            mapDH_SRID.put(25, 4513);
            CoordinateReferenceSystem crs26 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_26\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",26500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",78.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4514, crs26);
            mapDH_SRID.put(26, 4514);
            CoordinateReferenceSystem crs27 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_27\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",27500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4515, crs27);
            mapDH_SRID.put(27, 4515);
            CoordinateReferenceSystem crs28 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_28\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",28500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",84.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4516, crs28);
            mapDH_SRID.put(28, 4516);
            CoordinateReferenceSystem crs29 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_29\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",29500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4517, crs29);
            mapDH_SRID.put(29, 4517);
            CoordinateReferenceSystem crs30 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_30\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",30500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4518, crs30);
            mapDH_SRID.put(30, 4518);
            CoordinateReferenceSystem crs31 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_31\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",31500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4519, crs31);
            mapDH_SRID.put(31, 4519);
            CoordinateReferenceSystem crs32 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_32\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",32500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",96.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4520, crs32);
            mapDH_SRID.put(32, 4520);
            CoordinateReferenceSystem crs33 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_33\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4521, crs33);
            mapDH_SRID.put(33, 4521);
            CoordinateReferenceSystem crs34 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_34\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",34500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",102.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4522, crs34);
            mapDH_SRID.put(34, 4522);
            CoordinateReferenceSystem crs35 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_35\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",35500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4523, crs35);
            mapDH_SRID.put(35, 4523);
            CoordinateReferenceSystem crs36 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_36\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",36500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",108.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4524, crs36);
            mapDH_SRID.put(36, 4524);
            CoordinateReferenceSystem crs37 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_37\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",37500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4525, crs37);
            mapDH_SRID.put(37, 4525);
            CoordinateReferenceSystem crs38 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_38\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",38500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",114.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4526, crs38);
            mapDH_SRID.put(38, 4526);
            CoordinateReferenceSystem crs39 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_39\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",39500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4527, crs39);
            mapDH_SRID.put(39, 4527);
            CoordinateReferenceSystem crs40 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_40\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",40500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",120.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4528, crs40);
            mapDH_SRID.put(40, 4528);
            CoordinateReferenceSystem crs41 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_41\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",41500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4529, crs41);
            mapDH_SRID.put(41, 4529);
            CoordinateReferenceSystem crs42 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_42\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",42500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",126.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4530, crs42);
            mapDH_SRID.put(42, 4530);
            CoordinateReferenceSystem crs43 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_43\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",43500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4531, crs43);
            mapDH_SRID.put(43, 4531);
            CoordinateReferenceSystem crs44 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_44\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",44500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4532, crs44);
            mapDH_SRID.put(44, 4532);
            CoordinateReferenceSystem crs45 = CRS.parseWKT((String)"PROJCS[\"CGCS_2000_3_Degree_GK_Zone_45\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",45500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]\n");
            crsMap.put(4533, crs45);
            mapDH_SRID.put(45, 4533);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

