/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.core.domain.DictValue;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.service.DictService;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.EnumStatusType;
import com.geoway.onemap.zbph.dao.base.BaseTaskManageRepository;
import com.geoway.onemap.zbph.domain.base.BaseTaskManage;
import com.geoway.onemap.zbph.dto.base.BaseTaskParam;
import com.geoway.onemap.zbph.dto.xfstbrk.TbrkTaskParam;
import com.geoway.onemap.zbph.service.base.BaseTaskExecuteService;
import com.geoway.onemap.zbph.service.base.BaseTaskManageService;
import com.geoway.onemap.zbph.supoort.FileManageUtil;
import com.geoway.onemap.zbph.supoort.SwapUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseTaskManageServiceImpl
implements BaseTaskManageService {
    private static String QUEUE = "task:queue";
    private static String REQUEST = "req";
    private static String RESPONSE = "res";
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private DictService dictService;
    @Autowired
    private BaseTaskManageRepository repository;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private SwapUtil swapUtil;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String create(Map map, SysUser user) throws Exception {
        BaseTaskManage info = BaseTaskManage.builder().id(UUID.randomUUID().toString()).createTime(new Date()).userId(user.getId()).userName(user.getAlisname()).xzqdm(user.getXzqdm()).xzqmc(user.getFullXzqmc()).status(EnumStatusType.RUNNING.value).build();
        BaseTaskParam baseTaskParam = BaseTaskParam.convertFromMap(map, BaseTaskParam.class);
        BaseTaskExecuteService service = StringUtils.isNotEmpty((CharSequence)baseTaskParam.getClassPath()) ? (BaseTaskExecuteService)SpringContextUtil.getBean(Class.forName(baseTaskParam.getClassPath())) : this.getByType(baseTaskParam.getType());
        info.setParam(JSON.toJSONString((Object)map));
        info.setCustomClass(service.getClass().getName());
        info.setType(baseTaskParam.getType());
        info.setSwap(baseTaskParam.getIsSwap());
        this.repository.save(info);
        this.threadPoolTaskExecutor.submit(() -> {
            try {
                info.setStartTime(new Date());
                service.execute(map, user, info);
                info.setStatus(EnumStatusType.SUCCESS.value);
            }
            catch (Exception e) {
                e.printStackTrace();
                info.setStatus(EnumStatusType.FAILED.value);
                info.setMsg(e.getMessage());
            }
            info.setEndTime(new Date());
            this.repository.save(info);
        });
        return info.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createAsync(Map map, SysUser user) throws Exception {
        BaseTaskManage task = this.createTask(map, user);
        if (task.getSwap() != null && task.getSwap().booleanValue()) {
            this.uploadSwap(task, REQUEST);
        } else {
            this.pushQueue(task.getId());
        }
        return task.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> createBatchAsync(List<Map> list, SysUser user) throws Exception {
        ArrayList<String> taskList = new ArrayList<String>();
        for (Map map : list) {
            BaseTaskManage task = this.createTask(map, user);
            if (task.getSwap() != null && task.getSwap().booleanValue()) {
                this.uploadSwap(task, REQUEST);
                continue;
            }
            taskList.add(task.getId());
        }
        this.pushQueue(taskList);
        return taskList;
    }

    private BaseTaskManage createTask(Map map, SysUser user) throws IOException {
        BaseTaskManage info = BaseTaskManage.builder().id(UUID.randomUUID().toString()).createTime(new Date()).userId(user.getId()).userName(user.getAlisname()).xzqdm(user.getXzqdm()).xzqmc(user.getFullXzqmc()).status(EnumStatusType.QUEUE.value).build();
        BaseTaskParam baseTaskParam = BaseTaskParam.convertFromMap(map, BaseTaskParam.class);
        map.put("user", user);
        info.setParam(JSON.toJSONString((Object)map));
        info.setCustomClass(baseTaskParam.getClassPath());
        info.setType(baseTaskParam.getType());
        info.setSource(1);
        info.setSwap(baseTaskParam.getIsSwap());
        this.repository.save(info);
        return info;
    }

    @Override
    public Page<BaseTaskManage> queryPage(String filterParam, String sortParam, int page, int size, SysUser user) {
        String xzqdmWhere = this.getXzqWhere(user.getXzqdm());
        filterParam = StringUtils.isBlank((CharSequence)filterParam) ? xzqdmWhere : filterParam + ";" + xzqdmWhere;
        sortParam = StringUtils.isBlank((CharSequence)sortParam) ? "SORT_createTime_DESC" : sortParam;
        Page all = this.repository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return all;
    }

    @Override
    public BaseTaskManage queryInfo(String id) {
        return this.repository.findById(id).orElse(null);
    }

    @Override
    public void callBack(String swapId, String taskId) {
        InputStream is = this.swapUtil.httpDownloadFile(swapId, taskId);
        if (is == null) {
            System.out.println("\u3010" + taskId + "\u3011\u56de\u8c03\u5931\u8d25\uff01");
            return;
        }
        this.fileManage(is, taskId);
    }

    @Override
    public void callBack2(String businessId, String uniqueTaskId) {
        InputStream is = this.swapUtil.httpDownloadFile2(uniqueTaskId, businessId);
        if (is == null) {
            System.out.println("\u3010" + uniqueTaskId + "\u3011\u56de\u8c03\u5931\u8d25\uff01");
            return;
        }
        this.fileManage(is, uniqueTaskId);
    }

    @Override
    public void downloadByTaskId(HttpServletResponse response, String id) {
        BaseTaskManage info = this.queryInfo(id);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            TbrkTaskParam param = TbrkTaskParam.convertFromString(info.getParam(), TbrkTaskParam.class);
            File file = new File(param.getFilePath());
            String fileName = file.getName();
            FileInputStream fileInputStream = new FileInputStream(file);
            inputStream = new BufferedInputStream(fileInputStream);
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            response.reset();
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("Content-Length", "" + file.length());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            outputStream.write(buffer);
            outputStream.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public String pollingResult(String taskId) {
        while (true) {
            BaseTaskManage task = this.repository.findById(taskId).orElse(null);
            BoundValueOperations ops = this.redisTemplate.boundValueOps((Object)("swap-result:" + taskId));
            if (ops.get() != null) {
                task = (BaseTaskManage)JSON.parseObject((String)((String)ops.get()), BaseTaskManage.class);
                this.repository.save(task);
                this.redisTemplate.delete((Object)("swap-result:" + taskId));
            }
            if (EnumStatusType.SUCCESS.value.equals(task.getStatus())) {
                return task.getMsg();
            }
            if (EnumStatusType.FAILED.value.equals(task.getStatus())) {
                throw new RuntimeException("\u7ed3\u679c\u5931\u8d25\uff01" + task.getMsg());
            }
            long startTime = task.getCreateTime().getTime();
            long nowTime = new Date().getTime();
            long cost = nowTime - startTime;
            if (cost > (long)(ConfigConstant.TaskConfig.timeout * 60 * 1000)) {
                throw new RuntimeException("\u7ed3\u679c\u8f6e\u8be2\u8d85\u65f6\uff01");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getXzqWhere(String xzqdm) {
        String where = "Q_xzqdm_S_";
        String type = "LFK=";
        if (xzqdm.endsWith("0000")) {
            xzqdm = xzqdm.substring(0, 2);
        } else if (xzqdm.endsWith("00")) {
            xzqdm = xzqdm.substring(0, 4);
        } else {
            type = "EQ=";
        }
        return where + type + xzqdm;
    }

    private BaseTaskExecuteService getByType(String type) {
        List dictValues = this.dictService.queryDictValuesByDictKey("task-manage-type");
        try {
            for (DictValue value : dictValues) {
                if (!type.equals(value.getItemText())) continue;
                String className = value.getItemValue();
                Class<?> aClass = Class.forName(className);
                return (BaseTaskExecuteService)SpringContextUtil.getBean(aClass);
            }
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5b57\u5178\u3010task-manage-type\u3011\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e1a\u52a1\u7c7b\u578b\u3010" + type + "\u3011\u83b7\u53d6\u6267\u884c\u7c7b\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void pushQueue(String taskId) {
        BoundListOperations ops = this.redisTemplate.boundListOps((Object)QUEUE);
        ops.rightPush((Object)taskId);
    }

    private void pushQueue(List<String> taskId) {
        BoundListOperations ops = this.redisTemplate.boundListOps((Object)QUEUE);
        ops.rightPushAll((Object[])taskId.toArray(new String[taskId.size()]));
    }

    private String popQueue() {
        BoundListOperations ops = this.redisTemplate.boundListOps((Object)QUEUE);
        return (String)ops.leftPop();
    }

    @Override
    public void startTasks() {
        if (!ConfigConstant.TaskConfig.enable.booleanValue()) {
            System.out.println("\u4efb\u52a1\u76d1\u542c\u5668\u5df2\u5173\u95ed\uff01");
            return;
        }
        this.refreshQueue();
        System.out.println("\u4efb\u52a1\u76d1\u542c\u5668\u5df2\u542f\u52a8\uff01");
        int corePoolSize = ConfigConstant.SysConfig.ThreadPool_CorePoolSize;
        int size = ConfigConstant.TaskConfig.quantity > corePoolSize ? corePoolSize - 1 : ConfigConstant.TaskConfig.quantity;
        AtomicInteger quantity = new AtomicInteger(0);
        Thread thread = new Thread(() -> {
            Long start = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).getEpochSecond();
            while (true) {
                try {
                    while (true) {
                        Long end;
                        String taskId;
                        if (quantity.get() <= size && StringUtils.isNotEmpty((CharSequence)(taskId = this.popQueue()))) {
                            quantity.getAndIncrement();
                            BaseTaskManage task = this.repository.findById(taskId).orElse(null);
                            if (task != null && EnumStatusType.QUEUE.value.equals(task.getStatus())) {
                                this.startManageTask(task, quantity);
                            } else {
                                this.pushQueue(taskId);
                                quantity.getAndDecrement();
                            }
                        }
                        ThreadUtil.sleep((long)1000L);
                        if (!ConfigConstant.TaskConfig.refresh.booleanValue() || (end = Long.valueOf(LocalDateTime.now().toInstant(ZoneOffset.of("+8")).getEpochSecond())) - start < (long)(ConfigConstant.TaskConfig.refreshTime * 60)) continue;
                        this.refreshQueue();
                        start = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).getEpochSecond();
                    }
                }
                catch (Exception e) {
                    System.out.println("\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage());
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        thread.setPriority(10);
        thread.setName("TaskManage");
        thread.start();
    }

    private void refreshQueue() {
        List<String> tasks;
        if (ConfigConstant.TaskConfig.refresh.booleanValue() && (tasks = this.repository.findByStatus(EnumStatusType.QUEUE.value)).size() > 0) {
            System.out.println("\u6b63\u5728\u5237\u65b0\u4efb\u52a1\u961f\u5217\uff01");
            this.redisTemplate.delete((Object)QUEUE);
            BoundListOperations ops = this.redisTemplate.boundListOps((Object)QUEUE);
            ops.rightPushAll((Object[])tasks.toArray(new String[tasks.size()]));
        }
    }

    protected void startManageTask(BaseTaskManage info, AtomicInteger quantity) {
        this.repository.updateStatus(EnumStatusType.RUNNING.value, info.getId());
        this.threadPoolTaskExecutor.submit(() -> {
            try {
                BaseTaskExecuteService service = StringUtils.isNotEmpty((CharSequence)info.getCustomClass()) ? (BaseTaskExecuteService)SpringContextUtil.getBean(Class.forName(info.getCustomClass())) : this.getByType(info.getType());
                info.setStartTime(new Date());
                JSONObject object = JSON.parseObject((String)info.getParam());
                SysUser user = (SysUser)object.getObject("user", SysUser.class);
                service.execute((Map)object, user, info);
                info.setStatus(EnumStatusType.SUCCESS.value);
            }
            catch (Exception e) {
                e.printStackTrace();
                info.setStatus(EnumStatusType.FAILED.value);
                info.setMsg(e.getMessage());
            }
            info.setEndTime(new Date());
            this.repository.save(info);
            if (info.getSwap() != null && info.getSwap().booleanValue()) {
                this.uploadSwap(info, RESPONSE);
            }
            quantity.getAndDecrement();
        });
    }

    private void fileManage(InputStream is, String uid) {
        String filePath = FileManageUtil.unZip(is, uid);
        File fileDir = new File(filePath);
        if (!fileDir.exists()) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + filePath);
        }
        try {
            File[] files = fileDir.listFiles();
            File file = null;
            for (int i = 0; i < files.length; ++i) {
                file = files[i];
                if (file.isDirectory()) continue;
                String fileName = file.getName();
                String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
                if (REQUEST.equals(suffix)) {
                    this.swapTaskManage(file);
                    continue;
                }
                if (!RESPONSE.equals(suffix)) continue;
                this.swapTaskSave(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        finally {
            FileUtil.del((File)fileDir);
            FileManageUtil.deleteForceFile(filePath);
        }
    }

    private void uploadSwap(BaseTaskManage info, String suf) {
        if (!ConfigConstant.SwapConfig.enable.booleanValue()) {
            throw new RuntimeException("\u672a\u542f\u7528\u5185\u5916\u7f51\u4ea4\u6362\u529f\u80fd\uff01");
        }
        String uuid = UUID.randomUUID().toString();
        String fileName = info.getId() + "&&" + info.getType();
        String tempPath = FileManageUtil.getTempPath() + File.separator + uuid + File.separator + fileName + "." + suf;
        try {
            File file = FileUtil.newFile((String)tempPath);
            FileUtil.writeString((String)JSON.toJSONString((Object)info), (String)tempPath, (Charset)StandardCharsets.UTF_8);
            File zip = ZipUtil.zip((File)file);
            this.swapUtil.httpUploadFile(zip);
            if (REQUEST.equals(suf)) {
                info.setStatus(EnumStatusType.RUNNING.value);
                info.setStartTime(new Date());
                this.repository.save(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5185\u5916\u7f51\u4ea4\u6362\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff01" + e.getMessage());
        }
        finally {
            FileManageUtil.deleteForceFile(tempPath);
            FileUtil.del((String)tempPath);
        }
    }

    private void swapTaskManage(File file) {
        String text = FileUtil.readString((File)file, (Charset)StandardCharsets.UTF_8);
        BaseTaskManage task = (BaseTaskManage)JSON.parseObject((String)text, BaseTaskManage.class);
        task.setStatus(EnumStatusType.QUEUE.value);
        this.repository.save(task);
        this.pushQueue(task.getId());
    }

    private void swapTaskSave(File file) {
        String text = FileUtil.readString((File)file, (Charset)StandardCharsets.UTF_8);
        BaseTaskManage swapTask = (BaseTaskManage)JSON.parseObject((String)text, BaseTaskManage.class);
        BaseTaskManage task = this.repository.findById(swapTask.getId()).orElse(null);
        if (task == null) {
            task = swapTask;
        } else {
            task.setEndTime(new Date());
            task.setMsg(swapTask.getMsg());
        }
        task.setStatus(swapTask.getStatus());
        this.redisTemplate.boundValueOps((Object)("swap-result:" + task.getId())).set((Object)JSON.toJSONString((Object)task), 30L, TimeUnit.MINUTES);
    }
}

