/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.wyhc.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.base.support.util.Md5Util;
import com.geoway.onemap.core.support.FileUtil;
import com.geoway.onemap.core.support.HttpsUtil;
import com.geoway.onemap.core.support.ShapeUtil;
import com.geoway.onemap.core.support.Zip4jUtil;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.domain.xfsbcgdlx.XfsbcgdLxXzgdfw;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXzgdfw;
import com.geoway.onemap.zbph.dto.wyhc.BusinessPushDTO;
import com.geoway.onemap.zbph.service.wyhc.BusinessVerifyPushService;
import com.geoway.onemap.zbph.service.wyhc.impl.AbstracGtyPushServiceImpl;
import com.geoway.onemap.zbph.supoort.GtyGWApiUtil;
import com.geoway.zhgd.domain.OutCheckGty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnProperty(name={"business.verify.type"}, havingValue="gty-yngcy")
public class GtyYngcyVerifyPushServiceImpl
extends AbstracGtyPushServiceImpl
implements BusinessVerifyPushService {
    @Autowired
    private GtyGWApiUtil gtyGWApiUtil;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateStart(BusinessPushDTO dto) {
        this.start(dto);
    }

    @Override
    protected File generateGty(List<Map<String, Object>> XZGDFW, String dir) throws IOException {
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        if (XZGDFW.size() > 0) {
            String path = dir + "/XZGDFW.shp";
            ArrayList<String> attrKeys = new ArrayList<String>(XZGDFW.get(0).keySet());
            attrKeys.remove("WKT");
            ShapeUtil.write2Shape((String)path, (String)"UTF-8", (String)"MultiPolygon", (String)"WKT", attrKeys, XZGDFW);
        }
        String zipUrl = dir;
        zipUrl = Zip4jUtil.zip((String)zipUrl, (boolean)false, (String)"");
        File zipFile = new File(zipUrl);
        String gtyPath = zipUrl.substring(0, zipUrl.lastIndexOf(".")) + ".gty";
        File gtyFile = new File(gtyPath);
        zipFile.renameTo(gtyFile);
        FileUtils.forceDelete((File)dirFile);
        return gtyFile;
    }

    @Override
    protected String uploadFile(File file, String xmid, String type) {
        String fileName = file.getName().substring(0, file.getName().lastIndexOf("."));
        JSONObject tempUrlObj = this.gtyGWApiUtil.getTempUrl();
        String writeUrl = tempUrlObj.getString("writeUrl");
        byte[] bytes = new byte[]{};
        try {
            bytes = FileUtil.fileConvertToByteArray((File)file);
            if (writeUrl.startsWith("https")) {
                HttpsUtil.httpsRequestPost((String)writeUrl, (String)"PUT", (byte[])bytes);
            } else {
                HttpsUtil.httpRequestPost((String)writeUrl, (String)"PUT", (byte[])bytes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String readUrl = tempUrlObj.getString("readUrl");
        String filemd5 = Md5Util.getFileMd5Str((File)file);
        return this.gtyGWApiUtil.notice(readUrl, fileName, filemd5);
    }

    @Override
    protected void getBlocksLx(String projectId, String jbxx_xmmc, String ys_xmbh, List<OutCheckGty> outCheckGties, List<Map<String, Object>> xzgdfwList) {
        List<XfsbcgdLxXzgdfw> xzgdfws = this.lxXzgdfwService.findByPid(projectId);
        for (XfsbcgdLxXzgdfw xzgdfw : xzgdfws) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String bsm = UUID.randomUUID().toString();
            map.put("f_bsm", bsm);
            map.put("f_xzqdm", xzgdfw.getXzqdm());
            map.put("f_dkh", xzgdfw.getDkbh());
            map.put("f_tbbh", xzgdfw.getDkbh());
            map.put("f_dkmc", xzgdfw.getDkmc());
            map.put("f_dkmj", xzgdfw.getDkmj());
            map.put("f_yt", xzgdfw.getDkyt());
            map.put("f_tfh", xzgdfw.getTfh());
            map.put("f_tblx", xzgdfw.getTblx());
            map.put("f_dl", xzgdfw.getDlbm());
            map.put("f_gdpjzldj", xzgdfw.getGzqpjzldb());
            map.put("f_gzhpjzld", xzgdfw.getGzhpjzldb());
            map.put("f_xmmc", xzgdfw.getJbxxXmmc());
            map.put("WKT", xzgdfw.getShape().toText());
            map.put("f_xmjd", XmxxType.LX.type);
            map.put("f_xmid", xzgdfw.getYsXmbh());
            map.put("f_xzqmc", xzgdfw.getXzqmc());
            xzgdfwList.add(map);
            OutCheckGty outCheckGty = OutCheckGty.builder().bsm(bsm).yxxmbh(ys_xmbh).dikuaiNO(xzgdfw.getDkbh()).projectId(projectId).xmjd(XmxxType.LX.gtyType).state(Integer.valueOf(1)).createTime(new Date()).dkId(xzgdfw.getId()).source("gty").build();
            outCheckGties.add(outCheckGty);
        }
    }

    @Override
    protected void getBlocksYs(String projectId, String jbxx_xmmc, String ys_xmbh, List<OutCheckGty> outCheckGties, List<Map<String, Object>> xzgdfwList) {
        List<XfsbcgdYsXzgdfw> xzgdfws = this.ysXzgdfwService.findByPid(projectId);
        for (XfsbcgdYsXzgdfw xzgdfw : xzgdfws) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String bsm = UUID.randomUUID().toString();
            map.put("f_bsm", bsm);
            map.put("f_dkh", xzgdfw.getDkbh());
            map.put("f_tbbh", xzgdfw.getDkbh());
            map.put("f_dkmc", xzgdfw.getDkmc());
            map.put("f_dkmj", xzgdfw.getDkmj());
            map.put("f_yt", xzgdfw.getDkyt());
            map.put("f_tfh", xzgdfw.getTfh());
            map.put("f_tblx", xzgdfw.getTblx());
            map.put("f_dl", xzgdfw.getDlbm());
            map.put("f_gdpjzldj", xzgdfw.getGzqpjzldb());
            map.put("f_gzhpjzld", xzgdfw.getGzhpjzldb());
            map.put("f_xmmc", xzgdfw.getJbxxXmmc());
            map.put("WKT", xzgdfw.getShape().toText());
            map.put("f_xmjd", XmxxType.YS.type);
            map.put("f_xmid", xzgdfw.getYsXmbh());
            map.put("f_xzqdm", xzgdfw.getXzqdm());
            map.put("f_xzqmc", xzgdfw.getXzqmc());
            xzgdfwList.add(map);
            OutCheckGty outCheckGty = OutCheckGty.builder().bsm(bsm).yxxmbh(ys_xmbh).dikuaiNO(xzgdfw.getDkbh()).projectId(projectId).xmjd(XmxxType.YS.gtyType).state(Integer.valueOf(1)).createTime(new Date()).dkId(xzgdfw.getId()).source("gty").build();
            outCheckGties.add(outCheckGty);
        }
    }
}

