/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.xfsbcgdys.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.excel.util.IoUtils;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.core.domain.system.SimpleRole;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.stxf.dto.TaskXmxxDTO;
import com.geoway.onemap.stxf.service.BaseFileService;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.EnumLshType;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputMethod;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKType;
import com.geoway.onemap.zbph.dao.xfsbcgdys.XfsbcgdYsXzgdfwBxtRepository;
import com.geoway.onemap.zbph.domain.base.BaseCheckDetail;
import com.geoway.onemap.zbph.domain.base.ProcessStep;
import com.geoway.onemap.zbph.domain.base.ProcessTaskEvent;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXmfw;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXmxx;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXzgdfw;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXzgdfwBxt;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDKDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKInputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKSpatialDetail;
import com.geoway.onemap.zbph.dto.wyhc.BusinessPushDTO;
import com.geoway.onemap.zbph.dto.xfsbcgdys.OverviewYsDTO;
import com.geoway.onemap.zbph.dto.xfsbcgdys.XfsbcgdysDTO;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKInputDTO;
import com.geoway.onemap.zbph.service.base.BaseCheckService;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.service.base.DataVerifyTaskService;
import com.geoway.onemap.zbph.service.base.ProcessInstanceService;
import com.geoway.onemap.zbph.service.base.impl.AbstractXmxxManagerServiceImpl;
import com.geoway.onemap.zbph.service.wyhc.BusinessVerifyPushService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsManageService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXmfwService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXmxxService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXzgdfwService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.service.zgck.ZgckBcgdDkDetailService;
import com.geoway.onemap.zbph.supoort.EasyShpUtil;
import com.geoway.onemap.zbph.supoort.ExceptionCustomUtil;
import com.geoway.onemap.zbph.supoort.PFWHUtil;
import com.geoway.onemap.zbph.supoort.TempFileUtil;
import com.geoway.zhgd.domain.BaseFile;
import com.geoway.zhgd.domain.VerifyTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jodd.io.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class XfsbcgdYsManageServiceImpl
extends AbstractXmxxManagerServiceImpl<XfsbcgdysDTO, XfsbcgdYsXmxx, XfsbcgdYsXmxxService>
implements XfsbcgdYsManageService {
    @Value(value="${project.fxfw.service.ys:'GDZBPH_YS'}")
    private String serviceName;
    @Autowired
    private XfsbcgdYsXmxxService xmxxService;
    @Autowired
    private XfsbcgdYsXmfwService xmfwService;
    @Autowired
    private XfsbcgdYsXzgdfwService xzgdfwService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private BaseFileService baseFileService;
    @Autowired
    private BaseCheckService baseCheckService;
    @Autowired
    private DataVerifyTaskService dataVerifyTaskService;
    @Autowired
    private ZBKManagerService zbkManagerService;
    @Autowired
    private BaseLshService sidService;
    @Autowired
    private ZBKDKDetailService zbkdkDetailService;
    @Autowired
    private ZgckBcgdDkDetailService zgckBcgdDkDetailService;
    @Autowired
    private BusinessVerifyPushService businessVerifyPushService;
    @Autowired
    private XfsbcgdYsXzgdfwBxtRepository xfsbcgdYsXzgdfwBxtRepository;

    public XfsbcgdYsManageServiceImpl(XfsbcgdYsXmxxService service) {
        super(service);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdate(XfsbcgdysDTO dto, SysUser user) {
        PFWHUtil.ValidationResult validationResult;
        XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)dto.getXmxx();
        if (ConfigConstant.PfwhConfig.verify && !(validationResult = PFWHUtil.validate(xmxx.getPfwh(), DateUtil.year((Date)xmxx.getPfrq()))).isValid()) {
            throw new RuntimeException(validationResult.getMessage());
        }
        xmxx.setUpdateDate(DateUtil.now());
        XfsbcgdYsXmxx xfsbcgdYsXmxx = (XfsbcgdYsXmxx)this.xmxxService.findByName(xmxx.getXmmc());
        EnumLshType enumLshType = EnumLshType.fromValue(xmxx.getType());
        if (enumLshType == null) {
            enumLshType = EnumLshType.BCGDYS_Q;
        }
        if (StringUtils.isEmpty((CharSequence)xmxx.getXmid())) {
            ExceptionCustomUtil.isNotNull(xfsbcgdYsXmxx, "\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            xmxx.setLsh(this.sidService.generateLsh(user.getXzqdm(), enumLshType, xmxx.getYsrq()));
        } else {
            EnumLshType ysEnumLshType;
            XfsbcgdYsXmxx ysXmxx = (XfsbcgdYsXmxx)this.xmxxService.findById(xmxx.getXmid());
            if (!ysXmxx.getXmmc().equals(xmxx.getXmmc())) {
                ExceptionCustomUtil.isNotNull(xfsbcgdYsXmxx, "\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            if (!enumLshType.equals(ysEnumLshType = EnumLshType.fromValue(xmxx.getType())) || ysXmxx.getYsrq().getYear() != xmxx.getYsrq().getYear()) {
                xmxx.setLsh(this.sidService.generateLsh(user.getXzqdm(), enumLshType, xmxx.getYsrq()));
            }
        }
        if (dto.getXzgdfwList().stream().anyMatch(f -> StringUtils.isEmpty((CharSequence)f.getId()))) {
            xmxx.setIswy(0.0);
        }
        this.xmxxService.saveOrUpdate(xmxx, user);
        if (dto.getXmfwList() != null) {
            dto.getXmfwList().stream().forEach(f -> {
                f.setXmid(xmxx.getXmid());
                f.setXzqdm(xmxx.getXmXzqdm());
                f.setXzqmc(xmxx.getXmXzqdm());
                f.setJbxxXmmc(xmxx.getXmmc());
                f.setJbxxXzqdm(xmxx.getXmXzqdm());
                f.setJbxxXzqmc(xmxx.getXmXzqdm());
                f.setYsXmbh(xmxx.getLsh());
            });
            this.xmfwService.saveCover(dto.getXmfwList());
        }
        if (dto.getXzgdfwList() != null) {
            dto.getXzgdfwList().stream().forEach(f -> {
                f.setXmid(xmxx.getXmid());
                f.setXzqdm(xmxx.getXmXzqdm());
                f.setXzqmc(xmxx.getXmXzqdm());
                f.setJbxxXmmc(xmxx.getXmmc());
                f.setYsXmbh(xmxx.getLsh());
            });
            this.xzgdfwService.saveCover(dto.getXzgdfwList());
        }
        if (dto.getFjList() != null) {
            for (BaseFile file : dto.getFjList()) {
                if (StringUtils.isNotBlank((CharSequence)file.getId())) continue;
                file.setRelationId(xmxx.getXmid());
                this.baseFileService.fileManage(file, user);
            }
            this.baseFileService.saveCover(dto.getFjList());
        }
        return ((XfsbcgdYsXmxx)dto.getXmxx()).getXmid();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByXmid(String id) {
        XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)this.xmxxService.findById(id);
        this.baseCheckService.deleteByProcessId(xmxx.getProcessId());
        this.xmfwService.deleteByPid(id);
        this.xzgdfwService.deleteByPid(id);
        this.dataVerifyTaskService.deleteByPid(id);
        this.xmxxService.deleteByXmid(id);
    }

    @Override
    public XfsbcgdysDTO detailByXmid(String id) {
        XfsbcgdysDTO dto = new XfsbcgdysDTO();
        XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)this.xmxxService.findById(id);
        List<XfsbcgdYsXmfw> xmfws = this.xmfwService.findByPid(id);
        List<XfsbcgdYsXzgdfw> xzgdfws = this.xzgdfwService.findByPid(id);
        List<BaseFile> baseFileList = this.baseFileService.findByRelationId(id);
        List<BaseCheckDetail> checkDetails = this.baseCheckService.findByProcessId(xmxx.getProcessId());
        dto.setXmxx(xmxx);
        dto.setXmfwList(xmfws);
        dto.setXzgdfwList(xzgdfws);
        dto.setFjList(baseFileList);
        dto.setCheckList(checkDetails);
        return dto;
    }

    @Override
    public void verifyManage(VerifyTask verifyTask) {
        Integer status = verifyTask.getStatus();
        String pid = verifyTask.getPid();
        XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)this.xmxxService.findById(pid);
        Integer ruleStatus = verifyTask.getRuleStatus();
        SysUser sysUser = this.getUser(xmxx.getXzqdm(), "\u6570\u636e\u6821\u9a8c-\u7cfb\u7edf", xmxx.getProcessId());
        if (status == 200 && ruleStatus == 1) {
            this.xmxxService.pass(Arrays.asList(xmxx.getXmid().split(",")), sysUser, "\u6570\u636e\u67e5\u9a8c\u901a\u8fc7", "", "", null);
        } else {
            this.xmxxService.refuse(Arrays.asList(xmxx.getXmid().split(",")), sysUser, "\u6570\u636e\u67e5\u9a8c\u4e0d\u901a\u8fc7", "", "", null);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void notify(ProcessTaskEvent event) {
        XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)this.xmxxService.findByProcessId(event.getInstance().getId());
        String tag = event.getTag();
        if (tag == null) {
            this.inputZbk(event);
            return;
        }
        JSONObject object = JSONObject.parseObject((String)tag);
        String type = object.getString("type");
        if ("wy".equals(type)) {
            Boolean isReuse = object.getBoolean("isReuse");
            this.generateFhkGty(xmxx.getXmid(), event.getSysUser(), isReuse);
        } else if ("cy".equals(type)) {
            this.dataVerify(xmxx.getXmid());
        }
    }

    @Override
    public void notify(List<ProcessTaskEvent> processTaskEvent) {
        processTaskEvent.forEach(f -> this.notify((ProcessTaskEvent)f));
    }

    @Override
    public Page<OverviewYsDTO> overviews(String filterParam, String sortParam, int page, int rows) {
        Page pages = this.xmxxService.findPageByFilter(filterParam, sortParam, null, page, rows);
        List xmxxList = pages.getContent();
        if (!xmxxList.isEmpty()) {
            List<String> xmbhs = xmxxList.stream().map(m -> m.getXmbh()).collect(Collectors.toList());
            List<ZBKDKDetail> details = this.zbkdkDetailService.sumListByXmbhs(xmbhs);
            Map detailMap = details.stream().collect(Collectors.toMap(ZBKDKDetail::getXmbh, Function.identity()));
            Map<String, Integer> countMap = this.zgckBcgdDkDetailService.countByXmbhs(xmbhs);
            List list = xmxxList.stream().map(m -> {
                OverviewYsDTO dto = new OverviewYsDTO();
                dto.setXmid(m.getXmid());
                dto.setXmbh(m.getXmbh());
                dto.setXmmc(m.getXmmc());
                dto.setTime(m.getCreateDate());
                ZBKDKDetail detail = (ZBKDKDetail)detailMap.get(m.getXmbh());
                dto.setRkGdsl(detail.getGdmj());
                dto.setRkStsl(detail.getStmj());
                dto.setYyGdsl(detail.getGdmjyy());
                dto.setYyStsl(detail.getStmjyy());
                dto.setSyGdsl(detail.getGdmjsy());
                dto.setSyStsl(detail.getStmjsy());
                dto.setYyGgxm(countMap.get(m.getXmbh()) == null ? 0 : (Integer)countMap.get(m.getXmbh()));
                return dto;
            }).collect(Collectors.toList());
            PageImpl result = new PageImpl(list, pages.getPageable(), pages.getTotalElements());
            return result;
        }
        return new PageImpl(new ArrayList());
    }

    @Override
    public void exportShp(String xmid, HttpServletResponse response) {
        List<XfsbcgdYsXmfw> lxXmfws = this.xmfwService.findByPid(xmid);
        List<XfsbcgdYsXzgdfw> lxXzgdfws = this.xzgdfwService.findByPid(xmid);
        if (lxXmfws.size() == 0 || lxXzgdfws.size() == 0) {
            throw new RuntimeException("\u672a\u4e0a\u4f20\u9879\u76ee\u8303\u56f4\u6216\u8005\u8865\u5145\u8015\u5730\u8303\u56f4\uff01");
        }
        TempFileUtil tempFileUtil = (TempFileUtil)SpringContextUtil.getBean(TempFileUtil.class);
        File tempFile = tempFileUtil.getTempDir();
        EasyShpUtil<Serializable> easyShpUtil = new EasyShpUtil<Serializable>();
        String xmmc = lxXmfws.get(0).getJbxxXmmc();
        try {
            easyShpUtil.write(lxXmfws, xmmc + "\u9879\u76ee\u8303\u56f4", tempFile.getPath());
            easyShpUtil.write(lxXzgdfws, xmmc + "\u8865\u5145\u8015\u5730\u8303\u56f4\u8303\u56f4", tempFile.getPath());
            File zipFile = ZipUtil.zip((String)tempFile.getPath(), (String)(tempFile.getPath() + xmmc + ".zip"), (Charset)Charset.forName("UTF-8"), (boolean)false);
            response.setContentType("application/zip");
            response.setCharacterEncoding("utf-8");
            String utf8fileName = URLEncoder.encode(xmmc, "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + utf8fileName + ".zip");
            ServletOutputStream myout = response.getOutputStream();
            FileInputStream input = new FileInputStream(zipFile);
            myout.write(IoUtils.toByteArray((InputStream)input));
            ((InputStream)input).close();
            myout.flush();
            myout.close();
            FileUtil.deleteDir((File)tempFile);
            FileUtil.deleteFile((String)(tempFile.getPath() + xmmc + ".zip"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165shp\u5931\u8d25");
        }
    }

    @Override
    public File exportShpForBxt(List<Map<String, Object>> ysxmlist) {
        TempFileUtil tempFileUtil = (TempFileUtil)SpringContextUtil.getBean(TempFileUtil.class);
        File tempFile = tempFileUtil.getTempDir();
        if (ysxmlist.size() > 0) {
            for (Map<String, Object> ysxm : ysxmlist) {
                String xmid = ysxm.get("xmid").toString();
                String lsh = ysxm.get("bxt_lsh").toString();
                List<XfsbcgdYsXzgdfwBxt> lxXzgdfws = this.xfsbcgdYsXzgdfwBxtRepository.findByXmid(xmid);
                if (lxXzgdfws.size() == 0) {
                    throw new RuntimeException("\u672a\u4e0a\u4f20\u9a8c\u6536\u8015\u5730\u5730\u5757\uff01");
                }
                lxXzgdfws.forEach(obj -> {
                    obj.setXtbsm(lsh);
                    obj.setSftgzlys("\u662f");
                    obj.setSjnf("2024");
                    obj.setGdpdjbStr("3");
                    obj.setYsdm(obj.getDkbh());
                    obj.setTbbh(obj.getDkbh());
                    if (obj.getTblx().equalsIgnoreCase("\u65b0\u589e")) {
                        if (obj.getGzqpjzldb() != null) {
                            obj.setGddb(Integer.valueOf(obj.getGzqpjzldb()));
                            obj.setGddj(Integer.valueOf(obj.getGzqpjzldb()));
                        }
                    } else if (obj.getGzhpjzldb() != null) {
                        obj.setGddb(Integer.valueOf(obj.getGzhpjzldb()));
                        obj.setGddj(Integer.valueOf(obj.getGzhpjzldb()));
                    }
                    obj.setDlmc(this.getDlmc(obj.getDlbm()));
                });
                EasyShpUtil<XfsbcgdYsXzgdfwBxt> easyShpUtil = new EasyShpUtil<XfsbcgdYsXzgdfwBxt>();
                try {
                    String lxXzgdfwsDir = tempFile.getPath() + File.separator + "lsh-" + lsh;
                    if (!new File(lxXzgdfwsDir).exists()) {
                        new File(lxXzgdfwsDir).mkdirs();
                    }
                    easyShpUtil.write(lxXzgdfws, "lsh-" + lsh, lxXzgdfwsDir);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u5199\u5165shp\u5931\u8d25");
                }
            }
        }
        File zipFile = ZipUtil.zip((String)tempFile.getPath(), (String)(tempFile.getPath() + ".zip"), (Charset)Charset.forName("UTF-8"), (boolean)false);
        return zipFile;
    }

    private String getDlmc(String dlbm) {
        String dlmc = "";
        switch (dlbm) {
            case "0101": {
                dlmc = "\u6c34\u7530";
                break;
            }
            case "0102": {
                dlmc = "\u6c34\u6d47\u5730";
                break;
            }
            case "0103": {
                dlmc = "\u65f1\u5730";
                break;
            }
            default: {
                dlmc = "";
            }
        }
        return dlmc;
    }

    public void dataVerify(String id) {
        XfsbcgdysDTO detail = this.detailByXmid(id);
        TaskXmxxDTO xmxx = new TaskXmxxDTO();
        xmxx.setXmlx(((XfsbcgdYsXmxx)detail.getXmxx()).getType());
        xmxx.setXmjszgm(((XfsbcgdYsXmxx)detail.getXmxx()).getYszgm());
        SimpleDateFormat sbf = new SimpleDateFormat("yyyy-MM-dd");
        xmxx.setLxsj(((XfsbcgdYsXmxx)detail.getXmxx()).getPfrq() == null ? null : sbf.format(((XfsbcgdYsXmxx)detail.getXmxx()).getPfrq()));
        xmxx.setYssj(((XfsbcgdYsXmxx)detail.getXmxx()).getYsrq() == null ? null : sbf.format(((XfsbcgdYsXmxx)detail.getXmxx()).getYsrq()));
        xmxx.setXzgdmj(((XfsbcgdYsXmxx)detail.getXmxx()).getBcgdmj());
        xmxx.setXzstmj(((XfsbcgdYsXmxx)detail.getXmxx()).getBcstmj());
        xmxx.setXzsjdmj(((XfsbcgdYsXmxx)detail.getXmxx()).getBcsjdmj());
        xmxx.setTzgzgdmj(((XfsbcgdYsXmxx)detail.getXmxx()).getTzgzgdmj());
        xmxx.setTzgzstmj(((XfsbcgdYsXmxx)detail.getXmxx()).getTzgzstmj());
        xmxx.setRk_bcgdmj(((XfsbcgdYsXmxx)detail.getXmxx()).getRkbcgdmj());
        xmxx.setRk_jzgdmj(((XfsbcgdYsXmxx)detail.getXmxx()).getRkjzgdmj());
        xmxx.setRk_bcstmj(((XfsbcgdYsXmxx)detail.getXmxx()).getRkbcstmj());
        xmxx.setRk_jzstmj(((XfsbcgdYsXmxx)detail.getXmxx()).getRkjzstmj());
        xmxx.setRk_bcsjdmj(((XfsbcgdYsXmxx)detail.getXmxx()).getRkbcsjdmj());
        xmxx.setRk_jzsjdmj(((XfsbcgdYsXmxx)detail.getXmxx()).getRkjzsjdmj());
        xmxx.setRk_bcgdpjzldb(((XfsbcgdYsXmxx)detail.getXmxx()).getRkbcgdpjzldb());
        xmxx.setRk_tzgzgdmj(((XfsbcgdYsXmxx)detail.getXmxx()).getRktzgzgdmj());
        xmxx.setRk_tzgzstmj(((XfsbcgdYsXmxx)detail.getXmxx()).getRktzgzstmj());
        xmxx.setRk_gzqgdzldb(((XfsbcgdYsXmxx)detail.getXmxx()).getRktzgzqzldb());
        xmxx.setRk_gzhgdzldb(((XfsbcgdYsXmxx)detail.getXmxx()).getRktzgzhzldb());
        xmxx.setRk_tzjzgdmj(((XfsbcgdYsXmxx)detail.getXmxx()).getTzjzgdmj());
        xmxx.setRk_tzjzstmj(((XfsbcgdYsXmxx)detail.getXmxx()).getTzjzstmj());
        List<TaskBlockDTO> xmq = detail.getXmfwList().stream().map(m -> {
            TaskBlockDTO dto = new TaskBlockDTO();
            dto.setWkt(m.getShape().toText());
            dto.setDk_id("1");
            Map map = BeanUtil.beanToMap((Object)m, (String[])new String[0]);
            map.put("isAnalysis", false);
            map.put("xmdklx", "xmq");
            map.remove("shape");
            dto.setAttributes(map);
            return dto;
        }).collect(Collectors.toList());
        List gdfw = detail.getXzgdfwList().stream().map(m -> {
            TaskBlockDTO dto = new TaskBlockDTO();
            dto.setWkt(m.getShape().toText());
            dto.setDk_id(UUID.randomUUID().toString());
            Map map = BeanUtil.beanToMap((Object)m, (String[])new String[0]);
            map.put("isImage", false);
            map.remove("shape");
            dto.setAttributes(map);
            return dto;
        }).collect(Collectors.toList());
        xmq.addAll(gdfw);
        Map map = BeanUtil.beanToMap((Object)xmxx, (String[])new String[0]);
        Class<?> aClass = this.getClass();
        this.dataVerifyTaskService.createTask(map, xmq, null, this.serviceName, VerifyTask.builder().pid(id).type(XmxxType.YS.type).customClass(aClass.getName()).build());
    }

    private void inputZbk(ProcessTaskEvent event) {
        String pid = event.getInstance().getId();
        SysUser user = event.getSysUser();
        XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)this.xmxxService.findByProcessId(pid);
        ArrayList<ZBKInputDTO> zbkInputDTOS = new ArrayList<ZBKInputDTO>();
        List<XfsbcgdYsXzgdfw> xzgdfws = this.xzgdfwService.findByPid(xmxx.getXmid());
        for (XfsbcgdYsXzgdfw xzgdfw : xzgdfws) {
            ZBKInputDTO zbkInputDTO = new ZBKInputDTO();
            ZBKInputDetail inputDetail = new ZBKInputDetail();
            inputDetail.setZbxzqdm(xmxx.getXmXzqdm());
            inputDetail.setZbxzqmc(xmxx.getXmXzqmc());
            inputDetail.setCzxzqdm(xmxx.getXzqdm());
            inputDetail.setCzxzqmc(xmxx.getXzqmc());
            inputDetail.setCzlx(EnumZBKInputType.ZBBBRK.toValue());
            inputDetail.setZblx(EnumZBKType.XFSRKBCGDZB.toValue());
            inputDetail.setXmbh(xmxx.getXmbh());
            inputDetail.setXmmc(xmxx.getXmmc());
            inputDetail.setXmjgysrq(xmxx.getYsrq());
            inputDetail.setDate(new Date());
            inputDetail.setUserid(xmxx.getUserId());
            inputDetail.setUsername(xmxx.getUserName());
            inputDetail.setGdmj(xzgdfw.getXzgdmj());
            inputDetail.setStmj(xzgdfw.getXzstmj());
            inputDetail.setGddb(xzgdfw.getGzhpjzldb() == null ? 0.0 : Double.valueOf(xzgdfw.getGzhpjzldb()));
            inputDetail.setDlbm(this.getDlbm(xzgdfw.getDlbm()));
            inputDetail.setDlmc(xzgdfw.getDlbm());
            inputDetail.setDkbh(xzgdfw.getDkbh());
            inputDetail.setDkid(xzgdfw.getId());
            inputDetail.setDkmc(xzgdfw.getDkmc());
            inputDetail.setDkxzqdm(xzgdfw.getXzqdm());
            inputDetail.setDkxzqmc(xzgdfw.getXzqmc());
            inputDetail.setRklx(EnumZBKInputMethod.XMRK.toValue());
            double lscn = (16.0 - Double.valueOf(xzgdfw.getGzhpjzldb())) * 1500.0 * xzgdfw.getXzgdmj();
            inputDetail.setCnzb(lscn);
            ZBKSpatialDetail detail = new ZBKSpatialDetail();
            detail.setShape(xzgdfw.getShape());
            detail.setDlmc(xzgdfw.getDlbm());
            detail.setDlbm(this.getDlbm(detail.getDlmc()));
            detail.setTbmj(xzgdfw.getDkmj());
            zbkInputDTO.setZbkInputDetail(inputDetail);
            zbkInputDTO.setZbkSpatialDetail(detail);
            zbkInputDTOS.add(zbkInputDTO);
        }
        this.zbkManagerService.input(zbkInputDTOS);
    }

    private void generateFhkGty(String xmid, SysUser user, Boolean isReuse) {
        XfsbcgdysDTO detail = this.detailByXmid(xmid);
        XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)detail.getXmxx();
        Double iswy = xmxx.getIswy();
        if (iswy != 0.0) {
            if (isReuse.booleanValue()) {
                this.xmxxService.forcePass(Arrays.asList(xmid.split(",")), user, "\u6210\u679c\u590d\u7528", "", "", "");
                return;
            }
            this.xmxxService.updateWy(xmid, 0.0);
        }
        try {
            this.businessVerifyPushService.generateStart(BusinessPushDTO.builder().xmid(xmid).type(XmxxType.YS.gtyType).build());
        }
        catch (Exception e) {
            throw new RuntimeException("\u5916\u4e1a\u6838\u67e5\u5931\u8d25\uff1a" + e);
        }
    }

    private String getDlbm(String dlmc) {
        if ("\u6c34\u7530".equals(dlmc)) {
            return "0101";
        }
        if ("\u6c34\u6d47\u5730".equals(dlmc)) {
            return "0102";
        }
        if ("\u65f1\u5730".equals(dlmc)) {
            return "0103";
        }
        return dlmc;
    }

    private SysUser getUser(String xzqdm, String name, String processId) {
        ProcessStep processStep = this.processInstanceService.getCurrentStep(processId);
        SysUser sysUser = new SysUser();
        sysUser.setAlisname(name);
        sysUser.setUsername(name);
        sysUser.setXzqdm(xzqdm);
        sysUser.setId(name);
        HashSet<SimpleRole> roles = new HashSet<SimpleRole>();
        SimpleRole simpleRole = new SimpleRole();
        simpleRole.setRolename(processStep.getRelatedRoles().get(0));
        roles.add(simpleRole);
        sysUser.setRoles(roles);
        return sysUser;
    }
}

