/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkhandler.impl;

import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.constant.zbtj.EnumZbkdjReasonType;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDKDetail;
import com.geoway.onemap.zbph.domain.zbtj.Zbdj;
import com.geoway.onemap.zbph.domain.zbtj.ZbdjMx;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKOutputDTO;
import com.geoway.onemap.zbph.service.zbkhandler.ZbkFreezeHandler;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.service.zbkmanager.impl.ZBKOutputUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZbkFreezeHandlerImpl
implements ZbkFreezeHandler {
    @Autowired
    private ZBKDKDetailService zbkdkDetailService;
    @Autowired
    private ZBKManagerService zbkManagerService;

    @Override
    public void freeze(Zbdj zbdj, List<ZbdjMx> mxDetails, SysUser sysUser) {
        ArrayList<ZBKOutputDTO> outputDTOS = new ArrayList<ZBKOutputDTO>();
        if (mxDetails != null && mxDetails.size() > 0) {
            for (ZbdjMx zbdjMx : mxDetails) {
                outputDTOS.addAll(ZBKOutputUtil.getZBKOutputDTOs(this.zbkdkDetailService.findListByXmbh(zbdjMx.getXmbh()), zbdjMx.getDjzbgm(), zbdjMx.getDjstgm()));
            }
        } else {
            List<ZBKOutputUtil.ZBKOutputParam> outputParams = this.getZBKOutputParams(zbdj);
            outputDTOS.addAll(ZBKOutputUtil.getZBKOutputDTOs(outputParams, zbdj.getLscn()));
        }
        outputDTOS.forEach(zbkOutputDTO -> {
            zbkOutputDTO.setCzxzqdm(sysUser.getXzqdm());
            zbkOutputDTO.setCzxzqmc(sysUser.getFullXzqmc());
            if (EnumZbkdjReasonType.fromValue(zbdj.getDjlx()) == EnumZbkdjReasonType.JY) {
                zbkOutputDTO.setCzlx(EnumZBKOutputType.QTDJCK.toValue());
            } else {
                zbkOutputDTO.setCzlx(EnumZBKOutputType.WFYDDJCK.toValue());
            }
            ZBKDKDetail tempDk = this.zbkdkDetailService.findById(zbkOutputDTO.getZbid(), false);
            zbkOutputDTO.setXmbh(tempDk.getXmbh());
            zbkOutputDTO.setXmmc(tempDk.getXmmc());
            zbkOutputDTO.setUserid(sysUser.getId());
            zbkOutputDTO.setUsername(sysUser.getAlisname());
        });
        zbdj.setDjlsh(this.zbkManagerService.output(outputDTOS));
    }

    protected List<ZBKOutputUtil.ZBKOutputParam> getZBKOutputParams(Zbdj zbdj) {
        ZBKOutputUtil.ZBKOutputParam outputParam;
        String sortParam;
        String filterParam;
        ArrayList<ZBKOutputUtil.ZBKOutputParam> results = new ArrayList<ZBKOutputUtil.ZBKOutputParam>();
        if (zbdj.getZbgm0101() > 0.0 || zbdj.getZbgm0102() > 0.0 || zbdj.getZbgm0103() > 0.0) {
            if (zbdj.getZbgm0101() > 0.0) {
                filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s;Q_dlbm_S_EQ=%s", zbdj.getZblx(), zbdj.getZBXzqdm(), "0101");
                sortParam = "SORT_date_ASC;SORT_gdmjsy_ASC";
                outputParam = new ZBKOutputUtil.ZBKOutputParam();
                outputParam.setSortParam(sortParam);
                outputParam.setFilterParam(filterParam);
                outputParam.setStmj(0.0);
                outputParam.setGdmj(zbdj.getZbgm0101());
                results.add(outputParam);
            }
            if (zbdj.getZbgm0102() > 0.0) {
                filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s;Q_dlbm_S_EQ=%s", zbdj.getZblx(), zbdj.getZBXzqdm(), "0102");
                sortParam = "SORT_date_ASC;SORT_gdmjsy_ASC";
                outputParam = new ZBKOutputUtil.ZBKOutputParam();
                outputParam.setSortParam(sortParam);
                outputParam.setFilterParam(filterParam);
                outputParam.setStmj(0.0);
                outputParam.setGdmj(zbdj.getZbgm0102());
                results.add(outputParam);
            }
            if (zbdj.getZbgm0103() > 0.0) {
                filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s;Q_dlbm_S_EQ=%s", zbdj.getZblx(), zbdj.getZBXzqdm(), "0103");
                sortParam = "SORT_date_ASC;SORT_gdmjsy_ASC";
                outputParam = new ZBKOutputUtil.ZBKOutputParam();
                outputParam.setSortParam(sortParam);
                outputParam.setFilterParam(filterParam);
                outputParam.setGdmj(zbdj.getZbgm0103());
                outputParam.setStmj(0.0);
                results.add(outputParam);
            }
            if (zbdj.getStgm() > 0.0) {
                filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s", zbdj.getZblx(), zbdj.getZBXzqdm());
                sortParam = "SORT_date_ASC;SORT_gdmjsy_ASC";
                outputParam = new ZBKOutputUtil.ZBKOutputParam();
                outputParam.setSortParam(sortParam);
                outputParam.setFilterParam(filterParam);
                outputParam.setStmj(zbdj.getStgm());
                outputParam.setGdmj(0.0);
                results.add(outputParam);
            }
        } else {
            filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s", zbdj.getZblx(), zbdj.getZBXzqdm());
            sortParam = "SORT_date_ASC;SORT_gdmjsy_ASC;";
            outputParam = new ZBKOutputUtil.ZBKOutputParam();
            outputParam.setSortParam(sortParam);
            outputParam.setFilterParam(filterParam);
            outputParam.setStmj(zbdj.getStgm());
            outputParam.setGdmj(zbdj.getZbgm());
            results.add(outputParam);
        }
        if (zbdj.getLscn() > 0.0) {
            filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s", zbdj.getZblx(), zbdj.getZBXzqdm());
            sortParam = "SORT_date_ASC;SORT_cnzbsy_ASC";
            outputParam = new ZBKOutputUtil.ZBKOutputParam();
            outputParam.setSortParam(sortParam);
            outputParam.setFilterParam(filterParam);
            outputParam.setStmj(0.0);
            outputParam.setGdmj(0.0);
            results.add(outputParam);
        }
        return results;
    }

    @Override
    public void revert(Zbdj zbdj, SysUser sysUser) {
        String djlsh = zbdj.getDjlsh();
        String jdlsh = this.zbkManagerService.revertOutput(djlsh, sysUser);
        zbdj.setJdlsh(jdlsh);
    }
}

