/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkmanager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.core.domain.DictValue;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.service.DictService;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKConfigDetailRepository;
import com.geoway.onemap.zbph.domain.base.BaseTaskManage;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKConfigDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKPzLog;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKPZTaskParam;
import com.geoway.onemap.zbph.dto.zbkmanager.ZbkPzChildren;
import com.geoway.onemap.zbph.dto.zbkmanager.ZbkPzDTO;
import com.geoway.onemap.zbph.service.base.BaseTaskExecuteService;
import com.geoway.onemap.zbph.service.base.BaseTaskManageService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKConfigDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKPzLogService;
import com.geoway.onemap.zbph.supoort.EasyExcelUtil;
import com.geoway.onemap.zbph.supoort.ExceptionCustomUtil;
import com.geoway.onemap.zbph.supoort.FileManageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ZBKConfigDetailServiceImpl
implements ZBKConfigDetailService,
BaseTaskExecuteService {
    @Autowired
    private ZBKConfigDetailRepository zbkConfigDetailRepository;
    @Autowired
    private DictService dictService;
    @Autowired
    private BaseTaskManageService baseTaskManageService;
    @Autowired
    private ZBKPzLogService ZBKPzLogService;

    @Override
    public List<ZBKConfigDetail> findByXzqdm(String xzqdm) {
        return this.zbkConfigDetailRepository.findByXzqdm(xzqdm);
    }

    @Override
    public List<DictValue> queryDict() {
        return this.getLimitType();
    }

    @Override
    public List<ZbkPzDTO> queryTree(String filterParam, SysUser user) {
        List all = this.zbkConfigDetailRepository.findAll((Specification)new QuerySpecification(filterParam));
        if (all.isEmpty()) {
            return null;
        }
        List<ZbkPzDTO> allList = all.stream().collect(Collectors.toMap(a -> a.getXzqdm(), a -> {
            ZbkPzDTO zbkPzDTO = new ZbkPzDTO();
            BeanUtil.copyProperties((Object)a, (Object)zbkPzDTO, (String[])new String[0]);
            return zbkPzDTO;
        }, (o1, o2) -> {
            List<ZbkPzChildren> list;
            if (o1.getTypes() == null) {
                list = new ArrayList<ZbkPzChildren>();
                list.add(ZbkPzChildren.builder().id(o1.getId()).type(o1.getType()).value(o1.getValue()).build());
            } else {
                list = o1.getTypes();
            }
            list.add(ZbkPzChildren.builder().id(o2.getId()).type(o2.getType()).value(o2.getValue()).build());
            o1.setTypes(list);
            o1.setId(o1.getPid());
            return o1;
        })).values().stream().collect(Collectors.toList());
        allList = allList.stream().sorted(Comparator.comparing(ZbkPzDTO::getXzqdm)).collect(Collectors.toList());
        return this.getTree(allList);
    }

    @Override
    public String inputZbkPz(MultipartFile file, Boolean cover, String type, SysUser sysUser) throws Exception {
        String filePath = FileManageUtil.saveFile(file, "zbxzlr");
        ZBKPZTaskParam taskParam = new ZBKPZTaskParam();
        taskParam.setType(type);
        taskParam.setFilePath(filePath);
        taskParam.setCover(cover);
        taskParam.setClassPath(this.getClass().getName());
        try {
            return this.baseTaskManageService.create(BeanUtil.beanToMap((Object)taskParam, (String[])new String[0]), sysUser);
        }
        catch (Exception e) {
            FileManageUtil.deleteForceFile(filePath);
            throw new RuntimeException("\u521b\u5efa\u5bfc\u5165\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateValue(ZbkPzDTO zbkPzDTO, SysUser user) {
        List<ZbkPzChildren> types = zbkPzDTO.getTypes();
        types.forEach(f -> this.zbkConfigDetailRepository.updateValue(f.getValue(), new Date(), f.getId()));
        this.zbkConfigDetailRepository.updateReason(zbkPzDTO.getUpdateReason(), zbkPzDTO.getXzqdm(), zbkPzDTO.getYear());
        this.saveLog("update", user, JSON.toJSONString((Object)zbkPzDTO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SkipTransientField}));
    }

    @Override
    public void export(HttpServletResponse response, String ids, String filterParam, String fileName, Boolean isTemp) throws Exception {
        List<DictValue> types = this.getLimitType();
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
        ArrayList<List<String>> heads = new ArrayList<List<String>>();
        heads.add(new ArrayList<String>(){
            {
                this.add(HeadEnum.xzqdm.value);
            }
        });
        heads.add(new ArrayList<String>(){
            {
                this.add(HeadEnum.xzqmc.value);
            }
        });
        heads.add(new ArrayList<String>(){
            {
                this.add(HeadEnum.year.value);
            }
        });
        types.stream().forEach(f -> heads.add(new ArrayList<String>(){
            {
                this.add(f.getItemValue());
            }
        }));
        if (isTemp == null || !isTemp.booleanValue()) {
            List details = StringUtils.isNotEmpty((CharSequence)ids) ? this.zbkConfigDetailRepository.findByPids(Arrays.asList(ids.split(","))) : this.zbkConfigDetailRepository.findAll((Specification)new QuerySpecification(filterParam));
            this.getDatas(details, datas, types);
        }
        EasyExcelUtil.createExcel(response, StringUtils.isEmpty((CharSequence)fileName) ? "\u6307\u6807\u914d\u7f6e" : fileName, heads, datas);
    }

    private List<List<Object>> getDatas(List<ZBKConfigDetail> details, List<List<Object>> datas, List<DictValue> types) {
        details = details.stream().sorted(Comparator.comparing(ZBKConfigDetail::getYear).thenComparing(ZBKConfigDetail::getXzqdm)).collect(Collectors.toList());
        LinkedHashMap<String, HashMap<String, ZBKConfigDetail>> map = new LinkedHashMap<String, HashMap<String, ZBKConfigDetail>>();
        for (ZBKConfigDetail zBKConfigDetail : details) {
            HashMap<String, ZBKConfigDetail> detailMap = (HashMap<String, ZBKConfigDetail>)map.get(zBKConfigDetail.getPid());
            if (detailMap == null) {
                detailMap = new HashMap<String, ZBKConfigDetail>();
            }
            detailMap.put(zBKConfigDetail.getType(), zBKConfigDetail);
            map.put(zBKConfigDetail.getPid(), detailMap);
        }
        for (Map.Entry entry : map.entrySet()) {
            Map value = (Map)entry.getValue();
            ArrayList list = new ArrayList();
            types.stream().forEach(f -> {
                ZBKConfigDetail info = (ZBKConfigDetail)value.get(f.getItemText());
                if (list.isEmpty()) {
                    list.add(info.getXzqdm());
                    list.add(info.getXzqmc());
                    list.add(info.getYear());
                }
                list.add(info.getValue());
            });
            datas.add(list);
        }
        return datas;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void execute(Map map, SysUser user, BaseTaskManage taskInfo) throws Exception {
        ZBKPZTaskParam param = ZBKPZTaskParam.convertFromMap(map, ZBKPZTaskParam.class);
        String filePath = param.getFilePath();
        try {
            List<Map<String, Object>> mapList = EasyExcelUtil.getMap(filePath);
            List<DictValue> types = this.getLimitType();
            List<ZBKConfigDetail> details = new ArrayList<ZBKConfigDetail>();
            ZBKConfigDetail config = new ZBKConfigDetail();
            config.setUserId(user.getId());
            config.setUserName(user.getAlisname());
            config.setCreateTime(new Date());
            config.setUpdateTime(new Date());
            for (Map<String, Object> hashMap : mapList) {
                config.setXzqdm(String.valueOf(hashMap.get(HeadEnum.xzqdm.value)));
                config.setXzqmc(String.valueOf(hashMap.get(HeadEnum.xzqmc.value)));
                config.setYear(String.valueOf(hashMap.get(HeadEnum.year.value)));
                Object pCode = hashMap.get(HeadEnum.pCode.value);
                config.setPCode(pCode == null ? this.getPxzqdm(config.getXzqdm()) : String.valueOf(hashMap.get(HeadEnum.pCode.value)));
                config.setPid(UUID.randomUUID().toString());
                List detailList = types.stream().map(m -> {
                    ZBKConfigDetail detail = new ZBKConfigDetail();
                    BeanUtil.copyProperties((Object)config, (Object)detail, (String[])new String[0]);
                    detail.setId(UUID.randomUUID().toString());
                    detail.setType(m.getItemText());
                    Object obj = hashMap.get(m.getItemValue());
                    if (ObjectUtil.isNotEmpty(obj)) {
                        detail.setValue(Double.valueOf(String.valueOf(obj)));
                    }
                    detail.setAlias(m.getJsonStr());
                    return detail;
                }).collect(Collectors.toList());
                details.addAll(detailList);
            }
            ExceptionCustomUtil.isNull(details, "\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\uff01");
            details = this.coverManage(details, param.getCover());
            this.zbkConfigDetailRepository.saveAll(details);
            this.saveLog("import", user, JSON.toJSONString(details, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SkipTransientField}));
        }
        catch (Exception e) {
            throw new RuntimeException("\u9650\u5236\u5f55\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private String getPxzqdm(String xzqdm) {
        if (xzqdm.endsWith("0000")) {
            return "";
        }
        if (xzqdm.endsWith("00")) {
            return xzqdm.substring(0, 2) + "0000";
        }
        return xzqdm.substring(0, 4) + "00";
    }

    private List<ZBKConfigDetail> coverManage(List<ZBKConfigDetail> details, Boolean cover) {
        ArrayList deletes = new ArrayList();
        ZBKConfigDetail detail = details.get(0);
        String xzqdm = detail.getXzqdm();
        List<ZBKConfigDetail> list = this.zbkConfigDetailRepository.findByXzqdmAndYear(xzqdm.substring(0, 2), detail.getYear());
        Map map = list.stream().collect(Collectors.toMap(a -> a.getType() + a.getXzqdm(), Function.identity()));
        List types = map.keySet().stream().collect(Collectors.toList());
        details.stream().forEach(f -> {
            String key = f.getType() + f.getXzqdm();
            if (types.contains(key)) {
                if (cover != null && cover.booleanValue()) {
                    f.setId(((ZBKConfigDetail)map.get(key)).getId());
                    f.setUpdateTime(new Date());
                    if (f.getValue() == null) {
                        f.setValue(((ZBKConfigDetail)map.get(key)).getValue());
                    }
                } else {
                    deletes.add(f);
                }
            }
        });
        if (!deletes.isEmpty()) {
            details.removeAll(deletes);
        }
        return details;
    }

    private List<DictValue> getLimitType() {
        List dictValues = this.dictService.queryDictValuesByDictKey("zbkpz-config-type");
        ExceptionCustomUtil.isNull(dictValues, "\u672a\u67e5\u8be2\u5230\u9650\u503c\u5f55\u5165\u76f8\u5173\u5b57\u5178\uff01\u8bf7\u68c0\u67e5\u5b57\u5178\u3010zbkpz-config-type\u3011");
        return dictValues;
    }

    private List<ZbkPzDTO> getTree(List<ZbkPzDTO> list) {
        Map<String, List<ZbkPzDTO>> parentMap = list.stream().collect(Collectors.groupingBy(ZbkPzDTO::getPCode));
        list.forEach(item -> item.setChildren((List)parentMap.get(item.getXzqdm())));
        list = list.stream().sorted(Comparator.comparing(ZbkPzDTO::getXzqdm)).collect(Collectors.toList());
        final ZbkPzDTO zbkPzDTO = list.get(0);
        return new ArrayList<ZbkPzDTO>(){
            {
                this.add(zbkPzDTO);
            }
        };
    }

    private void saveLog(String type, SysUser user, String content) {
        ZBKPzLog log = new ZBKPzLog();
        log.setType(type);
        log.setUserid(user.getId());
        log.setUsername(user.getAlisname());
        log.setContent(content);
        this.ZBKPzLogService.saveInfo(log);
    }

    private static enum HeadEnum {
        xzqmc("xzqmc", "\u884c\u653f\u533a\u540d\u79f0"),
        xzqdm("xzqdm", "\u884c\u653f\u533a\u4ee3\u7801"),
        pCode("pCode", "\u4e0a\u7ea7\u884c\u653f\u533a\u4ee3\u7801"),
        year("year", "\u5e74\u5ea6");

        public String key;
        public String value;

        private HeadEnum(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public HeadEnum getByValue(String value) {
            for (HeadEnum headEnum : HeadEnum.values()) {
                if (!headEnum.value.equals(value)) continue;
                return headEnum;
            }
            return null;
        }
    }
}

