/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkmanager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.zbph.constant.base.EnumLockType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.domain.base.RefObject;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDKDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDkOutputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDkOutputDetailGC;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDkUseDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKInputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOperateDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetailGC;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKSpatialDetail;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKInputDTO;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKOutputDTO;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.service.base.BlockSplitService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKSpatialDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDkOutputDetailGCService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDkOutputDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDkUseDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKInputDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOperateDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOutputDetailGCService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOutputDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKUseDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.impl.ZBKManagerServiceImpl;
import com.geoway.onemap.zbph.supoort.BatchRepository;
import com.geoway.onemap.zbph.supoort.LockUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnExpression(value="${project.inputZbkSpatial.enable:false}==true")
public class ZBKDkManagerServiceImpl
extends ZBKManagerServiceImpl
implements ZBKManagerService {
    private static final Logger log = LoggerFactory.getLogger(ZBKDkManagerServiceImpl.class);
    @Autowired
    protected ZBKUseDetailService zbkUseDetailService;
    @Autowired
    protected ZBKDkUseDetailService zbkDkUseDetailService;
    @Autowired
    protected ZBKOutputDetailGCService zbkOutputDetailGCService;
    @Autowired
    protected ZBKDKSpatialDetailService zbkdkSpatialDetailService;
    @Autowired
    protected BaseLshService baseSidService;
    @Autowired
    protected ZBKOutputDetailService zbkOutputDetailService;
    @Autowired
    protected ZBKInputDetailService zbkInputDetailService;
    @Autowired
    protected ZBKOperateDetailService zbkOperateDetailService;
    @Autowired
    protected ZBKDKDetailService zbkdkDetailService;
    @Autowired
    protected LockUtil lockUtil;
    @Autowired
    private BatchRepository batchRepository;
    @Autowired
    ZBKDkOutputDetailGCService zbkdkOutputDetailGCService;
    @Autowired
    ZBKDkOutputDetailService zbkdkOutputDetailService;
    @Autowired
    BlockSplitService blockSplitService;

    @Override
    public boolean beforeInput(List<ZBKInputDTO> zbkInputDTOS, RefObject<String> msg) {
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String input(List<ZBKInputDTO> zbkInputDTOS) {
        String inputLsh = super.input(zbkInputDTOS);
        this.batchInputDk(zbkInputDTOS);
        return inputLsh;
    }

    @Override
    public boolean beforeOutput(List<ZBKOutputDTO> outputDetails, RefObject<String> msg) {
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String output(List<ZBKOutputDTO> outputDTOS) {
        String ckLsh = super.output(outputDTOS);
        this.outputDk(ckLsh, outputDTOS);
        return ckLsh;
    }

    private void outputDk(String ckLsh, List<ZBKOutputDTO> outputDTOS) {
        ArrayList zbkDkOutputDetails = new ArrayList();
        ArrayList<ZBKOutputDTO> outputDTOSResult = new ArrayList<ZBKOutputDTO>();
        List<ZBKOutputDTO> outputDTOSSplit = new ArrayList<ZBKOutputDTO>();
        for (ZBKOutputDTO item : outputDTOS) {
            if (item.getGdShape() != null || item.getStShape() != null || item.getCnzbShape() != null) {
                outputDTOSResult.add(item);
                continue;
            }
            outputDTOSSplit.add(item);
        }
        if (outputDTOSSplit.size() > 0) {
            outputDTOSSplit = this.blockSplitService.blockSplitForOutputDk(outputDTOSSplit);
            outputDTOSResult.addAll(outputDTOSSplit);
        }
        List<ZBKOutputDetail> zbkOutputDetails = this.zbkOutputDetailService.findListBySid(ckLsh);
        outputDTOSResult.forEach(f -> {
            ZBKDkOutputDetail zbkDkOutputDetail = new ZBKDkOutputDetail((ZBKOutputDTO)f);
            zbkDkOutputDetail.setSid(ckLsh);
            ZBKOutputDetail zbkOutputDetail = zbkOutputDetails.stream().filter(detail -> detail != null && f.getZbid() == detail.getZbid()).findFirst().orElse(null);
            if (zbkOutputDetail != null) {
                zbkDkOutputDetail.setCkmxId(zbkOutputDetail.getId());
            }
            zbkDkOutputDetails.add(zbkDkOutputDetail);
        });
        this.batchRepository.batchInsert(zbkDkOutputDetails);
        this.zbkDkUseDetailService.outputDkByLsh(ckLsh);
    }

    @Override
    public String revertOutput(String sid, SysUser sysUser) {
        Date now = new Date();
        List<ZBKOutputDetail> zbkOutputs = this.zbkOutputDetailService.findListBySid(sid);
        List<ZBKInputDetail> zbkInputDetails = this.zbkInputDetailService.findByZbids(zbkOutputs.stream().map(f -> f.getZbid()).collect(Collectors.toList()));
        ArrayList<ZBKInputDTO> inputDTOS = new ArrayList<ZBKInputDTO>();
        for (ZBKOutputDetail output : zbkOutputs) {
            ZBKInputDTO inputDTO = new ZBKInputDTO();
            ZBKInputDetail tempZbkInputDetail = zbkInputDetails.stream().filter(f -> f.getId().equals(output.getZbid())).findFirst().orElse(null);
            ZBKInputDetail zbkInputDetail = new ZBKInputDetail();
            BeanUtil.copyProperties((Object)tempZbkInputDetail, (Object)zbkInputDetail, (String[])new String[0]);
            switch (EnumZBKOutputType.fromValue(output.getCzlx())) {
                case BCGDHJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.QXZBHJRK.toValue());
                    break;
                }
                case KSTJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.CXTJRK.toValue());
                    break;
                }
                case SNKXTJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.CXTJRK.toValue());
                    break;
                }
                case SNKSTJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.CXTJRK.toValue());
                    break;
                }
                case WFYDDJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.WFYDJDRK.toValue());
                    break;
                }
                case QTDJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.QTDJJDRK.toValue());
                    break;
                }
                case JSXMGGCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.FNJSZYGDJGRK.toValue());
                    break;
                }
                default: {
                    throw new RuntimeException("\u76ee\u524d\u4ec5\u652f\u6301\u8865\u5145\u6838\u51cf\u64a4\u9500");
                }
            }
            zbkInputDetail.setCnzb(output.getCnzb());
            zbkInputDetail.setGdmj(output.getGdmj());
            zbkInputDetail.setStmj(output.getStmj());
            if (zbkInputDetail.getDate() == null) {
                zbkInputDetail.setDate(now);
            }
            zbkInputDetail.setOperDate(now);
            zbkInputDetail.setUserid(sysUser.getId());
            zbkInputDetail.setUsername(sysUser.getAlisname());
            zbkInputDetail.setCzxzqdm(sysUser.getXzqdm());
            zbkInputDetail.setCzxzqmc(sysUser.getFullXzqmc());
            zbkInputDetail.setZbxzqdm(output.getZbxzqdm());
            zbkInputDetail.setZbxzqmc(output.getZbxzqmc());
            zbkInputDetail.setSrcid(output.getId());
            ZBKDkOutputDetail zbkdkOutputDetail = this.zbkdkOutputDetailService.findByCkmxid(output.getId());
            if (zbkdkOutputDetail != null) {
                if (zbkdkOutputDetail.getGdShape() != null) {
                    zbkInputDetail.setGdShape(zbkdkOutputDetail.getGdShape());
                }
                if (zbkdkOutputDetail.getStShape() != null) {
                    zbkInputDetail.setStShape(zbkdkOutputDetail.getStShape());
                }
                if (zbkdkOutputDetail.getCnzbShape() != null) {
                    zbkInputDetail.setCnzbShape(zbkdkOutputDetail.getCnzbShape());
                }
            }
            inputDTO.setZbkInputDetail(zbkInputDetail);
            inputDTOS.add(inputDTO);
        }
        return this.input(inputDTOS);
    }

    @Override
    public String revertInput(String inputSid, SysUser sysUser) {
        List<ZBKDKDetail> zbkInputs = this.zbkdkDetailService.findListByLsh(inputSid);
        List<ZBKOutputDetail> zbkOutputDetails = this.zbkOutputDetailService.findByIds(zbkInputs.stream().filter(f -> StrUtil.isNotBlank((CharSequence)f.getSrcid())).map(f -> f.getSrcid()).collect(Collectors.toList()));
        if (zbkInputs.stream().filter(f -> f.getCnzbsd() > 0.0 || f.getCnzbyy() > 0.0 || f.getGdmjsd() > 0.0 || f.getGdmjyy() > 0.0 || f.getStmjsd() > 0.0 || f.getStmjyy() > 0.0).count() > 0L) {
            throw new RuntimeException("\u6307\u6807\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u64a4\u9500\uff01");
        }
        ArrayList<ZBKOutputDTO> outputDTOS = new ArrayList<ZBKOutputDTO>();
        for (ZBKDKDetail input : zbkInputs) {
            ZBKOutputDTO outputDTO = new ZBKOutputDTO();
            BeanUtil.copyProperties((Object)input, (Object)outputDTO, (String[])new String[0]);
            switch (EnumZBKInputType.fromValue(input.getCzlx())) {
                case SNKXTJRK: {
                    outputDTO.setCzlx(EnumZBKOutputType.CXTJCK.toValue());
                    break;
                }
                case SNKSTJRK: {
                    outputDTO.setCzlx(EnumZBKOutputType.CXTJCK.toValue());
                    break;
                }
                case KSTJRK: {
                    outputDTO.setCzlx(EnumZBKOutputType.CXTJCK.toValue());
                    break;
                }
                default: {
                    throw new RuntimeException("\u76ee\u524d\u4ec5\u652f\u6301\u5212\u8f6c\u64a4\u9500");
                }
            }
            if (StrUtil.isNotBlank((CharSequence)input.getSrcid())) {
                ZBKOutputDetail outputDetail = zbkOutputDetails.stream().filter(f -> f.getId().equals(input.getSrcid())).findFirst().orElse(null);
                outputDTO.setCkxzqmc(outputDetail.getZbxzqmc());
                outputDTO.setCkxzqdm(outputDetail.getZbxzqdm());
            }
            outputDTO.setZbid(input.getId());
            outputDTO.setUserid(sysUser.getId());
            outputDTO.setUsername(sysUser.getAlisname());
            outputDTO.setCzxzqdm(sysUser.getXzqdm());
            outputDTO.setCzxzqmc(sysUser.getFullXzqmc());
            outputDTOS.add(outputDTO);
        }
        return this.output(outputDTOS);
    }

    @Override
    public boolean beforeLock(List<ZBKOutputDTO> outputDetails, RefObject<String> msg) {
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    protected void lock(ZBKOutputDTO outputDTO, String lsh) {
        ZBKOutputDetailGC zbkOutputDetailGC = new ZBKOutputDetailGC();
        BeanUtil.copyProperties((Object)outputDTO, (Object)zbkOutputDetailGC, (String[])new String[0]);
        this.lockUtil.getLock(outputDTO.getZbid(), EnumLockType.ZB);
        ZBKDKDetail zbkInputDetail = outputDTO.getZbkdkDetail();
        if (zbkInputDetail == null) {
            zbkInputDetail = this.zbkdkDetailService.findById(zbkOutputDetailGC.getZbid(), false);
        }
        if (zbkInputDetail == null) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u5728\u6307\u6807\u5e93\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
        }
        if (zbkInputDetail == null) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u5728\u6307\u6807\u5e93\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
        }
        if (zbkInputDetail.getStmjsy() < outputDTO.getStmj()) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u6c34\u7530\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
        }
        if (zbkInputDetail.getGdmjsy() < outputDTO.getGdmj()) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u8015\u5730\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
        }
        if (zbkInputDetail.getCnzbsy() < outputDTO.getCnzb()) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u4ea7\u80fd\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
        }
        zbkOutputDetailGC.setId(UUID.randomUUID().toString());
        zbkOutputDetailGC.setDate(new Date());
        zbkOutputDetailGC.setZblx(zbkInputDetail.getZblx());
        zbkOutputDetailGC.setZbxmbh(zbkInputDetail.getXmbh());
        zbkOutputDetailGC.setZbxmmc(zbkInputDetail.getXmmc());
        zbkOutputDetailGC.setZbxmmc(zbkInputDetail.getXmmc());
        zbkOutputDetailGC.setZbdkbh(zbkInputDetail.getDkbh());
        zbkOutputDetailGC.setZbdkmc(zbkInputDetail.getDkmc());
        zbkOutputDetailGC.setZbgddb(zbkInputDetail.getGddb());
        zbkOutputDetailGC.setDkxzqdm(zbkInputDetail.getDkxzqdm());
        zbkOutputDetailGC.setDkxzqmc(zbkInputDetail.getDkxzqmc());
        zbkOutputDetailGC.setZbxzqdm(zbkInputDetail.getZbxzqdm());
        zbkOutputDetailGC.setZbxzqmc(zbkInputDetail.getZbxzqmc());
        zbkOutputDetailGC.setSid(lsh);
        this.zbkOutputDetailGCService.saveOrUpdate(zbkOutputDetailGC);
        this.zbkUseDetailService.lock(zbkInputDetail.getId(), outputDTO.getCnzb(), outputDTO.getGdmj(), outputDTO.getStmj());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String lock(List<ZBKOutputDTO> outputDetails) {
        return this.lock("", outputDetails);
    }

    @Override
    public String lock(String lockLsh, List<ZBKOutputDTO> outputDetails) {
        lockLsh = super.lock(lockLsh, outputDetails);
        this.lockDk(lockLsh, outputDetails);
        return lockLsh;
    }

    private String lockDk(String lockLsh, List<ZBKOutputDTO> outputDetails) {
        if (outputDetails == null || outputDetails.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u9700\u8981\u9501\u5b9a\u7684\u6307\u6807!");
        }
        if (StrUtil.isBlank((CharSequence)lockLsh)) {
            throw new RuntimeException("\u6ca1\u6709\u9700\u8981\u9501\u5b9a\u7684\u6307\u6807!");
        }
        ArrayList<ZBKOutputDTO> outputDTOSResult = new ArrayList<ZBKOutputDTO>();
        List<ZBKOutputDTO> outputDTOSSplit = new ArrayList<ZBKOutputDTO>();
        for (ZBKOutputDTO item : outputDetails) {
            if (item.getGdShape() != null || item.getStShape() != null || item.getCnzbShape() != null) {
                outputDTOSResult.add(item);
                continue;
            }
            outputDTOSSplit.add(item);
        }
        if (outputDTOSSplit.size() > 0) {
            outputDTOSSplit = this.blockSplitService.blockSplitForOutputDk(outputDTOSSplit);
            outputDTOSResult.addAll(outputDTOSSplit);
        }
        outputDetails = outputDTOSResult;
        ArrayList<ZBKDkOutputDetailGC> zbkdkOutputDetailGCs = new ArrayList<ZBKDkOutputDetailGC>();
        List<ZBKOutputDetailGC> zbkOutputDetailGCs = this.zbkOutputDetailGCService.findListBySid(lockLsh);
        for (ZBKOutputDTO zbkOutputDTO : outputDetails) {
            ZBKDkOutputDetailGC zbkdkOutputDetailGC = new ZBKDkOutputDetailGC();
            this.lockUtil.getLock(zbkOutputDTO.getZbid(), EnumLockType.ZB);
            zbkdkOutputDetailGC.setId(UUID.randomUUID().toString());
            zbkdkOutputDetailGC.setSid(lockLsh);
            zbkdkOutputDetailGC.setZbid(zbkOutputDTO.getZbid());
            zbkdkOutputDetailGC.setGdShape(zbkOutputDTO.getGdShape());
            zbkdkOutputDetailGC.setStShape(zbkOutputDTO.getStShape());
            zbkdkOutputDetailGC.setCnzbShape(zbkOutputDTO.getCnzbShape());
            ZBKOutputDetailGC zbkOutputDetailGC = zbkOutputDetailGCs.stream().filter(detail -> detail != null && zbkOutputDTO.getZbid() == detail.getZbid()).findFirst().orElse(null);
            if (zbkOutputDetailGC != null) {
                zbkdkOutputDetailGC.setCkgcmxId(zbkOutputDetailGC.getId());
            }
            zbkdkOutputDetailGCs.add(zbkdkOutputDetailGC);
        }
        this.batchRepository.batchInsert(zbkdkOutputDetailGCs);
        this.zbkDkUseDetailService.lockDkByLsh(lockLsh);
        return lockLsh;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unLock2Output(String lsh, boolean output, List<ZBKOperateDetail> zbkOperateDetail) {
        List<ZBKOutputDetailGC> lockDetails = this.zbkOutputDetailGCService.findListBySid(lsh);
        Date now = new Date();
        if (!output) {
            lockDetails.forEach(f -> this.lockUtil.getLock(f.getZbid(), EnumLockType.ZB));
            this.zbkUseDetailService.unLockNotOutputByLsh(lsh);
            this.zbkOutputDetailGCService.deleteByLsh(lsh);
        } else {
            ArrayList<ZBKOutputDetail> outputDetails = new ArrayList<ZBKOutputDetail>();
            lockDetails.forEach(f -> {
                this.lockUtil.getLock(f.getZbid(), EnumLockType.ZB);
                ZBKOutputDetail zbkOutputDetail = new ZBKOutputDetail();
                BeanUtil.copyProperties((Object)f, (Object)zbkOutputDetail, (String[])new String[0]);
                zbkOutputDetail.setId(UUID.randomUUID().toString());
                if (zbkOutputDetail.getDate() == null) {
                    zbkOutputDetail.setDate(now);
                }
                zbkOutputDetail.setOperDate(now);
                outputDetails.add(zbkOutputDetail);
            });
            this.batchRepository.batchInsert(outputDetails);
            this.zbkUseDetailService.unLockOutputByLsh(lsh);
            this.zbkOutputDetailGCService.deleteByLsh(lsh);
            if (zbkOperateDetail == null) {
                this.zbkOperateDetailService.saveOrUpdate(this.zbkOperateDetailService.getOutputOperateDetail(outputDetails));
            } else {
                zbkOperateDetail.forEach(f -> f.setLsh(((ZBKOutputDetail)outputDetails.get(0)).getSid()));
                this.zbkOperateDetailService.saveOrUpdate(zbkOperateDetail);
            }
        }
        this.unLockDk2Output(lsh, output, zbkOperateDetail);
    }

    private void unLockDk2Output(String lsh, boolean output, List<ZBKOperateDetail> zbkOperateDetail) {
        List<ZBKDkOutputDetailGC> lockDetails = this.zbkdkOutputDetailGCService.findListBySid(lsh);
        if (!output) {
            lockDetails.forEach(f -> this.lockUtil.getLock(f.getZbid(), EnumLockType.ZB));
            this.zbkDkUseDetailService.unLockDkNotOutputByLsh(lsh);
            this.zbkdkOutputDetailGCService.deleteByLsh(lsh);
        } else {
            List<ZBKOutputDetail> zbkOutputDetails = this.zbkOutputDetailService.findListBySid(lsh);
            ArrayList outputDetails = new ArrayList();
            lockDetails.forEach(f -> {
                this.lockUtil.getLock(f.getZbid(), EnumLockType.ZB);
                ZBKDkOutputDetail zbkdkOutputDetail = new ZBKDkOutputDetail();
                BeanUtil.copyProperties((Object)f, (Object)zbkdkOutputDetail, (String[])new String[0]);
                zbkdkOutputDetail.setId(UUID.randomUUID().toString());
                if (zbkOutputDetails.size() > 0) {
                    for (ZBKOutputDetail zbkOutputDetail : zbkOutputDetails) {
                        if (!zbkdkOutputDetail.getSid().equalsIgnoreCase(zbkOutputDetail.getSid()) || !zbkdkOutputDetail.getZbid().equalsIgnoreCase(zbkOutputDetail.getZbid())) continue;
                        zbkdkOutputDetail.setCkmxId(zbkOutputDetail.getId());
                    }
                }
                outputDetails.add(zbkdkOutputDetail);
            });
            this.batchRepository.batchInsert(outputDetails);
            this.zbkDkUseDetailService.unLockDkOutputByLsh(lsh);
            this.zbkdkOutputDetailGCService.deleteByLsh(lsh);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unLock2Output(String lsh, boolean output) {
        this.unLock2Output(lsh, output, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unOutput2Lock(String lsh) {
        super.unOutput2Lock(lsh);
        this.unOutputDk2Lock(lsh);
    }

    private void unOutputDk2Lock(String lsh) {
        List<ZBKOutputDetailGC> outputDetailGCs = this.zbkOutputDetailGCService.findListBySid(lsh);
        List<ZBKDkOutputDetail> outputDkDetails = this.zbkdkOutputDetailService.findListBySid(lsh);
        ArrayList outputDkDetailGCS = new ArrayList();
        outputDkDetails.forEach(f -> {
            this.lockUtil.getLock(f.getZbid(), EnumLockType.ZB);
            ZBKDkOutputDetailGC outputDkDetailGC = new ZBKDkOutputDetailGC();
            BeanUtil.copyProperties((Object)f, (Object)outputDkDetailGC, (String[])new String[0]);
            outputDkDetailGC.setId(UUID.randomUUID().toString());
            ZBKOutputDetailGC zbkOutputDetailGC = outputDetailGCs.stream().filter(detail -> detail != null && outputDkDetailGC.getZbid().equalsIgnoreCase(detail.getZbid())).findFirst().orElse(null);
            if (zbkOutputDetailGC != null) {
                outputDkDetailGC.setCkgcmxId(zbkOutputDetailGC.getId());
            }
            outputDkDetailGCS.add(outputDkDetailGC);
        });
        this.batchRepository.batchInsert(outputDkDetailGCS);
        this.zbkDkUseDetailService.un0utputDkLockByLsh(lsh);
        this.zbkdkOutputDetailService.deleteByLsh(lsh);
    }

    private void batchInputDk(List<ZBKInputDTO> zbkDtos) {
        ArrayList<ZBKDkUseDetail> ZBKDkUseDetails = new ArrayList<ZBKDkUseDetail>();
        for (ZBKInputDTO zbkDto : zbkDtos) {
            ZBKInputDetail zbkInputDetail = zbkDto.getZbkInputDetail();
            ZBKDkUseDetail zbkDkUseDetail = new ZBKDkUseDetail(zbkInputDetail);
            if (zbkInputDetail.getCzlx().equalsIgnoreCase(EnumZBKInputType.ZBBBRK.toValue())) {
                ZBKSpatialDetail zbkSpatialDetail;
                if (zbkDto.getZbkSpatialDetail() != null && (zbkSpatialDetail = zbkDto.getZbkSpatialDetail()).getShape() != null) {
                    if (zbkInputDetail.getGdmj() != null && zbkInputDetail.getGdmj() > 0.0) {
                        zbkDkUseDetail.setGdShape(zbkSpatialDetail.getShape());
                        zbkDkUseDetail.setGdShapeSy(zbkSpatialDetail.getShape());
                    }
                    if (zbkInputDetail.getStmj() != null && zbkInputDetail.getStmj() > 0.0) {
                        zbkDkUseDetail.setStShape(zbkSpatialDetail.getShape());
                        zbkDkUseDetail.setStShapeSy(zbkSpatialDetail.getShape());
                    }
                    if (zbkInputDetail.getCnzb() != null && zbkInputDetail.getCnzb() > 0.0) {
                        zbkDkUseDetail.setCnzbShape(zbkSpatialDetail.getShape());
                        zbkDkUseDetail.setCnzbShapeSy(zbkSpatialDetail.getShape());
                    }
                }
            } else {
                if (zbkInputDetail.getGdmj() != null && zbkInputDetail.getGdmj() > 0.0 && zbkInputDetail.getGdShape() != null) {
                    zbkDkUseDetail.setGdShape(zbkInputDetail.getGdShape());
                    zbkDkUseDetail.setGdShapeSy(zbkInputDetail.getGdShape());
                }
                if (zbkInputDetail.getStmj() != null && zbkInputDetail.getStmj() > 0.0 && zbkInputDetail.getStShape() != null) {
                    zbkDkUseDetail.setStShape(zbkInputDetail.getStShape());
                    zbkDkUseDetail.setStShapeSy(zbkInputDetail.getStShape());
                }
                if (zbkInputDetail.getCnzb() != null && zbkInputDetail.getCnzb() > 0.0 && zbkInputDetail.getCnzbShape() != null) {
                    zbkDkUseDetail.setCnzbShape(zbkInputDetail.getCnzbShape());
                    zbkDkUseDetail.setCnzbShapeSy(zbkInputDetail.getCnzbShape());
                }
            }
            ZBKDkUseDetails.add(zbkDkUseDetail);
        }
        this.batchRepository.batchInsert(ZBKDkUseDetails);
    }
}

