/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkmanager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.zbph.constant.base.EnumLockType;
import com.geoway.onemap.zbph.constant.base.EnumLshType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.domain.base.RefObject;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDKDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKInputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOperateDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetailGC;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKSpatialDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKUseDetail;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKInputDTO;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKOutputDTO;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKSpatialDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKInputDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOperateDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOutputDetailGCService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOutputDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKUseDetailService;
import com.geoway.onemap.zbph.supoort.BatchRepository;
import com.geoway.onemap.zbph.supoort.LockUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnExpression(value="${project.inputZbkSpatial.enable:false}==false")
public class ZBKManagerServiceImpl
implements ZBKManagerService {
    private static final Logger log = LoggerFactory.getLogger(ZBKManagerServiceImpl.class);
    @Autowired
    protected ZBKUseDetailService zbkUseDetailService;
    @Autowired
    protected ZBKOutputDetailGCService zbkOutputDetailGCService;
    @Autowired
    protected ZBKDKSpatialDetailService zbkdkSpatialDetailService;
    @Autowired
    protected BaseLshService baseSidService;
    @Autowired
    protected ZBKOutputDetailService zbkOutputDetailService;
    @Autowired
    protected ZBKInputDetailService zbkInputDetailService;
    @Autowired
    protected ZBKOperateDetailService zbkOperateDetailService;
    @Autowired
    protected ZBKDKDetailService zbkdkDetailService;
    @Autowired
    protected LockUtil lockUtil;
    @Autowired
    private BatchRepository batchRepository;

    @Override
    public boolean beforeInput(List<ZBKInputDTO> zbkInputDTOS, RefObject<String> msg) {
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String input(List<ZBKInputDTO> zbkInputDTOS) {
        if (zbkInputDTOS == null || zbkInputDTOS.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u6570\u636e\u9700\u8981\u5165\u5230\u6307\u6807\u5e93!");
        }
        Date now = new Date();
        zbkInputDTOS.forEach(f -> {
            if (f.getZbkInputDetail().getDate() == null) {
                f.getZbkInputDetail().setDate(now);
            }
            f.getZbkInputDetail().setOperDate(now);
        });
        String inputLsh = this.baseSidService.generateLsh(zbkInputDTOS.get(0).getZbkInputDetail().getCzxzqdm(), EnumLshType.LSH);
        zbkInputDTOS.forEach(f -> f.getZbkInputDetail().setLsh(inputLsh));
        this.batchInput(zbkInputDTOS);
        this.zbkOperateDetailService.saveOrUpdate(this.zbkOperateDetailService.getInputOperateDetail(zbkInputDTOS.stream().map(f -> f.getZbkInputDetail()).collect(Collectors.toList())));
        return inputLsh;
    }

    @Override
    public boolean beforeOutput(List<ZBKOutputDTO> outputDetails, RefObject<String> msg) {
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String output(List<ZBKOutputDTO> outputDTOS) {
        if (outputDTOS == null || outputDTOS.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u6570\u636e\u9700\u8981\u5165\u5230\u6307\u6807\u5e93!");
        }
        String lsh = this.baseSidService.generateLsh(outputDTOS.get(0).getCzxzqdm(), EnumLshType.LSH);
        List<ZBKOutputDetail> zbkOutputDetails = outputDTOS.stream().map(f -> this.convert2OutputDetail((ZBKOutputDTO)f, lsh)).collect(Collectors.toList());
        Date now = new Date();
        zbkOutputDetails.forEach(f -> {
            if (f.getDate() == null) {
                f.setDate(now);
            }
            f.setOperDate(now);
        });
        this.zbkOperateDetailService.saveOrUpdate(this.zbkOperateDetailService.getOutputOperateDetail(zbkOutputDetails));
        this.batchRepository.batchInsert(zbkOutputDetails);
        this.zbkUseDetailService.outputByLsh(zbkOutputDetails.get(0).getSid());
        return lsh;
    }

    @Override
    public String revertOutput(String sid, SysUser sysUser) {
        Date now = new Date();
        List<ZBKOutputDetail> zbkOutputs = this.zbkOutputDetailService.findListBySid(sid);
        List<ZBKInputDetail> zbkInputDetails = this.zbkInputDetailService.findByZbids(zbkOutputs.stream().map(f -> f.getZbid()).collect(Collectors.toList()));
        ArrayList<ZBKInputDTO> inputDTOS = new ArrayList<ZBKInputDTO>();
        for (ZBKOutputDetail output : zbkOutputs) {
            ZBKInputDTO inputDTO = new ZBKInputDTO();
            ZBKInputDetail tempZbkInputDetail = zbkInputDetails.stream().filter(f -> f.getId().equals(output.getZbid())).findFirst().orElse(null);
            ZBKInputDetail zbkInputDetail = new ZBKInputDetail();
            BeanUtil.copyProperties((Object)tempZbkInputDetail, (Object)zbkInputDetail, (String[])new String[0]);
            switch (EnumZBKOutputType.fromValue(output.getCzlx())) {
                case BCGDHJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.QXZBHJRK.toValue());
                    break;
                }
                case KSTJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.CXTJRK.toValue());
                    break;
                }
                case SNKXTJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.CXTJRK.toValue());
                    break;
                }
                case SNKSTJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.CXTJRK.toValue());
                    break;
                }
                case WFYDDJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.WFYDJDRK.toValue());
                    break;
                }
                case QTDJCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.QTDJJDRK.toValue());
                    break;
                }
                case JSXMGGCK: {
                    zbkInputDetail.setCzlx(EnumZBKInputType.FNJSZYGDJGRK.toValue());
                    break;
                }
                default: {
                    throw new RuntimeException("\u76ee\u524d\u4ec5\u652f\u6301\u8865\u5145\u6838\u51cf\u64a4\u9500");
                }
            }
            zbkInputDetail.setCnzb(output.getCnzb());
            zbkInputDetail.setGdmj(output.getGdmj());
            zbkInputDetail.setStmj(output.getStmj());
            if (zbkInputDetail.getDate() == null) {
                zbkInputDetail.setDate(now);
            }
            zbkInputDetail.setOperDate(now);
            zbkInputDetail.setUserid(sysUser.getId());
            zbkInputDetail.setUsername(sysUser.getAlisname());
            zbkInputDetail.setCzxzqdm(sysUser.getXzqdm());
            zbkInputDetail.setCzxzqmc(sysUser.getFullXzqmc());
            zbkInputDetail.setZbxzqdm(output.getZbxzqdm());
            zbkInputDetail.setZbxzqmc(output.getZbxzqmc());
            zbkInputDetail.setSrcid(output.getId());
            inputDTO.setZbkInputDetail(zbkInputDetail);
            inputDTOS.add(inputDTO);
        }
        return this.input(inputDTOS);
    }

    @Override
    public String revertInput(String inputSid, SysUser sysUser) {
        List<ZBKDKDetail> zbkInputs = this.zbkdkDetailService.findListByLsh(inputSid);
        List<ZBKOutputDetail> zbkOutputDetails = this.zbkOutputDetailService.findByIds(zbkInputs.stream().filter(f -> StrUtil.isNotBlank((CharSequence)f.getSrcid())).map(f -> f.getSrcid()).collect(Collectors.toList()));
        if (zbkInputs.stream().filter(f -> f.getCnzbsd() > 0.0 || f.getCnzbyy() > 0.0 || f.getGdmjsd() > 0.0 || f.getGdmjyy() > 0.0 || f.getStmjsd() > 0.0 || f.getStmjyy() > 0.0).count() > 0L) {
            throw new RuntimeException("\u6307\u6807\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u64a4\u9500\uff01");
        }
        ArrayList<ZBKOutputDTO> outputDTOS = new ArrayList<ZBKOutputDTO>();
        for (ZBKDKDetail input : zbkInputs) {
            ZBKOutputDTO outputDTO = new ZBKOutputDTO();
            BeanUtil.copyProperties((Object)input, (Object)outputDTO, (String[])new String[0]);
            switch (EnumZBKInputType.fromValue(input.getCzlx())) {
                case SNKXTJRK: {
                    outputDTO.setCzlx(EnumZBKOutputType.CXTJCK.toValue());
                    break;
                }
                case SNKSTJRK: {
                    outputDTO.setCzlx(EnumZBKOutputType.CXTJCK.toValue());
                    break;
                }
                case KSTJRK: {
                    outputDTO.setCzlx(EnumZBKOutputType.CXTJCK.toValue());
                    break;
                }
                default: {
                    throw new RuntimeException("\u76ee\u524d\u4ec5\u652f\u6301\u5212\u8f6c\u64a4\u9500");
                }
            }
            if (StrUtil.isNotBlank((CharSequence)input.getSrcid())) {
                ZBKOutputDetail outputDetail = zbkOutputDetails.stream().filter(f -> f.getId().equals(input.getSrcid())).findFirst().orElse(null);
                outputDTO.setCkxzqmc(outputDetail.getZbxzqmc());
                outputDTO.setCkxzqdm(outputDetail.getZbxzqdm());
            }
            outputDTO.setZbid(input.getId());
            outputDTO.setUserid(sysUser.getId());
            outputDTO.setUsername(sysUser.getAlisname());
            outputDTO.setCzxzqdm(sysUser.getXzqdm());
            outputDTO.setCzxzqmc(sysUser.getFullXzqmc());
            outputDTOS.add(outputDTO);
        }
        return this.output(outputDTOS);
    }

    @Override
    public boolean beforeLock(List<ZBKOutputDTO> outputDetails, RefObject<String> msg) {
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    protected void lock(ZBKOutputDTO outputDTO, String lsh) {
        ZBKOutputDetailGC zbkOutputDetailGC = new ZBKOutputDetailGC();
        BeanUtil.copyProperties((Object)outputDTO, (Object)zbkOutputDetailGC, (String[])new String[0]);
        this.lockUtil.getLock(outputDTO.getZbid(), EnumLockType.ZB);
        ZBKDKDetail zbkInputDetail = outputDTO.getZbkdkDetail();
        if (zbkInputDetail == null) {
            zbkInputDetail = this.zbkdkDetailService.findById(zbkOutputDetailGC.getZbid(), false);
        }
        if (zbkInputDetail == null) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u5728\u6307\u6807\u5e93\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
        }
        if (zbkInputDetail == null) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u5728\u6307\u6807\u5e93\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
        }
        if (zbkInputDetail.getStmjsy() < outputDTO.getStmj()) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u6c34\u7530\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
        }
        if (zbkInputDetail.getGdmjsy() < outputDTO.getGdmj()) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u8015\u5730\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
        }
        if (zbkInputDetail.getCnzbsy() < outputDTO.getCnzb()) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u4ea7\u80fd\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
        }
        zbkOutputDetailGC.setId(UUID.randomUUID().toString());
        zbkOutputDetailGC.setDate(new Date());
        zbkOutputDetailGC.setZblx(zbkInputDetail.getZblx());
        zbkOutputDetailGC.setZbxmbh(zbkInputDetail.getXmbh());
        zbkOutputDetailGC.setZbxmmc(zbkInputDetail.getXmmc());
        zbkOutputDetailGC.setZbxmmc(zbkInputDetail.getXmmc());
        zbkOutputDetailGC.setZbdkbh(zbkInputDetail.getDkbh());
        zbkOutputDetailGC.setZbdkmc(zbkInputDetail.getDkmc());
        zbkOutputDetailGC.setZbgddb(zbkInputDetail.getGddb());
        zbkOutputDetailGC.setDkxzqdm(zbkInputDetail.getDkxzqdm());
        zbkOutputDetailGC.setDkxzqmc(zbkInputDetail.getDkxzqmc());
        zbkOutputDetailGC.setZbxzqdm(zbkInputDetail.getZbxzqdm());
        zbkOutputDetailGC.setZbxzqmc(zbkInputDetail.getZbxzqmc());
        zbkOutputDetailGC.setSid(lsh);
        this.zbkOutputDetailGCService.saveOrUpdate(zbkOutputDetailGC);
        this.zbkUseDetailService.lock(zbkInputDetail.getId(), outputDTO.getCnzb(), outputDTO.getGdmj(), outputDTO.getStmj());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String lock(List<ZBKOutputDTO> outputDetails) {
        return this.lock("", outputDetails);
    }

    @Override
    public String lock(String lockLsh, List<ZBKOutputDTO> outputDetails) {
        if (outputDetails == null || outputDetails.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u9700\u8981\u9501\u5b9a\u7684\u6307\u6807!");
        }
        if (StrUtil.isBlank((CharSequence)lockLsh)) {
            lockLsh = this.baseSidService.generateLsh(outputDetails.get(0).getCzxzqdm(), EnumLshType.LSH);
        }
        ArrayList<ZBKOutputDetailGC> zbkOutputDetailGCs = new ArrayList<ZBKOutputDetailGC>();
        for (ZBKOutputDTO outputDTO : outputDetails) {
            ZBKOutputDetailGC zbkOutputDetailGC = new ZBKOutputDetailGC();
            BeanUtil.copyProperties((Object)outputDTO, (Object)zbkOutputDetailGC, (String[])new String[0]);
            this.lockUtil.getLock(outputDTO.getZbid(), EnumLockType.ZB);
            ZBKDKDetail zbkInputDetail = outputDTO.getZbkdkDetail();
            if (zbkInputDetail == null) {
                System.out.println("\u51fa\u5e93\u8017\u65f6\uff1a" + zbkOutputDetailGC.getZbid());
                zbkInputDetail = this.zbkdkDetailService.findById(zbkOutputDetailGC.getZbid(), false);
            }
            if (zbkInputDetail == null) {
                throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u5728\u6307\u6807\u5e93\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
            }
            if (zbkInputDetail == null) {
                throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u5728\u6307\u6807\u5e93\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
            }
            if (zbkInputDetail.getStmjsy() < outputDTO.getStmj()) {
                throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u6c34\u7530\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
            }
            if (zbkInputDetail.getGdmjsy() < outputDTO.getGdmj()) {
                throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u8015\u5730\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
            }
            if (zbkInputDetail.getCnzbsy() < outputDTO.getCnzb()) {
                throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u4ea7\u80fd\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", outputDTO.getZbid()));
            }
            zbkOutputDetailGC.setId(UUID.randomUUID().toString());
            zbkOutputDetailGC.setDate(new Date());
            zbkOutputDetailGC.setZblx(zbkInputDetail.getZblx());
            zbkOutputDetailGC.setZbxmbh(zbkInputDetail.getXmbh());
            zbkOutputDetailGC.setZbxmmc(zbkInputDetail.getXmmc());
            zbkOutputDetailGC.setZbxmmc(zbkInputDetail.getXmmc());
            zbkOutputDetailGC.setZbdkbh(zbkInputDetail.getDkbh());
            zbkOutputDetailGC.setZbdkmc(zbkInputDetail.getDkmc());
            zbkOutputDetailGC.setZbgddb(zbkInputDetail.getGddb());
            zbkOutputDetailGC.setDkxzqdm(zbkInputDetail.getDkxzqdm());
            zbkOutputDetailGC.setDkxzqmc(zbkInputDetail.getDkxzqmc());
            zbkOutputDetailGC.setZbxzqdm(zbkInputDetail.getZbxzqdm());
            zbkOutputDetailGC.setZbxzqmc(zbkInputDetail.getZbxzqmc());
            zbkOutputDetailGC.setSid(lockLsh);
            zbkOutputDetailGCs.add(zbkOutputDetailGC);
        }
        this.batchRepository.batchInsert(zbkOutputDetailGCs);
        this.zbkUseDetailService.lockByLsh(lockLsh);
        return lockLsh;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unLock2Output(String lsh, boolean output, List<ZBKOperateDetail> zbkOperateDetail) {
        List<ZBKOutputDetailGC> lockDetails = this.zbkOutputDetailGCService.findListBySid(lsh);
        Date now = new Date();
        if (!output) {
            lockDetails.forEach(f -> this.lockUtil.getLock(f.getZbid(), EnumLockType.ZB));
            this.zbkUseDetailService.unLockNotOutputByLsh(lsh);
            this.zbkOutputDetailGCService.deleteByLsh(lsh);
        } else {
            ArrayList<ZBKOutputDetail> outputDetails = new ArrayList<ZBKOutputDetail>();
            lockDetails.forEach(f -> {
                this.lockUtil.getLock(f.getZbid(), EnumLockType.ZB);
                ZBKOutputDetail zbkOutputDetail = new ZBKOutputDetail();
                BeanUtil.copyProperties((Object)f, (Object)zbkOutputDetail, (String[])new String[0]);
                zbkOutputDetail.setId(UUID.randomUUID().toString());
                if (zbkOutputDetail.getDate() == null) {
                    zbkOutputDetail.setDate(now);
                }
                zbkOutputDetail.setOperDate(now);
                outputDetails.add(zbkOutputDetail);
            });
            this.batchRepository.batchInsert(outputDetails);
            this.zbkUseDetailService.unLockOutputByLsh(lsh);
            this.zbkOutputDetailGCService.deleteByLsh(lsh);
            if (zbkOperateDetail == null) {
                this.zbkOperateDetailService.saveOrUpdate(this.zbkOperateDetailService.getOutputOperateDetail(outputDetails));
            } else {
                zbkOperateDetail.forEach(f -> f.setLsh(((ZBKOutputDetail)outputDetails.get(0)).getSid()));
                this.zbkOperateDetailService.saveOrUpdate(zbkOperateDetail);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unLock2Output(String lsh, boolean output) {
        this.unLock2Output(lsh, output, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unOutput2Lock(String lsh) {
        List<ZBKOutputDetail> outputDetails = this.zbkOutputDetailService.findListBySid(lsh);
        ArrayList outputDetailGCS = new ArrayList();
        outputDetails.forEach(f -> {
            this.lockUtil.getLock(f.getZbid(), EnumLockType.ZB);
            ZBKOutputDetailGC outputDetailGC = new ZBKOutputDetailGC();
            BeanUtil.copyProperties((Object)f, (Object)outputDetailGC, (String[])new String[0]);
            outputDetailGC.setId(UUID.randomUUID().toString());
            outputDetailGC.setDate(new Date());
            outputDetailGCS.add(outputDetailGC);
        });
        this.batchRepository.batchInsert(outputDetailGCS);
        this.zbkUseDetailService.un0utputLockByLsh(lsh);
        this.zbkOutputDetailService.deleteByLsh(lsh);
        this.zbkOperateDetailService.deleteByLsh(lsh);
    }

    @Transactional(rollbackFor={Exception.class})
    protected void output(ZBKOutputDetail outputDetail) {
        this.zbkOutputDetailService.saveOrUpdate(outputDetail);
        this.zbkUseDetailService.output(outputDetail.getZbid(), outputDetail.getCnzb(), outputDetail.getGdmj(), outputDetail.getStmj());
    }

    private ZBKOutputDetail convert2OutputDetail(ZBKOutputDTO zbkOutputDTO, String sid) {
        this.lockUtil.getLock(zbkOutputDTO.getZbid(), EnumLockType.ZB);
        ZBKDKDetail zbkInputDetail = zbkOutputDTO.getZbkdkDetail();
        if (zbkInputDetail == null) {
            zbkInputDetail = this.zbkdkDetailService.findById(zbkOutputDTO.getZbid(), false);
        }
        if (zbkInputDetail == null) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u5728\u6307\u6807\u5e93\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u67e5\uff01", zbkOutputDTO.getZbid()));
        }
        if (zbkInputDetail.getStmjsy() < zbkOutputDTO.getStmj()) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u6c34\u7530\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", zbkOutputDTO.getZbid()));
        }
        if (zbkInputDetail.getGdmjsy() < zbkOutputDTO.getGdmj()) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u8015\u5730\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", zbkOutputDTO.getZbid()));
        }
        if (zbkInputDetail.getCnzbsy() < zbkOutputDTO.getCnzb()) {
            throw new RuntimeException(String.format("id\u4e3a\u3010%s\u3011\u4ea7\u80fd\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u51fa\u5e93,\u8bf7\u6838\u67e5\uff01", zbkOutputDTO.getZbid()));
        }
        ZBKOutputDetail outputDetail = new ZBKOutputDetail();
        BeanUtil.copyProperties((Object)zbkOutputDTO, (Object)outputDetail, (String[])new String[0]);
        outputDetail.setId(UUID.randomUUID().toString());
        outputDetail.setZblx(zbkInputDetail.getZblx());
        outputDetail.setZbxmbh(zbkInputDetail.getXmbh());
        outputDetail.setZbxmmc(zbkInputDetail.getXmmc());
        outputDetail.setZbxzqdm(zbkInputDetail.getZbxzqdm());
        outputDetail.setZbxzqmc(zbkInputDetail.getZbxzqmc());
        outputDetail.setZbdkbh(zbkInputDetail.getDkbh());
        outputDetail.setZbdkmc(zbkInputDetail.getDkmc());
        outputDetail.setDkxzqmc(zbkInputDetail.getDkxzqmc());
        outputDetail.setDkxzqdm(zbkInputDetail.getDkxzqdm());
        outputDetail.setZbgddb(zbkInputDetail.getGddb());
        outputDetail.setSid(sid);
        return outputDetail;
    }

    @Transactional(rollbackFor={Exception.class})
    protected void batchInput(List<ZBKInputDTO> zbkDtos) {
        ArrayList<ZBKInputDetail> zbkInputDetails = new ArrayList<ZBKInputDetail>();
        ArrayList<ZBKUseDetail> zbkUseDetails = new ArrayList<ZBKUseDetail>();
        ArrayList<ZBKSpatialDetail> zbkSpatialDetails = new ArrayList<ZBKSpatialDetail>();
        Date now = new Date();
        for (ZBKInputDTO zbkDto : zbkDtos) {
            ZBKInputDetail zbkInputDetail = zbkDto.getZbkInputDetail();
            if (zbkInputDetail.getDate() == null) {
                throw new RuntimeException("\u6ca1\u6709\u6307\u5b9a\u5165\u5e93\u65e5\u671f!");
            }
            zbkInputDetail.setOperDate(now);
            zbkInputDetail.setId(UUID.randomUUID().toString());
            zbkInputDetails.add(zbkInputDetail);
            ZBKUseDetail zbkUseDetail = new ZBKUseDetail(zbkInputDetail);
            zbkUseDetails.add(zbkUseDetail);
            if (zbkDto.getZbkSpatialDetail() == null) continue;
            ZBKSpatialDetail zbkSpatialDetail = zbkDto.getZbkSpatialDetail();
            zbkSpatialDetail.setId(UUID.randomUUID().toString());
            zbkSpatialDetail.setDkid(zbkInputDetail.getDkid());
            zbkSpatialDetails.add(zbkSpatialDetail);
        }
        this.batchRepository.batchInsert(zbkInputDetails);
        this.batchRepository.batchInsert(zbkUseDetails);
        this.batchRepository.batchInsert(zbkSpatialDetails);
    }
}

