/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbtj.dj.impl;

import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.core.support.http.StringUtils;
import com.geoway.onemap.zbph.constant.base.EnumUserLevel;
import com.geoway.onemap.zbph.constant.zbtj.EnumZbkdjState;
import com.geoway.onemap.zbph.domain.zbtj.Zbdj;
import com.geoway.onemap.zbph.dto.zbtj.ZbtjZbdjDTO;
import com.geoway.onemap.zbph.service.base.impl.AbstractXmxxManagerServiceImpl;
import com.geoway.onemap.zbph.service.zbkhandler.ZbkFreezeHandler;
import com.geoway.onemap.zbph.service.zbtj.dj.ZbdjManageService;
import com.geoway.onemap.zbph.service.zbtj.dj.ZbdjService;
import com.geoway.onemap.zbph.supoort.LockUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZbdjManageServiceImpl
extends AbstractXmxxManagerServiceImpl<ZbtjZbdjDTO, Zbdj, ZbdjService>
implements ZbdjManageService {
    @Autowired
    private ZbkFreezeHandler zbkFreezeHandler;
    @Value(value="${project.jdAuthVerify:false}")
    private Boolean jdAuthVerify;

    public ZbdjManageServiceImpl(ZbdjService service) {
        super(service);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeState(String id, String state, SysUser user) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        List<String> ids = Arrays.asList(id.split(","));
        if (ids.size() == 0) {
            return;
        }
        List list = ((ZbdjService)this.service).findByIds(ids);
        if (this.jdAuthVerify.booleanValue()) {
            String userLevel = EnumUserLevel.fromSysUser(user).toValue();
            int userLevelInt = Integer.parseInt(userLevel);
            for (Zbdj zbdj : list) {
                if (zbdj.getUserLevel() == null || Integer.valueOf(zbdj.getUserLevel()) >= userLevelInt) continue;
                throw new RuntimeException("\u8be5\u6307\u6807\u7531\u4e0a\u7ea7\u653f\u533a\u51bb\u7ed3\uff0c\u672c\u7ea7\u65e0\u6cd5\u89e3\u51bb\u3002");
            }
        }
        for (Zbdj zbdj : list) {
            if (EnumZbkdjState.fromValue(state) == EnumZbkdjState.Revert) {
                this.zbkFreezeHandler.revert(zbdj, user);
                zbdj.setJdtime(new Date());
                zbdj.setJdUserName(user.getUsername());
            }
            zbdj.setState(state);
        }
        ((ZbdjService)this.service).batchSaveOrUpdate(list, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchFreeze(List<String> ids, SysUser sysUser) {
        for (String id : ids) {
            ZbtjZbdjDTO zbtjZbdjDTO = (ZbtjZbdjDTO)this.detailByXmid(id);
            this.saveOrUpdate(zbtjZbdjDTO, sysUser);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdate(ZbtjZbdjDTO zbtjZbdjDTO, SysUser sysUser) {
        Zbdj xmxx = (Zbdj)zbtjZbdjDTO.getXmxx();
        this.zbkFreezeHandler.freeze(xmxx, zbtjZbdjDTO.getMxDetails(), sysUser);
        String userLevel = EnumUserLevel.fromSysUser(sysUser).toValue();
        ((Zbdj)zbtjZbdjDTO.getXmxx()).setUserLevel(userLevel);
        return super.saveOrUpdate(zbtjZbdjDTO, sysUser);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByXmid(String xmid) {
        throw new RuntimeException("\u4e0d\u652f\u6301\u5220\u9664\u64cd\u4f5c!!!!");
    }

    @Override
    public void lock(ZbtjZbdjDTO xmxxDto) {
        LockUtil lockUtil = (LockUtil)SpringContextUtil.getBean(LockUtil.class);
        xmxxDto.getMxDetails().stream().forEach(f -> lockUtil.getLock(((Zbdj)xmxxDto.getXmxx()).getLshType() + "_" + f.getXmmc() + f.getXmbh()));
    }
}

