/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbtj.hz.impl;

import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.RegionServiceUtil;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.core.support.http.StringUtils;
import com.geoway.onemap.zbph.constant.zbtj.EnumZbkhzState;
import com.geoway.onemap.zbph.domain.zbtj.Zbhz;
import com.geoway.onemap.zbph.dto.zbtj.ZbtjZbhzDTO;
import com.geoway.onemap.zbph.service.base.impl.AbstractXmxxManagerServiceImpl;
import com.geoway.onemap.zbph.service.zbkhandler.ZbkTransferHandler;
import com.geoway.onemap.zbph.service.zbtj.hz.ZbhzManageService;
import com.geoway.onemap.zbph.service.zbtj.hz.ZbhzService;
import com.geoway.onemap.zbph.supoort.LockUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZbhzManageServiceImpl
extends AbstractXmxxManagerServiceImpl<ZbtjZbhzDTO, Zbhz, ZbhzService>
implements ZbhzManageService {
    @Autowired
    private ZbkTransferHandler zbkTransferHandler;

    public ZbhzManageServiceImpl(ZbhzService service) {
        super(service);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeState(String id, String state, SysUser user) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        List<String> ids = Arrays.asList(id.split(","));
        if (ids.size() == 0) {
            return;
        }
        List list = ((ZbhzService)this.service).findByIds(ids);
        for (Zbhz zbhz : list) {
            if (EnumZbkhzState.fromValue(state) == EnumZbkhzState.Revert) {
                zbhz.setCxUserName(user.getUsername());
                zbhz.setCxTime(new Date());
                this.zbkTransferHandler.revert(zbhz, user);
            }
            zbhz.setState(state);
        }
        ((ZbhzService)this.service).batchSaveOrUpdate(list, user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdate(ZbtjZbhzDTO zbtjZbhzDTO, SysUser sysUser) {
        Zbhz xmxx = (Zbhz)zbtjZbhzDTO.getXmxx();
        xmxx.setHcXzqmc(RegionServiceUtil.getFullRegionName((String)xmxx.getHcXzqdm()));
        xmxx.setHrXzqmc(RegionServiceUtil.getFullRegionName((String)xmxx.getHrXzqdm()));
        this.zbkTransferHandler.transfer(xmxx, sysUser);
        return super.saveOrUpdate(zbtjZbhzDTO, sysUser);
    }

    @Override
    public void lock(ZbtjZbhzDTO xmxxDto) {
        LockUtil lockUtil = (LockUtil)SpringContextUtil.getBean(LockUtil.class);
        lockUtil.getLock(((Zbhz)xmxxDto.getXmxx()).getLshType() + "_" + ((Zbhz)xmxxDto.getXmxx()).getHcXzqdm());
        lockUtil.getLock(((Zbhz)xmxxDto.getXmxx()).getLshType() + "_" + ((Zbhz)xmxxDto.getXmxx()).getHrXzqdm());
    }

    @Override
    public void deleteByXmid(String xmid) {
    }
}

