/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zgck.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.core.domain.DictValue;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.service.DictService;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.EnumLshType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKType;
import com.geoway.onemap.zbph.domain.base.BaseCheckDetail;
import com.geoway.onemap.zbph.domain.base.BaseTaskManage;
import com.geoway.onemap.zbph.domain.base.ProcessStep;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDKDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOperateDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetailGC;
import com.geoway.onemap.zbph.domain.zgck.ZgckBcgdDkDetail;
import com.geoway.onemap.zbph.domain.zgck.ZgckBcgdXzqDetail;
import com.geoway.onemap.zbph.domain.zgck.ZgckXmxx;
import com.geoway.onemap.zbph.domain.zgck.ZgckZymjDetail;
import com.geoway.onemap.zbph.dto.base.QrdDownloadDTO;
import com.geoway.onemap.zbph.dto.base.SplitDTO;
import com.geoway.onemap.zbph.dto.base.WordFillDTO;
import com.geoway.onemap.zbph.dto.base.WordValDTO;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKOutputDTO;
import com.geoway.onemap.zbph.dto.zgck.DlbmGroupArea;
import com.geoway.onemap.zbph.dto.zgck.QrdTaskParam;
import com.geoway.onemap.zbph.dto.zgck.ZgckDTO;
import com.geoway.onemap.zbph.service.base.BaseQrdManageService;
import com.geoway.onemap.zbph.service.base.BaseTaskExecuteService;
import com.geoway.onemap.zbph.service.base.BaseTaskManageService;
import com.geoway.onemap.zbph.service.base.BlockSplitService;
import com.geoway.onemap.zbph.service.base.CustomQrdService;
import com.geoway.onemap.zbph.service.base.DataVerifyTaskService;
import com.geoway.onemap.zbph.service.base.GraphicAnalysisService;
import com.geoway.onemap.zbph.service.base.ProcessInstanceService;
import com.geoway.onemap.zbph.service.base.impl.AbstractXmxxManagerServiceImpl;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDkUseDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOperateDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOutputDetailGCService;
import com.geoway.onemap.zbph.service.zbkmanager.impl.ZBKOutputUtil;
import com.geoway.onemap.zbph.service.zgck.ZgckBcgdDkDetailService;
import com.geoway.onemap.zbph.service.zgck.ZgckManagerService;
import com.geoway.onemap.zbph.service.zgck.ZgckXmxxService;
import com.geoway.onemap.zbph.service.zgck.impl.ZgckXmxxServiceImpl;
import com.geoway.onemap.zbph.supoort.ExceptionCustomUtil;
import com.geoway.onemap.zbph.supoort.FileManageUtil;
import com.geoway.onemap.zbph.supoort.LockUtil;
import com.geoway.onemap.zbph.supoort.RedisLock;
import com.geoway.onemap.zbph.supoort.WordManageUtil;
import com.geoway.zhgd.domain.VerifyTask;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZgckManagerServiceImpl
extends AbstractXmxxManagerServiceImpl<ZgckDTO, ZgckXmxx, ZgckXmxxService>
implements ZgckManagerService,
BaseTaskExecuteService {
    private static final Logger log = LoggerFactory.getLogger(ZgckManagerServiceImpl.class);
    @Value(value="${project.splitBlock.enable:false}")
    private boolean splitBlock;
    @Autowired
    private ZgckBcgdDkDetailService zgckBcgdDkDetailService;
    @Autowired
    private ZBKManagerService zbkManagerService;
    @Autowired
    private ZBKDKDetailService zbkdkDetailService;
    @Autowired
    private BlockSplitService blockSplitService;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private ZgckBcgdDkDetailService dkDetailService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private BaseTaskManageService baseTaskManageService;
    @Autowired
    protected ZBKOutputDetailGCService zbkOutputDetailGCService;
    @Autowired
    protected ZBKOperateDetailService zbkOperateDetailService;
    @Autowired
    private DictService dictService;
    @Autowired
    private BaseQrdManageService baseQrdManageService;
    @Autowired
    private DataVerifyTaskService dataVerifyTaskService;
    @Autowired
    private GraphicAnalysisService graphicAnalysisService;
    @Autowired
    private CustomQrdService customQrdService;
    @Autowired
    ZBKDkUseDetailService zbkdkUseDetailService;

    public ZgckManagerServiceImpl(ZgckXmxxService service) {
        super(service);
    }

    @Override
    public List<ZgckDTO> findByXmbh(String xmbh) {
        ArrayList<ZgckDTO> dtos = new ArrayList<ZgckDTO>();
        List<String> xmids = this.dkDetailService.findXmIdByXmbh(xmbh);
        for (String xmid : xmids) {
            ZgckDTO fnZgckDTO = this.detailByXmid(xmid);
            dtos.add(fnZgckDTO);
        }
        return dtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdate(ZgckDTO xmxxDto, SysUser sysUser) {
        long start = System.currentTimeMillis();
        if (!((ZgckXmxxService)this.service).checkNameValid(((ZgckXmxx)xmxxDto.getXmxx()).getXmid(), ((ZgckXmxx)xmxxDto.getXmxx()).getXmmc())) {
            throw new RuntimeException(String.format("\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a\u3010%s\u3011\u7684\u9879\u76ee", ((ZgckXmxx)xmxxDto.getXmxx()).getXmmc()));
        }
        this.unlockZbk(xmxxDto, false);
        log.error("\u51fa\u5e93\u8017\u65f61:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.resetFNZygdDTO(sysUser, xmxxDto);
        log.error("\u51fa\u5e93\u8017\u65f62:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        ZgckXmxx zgckXmxx = (ZgckXmxx)xmxxDto.getXmxx();
        zgckXmxx.setXzqmc(sysUser.getFullXzqmc());
        zgckXmxx.setBcgdsl(xmxxDto.getBcgdDetails().stream().mapToDouble(f -> f.getBcgdmj()).sum());
        zgckXmxx.setBcstgm(xmxxDto.getBcgdDetails().stream().mapToDouble(f -> f.getBcstmj()).sum());
        zgckXmxx.setBcggxmgs((int)xmxxDto.getBcgdDetails().stream().map(f -> f.getZbkDetail().getXmbh()).distinct().count());
        zgckXmxx.setXbclscn(0.0);
        zgckXmxx.setVerification(0);
        zgckXmxx.setUnhook(0);
        zgckXmxx.setXbcgdsl(xmxxDto.getZygdmjDetails().stream().mapToDouble(f -> f.getZygdsl()).sum());
        zgckXmxx.setXbcstgm(xmxxDto.getZygdmjDetails().stream().mapToDouble(f -> f.getZystsl()).sum());
        String lockLsh = this.lockZbk(xmxxDto);
        ((ZgckXmxx)xmxxDto.getXmxx()).setCkLsh(lockLsh);
        log.error("\u51fa\u5e93\u8017\u65f63:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        super.saveOrUpdate(xmxxDto, sysUser);
        log.error("\u51fa\u5e93\u8017\u65f64:" + (System.currentTimeMillis() - start));
        return ((ZgckXmxx)xmxxDto.getXmxx()).getXmid();
    }

    private void unlockZbk(ZgckDTO zgckDTO, boolean output) {
        if (StrUtil.isEmpty((CharSequence)((ZgckXmxx)zgckDTO.getXmxx()).getCkLsh())) {
            return;
        }
        if (output) {
            List<ZBKOutputDetailGC> outputDetailGCList = this.zbkOutputDetailGCService.findListBySid(((ZgckXmxx)zgckDTO.getXmxx()).getCkLsh());
            List<ZBKOutputDetail> outputDetails = outputDetailGCList.stream().map(f -> {
                ZBKOutputDetail zbkOutputDetail = new ZBKOutputDetail();
                BeanUtil.copyProperties((Object)f, (Object)zbkOutputDetail, (String[])new String[0]);
                return zbkOutputDetail;
            }).collect(Collectors.toList());
            List<ZBKOperateDetail> operateDetailList = this.zbkOperateDetailService.getOutputOperateDetail(outputDetails);
            ZgckXmxx zgckXmxx = (ZgckXmxx)zgckDTO.getXmxx();
            String zy = String.format("\u8865\u5145\u8015\u5730\u786e\u8ba4\u4fe1\u606f\u7f16\u53f7\uff1a%s\uff0c\u5efa\u8bbe\u9879\u76ee\u540d\u79f0\uff1a%s", zgckXmxx.getBcgdxxqrdh().replace(EnumLshType.BCGDXXQRD.toValue(), ""), zgckXmxx.getXmmc());
            operateDetailList.forEach(f -> {
                f.setZy(zy);
                f.setZy_2(zy);
            });
            this.zbkManagerService.unLock2Output(((ZgckXmxx)zgckDTO.getXmxx()).getCkLsh(), output, operateDetailList);
        } else {
            this.zbkManagerService.unLock2Output(((ZgckXmxx)zgckDTO.getXmxx()).getCkLsh(), output);
        }
    }

    private void resetFNZygdDTO(SysUser sysUser, ZgckDTO zgckDTO) {
        if (zgckDTO.getBcgdDetails() != null && zgckDTO.getBcgdDetails().size() > 0) {
            List<ZBKDKDetail> zbkdkDetails = this.zbkdkDetailService.findByIds(zgckDTO.getBcgdDetails().stream().map(f -> f.getZbid()).collect(Collectors.toList()), false);
            zgckDTO.getBcgdDetails().forEach(f -> f.setZbkDetail(zbkdkDetails.stream().filter(g -> g.getId().equals(f.getZbid())).findFirst().orElse(null)));
            return;
        }
        ZgckXmxx fnZygdXmxx = (ZgckXmxx)zgckDTO.getXmxx();
        ArrayList<ZgckBcgdDkDetail> bcgdDkDetails = new ArrayList<ZgckBcgdDkDetail>();
        List<ZgckBcgdXzqDetail> bcgdXzqDetails = zgckDTO.getBcgdXzqDetails();
        Map<String, Map<String, List<ZgckBcgdXzqDetail>>> groupXzqDetail = bcgdXzqDetails.stream().collect(Collectors.groupingBy(ZgckBcgdXzqDetail::getXzqdm, Collectors.groupingBy(ZgckBcgdXzqDetail::getZblx)));
        for (Map.Entry<String, Map<String, List<ZgckBcgdXzqDetail>>> xzqKv : groupXzqDetail.entrySet()) {
            String xzq = xzqKv.getKey();
            for (Map.Entry<String, List<ZgckBcgdXzqDetail>> zblxKv : xzqKv.getValue().entrySet()) {
                ArrayList<ZBKOutputUtil.ZBKOutputParam> zbkOutputParams = new ArrayList<ZBKOutputUtil.ZBKOutputParam>();
                String zblx = zblxKv.getKey();
                for (ZgckBcgdXzqDetail xzqDetail : zblxKv.getValue()) {
                    String filterParam = "";
                    filterParam = String.format("Q_zblx_S_EQ=%s;Q_zbxzqdm_S_EQ=%s", xzqDetail.getZblx(), xzqDetail.getXzqdm());
                    if (StrUtil.isNotBlank((CharSequence)xzqDetail.getBcdlbm())) {
                        filterParam = String.format(filterParam + ";Q_dlbm_S_EQ=%s", xzqDetail.getBcdlbm());
                    }
                    if (xzqDetail.getBcgddb() != null && xzqDetail.getBcgddb() > 0) {
                        filterParam = String.format(filterParam + ";Q_gddb_N_EQ=%s", xzqDetail.getBcgddb());
                    }
                    String sortParam = "";
                    sortParam = StrUtil.isNotBlank((CharSequence)xzqDetail.getSortParam()) ? xzqDetail.getSortParam() : "SORT_date_ASC;SORT_gdmjsy_ASC";
                    ZBKOutputUtil.ZBKOutputParam zbkOutputParam = new ZBKOutputUtil.ZBKOutputParam();
                    zbkOutputParam.setFilterParam(filterParam);
                    zbkOutputParam.setGdmj(xzqDetail.getBcgdmj());
                    zbkOutputParam.setStmj(xzqDetail.getBcstmj());
                    zbkOutputParam.setSortParam(sortParam);
                    zbkOutputParams.add(zbkOutputParam);
                }
                ZBKOutputUtil.ZBKOutputParam zbkOutputParam = new ZBKOutputUtil.ZBKOutputParam();
                String filterParam = String.format("Q_zblx_S_EQ=%s;Q_zbxzqdm_S_EQ=%s", zblx, xzq);
                String sortParam = "SORT_date_ASC;SORT_cnzbsy_ASC";
                zbkOutputParam.setFilterParam(filterParam);
                zbkOutputParam.setGdmj(0.0);
                zbkOutputParam.setStmj(0.0);
                zbkOutputParam.setSortParam(sortParam);
                zbkOutputParams.add(zbkOutputParam);
                List<ZBKOutputDTO> zbkOutputDTOS = ZBKOutputUtil.getZBKOutputDTOs(zbkOutputParams, zblxKv.getValue().get(0).getBclscn());
                for (ZBKOutputDTO zbkOutputDTO : zbkOutputDTOS) {
                    ZgckBcgdDkDetail zgckBcgdDkDetail = new ZgckBcgdDkDetail();
                    zgckBcgdDkDetail.setBcgdmj(zbkOutputDTO.getGdmj());
                    zgckBcgdDkDetail.setBcstmj(zbkOutputDTO.getStmj());
                    zgckBcgdDkDetail.setBclscn(zbkOutputDTO.getCnzb());
                    zgckBcgdDkDetail.setXmid(fnZygdXmxx.getXmid());
                    zgckBcgdDkDetail.setZbid(zbkOutputDTO.getZbid());
                    ZBKDKDetail zbkdkDetail = zbkOutputDTO.getZbkdkDetail();
                    zgckBcgdDkDetail.setBcdlbm(zbkdkDetail.getDlbm());
                    zgckBcgdDkDetail.setBcdlmc(zbkdkDetail.getDlmc());
                    zgckBcgdDkDetail.setBcgddb((int)zbkdkDetail.getGddb());
                    zgckBcgdDkDetail.setZbkDetail(zbkdkDetail);
                    bcgdDkDetails.add(zgckBcgdDkDetail);
                }
            }
        }
        zgckDTO.setBcgdDetails(bcgdDkDetails);
    }

    private String lockZbk(ZgckDTO zgckDTO) {
        ArrayList<ZBKOutputDTO> lockDetails = new ArrayList<ZBKOutputDTO>();
        if (zgckDTO.getBcgdDetails() == null || zgckDTO.getBcgdDetails().size() == 0) {
            return "";
        }
        for (ZgckBcgdDkDetail bcgdDetail : zgckDTO.getBcgdDetails()) {
            ZBKOutputDTO zbkOutputDTO = new ZBKOutputDTO();
            ZgckXmxx fnZygdXmxx = (ZgckXmxx)zgckDTO.getXmxx();
            zbkOutputDTO.setCnzb(bcgdDetail.getBclscn());
            zbkOutputDTO.setCkxzqdm(fnZygdXmxx.getXmXzqdm());
            zbkOutputDTO.setCkxzqmc(fnZygdXmxx.getXmXzqmc());
            zbkOutputDTO.setCzxzqdm(fnZygdXmxx.getXzqdm());
            zbkOutputDTO.setCzxzqmc(fnZygdXmxx.getXzqmc());
            zbkOutputDTO.setStmj(bcgdDetail.getBcstmj());
            zbkOutputDTO.setGdmj(bcgdDetail.getBcgdmj());
            zbkOutputDTO.setXmbh(fnZygdXmxx.getXmbh());
            zbkOutputDTO.setXmmc(fnZygdXmxx.getXmmc());
            zbkOutputDTO.setUserid(fnZygdXmxx.getUserId());
            zbkOutputDTO.setUsername(fnZygdXmxx.getUserName());
            zbkOutputDTO.setZbid(bcgdDetail.getZbid());
            zbkOutputDTO.setZbkdkDetail(bcgdDetail.getZbkDetail());
            zbkOutputDTO.setCzlx(EnumZBKOutputType.JSXMGGCK.toValue());
            lockDetails.add(zbkOutputDTO);
        }
        return this.zbkManagerService.lock(((ZgckXmxx)zgckDTO.getXmxx()).getCkLsh(), lockDetails);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByXmid(String xmid) {
        ZgckDTO zgckDTO = this.detailByXmid(xmid);
        super.deleteByXmid(xmid);
        this.unlockZbk(zgckDTO, false);
    }

    @Override
    public ZgckDTO detailByXmid(String xmid, boolean dkxx) {
        ZgckDTO zgckDTO = (ZgckDTO)super.detailByXmid(xmid);
        if (dkxx && zgckDTO != null) {
            zgckDTO.setBcgdDetails(this.dkDetailService.findByXmid(xmid));
        }
        return zgckDTO;
    }

    @Override
    public ZgckDTO detailByXmid(String xmid) {
        return this.detailByXmid(xmid, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void finishByXmid(String[] xmids) {
        ((ZgckXmxxService)this.service).batchFinish(xmids);
        for (String xmid : xmids) {
            ZgckDTO zgckDTO = this.detailByXmid(xmid, false);
            this.unlockZbk(zgckDTO, true);
            if (!this.splitBlock) continue;
            this.blockSplit(xmid);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void blockSplit(String projectId) {
        List<ZgckBcgdDkDetail> details = this.zgckBcgdDkDetailService.findByXmid(projectId);
        if ((details = details.stream().filter(f -> f.getIsSplit() == null || f.getIsSplit() == 0).collect(Collectors.toList())).size() > 0) {
            ArrayList<String> keys = new ArrayList<String>();
            try {
                List zbIds = details.stream().map(m -> m.getZbid()).collect(Collectors.toList());
                for (String id : zbIds) {
                    String key = "block-split-" + id;
                    if (this.redisLock.tryLock(key, "", 5L).booleanValue()) {
                        keys.add(key);
                        continue;
                    }
                    throw new RuntimeException("\u5360\u8015\u5730\u5757\u5df2\u5728\u8fdb\u884c\u7834\u56fe\u6591\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                }
                Map<String, SplitDTO> split = this.blockSplitService.blockSplit(details.stream().map(m -> new SplitDTO(m.getZbid(), m.getBcgdmj())).collect(Collectors.toList()));
                details.stream().forEach(f -> {
                    SplitDTO dto = (SplitDTO)split.get(f.getZbid());
                    f.setShape(dto.getWkt());
                    f.setIsSplit(1);
                });
                this.zgckBcgdDkDetailService.updateBatch(details);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                keys.forEach(f -> this.redisLock.unlock((String)f));
            }
        }
    }

    @Override
    public String updateVerification(String xmids, String approvalOffice, String approvalTime, String verificationTime, String filterParam) throws Exception {
        String msg = "";
        ArrayList<ZgckXmxx> saveList = new ArrayList<ZgckXmxx>();
        List list = StringUtils.isNotBlank((CharSequence)filterParam) ? ((ZgckXmxxService)this.service).findByFilter(filterParam) : ((ZgckXmxxService)this.service).findByIds(Arrays.asList(xmids.split(",")));
        if ((list = list.stream().filter(f -> f.getVerification() != 1).collect(Collectors.toList())).isEmpty()) {
            return "0";
        }
        for (ZgckXmxx xmxx : list) {
            ProcessStep nextStep = this.processInstanceService.getNextStep(xmxx.getProcessId());
            if (nextStep != null) continue;
            String lockInfo = this.lockXm(xmxx);
            if (lockInfo != null) {
                msg = msg + lockInfo;
                continue;
            }
            if (xmxx.getUnhook() == null || xmxx.getUnhook() == 1) continue;
            xmxx.setVerification(1);
            xmxx.setVerificationTime(verificationTime);
            xmxx.setApprovalOffice(approvalOffice);
            xmxx.setApprovalTime(approvalTime);
            xmxx.setUpdateDate(DateUtil.now());
            saveList.add(xmxx);
        }
        if (saveList.size() > 0) {
            ((ZgckXmxxService)this.service).batchSaveOrUpdate(saveList, null);
        }
        return msg;
    }

    @Override
    public String unhook(String xmids, String unhookInfo, SysUser user, String filterParam) {
        String msg = "";
        ArrayList<ZgckXmxx> saveList = new ArrayList<ZgckXmxx>();
        List list = StringUtils.isNotBlank((CharSequence)filterParam) ? ((ZgckXmxxService)this.service).findByFilter(filterParam) : ((ZgckXmxxService)this.service).findByIds(Arrays.asList(xmids.split(",")));
        if ((list = list.stream().filter(f -> f.getUnhook() != 1).collect(Collectors.toList())).isEmpty()) {
            return "0";
        }
        for (ZgckXmxx xmxx : list) {
            ProcessStep nextStep = this.processInstanceService.getNextStep(xmxx.getProcessId());
            if (nextStep != null) continue;
            String lockInfo = this.lockXm(xmxx);
            if (lockInfo != null) {
                msg = msg + lockInfo;
                continue;
            }
            if (xmxx.getVerification() == null || xmxx.getVerification() == 1) continue;
            try {
                this.zbkManagerService.revertOutput(xmxx.getCkLsh(), user);
                xmxx.setUnhook(1);
                xmxx.setUnhookTime(DateUtil.now());
                xmxx.setUnhookInfo(unhookInfo);
                xmxx.setUpdateDate(DateUtil.now());
                saveList.add(xmxx);
            }
            catch (Exception e) {
                msg = msg + "\u3010" + xmxx.getXmmc() + "\u3011\u89e3\u6302\u5931\u8d25\uff1a" + e.getMessage() + ";";
            }
        }
        if (saveList.size() > 0) {
            ((ZgckXmxxService)this.service).batchSaveOrUpdate(saveList, null);
        }
        return msg;
    }

    private String lockXm(ZgckXmxx xmxx) {
        String msg = null;
        try {
            LockUtil lockUtil = (LockUtil)SpringContextUtil.getBean(LockUtil.class);
            lockUtil.getLock(xmxx.getXmid());
        }
        catch (Exception e) {
            msg = "\u3010" + xmxx.getXmmc() + "\u3011\u6b63\u5728\u8fdb\u884c\u6838\u9500\u6216\u89e3\u6302\uff0c\u5df2\u8df3\u8fc7\u672c\u6b21\u64cd\u4f5c\uff01";
        }
        return msg;
    }

    @Override
    public void createQrd(final String xmid, SysUser user) {
        ZgckDTO dto = this.detailByXmid(xmid);
        this.batchDownloadQrd((List<String>)new ArrayList<String>(){
            {
                this.add(xmid);
            }
        }, ((ZgckXmxx)dto.getXmxx()).getCklx(), user);
    }

    @Override
    public Map<String, List<DlbmGroupArea>> getDlbmGroupArea(String taskId) {
        JSONArray array = new JSONArray();
        List result = this.dataVerifyTaskService.queryAnalysResult(taskId, null);
        for (Object o : result) {
            JSONObject obj = (JSONObject)o;
            String name = obj.getString("serviceName");
            if (!ConfigConstant.GeoServerConfig.Service_Dlmj_Group.equals(name)) continue;
            array = obj.getJSONObject("result").getJSONArray("Results");
        }
        HashMap<String, List<DlbmGroupArea>> map = new HashMap<String, List<DlbmGroupArea>>();
        ArrayList<DlbmGroupArea> list = new ArrayList<DlbmGroupArea>();
        JSONObject json = null;
        for (Object e : array) {
            json = (JSONObject)e;
            Double yzmj = json.getDouble("YZMJ");
            Double kcxs = json.getDouble("KCXS");
            double area = (1.0 - kcxs) * yzmj;
            final DlbmGroupArea dlbmArea = new DlbmGroupArea();
            dlbmArea.setId(json.getString("DK_ID"));
            dlbmArea.setDlbm(json.getString("DLBM"));
            dlbmArea.setDlmc(json.getString("DLMC"));
            dlbmArea.setArea(area);
            list.add(dlbmArea);
            ArrayList<DlbmGroupArea> areaList = map.get(dlbmArea.getId());
            if (areaList == null || areaList.isEmpty()) {
                areaList = new ArrayList<DlbmGroupArea>(){
                    {
                        this.add(dlbmArea);
                    }
                };
            } else {
                areaList.add(dlbmArea);
            }
            map.put(dlbmArea.getId(), (List<DlbmGroupArea>)areaList);
        }
        for (Map.Entry entry : map.entrySet()) {
            List areaList = (List)entry.getValue();
            entry.setValue(areaList.stream().collect(Collectors.toMap(DlbmGroupArea::getDlbm, a -> {
                a.setArea(new BigDecimal(a.getArea() / 10000.0).setScale(4, 4).doubleValue());
                return a;
            }, (o1, o2) -> {
                Double area = o1.getArea() + o2.getArea();
                o1.setArea(new BigDecimal(area).setScale(4, 4).doubleValue());
                return o1;
            })).values().stream().collect(Collectors.toList()));
        }
        return map;
    }

    @Override
    public String sendDataVerity(List<TaskBlockDTO> blocks) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("areaType", "TerranArea");
        return this.dataVerifyTaskService.createTask(null, blocks, map, ConfigConstant.GeoServerConfig.Service_CK, VerifyTask.builder().customClass(ZgckXmxxServiceImpl.class.getName()).build());
    }

    @Override
    public void downloadQrd(HttpServletResponse respons, QrdDownloadDTO dto) {
        String path;
        List<String> list;
        if (StringUtils.isEmpty((CharSequence)dto.getXmid())) {
            List byFilter = ((ZgckXmxxService)this.service).findByFilter(dto.getFilterParam());
            byFilter = byFilter.stream().filter(f -> StringUtils.isNotEmpty((CharSequence)f.getBcgdxxqrdh())).collect(Collectors.toList());
            list = byFilter.stream().map(m -> m.getXmid()).collect(Collectors.toList());
        } else {
            list = Arrays.asList(dto.getXmid().split(","));
        }
        if (list.isEmpty()) {
            throw new RuntimeException("\u672a\u627e\u5230\u5b58\u5728\u786e\u8ba4\u5355\u7684\u6570\u636e\uff01\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\uff01");
        }
        if (dto.getIsZip().booleanValue() || list.size() > 1) {
            ArrayList<String> pathList = new ArrayList<String>();
            for (String xmid : list) {
                ZgckXmxx xmxx = (ZgckXmxx)((ZgckXmxxService)this.service).findById(xmid);
                String pdfPath = this.downloadQrdById(xmxx.getXmid(), xmxx.getCklx(), dto.getIsDelOld());
                ExceptionCustomUtil.isNull(pdfPath, "\u3010" + xmxx.getXmmc() + "\u3011\u786e\u8ba4\u5355\u6b63\u5728\u751f\u6210\u4e2d\uff01");
                pathList.add(pdfPath);
            }
            path = FileManageUtil.zip("\u8865\u5145\u8015\u5730\u4fe1\u606f\u786e\u8ba4\u5355", pathList);
            FileManageUtil.downloadFile(path, respons);
            FileManageUtil.deleteForceFile(path);
        } else {
            String xmid = list.get(0);
            ZgckXmxx xmxx = (ZgckXmxx)((ZgckXmxxService)this.service).findById(xmid);
            path = this.downloadQrdById(xmxx.getXmid(), xmxx.getCklx(), dto.getIsDelOld());
            ExceptionCustomUtil.isNull(path, "\u3010" + xmxx.getXmmc() + "\u3011\u786e\u8ba4\u5355\u6b63\u5728\u751f\u6210\u4e2d\uff01");
            FileManageUtil.downloadFile(path, respons);
        }
    }

    @Override
    public void blockRepeatVerify(List<String> wkts) {
        List<JSONObject> list = this.graphicAnalysisService.queryRepeatBlocks(wkts);
        if (CollectionUtil.isNotEmpty(list)) {
            JSONObject object = list.get(0);
            String xmid = object.get((Object)"F_XMID").toString();
            String dkbh = String.join((CharSequence)"\u3001", list.stream().map(m -> m.getString("F_DKBH")).collect(Collectors.toList()));
            ZgckDTO dto = this.detailByXmid(xmid, false);
            throw new RuntimeException("\u4e0e\u9879\u76ee\u3010" + ((ZgckXmxx)dto.getXmxx()).getXmmc() + "\u3011\u4e2d\u5730\u5757\u7f16\u53f7\u4e3a\u3010" + dkbh + "\u3011\u7684\u5730\u5757\u5b58\u5728\u91cd\u53e0\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
    }

    @Override
    public void execute(Map map, SysUser user, BaseTaskManage info) throws Exception {
        QrdTaskParam taskParam = QrdTaskParam.convertFromMap(map, QrdTaskParam.class);
        StringBuilder sbf = new StringBuilder();
        for (String xmid : taskParam.getXmids()) {
            try {
                this.downloadQrdById(xmid, taskParam.getQrdType(), true);
            }
            catch (Exception e) {
                sbf.append(e);
            }
        }
        info.setMsg(sbf.toString());
    }

    private void batchDownloadQrd(List<String> ids, String qrdType, SysUser sysUser) {
        QrdTaskParam param = new QrdTaskParam();
        param.setClassPath(this.getClass().getName());
        param.setXmids(ids);
        param.setQrdType(qrdType);
        param.setType("QRD");
        try {
            this.baseTaskManageService.createAsync(BeanUtil.beanToMap((Object)param, (String[])new String[0]), sysUser);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6253\u5305\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public String downloadQrdById(String xmid, String type, Boolean isDelOld) {
        ZgckDTO zgckDTO = this.detailByXmid(xmid);
        ArrayList<WordFillDTO> all = new ArrayList<WordFillDTO>();
        ZgckXmxx xmxx = (ZgckXmxx)zgckDTO.getXmxx();
        String bcgdxxqrdh = xmxx.getBcgdxxqrdh();
        if (StringUtils.isEmpty((CharSequence)bcgdxxqrdh)) {
            xmxx.setBcgdxxqrdh("001");
        }
        String qrd = xmxx.getBcgdxxqrdh();
        String tempName = null;
        String pdfPath = null;
        if (isDelOld.booleanValue()) {
            this.baseQrdManageService.deleteBcgdQrdPdf(xmxx.getXmmc(), xmxx.getCklx());
        } else {
            pdfPath = this.baseQrdManageService.getBcgdQrdPdf(xmxx.getXmmc(), xmxx.getCklx());
        }
        if (StringUtils.isEmpty((CharSequence)pdfPath)) {
            WordFillDTO xmmc = WordManageUtil.getWordFIll("xmmc", xmxx.getXmmc());
            all.add(xmmc);
            WordFillDTO xmxz = WordManageUtil.getWordFIll("xmxz", (String)xmxx.get("f_xmxz"));
            all.add(xmxz);
            WordFillDTO xmlx = WordManageUtil.getWordFIll("xmlx", (String)xmxx.get("f_xmlx"));
            all.add(xmlx);
            List values = this.dictService.queryDictValuesByDictKey("zgck-qrd-type");
            Map map = values.stream().collect(Collectors.toMap(DictValue::getItemText, Function.identity()));
            DictValue value = (DictValue)map.get(type);
            switch (value.getItemValue()) {
                case "FLCK": {
                    this.qrdManageHf(zgckDTO, all);
                    break;
                }
                default: {
                    this.qrdManage(zgckDTO, all);
                }
            }
            tempName = value.getJsonStr();
            List<BaseCheckDetail> baseCheckDetails = zgckDTO.getBaseCheckDetails();
            BaseCheckDetail detail = baseCheckDetails.stream().sorted(Comparator.comparing(BaseCheckDetail::getCheckDate).reversed()).findFirst().orElse(null);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            all.add(WordManageUtil.getWordFIll("time", sdf.format(detail.getCheckDate())));
            WordFillDTO jbr = WordManageUtil.getWordFIll("jbr", xmxx.getUserName());
            all.add(jbr);
            List<BaseCheckDetail> list = zgckDTO.getBaseCheckDetails();
            BaseCheckDetail checkDetail = list.stream().sorted(Comparator.comparing(BaseCheckDetail::getCheckDate).reversed()).findFirst().orElse(null);
            WordFillDTO shr = WordManageUtil.getWordFIll("shr", checkDetail.getCheckUserName());
            all.add(shr);
            List<WordFillDTO> fillDTOS = this.customQrdService.customFill(zgckDTO);
            if (CollectionUtil.isNotEmpty(fillDTOS)) {
                all.addAll(fillDTOS);
            }
            qrd = qrd.replace(EnumLshType.BCGDXXQRD.toValue(), "");
            String qrText = ConfigConstant.TbrkConfig.isQr != false ? ConfigConstant.SysConfig.System_Path + "/zbph/zgck/downloadQrd.do?xmid=" + xmid + "&qrdType=" + type : null;
            try {
                pdfPath = this.baseQrdManageService.getBcgdQrdPdf(all, qrd, qrText, tempName, xmxx.getXmmc(), type);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                pdfPath = this.baseQrdManageService.getBcgdQrdPdf(xmxx.getXmmc(), xmxx.getCklx());
            }
        }
        return pdfPath;
    }

    private List<WordFillDTO> qrdManage(ZgckDTO zgckDTO, List<WordFillDTO> all) {
        NumberFormat nft = NumberFormat.getInstance();
        nft.setMaximumFractionDigits(4);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        ZgckXmxx xmxx = (ZgckXmxx)zgckDTO.getXmxx();
        all.add(WordManageUtil.getWordFIll("sqydmj", nft.format(xmxx.get("f_jsmj")), 10));
        double bcgdmj = 0.0;
        double bcstmj = 0.0;
        double bcdlstmj = 0.0;
        for (ZgckZymjDetail detail : zgckDTO.getZygdmjDetails()) {
            if ("st".equals(detail.getTag())) {
                bcdlstmj += detail.getZygdsl();
                continue;
            }
            bcgdmj += detail.getZygdsl();
            bcstmj += detail.getZystsl();
        }
        all.add(WordManageUtil.getWordFIll("bcgdmj", bcgdmj <= 0.0 ? "0" : nft.format(BigDecimal.valueOf(bcgdmj).setScale(4, 4).doubleValue()), 10));
        all.add(WordManageUtil.getWordFIll("bcstmj", bcstmj <= 0.0 ? "0" : nft.format(BigDecimal.valueOf(bcstmj).setScale(4, 4).doubleValue()), 10));
        all.add(WordManageUtil.getWordFIll("bcdlstmj", bcdlstmj <= 0.0 ? "0" : nft.format(BigDecimal.valueOf(bcdlstmj).setScale(4, 4).doubleValue()), 10));
        double ybcgdmj = 0.0;
        double ybcstmj = 0.0;
        double ybcdlstmj = 0.0;
        if (zgckDTO.getBcgdXzqDetails() != null && zgckDTO.getBcgdXzqDetails().size() > 0) {
            for (ZgckBcgdXzqDetail detail : zgckDTO.getBcgdXzqDetails()) {
                if ("0101".equals(detail.getBcdlbm())) {
                    ybcdlstmj += detail.getBcgdmj();
                } else {
                    ybcstmj += detail.getBcstmj();
                }
                ybcgdmj += detail.getBcgdmj();
            }
        } else {
            for (ZgckBcgdDkDetail detail : zgckDTO.getBcgdDetails()) {
                if ("0101".equals(detail.getBcdlbm())) {
                    ybcdlstmj += detail.getBcgdmj();
                } else {
                    ybcstmj += detail.getBcstmj();
                }
                ybcgdmj += detail.getBcgdmj();
            }
        }
        all.add(WordManageUtil.getWordFIll("ybcgdmj", ybcgdmj <= 0.0 ? "0" : nft.format(BigDecimal.valueOf(ybcgdmj).setScale(4, 4).doubleValue()), 10));
        all.add(WordManageUtil.getWordFIll("ybcstmj", ybcstmj <= 0.0 ? "0" : nft.format(BigDecimal.valueOf(ybcstmj).setScale(4, 4).doubleValue()), 10));
        all.add(WordManageUtil.getWordFIll("ybcdlstmj", ybcdlstmj <= 0.0 ? "0" : nft.format(BigDecimal.valueOf(ybcdlstmj).setScale(4, 4).doubleValue()), 10));
        all.add(WordManageUtil.getWordFIll("sfwdzz", this.getWhether(xmxx.get("f_sfwdzz")), 6));
        all.add(WordManageUtil.getWordFIll("sfkcn", this.getWhether(xmxx.get("f_sfkcn")), 6));
        all.add(WordManageUtil.getWordFIll("cnrq", xmxx.get("f_cnrq") == null ? "" : sdf.format(xmxx.get("f_cnrq"))));
        all.add(WordManageUtil.getWordFIll("cngdmj", "0", 10));
        all.add(WordManageUtil.getWordFIll("cnstmj", "0", 10));
        return all;
    }

    private List<WordFillDTO> qrdManageHf(ZgckDTO zgckDTO, List<WordFillDTO> all) {
        ZgckXmxx xmxx = (ZgckXmxx)zgckDTO.getXmxx();
        List<ZgckZymjDetail> zygd = zgckDTO.getZygdmjDetails();
        double hdzmj = 0.0;
        double stzmj = 0.0;
        double sjdzmjs = 0.0;
        double lscnsl = 0.0;
        for (ZgckZymjDetail detail : zygd) {
            String dlmc = detail.getZydlmc();
            double area = detail.getZygdsl();
            if (!(area > 0.0)) continue;
            if ("\u6c34\u6d47\u5730".equals(dlmc)) {
                sjdzmjs += area;
            } else if ("\u6c34\u7530".equals(dlmc)) {
                stzmj += area;
            } else {
                hdzmj += area;
            }
            double lscn = (double)(16 - (detail.getZygddb() == null ? 0 : detail.getZygddb())) * 1500.0 * area;
            lscnsl += lscn;
        }
        double xbzmj = hdzmj + stzmj + sjdzmjs;
        double ybzmj = 0.0;
        double ybst = 0.0;
        double ybsjd = 0.0;
        double yblscn = 0.0;
        List<ZgckBcgdXzqDetail> bcgdXzqDetails = zgckDTO.getBcgdXzqDetails();
        bcgdXzqDetails.forEach(f -> {
            if (f.getBcgddb() == null) {
                f.setBcgddb(0);
            }
        });
        HashMap<String, Double> map = new HashMap<String, Double>();
        bcgdXzqDetails.sort(Comparator.comparing(ZgckBcgdXzqDetail::getBcgddb));
        for (ZgckBcgdXzqDetail detail : bcgdXzqDetails) {
            double area = detail.getBcgdmj();
            String zblx = detail.getZblx();
            String dlmc = detail.getBcdlmc();
            if (EnumZBKType.XFSRKBCGDZB.toValue().equals(zblx)) {
                if ("\u6c34\u6d47\u5730".equals(dlmc)) {
                    ybsjd += area;
                } else if (dlmc == null) {
                    ybst += detail.getBcstmj();
                }
            } else if ("\u6c34\u6d47\u5730".equals(dlmc)) {
                ybsjd += area;
            } else if ("\u6c34\u7530".equals(dlmc)) {
                ybst += area;
            }
            String key = detail.getXzqdm() + detail.getZblx();
            if (detail.getBclscn() > 0.0) {
                map.putIfAbsent(key, detail.getBclscn());
            }
            ybzmj += area;
        }
        for (Double value : map.values()) {
            yblscn += value.doubleValue();
        }
        double hfgd = 0.0;
        double hfst = 0.0;
        double hfsjd = 0.0;
        double hflscn = 0.0;
        map.clear();
        List hfgdList = zgckDTO.getBcgdXzqDetails().stream().filter(f -> EnumZBKType.FFGDZB.toValue().equals(f.getZblx())).collect(Collectors.toList());
        for (ZgckBcgdXzqDetail detail : hfgdList) {
            double area = detail.getBcgdmj();
            String dlmc = detail.getBcdlmc();
            hfgd += area;
            if ("\u6c34\u6d47\u5730".equals(dlmc)) {
                hfsjd += area;
            } else if ("\u6c34\u7530".equals(dlmc)) {
                hfst += area;
            }
            String key = detail.getXzqdm() + detail.getZblx();
            if (!(detail.getBclscn() > 0.0)) continue;
            map.putIfAbsent(key, detail.getBclscn());
        }
        for (Double value : map.values()) {
            hflscn += value.doubleValue();
        }
        double hfhd = hfgd - hfst - hfsjd;
        List bcgdList = zgckDTO.getBcgdXzqDetails().stream().filter(f -> EnumZBKType.XFSRKBCGDZB.toValue().equals(f.getZblx())).collect(Collectors.toList());
        double bcgd = 0.0;
        double bcst = 0.0;
        double bcsjd = 0.0;
        double bclscn = 0.0;
        map.clear();
        for (ZgckBcgdXzqDetail detail : bcgdList) {
            double area = detail.getBcgdmj();
            String dlmc = detail.getBcdlmc();
            if (dlmc != null) {
                bcgd += area;
            }
            if ("\u6c34\u6d47\u5730".equals(dlmc)) {
                bcsjd += area;
            } else if ("\u6c34\u7530".equals(dlmc)) {
                bcst += area;
            } else if (dlmc == null) {
                bcst += detail.getBcstmj();
            }
            String key = detail.getXzqdm() + detail.getZblx();
            if (!(detail.getBclscn() > 0.0)) continue;
            map.putIfAbsent(key, detail.getBclscn());
        }
        for (Double value : map.values()) {
            bclscn += value.doubleValue();
        }
        all.add(WordManageUtil.getWordFIll("sqydmj", this.getValues((Double)xmxx.get("f_jsmj")), 10));
        all.add(WordManageUtil.getWordFIll("xbzmj", this.getValues(xbzmj), 10));
        all.add(WordManageUtil.getWordFIll("hdzmj", this.getValues(hdzmj), 10));
        all.add(WordManageUtil.getWordFIll("sjdzmj", this.getValues(sjdzmjs), 10));
        all.add(WordManageUtil.getWordFIll("stzmj", this.getValues(stzmj), 10));
        all.add(WordManageUtil.getWordFIll("lscnsl", this.getValues(lscnsl), 10));
        all.add(WordManageUtil.getWordFIll("ybzmj", this.getValues(ybzmj), 10));
        all.add(WordManageUtil.getWordFIll("ybstmj", this.getValues(ybst), 10));
        all.add(WordManageUtil.getWordFIll("ybsjdmj", this.getValues(ybsjd), 10));
        all.add(WordManageUtil.getWordFIll("yblscn", this.getValues(yblscn), 10));
        all.add(WordManageUtil.getWordFIll("hfgd", this.getValues(hfgd), 10));
        all.add(WordManageUtil.getWordFIll("hfhd", this.getValues(hfhd), 10));
        all.add(WordManageUtil.getWordFIll("hfsjd", this.getValues(hfsjd), 10));
        all.add(WordManageUtil.getWordFIll("hfst", this.getValues(hfst), 10));
        all.add(WordManageUtil.getWordFIll("hflscn", this.getValues(hflscn), 10));
        all.add(WordManageUtil.getWordFIll("bcgd", this.getValues(bcgd), 10));
        all.add(WordManageUtil.getWordFIll("bcsjd", this.getValues(bcsjd), 10));
        all.add(WordManageUtil.getWordFIll("bcst", this.getValues(bcst), 10));
        all.add(WordManageUtil.getWordFIll("bclscn", this.getValues(bclscn), 10));
        return all;
    }

    private void addText(List<WordValDTO> list, String zl, String value) {
        if (list.size() > 0) {
            list.add(WordValDTO.builder().value("\uff0c").build());
        }
        list.add(WordValDTO.builder().value(zl).fillLength(6).underlinePatterns(UnderlinePatterns.THICK).build());
        list.add(WordValDTO.builder().value("\u7b49").build());
        list.add(WordValDTO.builder().value(this.getValues(value)).fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
        list.add(WordValDTO.builder().value("\u516c\u9877").build());
    }

    private String getValues(String value) {
        int i = value.indexOf(".");
        int index = value.length() - i - 1;
        if (index == 1) {
            value = value + "000";
        } else if (index == 2) {
            value = value + "00";
        } else if (index == 3) {
            value = value + "0";
        }
        return value;
    }

    private String getValues(double val) {
        int index;
        NumberFormat instance = NumberFormat.getInstance();
        instance.setGroupingUsed(false);
        instance.setMaximumFractionDigits(4);
        String value = instance.format(val);
        int i = value.indexOf(".");
        if (i == -1) {
            value = value + ".0";
            i = value.indexOf(".");
        }
        if ((index = value.length() - i - 1) == 1) {
            value = value + "000";
        } else if (index == 2) {
            value = value + "00";
        } else if (index == 3) {
            value = value + "0";
        }
        return value;
    }

    private void addText(List<WordValDTO> list, String zl, String zlText, String value) {
        if (list.size() > 0) {
            list.add(WordValDTO.builder().value("\uff0c").build());
        }
        list.add(WordValDTO.builder().value(zl).fillLength(4).underlinePatterns(UnderlinePatterns.THICK).build());
        list.add(WordValDTO.builder().value(zlText).build());
        list.add(WordValDTO.builder().value(value).fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
        list.add(WordValDTO.builder().value("\u516c\u9877").build());
    }

    private String getWhether(Object obj) {
        if (obj == null) {
            return "\u5426";
        }
        if (String.valueOf(obj).equals("1")) {
            return "\u662f";
        }
        return "\u5426";
    }
}

