/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class BarcodeUtil {
    public static void main(String[] args) {
        String code = "650000202407000001";
        BarcodeUtil.create(code, "C:\\Users\\wujing1\\Desktop\\txm.png");
    }

    public static String create(String code, String outPath) {
        try {
            BufferedImage image;
            Code128Bean bean = new Code128Bean();
            double moduleWidth = UnitConv.in2mm((double)0.0055555556900799274);
            bean.setModuleWidth(moduleWidth);
            bean.doQuietZone(false);
            bean.setBarHeight(3.0);
            bean.setFontSize(1.0);
            bean.setFontName("Helvetica");
            bean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream bis = null;
            try {
                BitmapCanvasProvider canvas = new BitmapCanvasProvider((OutputStream)out, "image/x-png", 1200, 12, false, 0);
                bean.generateBarcode((CanvasProvider)canvas, code);
                canvas.finish();
                bis = new ByteArrayInputStream(out.toByteArray());
                image = ImageIO.read(bis);
            }
            catch (Exception e) {
                throw new RuntimeException("\u6761\u5f62\u7801\u521b\u5efa\u5931\u8d25\uff01" + e.getMessage());
            }
            finally {
                out.close();
                if (bis != null) {
                    bis.close();
                }
            }
            File outputFile = new File(outPath);
            BufferedImage scaledImage = BarcodeUtil.resizeImage(image, 174, 46);
            ImageIO.write((RenderedImage)scaledImage, "PNG", outputFile);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6761\u5f62\u7801\u751f\u6210\u5931\u8d25\uff01" + e.getMessage());
        }
        return outPath;
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int targetWidth, int targetHeight) {
        Image resultingImage = originalImage.getScaledInstance(targetWidth, targetHeight, 4);
        BufferedImage outputImage = new BufferedImage(targetWidth, targetHeight, 1);
        outputImage.getGraphics().drawImage(resultingImage, 0, 0, null);
        return outputImage;
    }

    public static String createQr(String text, String outPath, Integer size) {
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, size.intValue(), size.intValue());
            Path path = FileSystems.getDefault().getPath(outPath, new String[0]);
            MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix, (String)"PNG", (Path)path);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25\uff01" + e.getMessage());
        }
        return outPath;
    }
}

