/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileManageUtil {
    public static String uploadDir;

    @Value(value="${project.uploadDir:''}")
    public void setStaticProperty(String uploadDir) {
        FileManageUtil.uploadDir = uploadDir;
    }

    public static String saveFile(MultipartFile multipartFile, String type) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String name = multipartFile.getOriginalFilename();
            name = name.replace(".", "-" + DateTime.now().getTime() + ".");
            String path = File.separator + type + File.separator + sdf.format(new Date()) + File.separator + name;
            String filePath = uploadDir + path;
            File file = new File(filePath);
            InputStream inputStream = multipartFile.getInputStream();
            if (!FileUtil.exist((File)file)) {
                file = FileUtil.file((String)filePath);
            }
            FileUtil.writeFromStream((InputStream)inputStream, (File)file);
            return filePath;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static void downloadFile(String filePath, HttpServletResponse response) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            File file = new File(filePath);
            String fileName = file.getName();
            FileInputStream fileInputStream = new FileInputStream(file);
            inputStream = new BufferedInputStream(fileInputStream);
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("Content-Length", "" + file.length());
            response.setCharacterEncoding("UTF-8");
            response.setContentType(FileManageUtil.getContentType(fileName));
            outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            outputStream.write(buffer);
            outputStream.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void deleteForceFile(String path) {
        try {
            int index = path.lastIndexOf(".");
            String dir = path.substring(0, index);
            File file = new File(dir);
            boolean delete = file.delete();
            if (!delete) {
                FileManageUtil.deleteDirectory(file);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u3010" + path + "\u3011\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static void createFiles(InputStream is, String path) {
        try {
            Files.copy(is, Paths.get(path, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u6d41\u5199\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static String zip(String fileName, String zipPath, List<String> filePath) {
        zipPath = zipPath + File.separator + fileName + "-" + UUID.randomUUID() + ".zip";
        return FileManageUtil.zip(zipPath, filePath, false);
    }

    public static String zip(String fileName, List<String> filePath) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String path = uploadDir + File.separator + "zip" + File.separator + sdf.format(new Date()) + File.separator + fileName + "-" + UUID.randomUUID() + ".zip";
        return FileManageUtil.zip(path, filePath, false);
    }

    public static String zip(String zipPath, List<String> filePath, boolean withSrcDir) {
        ArrayList<File> list = new ArrayList<File>();
        for (String file : filePath) {
            list.add(new File(file));
        }
        ZipUtil.zip((File)new File(zipPath), (boolean)withSrcDir, (File[])list.toArray(new File[list.size()]));
        return zipPath;
    }

    public static String unZip(InputStream is, String name) {
        String filePath = System.getProperty("user.dir") + File.separator + name + ".zip";
        String fileDir = System.getProperty("user.dir") + File.separator + name;
        File zipFile = new File(filePath);
        try {
            int len;
            FileOutputStream out = new FileOutputStream(zipFile);
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            out.flush();
            is.close();
            ((OutputStream)out).close();
            ZipUtil.unzip((String)filePath, (String)fileDir);
            String string = fileDir;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bf7\u6c42\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            FileUtil.del((File)zipFile);
        }
    }

    private static boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileManageUtil.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return directory.delete();
    }

    public static String getContentType(String fileName) {
        String fix;
        int index = fileName.lastIndexOf(".");
        switch (fix = fileName.substring(++index)) {
            case "pdf": {
                return "application/pdf";
            }
            case "zip": {
                return "application/zip";
            }
            case "docx": 
            case "doc": {
                return "application/msword";
            }
            case "xlsx": 
            case "xls": {
                return "application/vnd.ms-excel";
            }
            case "pptx": 
            case "ppt": {
                return "application/vnd.ms-powerpoint";
            }
            case "png": {
                return "image/png";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "txt": {
                return "text/plain";
            }
            case "rar": {
                return "application/x-rar-compressed";
            }
        }
        return "application/octet-stream";
    }

    public static String getTempPath() {
        ApplicationHome applicationHome = new ApplicationHome(FileManageUtil.class);
        return applicationHome.getSource().getParentFile().toString();
    }

    public static byte[] readLargeFileToByteArray(String filePath) throws IOException {
        File file = new File(filePath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try (FileInputStream fis = new FileInputStream(file);){
            int len;
            while ((len = fis.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
        }
        return baos.toByteArray();
    }
}

