/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GeoserverUtil {
    @Value(value="${project.fxfw.service.headers:''}")
    private String headers;
    @Value(value="${project.verify.default:false}")
    private Boolean verifyDefault;

    public JSONObject httpCreateTask(String service, String body) {
        HttpRequest post = this.createHttp("/rest/dtsp/" + service + "/rule", Method.POST);
        HttpResponse execute = post.body(body).execute();
        return this.getResult(execute);
    }

    public JSONObject httpCreateByType(String service, String type, String body) {
        HttpRequest post = this.createHttp("/rest/" + type + "/" + service, Method.POST);
        HttpResponse execute = post.body(body).execute();
        return this.getResult(execute);
    }

    public Boolean httpFindStatus(String id) {
        HttpRequest get = this.createHttp("/rest/dtsp/result/rule/task/findResult", Method.GET);
        HttpResponse execute = get.form("id", (Object)id).execute();
        JSONObject result = this.getResult(execute);
        Boolean results = result.getBoolean("Results");
        if (this.verifyDefault.booleanValue()) {
            return true;
        }
        return results;
    }

    public int httpFindTaskStatus(String id) {
        HttpRequest get = this.createHttp("/rest/task/findTaskById", Method.GET);
        HttpResponse execute = get.form("taskId", (Object)id).execute();
        JSONObject result = this.getResult(execute);
        JSONObject results = result.getJSONObject("Results");
        return results.getIntValue("status");
    }

    public JSONArray httpFindResult(String service, String type, Boolean status, String id, Integer verify) {
        HttpRequest get = this.createHttp("/rest/dtsp/result/rule/" + service + "/findDetail", Method.GET);
        HttpResponse execute = get.form("type", (Object)type).form("status", (Object)status).form("id", (Object)id).form("verify", (Object)verify).execute();
        JSONObject result = this.getResult(execute);
        return result.getJSONArray("Results");
    }

    public JSONArray httpFindAnalysResult(String id) {
        HttpRequest get = this.createHttp("/rest/dtsp/result/findResultByTaskId", Method.GET);
        HttpResponse execute = get.form("id", (Object)id).execute();
        JSONObject result = this.getResult(execute);
        return result.getJSONArray("Results");
    }

    public JSONArray httpFindInfo(String name) {
        HttpRequest get = this.createHttp("/rest/dtsp/findByName", Method.GET);
        HttpResponse execute = get.form("name", (Object)name).execute();
        JSONObject result = this.getResult(execute);
        return result.getJSONArray("Results");
    }

    public JSONObject httpStat(String serviceName, String params) {
        HttpRequest post = this.createHttp("/rest/yzfx/" + serviceName + "/StatByResult", Method.POST);
        HttpResponse execute = post.body(params).execute();
        JSONObject result = this.getResult(execute);
        return result.getJSONObject("Results");
    }

    public JSONArray httpSplitByRatios(final List<TaskBlockDTO> blocks) {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("Blocks", blocks);
                this.put("applicationGUID", ConfigConstant.GeoServerConfig.Service_Key);
            }
        };
        HttpRequest post = this.createHttp("/rest/tools/splitByRatio", Method.POST);
        HttpResponse execute = post.body(JSON.toJSONString((Object)map)).execute();
        JSONObject result = this.getResult(execute);
        return result.getJSONArray("Results");
    }

    public JSONArray httpKjcc(final List<TaskBlockDTO> blocks, final List<TaskBlockDTO> eraseBlocks) {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("Blocks", blocks);
                this.put("EraseBlocks", eraseBlocks);
                this.put("applicationGUID", ConfigConstant.GeoServerConfig.Service_Key);
            }
        };
        HttpRequest post = HttpUtil.createPost((String)(ConfigConstant.GeoServerConfig.Url + "/rest/tools/kjcc"));
        HttpResponse execute = post.body(JSON.toJSONString((Object)map)).execute();
        JSONObject result = this.getResult(execute);
        return result.getJSONArray("Results");
    }

    public Geometry KjccByFxfw(Geometry block, Geometry eraseBlock) {
        ArrayList<TaskBlockDTO> blockList = new ArrayList<TaskBlockDTO>();
        TaskBlockDTO taskBlockDTO = new TaskBlockDTO();
        taskBlockDTO.setDk_id("1");
        taskBlockDTO.setWkt(block.toText());
        taskBlockDTO.setWkid("4490");
        blockList.add(taskBlockDTO);
        ArrayList<TaskBlockDTO> eraseBlockList = new ArrayList<TaskBlockDTO>();
        TaskBlockDTO eraseBlockDTO = new TaskBlockDTO();
        eraseBlockDTO.setDk_id("2");
        eraseBlockDTO.setWkt(eraseBlock.toText());
        eraseBlockDTO.setWkid("4490");
        eraseBlockList.add(eraseBlockDTO);
        JSONArray array = this.httpKjcc(blockList, eraseBlockList);
        if (array.size() > 0) {
            JSONObject object = (JSONObject)array.get(0);
            if (object.getString("WKT") != null) {
                return GeoserverUtil.wktToGeo(object.getString("WKT"));
            }
            return null;
        }
        return null;
    }

    public JSONArray httpTerranArea(final List<TaskBlockDTO> blocks) {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("Blocks", blocks);
                this.put("applicationGUID", ConfigConstant.GeoServerConfig.Service_Key);
            }
        };
        HttpRequest post = this.createHttp2("/rest/tools/" + ConfigConstant.GeoServerConfig.Area_calculation, Method.POST);
        HttpResponse execute = post.body(JSON.toJSONString((Object)map)).execute();
        JSONObject result = this.getResult(execute);
        return result.getJSONArray("Results");
    }

    public JSONArray httpGetDlGroup(final List<TaskBlockDTO> blocks, final String areaType) {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("Blocks", blocks);
                this.put("applicationGUID", ConfigConstant.GeoServerConfig.Service_Key);
                this.put("areaType", areaType);
            }
        };
        HttpRequest post = this.createHttp("/rest/yzfx/" + ConfigConstant.GeoServerConfig.Service_Dlmj_Group, Method.POST);
        HttpResponse execute = post.body(JSON.toJSONString((Object)map)).execute();
        JSONObject result = this.getResult(execute);
        return result.getJSONArray("Results");
    }

    public JSONArray httpFindSubTask(String taskId) {
        HttpRequest http = this.createHttp("/rest/task/findSubTasks", Method.GET);
        http.form("taskId", (Object)taskId);
        JSONObject result = this.getResult(http.execute());
        return result.getJSONArray("Results");
    }

    public InputStream httpWordToPdf(String wordPath, String pdfPath) {
        HttpRequest request = HttpUtil.createRequest((Method)Method.POST, (String)(ConfigConstant.GeoServerConfig.Url_Document + "/convert/docxToPdf"));
        request.form("docxFile", new File(wordPath));
        HttpResponse execute = request.execute();
        Map headerMap = execute.headers();
        return execute.bodyStream();
    }

    private JSONObject getResult(HttpResponse execute) {
        if (execute.getStatus() != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u8c03\u7528\u5931\u8d25\uff1a" + execute.body());
        }
        JSONObject object = JSON.parseObject((String)execute.body());
        if (object.getIntValue("StatusCode") != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + object.getString("Message"));
        }
        return object;
    }

    private HttpRequest createHttp(String path, Method method) {
        HttpRequest request = HttpUtil.createRequest((Method)method, (String)(ConfigConstant.GeoServerConfig.Url + path));
        if (StringUtils.isNotEmpty((CharSequence)this.headers)) {
            Map map = (Map)JSON.parseObject((String)this.headers, Map.class);
            request.addHeaders(map);
        }
        return request;
    }

    private HttpRequest createHttp2(String path, Method method) {
        String url = StringUtils.isEmpty((CharSequence)ConfigConstant.GeoServerConfig.Url_Calculate) ? ConfigConstant.GeoServerConfig.Url : ConfigConstant.GeoServerConfig.Url_Calculate;
        HttpRequest request = HttpUtil.createRequest((Method)method, (String)(url + path));
        request.setConnectionTimeout(ConfigConstant.GeoServerConfig.timeOut * 60 * 1000);
        request.timeout(ConfigConstant.GeoServerConfig.timeOut * 60 * 1000);
        if (StringUtils.isNotEmpty((CharSequence)this.headers)) {
            Map map = (Map)JSON.parseObject((String)this.headers, Map.class);
            request.addHeaders(map);
        }
        return request;
    }

    public static Geometry wktToGeo(String wkt) {
        WKTReader reader = new WKTReader();
        Geometry geometry = null;
        try {
            geometry = reader.read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return geometry;
    }

    public static Geometry unionGeometry(Geometry ... geos) {
        GeometryFactory geometryFactory = new GeometryFactory();
        GeometryCollection geometryCollection = geometryFactory.createGeometryCollection(geos);
        return geometryCollection.union();
    }
}

