/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.supoort.FileManageUtil;
import io.minio.MinioClient;
import java.io.File;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Component
public class MinioUtil {
    public static MinioClient minioClient = null;

    private MinioClient createClient() {
        if (minioClient != null) {
            return minioClient;
        }
        try {
            if (ConfigConstant.FileConfig.Minio_Api.startsWith("https")) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                X509TrustManager x509TrustManager = (X509TrustManager)trustAllCerts[0];
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                OkHttpClient.Builder builder = new OkHttpClient.Builder();
                builder.sslSocketFactory(sslSocketFactory, x509TrustManager);
                builder.hostnameVerifier((s, sslSession) -> true);
                OkHttpClient okHttpClient = builder.build();
                minioClient = new MinioClient(ConfigConstant.FileConfig.Minio_Api, 0, ConfigConstant.FileConfig.Minio_Key, ConfigConstant.FileConfig.Minio_Secret, null, true, okHttpClient);
            } else {
                minioClient = new MinioClient(ConfigConstant.FileConfig.Minio_Api, ConfigConstant.FileConfig.Minio_Key, ConfigConstant.FileConfig.Minio_Secret);
            }
            return minioClient;
        }
        catch (Exception e) {
            throw new RuntimeException("Minio\u8fde\u63a5\u5931\u8d25\uff0c" + e);
        }
    }

    public String uploadFile(File file, String type) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        CommonsMultipartFile multipartFile = new CommonsMultipartFile(factory.createItem(file.getName(), "multipart/form-data", true, file.getName()));
        String fileName = multipartFile.getOriginalFilename();
        String savePath = this.getSavePath(fileName, type);
        return this.uploadFile((MultipartFile)multipartFile, type, savePath);
    }

    public String uploadFile(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        String savePath = this.getSavePath(fileName, null);
        return this.uploadFile(file, null, savePath);
    }

    public String uploadFile(MultipartFile file, String type) {
        String fileName = file.getOriginalFilename();
        String savePath = this.getSavePath(fileName, type);
        return this.uploadFile(file, type, savePath);
    }

    public String uploadFile(MultipartFile file, String type, String savePath) {
        try {
            MinioClient client = this.createClient();
            client.putObject(ConfigConstant.FileConfig.Minio_Bucket, savePath, file.getInputStream(), Long.valueOf(file.getSize()), null, null, FileManageUtil.getContentType(file.getOriginalFilename()));
            return savePath;
        }
        catch (Exception e) {
            throw new RuntimeException("minio\u5bf9\u8c61\u5b58\u50a8\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25, " + e);
        }
    }

    public String getUrl(String savePath) {
        if (ConfigConstant.FileConfig.Minio_isPrivate.booleanValue()) {
            MinioClient client = this.createClient();
            try {
                String url = client.presignedGetObject(ConfigConstant.FileConfig.Minio_Bucket, savePath, ConfigConstant.FileConfig.Minio_Expires);
                return url.replace(ConfigConstant.FileConfig.Minio_Api, ConfigConstant.FileConfig.Minio_Endpoint);
            }
            catch (Exception e) {
                throw new RuntimeException("\u83b7\u53d6\u4e34\u65f6\u8bbf\u95ee\u5730\u5740\u5931\u8d25\uff01");
            }
        }
        return ConfigConstant.FileConfig.Minio_Endpoint + "/" + ConfigConstant.FileConfig.Minio_Bucket + "/" + savePath;
    }

    private String getSavePath(String fileName, String type) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String path = simpleDateFormat.format(new Date());
        return ConfigConstant.FileConfig.Minio_Prefix + "/" + (StringUtils.isNotBlank((CharSequence)type) ? type + "/" : "default/") + path + "/" + LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli() + "/" + fileName;
    }
}

