/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.stereotype.Component;

@Component
public class RedisLock {
    private static final Long SUCCESS = 1L;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public Boolean tryLock(String key, String value, long expireTime) {
        try {
            Boolean ret = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, expireTime, TimeUnit.MILLISECONDS);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean unlock(String key) {
        try {
            String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
            DefaultRedisScript redisScript = new DefaultRedisScript(script, String.class);
            Long result = this.redisTemplate.delete(Collections.singletonList(key));
            if (SUCCESS.equals(result)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

