/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.base.metadata.domain.ModelFields;
import com.geoway.onemap.zbph.annotation.GeoJSON;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShpUtil<T> {
    private final int FEILD_LENGTH_LIMIT = 10;
    private final String GEOM_FIELD_NAME = "the_geom";
    private final String CGCS2000 = "GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4490]]";

    public void readShpToES(String fileName, String url) throws MalformedURLException, IOException {
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        WKTReader reader = new WKTReader();
        File file = new File(fileName);
        ShapefileDataStore sds = (ShapefileDataStore)dataStoreFactory.createDataStore(file.toURI().toURL());
        sds.setCharset(Charset.forName("UTF-8"));
        ArrayList<Map<String, String>> fs = new ArrayList<Map<String, String>>();
        ContentFeatureSource featureSource = sds.getFeatureSource();
        SimpleFeatureIterator iterator = featureSource.getFeatures().features();
        Property per = null;
        while (iterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iterator.next();
            Iterator it = feature.getProperties().iterator();
            HashMap<String, String> properties = new HashMap<String, String>();
            while (it.hasNext()) {
                per = (Property)it.next();
                String key = per.getName().toString();
                properties.put(key, per.getValue().toString());
            }
            fs.add(properties);
        }
        this.shpToES(fs, url);
    }

    private String rename(String fname) {
        int index = fname.lastIndexOf(".");
        String temp = fname.substring(0, index) + System.currentTimeMillis();
        temp = temp + fname.substring(index);
        return temp;
    }

    private boolean shpToES(List<Map<String, String>> fs, String url) throws IOException {
        if (null == url || "".equals(url)) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        HttpPost httpPost = new HttpPost(url);
        StringBuilder sb = new StringBuilder();
        Map<String, String> prs = null;
        int total = fs.size();
        for (int i = 0; i < total; ++i) {
            prs = fs.get(i);
            sb.append("{\"create\":{\"_id\":\"").append(startTime + (long)i).append("\"}}\n");
            sb.append(this.toJson(prs)).append("\n");
            if (i % 200 != 0 && i != total - 1) continue;
            httpPost.setEntity((HttpEntity)new StringEntity(sb.toString(), "utf-8"));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            response.close();
            sb = null;
            sb = new StringBuilder();
            System.out.println("\u6570\u636e\u5165\u5e93\u5b8c\u6210\uff0c\u603b\u5171" + total + "\uff0c\u5df2\u5b8c\u6210" + i + ", \u8017\u65f6 " + (System.currentTimeMillis() - startTime) + "\u6beb\u79d2");
        }
        httpclient.close();
        return true;
    }

    private String toJson(Map<String, String> ms) {
        if (null == ms) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        for (String k : ms.keySet()) {
            sb.append("\"").append(k).append("\":\"").append(ms.get(k)).append("\"");
            sb.append(",");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        sb.append("}");
        return sb.toString();
    }

    @Deprecated
    protected void testCreateFeature() throws SchemaException, ParseException, IOException {
        SimpleFeatureType featureType = DataUtilities.createType((String)"Location", (String)"the_geom:MultiPolygon:4490,name:String,type:String,typeCode:String");
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(featureType);
        WKTReader wktReader = new WKTReader();
        com.vividsolutions.jts.geom.Geometry g = wktReader.read("MULTIPOLYGON(((120.245550628244 30.3697319771691,120.245604273926 30.3693135531255,120.24339413664 30.3690667936267,120.243630170808 30.368079739938,120.24205303449 30.3678007917758,120.241409305793 30.3668673845079,120.241291288517 30.3659447050454,120.241838457153 30.3652902449766,120.24261093291 30.3647216149009,120.242857696301 30.3633590530615,120.242986442154 30.3626831362105,120.246097798899 30.3664382241636,120.249713410056 30.3696568698573,120.249788512627 30.3709336004773,120.249482741414 30.3710677121942,120.247229688992 30.3708906898944,120.247353069806 30.3699948315325,120.245513078403 30.3698285368174,120.245550628244 30.3697319771691,120.245550628244 30.3697319771691)),((120.250083554427 30.3672053292808,120.250094283151 30.367993898842,120.249713410056 30.3696568698573,120.247953884385 30.3681011910327,120.24685954468 30.3670712245555,120.247661524439 30.3666179298771,120.248780002808 30.365907142485,120.249450554592 30.366513321681,120.250083554427 30.3672053292808,120.250083554427 30.3672053292808,120.250083554427 30.3672053292808)))");
        sfb.add((Object)g);
        sfb.add((Object)"ming cheng");
        sfb.add((Object)"lei xing");
        sfb.add((Object)"type code");
        features.add(sfb.buildFeature("idididi"));
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        File f = new File("d:\\test.shp");
        params.put("url", f.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(featureType);
        String typeName = newDataStore.getTypeNames()[0];
        ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
        SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
        ListFeatureCollection collection = new ListFeatureCollection(featureType, features);
        DefaultTransaction transaction = new DefaultTransaction("create");
        featureStore.setTransaction((Transaction)transaction);
        featureStore.addFeatures((FeatureCollection)collection);
        transaction.commit();
    }

    @Deprecated
    public SimpleFeatureTypeBuilder createFeatureTypeBuilder(String[] heads, String geomName, Class geomClass) {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        for (String name : heads) {
            if (name.equals(geomName)) {
                sftb.add("the_geom", geomClass);
                continue;
            }
            sftb.add(name, String.class);
        }
        return sftb;
    }

    public SimpleFeatureTypeBuilder createFeatureTypeBuilder(Class clazz) {
        Field[] fs;
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        String name = clazz.getAnnotation(GeoJSON.class).name();
        if (null == name) {
            sftb.setName("feature");
        } else {
            sftb.setName(name);
        }
        sftb.add("the_geom", clazz.getAnnotation(GeoJSON.class).type());
        boolean hasGeometry = false;
        for (Field f : fs = clazz.getDeclaredFields()) {
            Class type;
            GeoJSON g = f.getAnnotation(GeoJSON.class);
            if (null == g) continue;
            String field = g.field();
            if ("".equals(field)) {
                field = f.getName();
            }
            if (!hasGeometry && g.isGeometry()) {
                hasGeometry = true;
                field = "the_geom";
            }
            if ((type = g.type()) == Object.class) {
                sftb.add(field, f.getType());
                continue;
            }
            sftb.add(field, type);
        }
        if (!hasGeometry) {
            throw new NullPointerException("GeoJSON : annotation must has geometry field");
        }
        return sftb;
    }

    public boolean writeToShpFile(SimpleFeatureTypeBuilder tb, List<Map<String, Object>> list, String filePath) throws Exception {
        boolean b = false;
        HashMap<String, URL> params = new HashMap<String, URL>();
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        params.put(ShapefileDataStoreFactory.URLP.key, new File(filePath).toURI().toURL());
        ShapefileDataStore ds = (ShapefileDataStore)factory.createNewDataStore(params);
        tb.setName("shapefile");
        SimpleFeatureType sft = tb.buildFeatureType();
        ds.createSchema(sft);
        ds.setCharset(Charset.forName("UTF-8"));
        FeatureWriter writer = ds.getFeatureWriter(Transaction.AUTO_COMMIT);
        for (int i = 0; i < list.size(); ++i) {
            SimpleFeature feature = (SimpleFeature)writer.next();
            for (Map.Entry<String, Object> entry : list.get(i).entrySet()) {
                if (null == feature.getProperty(entry.getKey())) continue;
                feature.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        writer.write();
        writer.close();
        ds.dispose();
        b = true;
        return b;
    }

    private com.vividsolutions.jts.geom.Geometry convertToViviGeo(String wkt) {
        WKTReader reader = new WKTReader();
        try {
            com.vividsolutions.jts.geom.Geometry geometry = reader.read(wkt);
            geometry.setSRID(4490);
            return geometry;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Geometry convertToJtsGeo(String wkt) {
        org.locationtech.jts.io.WKTReader reader = new org.locationtech.jts.io.WKTReader();
        try {
            Geometry geometry = reader.read(wkt);
            geometry.setSRID(4490);
            return geometry;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean writeToShpFromGeoJSON(List<T> objs, String filePath) throws Exception {
        boolean b = false;
        if (objs.size() == 0) {
            return b;
        }
        Class<?> clazz = objs.get(0).getClass();
        GeoJSON g = objs.get(0).getClass().getAnnotation(GeoJSON.class);
        if (null == g) {
            return b;
        }
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(g.name());
        CoordinateReferenceSystem crs4490 = CRS.parseWKT((String)"GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4490]]");
        simpleFeatureTypeBuilder.setCRS(crs4490);
        boolean hasGeometry = false;
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (Field f : fields) {
            Class type;
            g = f.getAnnotation(GeoJSON.class);
            if (null == g) continue;
            String field = g.field();
            if ("".equals(field)) {
                field = f.getName();
            }
            if (field.length() > 10) {
                throw new Exception("\u5b9a\u4e49shp\u6587\u4ef6\u7684\u5c5e\u6027\u5b57\u6bb5\u540d\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57\u7b26" + field);
            }
            if (!hasGeometry && g.isGeometry()) {
                hasGeometry = true;
                field = "the_geom";
                simpleFeatureTypeBuilder.add("the_geom", g.type());
            }
            if ((type = g.type()) == Object.class) {
                simpleFeatureTypeBuilder.add(field, f.getType());
            } else {
                simpleFeatureTypeBuilder.add(field, type);
            }
            fieldMap.put(field, f.getName());
        }
        if (!hasGeometry) {
            throw new NullPointerException("GeoJSON : annotation must has geometry field");
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (T t : objs) {
            HashMap obj = new HashMap();
            for (Map.Entry fieldEntry : fieldMap.entrySet()) {
                Method method = clazz.getMethod(this.getMethodName((String)fieldEntry.getValue()), new Class[0]);
                if (!((String)fieldEntry.getKey()).equals("the_geom")) {
                    obj.put(fieldEntry.getKey(), method.invoke(t, new Object[0]));
                    continue;
                }
                obj.put(fieldEntry.getKey(), this.convertToViviGeo(method.invoke(t, new Object[0]).toString()));
            }
            list.add(obj);
        }
        b = this.writeToShpFile(simpleFeatureTypeBuilder, list, filePath);
        return b;
    }

    public boolean writeToShpFromGeoJSON(List<Map<String, Object>> objs, String geometryField, List<ModelFields> fields, Map<String, String> fieldMap, String filePath) throws Exception {
        boolean b = false;
        if (objs == null || objs.size() == 0) {
            return b;
        }
        Map<String, Object> template = objs.get(0);
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName("shp");
        CoordinateReferenceSystem crs4490 = CRS.parseWKT((String)"GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4490]]");
        simpleFeatureTypeBuilder.setCRS(crs4490);
        boolean hasGeometry = false;
        com.vividsolutions.jts.geom.Geometry geometry = this.convertToViviGeo(template.get(geometryField).toString());
        for (ModelFields modelFields : fields) {
            String fieldName = modelFields.getFieldName();
            if (fieldMap.containsKey(fieldName)) {
                fieldName = fieldMap.get(fieldName);
            }
            switch (modelFields.getFieldType().toLowerCase()) {
                case "text": 
                case "varchar": {
                    simpleFeatureTypeBuilder.add(fieldName, String.class);
                    break;
                }
                case "timestamp": {
                    simpleFeatureTypeBuilder.add(fieldName, Date.class);
                    break;
                }
                case "int2": 
                case "int4": {
                    simpleFeatureTypeBuilder.add(fieldName, Integer.class);
                    break;
                }
                case "int8": {
                    simpleFeatureTypeBuilder.add(fieldName, Long.class);
                    break;
                }
                case "geometry": {
                    hasGeometry = true;
                    simpleFeatureTypeBuilder.add("the_geom", geometry.getClass());
                    break;
                }
                case "decimal": 
                case "numberic": {
                    simpleFeatureTypeBuilder.add(fieldName, Double.class);
                }
            }
        }
        if (!hasGeometry) {
            throw new NullPointerException("GeoJSON : annotation must has geometry field");
        }
        for (Map map : objs) {
            map.put("the_geom", this.convertToViviGeo(map.get(geometryField).toString()));
            for (Map.Entry<String, String> kv : fieldMap.entrySet()) {
                map.put(kv.getValue(), map.get(kv.getKey()));
                map.remove(kv.getKey());
            }
        }
        b = this.writeToShpFile(simpleFeatureTypeBuilder, objs, filePath);
        return b;
    }

    public Iterator<T> readShp(String filePath, final ShpEntityBuilder<T> shpEntityBuilder) throws Exception {
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        File file = new File(filePath);
        ShapefileDataStore sds = (ShapefileDataStore)dataStoreFactory.createDataStore(file.toURI().toURL());
        sds.setCharset(ShpUtil.getShapeFileCharsetName(filePath));
        final SimpleFeatureIterator iterator = sds.getFeatureSource().getFeatures().features();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                try {
                    return shpEntityBuilder.createEntity((SimpleFeature)iterator.next());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage(), exception);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset getShapeFileCharsetName(String shpPath) throws Exception {
        File dir = new File(shpPath).getParentFile();
        File file = Arrays.stream(dir.listFiles()).filter(f -> f.getAbsolutePath().toLowerCase().endsWith(".dbf")).findAny().orElse(null);
        if (file == null) {
            return Charset.forName("UTF-8");
        }
        try (FileInputStream dbf = new FileInputStream(file);){
            byte[] bytes = new byte[30];
            ((InputStream)dbf).read(bytes);
            byte b = bytes[29];
            String hex = Integer.toHexString(Byte.toUnsignedInt(b));
            if (hex.toUpperCase().equals("4D") || hex.toUpperCase().equals("7A")) {
                Charset charset = CharsetUtil.CHARSET_GBK;
                return charset;
            }
            Charset charset = CharsetUtil.CHARSET_UTF_8;
            return charset;
        }
    }

    public SimpleFeature toSimpleFeature(Object obj) throws IOException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Field[] fields;
        Class<?> clazz = obj.getClass();
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = this.createFeatureTypeBuilder(clazz);
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(simpleFeatureTypeBuilder.buildFeatureType());
        String id = null;
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            GeoJSON g = field.getAnnotation(GeoJSON.class);
            if (null == g) continue;
            if (g.isID()) {
                Method method = clazz.getMethod(this.getMethodName(field.getName()), new Class[0]);
                id = method.invoke(obj, new Object[0]).toString();
                continue;
            }
            String fieldName = g.field();
            if ("".equals(fieldName)) {
                fieldName = field.getName();
            }
            if (g.isGeometry()) {
                fieldName = "the_geom";
            }
            Method method = clazz.getMethod(this.getMethodName(field.getName()), new Class[0]);
            values.put(fieldName, method.invoke(obj, new Object[0]));
        }
        if (null == id) {
            id = String.valueOf(System.currentTimeMillis());
        }
        SimpleFeature feature = simpleFeatureBuilder.buildFeature(id);
        for (Map.Entry entry : values.entrySet()) {
            feature.setAttribute((String)entry.getKey(), entry.getValue());
        }
        return feature;
    }

    public SimpleFeatureCollection toSimpleFeatureCollection(List<Object> list) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, IOException {
        DefaultFeatureCollection featureCollection = new DefaultFeatureCollection();
        for (Object obj : list) {
            featureCollection.add(this.toSimpleFeature(obj));
        }
        return featureCollection;
    }

    public String toGeoJSON(Object obj) throws IOException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        SimpleFeature feature = this.toSimpleFeature(obj);
        StringWriter writer = new StringWriter();
        org.geotools.geojson.GeoJSON.write((Object)feature, (Object)writer);
        return writer.toString();
    }

    private String getMethodName(String field) {
        char first = field.charAt(0);
        String str = String.valueOf(first).toUpperCase();
        String name = field.replaceFirst(String.valueOf(first), str);
        return "get" + name;
    }

    private String getSetMethodName(String field) {
        char first = field.charAt(0);
        String str = String.valueOf(first).toUpperCase();
        String name = field.replaceFirst(String.valueOf(first), str);
        return "set" + name;
    }

    public ShpEntityBuilder<T> useDefaultBuilder(Class clazz) {
        return feature -> {
            Field[] fields;
            CaseInsensitiveMap ingonreEscape = new CaseInsensitiveMap();
            Collection properties = feature.getProperties();
            for (Property property : properties) {
                String name = property.getName().getLocalPart();
                ingonreEscape.put(name, name);
            }
            GeoJSON g = clazz.getAnnotation(GeoJSON.class);
            if (null == g) {
                throw new Exception("\u975eGeoJSON\u6ce8\u89e3\u7684\u7c7b");
            }
            Object t = clazz.newInstance();
            for (Field f : fields = clazz.getDeclaredFields()) {
                try {
                    Object value;
                    String featureFieldName;
                    if (f.getName().equals("gddj")) {
                        boolean bl = false;
                    }
                    if (null == (g = f.getAnnotation(GeoJSON.class))) continue;
                    Method method = clazz.getMethod(this.getSetMethodName(f.getName()), f.getType());
                    String fieldName = f.getName();
                    if (!g.field().equals("")) {
                        fieldName = g.field();
                    }
                    if (g.isGeometry()) {
                        fieldName = "the_geom";
                    }
                    if (StrUtil.isBlank((CharSequence)(featureFieldName = (String)ingonreEscape.get(fieldName))) || (value = feature.getAttribute(featureFieldName)) == null || StrUtil.isBlank((CharSequence)value.toString())) continue;
                    if (value.getClass().getName().toUpperCase().equals(f.getType().getName().toUpperCase())) {
                        method.invoke(t, value);
                        continue;
                    }
                    String typeName = f.getType().getName().toLowerCase();
                    if (typeName.equals(String.class.getName().toLowerCase())) {
                        value = value.toString();
                    } else if (typeName.equals(Double.class.getName().toLowerCase())) {
                        value = Double.parseDouble(value.toString());
                    } else if (typeName.equals(Integer.class.getName().toLowerCase()) || typeName.equals(Integer.TYPE.getName().toLowerCase())) {
                        value = Integer.parseInt(value.toString());
                    } else if (typeName.equals(Long.class.getName().toLowerCase())) {
                        value = Long.parseLong(value.toString());
                    } else if (typeName.equals(Float.class.getName().toLowerCase())) {
                        value = Float.valueOf(Float.parseFloat(value.toString()));
                    } else if (typeName.equals(Geometry.class.getName().toLowerCase())) {
                        value = this.convertToJtsGeo(value.toString());
                    } else if (typeName.equals(com.vividsolutions.jts.geom.Geometry.class.getName().toLowerCase())) {
                        value = this.convertToViviGeo(value.toString());
                    } else if (typeName.equals(Date.class.getName().toLowerCase())) {
                        value = this.obj2Date(value);
                    } else {
                        throw new RuntimeException(String.format("\u5b57\u6bb5%s\u7684\u7c7b\u578b\u4e3a%s,\u6682\u4e0d\u652f\u6301", f.getName(), f.getType().getName()));
                    }
                    method.invoke(t, value);
                }
                catch (Exception exception) {
                    throw new RuntimeException(String.format("\u5b57\u6bb5%s\u7684\u7c7b\u578b\u4e3a%s,\u8f6c\u6362\u5931\u8d25", f.getName(), f.getType().getName()), exception);
                }
            }
            return t;
        };
    }

    protected Date obj2Date(Object obj) {
        Date date = null;
        try {
            if (obj instanceof Long || ShpUtil.isNumeric(obj.toString())) {
                date = new Date(Long.parseLong(obj.toString()));
            } else if (obj.toString().contains("-")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String foo = obj.toString();
                if (foo.contains("T")) {
                    sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                }
                date = sdf.parse(foo);
            } else if (obj.toString().contains("/")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                String foo = obj.toString();
                if (foo.contains("T")) {
                    sdf = new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss.SSSZ");
                }
                date = sdf.parse(foo);
            } else {
                date = new Date(obj.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return date;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static interface ShpEntityBuilder<T> {
        public T createEntity(SimpleFeature var1) throws Exception;
    }
}

