/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import cn.hutool.core.io.FileUtil;
import com.documents4j.api.DocumentType;
import com.documents4j.api.IConverter;
import com.documents4j.job.LocalConverter;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.dto.base.WordFillDTO;
import com.geoway.onemap.zbph.dto.base.WordValDTO;
import com.geoway.onemap.zbph.supoort.BarcodeUtil;
import com.spire.doc.Document;
import com.spire.doc.FileFormat;
import com.spire.doc.Section;
import com.spire.doc.documents.HorizontalAlignment;
import com.spire.doc.documents.Paragraph;
import com.spire.doc.fields.DocPicture;
import com.spire.doc.formatting.ParagraphFormat;
import com.spire.doc.interfaces.IDocument;
import com.spire.doc.interfaces.IDocumentObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class WordManageUtil {
    public static void main(String[] args) throws Exception {
        String tempPath = "C:\\Users\\wujing1\\Desktop\\\u6062\u590d\u8015\u5730\u8865\u5145\u4fe1\u606f\u786e\u8ba4\u5355-\u6a21\u677f.docx";
        String filePath = "C:\\Users\\wujing1\\Desktop\\\u586b\u5145.docx";
        String outPath = "C:\\Users\\wujing1\\Desktop\\\u4fe1\u606f\u5355.pdf";
        String txm = "C:\\Users\\wujing1\\Desktop\\txm.png";
        String qr = "C:\\Users\\wujing1\\Desktop\\qr.png";
        ArrayList<WordFillDTO> list = new ArrayList<WordFillDTO>();
        WordFillDTO xmmc = new WordFillDTO();
        xmmc.setKey("xmmc");
        xmmc.setValueList((List<WordValDTO>)new ArrayList<WordValDTO>(){
            {
                this.add(WordValDTO.builder().value("\u975e\u519c\u9879\u76ee").build());
            }
        });
        list.add(xmmc);
        WordFillDTO xmxz = new WordFillDTO();
        xmxz.setKey("xmxz");
        xmxz.setValueList((List<WordValDTO>)new ArrayList<WordValDTO>(){
            {
                this.add(WordValDTO.builder().value("\u5355\u72ec\u9009\u5740\u5efa\u8bbe\u7528\u5730\u9879\u76ee").build());
            }
        });
        list.add(xmxz);
        WordFillDTO ydInfo = new WordFillDTO();
        ydInfo.setKey("ydInfo");
        ydInfo.setValueList((List<WordValDTO>)new ArrayList<WordValDTO>(){
            {
                this.add(WordValDTO.builder().value("\u7533\u8bf7\u7528\u5730\u9762\u79ef\uff1a").build());
                this.add(WordValDTO.builder().value("3.56").fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
                this.add(WordValDTO.builder().value("\u516c\u9877\uff0c\u5176\u4e2d\u5360\u7528\u65f1\u5730\u9762\u79ef\uff1a").build());
                this.add(WordValDTO.builder().value("1.9").fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
                this.add(WordValDTO.builder().value("\u516c\u9877\uff0c\u8d28\u91cf\uff1a").build());
                this.add(WordValDTO.builder().value("2").fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
                this.add(WordValDTO.builder().value("\u7b49\uff1b").build());
                this.add(WordValDTO.builder().value("\u5360\u7528\u65f1\u5730\u9762\u79ef\uff1a").build());
                this.add(WordValDTO.builder().value("0.4").fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
                this.add(WordValDTO.builder().value("\u516c\u9877\uff0c\u8d28\u91cf\uff1a").build());
                this.add(WordValDTO.builder().value("1.56").fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
                this.add(WordValDTO.builder().value("\u7b49\uff1b").build());
                this.add(WordValDTO.builder().value("\u5360\u7528\u6c34\u7530\u9762\u79ef\uff1a").build());
                this.add(WordValDTO.builder().value("2.4591").fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
                this.add(WordValDTO.builder().value("\u516c\u9877\uff0c\u8d28\u91cf\uff1a").build());
                this.add(WordValDTO.builder().value("5").fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
                this.add(WordValDTO.builder().value("\u7b49\uff1b").build());
                this.add(WordValDTO.builder().value("\u5360\u7528\u6c34\u6d47\u5730\u9762\u79ef\uff1a").build());
                this.add(WordValDTO.builder().value("10.2").fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
                this.add(WordValDTO.builder().value("\u516c\u9877\uff0c\u8d28\u91cf\uff1a").build());
                this.add(WordValDTO.builder().value("9.5").fillLength(10).underlinePatterns(UnderlinePatterns.THICK).build());
                this.add(WordValDTO.builder().value("\u7b49\u3002").build());
            }
        });
        list.add(ydInfo);
        WordFillDTO ybhdmj = new WordFillDTO();
        ybhdmj.setKey("ybhdmj");
        ybhdmj.setValueList((List<WordValDTO>)new ArrayList<WordValDTO>(){
            {
                this.add(WordValDTO.builder().value("2.42").fillLength(10).build());
            }
        });
        list.add(ybhdmj);
        WordFillDTO ybstmj = new WordFillDTO();
        ybstmj.setKey("ybstmj");
        ybstmj.setValueList((List<WordValDTO>)new ArrayList<WordValDTO>(){
            {
                this.add(WordValDTO.builder().value("2.4591").fillLength(10).build());
            }
        });
        list.add(ybstmj);
        WordFillDTO ybsjdmj = new WordFillDTO();
        ybsjdmj.setKey("ybsjdmj");
        ybsjdmj.setValueList((List<WordValDTO>)new ArrayList<WordValDTO>(){
            {
                this.add(WordValDTO.builder().value("10.2").fillLength(10).build());
            }
        });
        list.add(ybsjdmj);
        WordFillDTO bczl = new WordFillDTO();
        bczl.setKey("bczl");
        bczl.setValueList((List<WordValDTO>)new ArrayList<WordValDTO>(){
            {
                this.add(WordValDTO.builder().value("--").fillLength(10).build());
            }
        });
        list.add(bczl);
        WordFillDTO time = new WordFillDTO();
        time.setKey("time");
        time.setValueList((List<WordValDTO>)new ArrayList<WordValDTO>(){
            {
                this.add(WordValDTO.builder().value("2024\u5e7408\u670801\u65e5").build());
            }
        });
        list.add(time);
        WordManageUtil.wordFill(tempPath, filePath, list);
        BarcodeUtil.create("650000202408010012", txm);
        BarcodeUtil.createQr("650000202408010012", qr, 100);
        WordManageUtil.inertImage(filePath, qr, txm);
        WordManageUtil.toPdf2(filePath, outPath);
        FileUtil.del((String)filePath);
        FileUtil.del((String)txm);
        FileUtil.del((String)qr);
    }

    public static void inertImage(String filePath, String imagePath, String qrPath) {
        Document document = new Document();
        document.loadFromFile(filePath);
        Section section = document.getSections().get(0);
        Paragraph paragraph = section.getParagraphs().get(0);
        DocPicture picture = new DocPicture((IDocument)document);
        picture.loadImage(imagePath);
        paragraph.getChildObjects().insert(0, (IDocumentObject)picture);
        paragraph.appendPicture(ConfigConstant.FileConfig.templateDir + File.separator + "kong.png");
        paragraph.appendPicture(qrPath);
        document.saveToFile(filePath, FileFormat.Docx);
        picture.close();
    }

    public static void inertImage(String filePath, String imagePath) {
        Document document = new Document();
        document.loadFromFile(filePath);
        Section section = document.getSections().get(0);
        Paragraph paragraph = section.getParagraphs().get(1);
        DocPicture picture = new DocPicture((IDocument)document);
        picture.loadImage(imagePath);
        paragraph.getChildObjects().insert(0, (IDocumentObject)picture);
        ParagraphFormat format = paragraph.getFormat();
        format.setHorizontalAlignment(HorizontalAlignment.Right);
        document.saveToFile(filePath, FileFormat.Docx);
        picture.close();
    }

    public static void toPdf(String filePath, String outPath) {
        File inputWord = new File(filePath);
        File outputFile = new File(outPath);
        try {
            FileInputStream docxInputStream = new FileInputStream(inputWord);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            IConverter converter = LocalConverter.builder().build();
            boolean execute = (Boolean)converter.convert((InputStream)docxInputStream).as(DocumentType.DOCX).to((OutputStream)outputStream).as(DocumentType.PDF).schedule().get();
            ((OutputStream)outputStream).close();
            ((InputStream)docxInputStream).close();
            converter.shutDown();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("word\u8f6cpdf\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static void toPdf2(String filePath, String outPath) {
        try {
            Document doc = new Document(filePath);
            doc.saveToFile(outPath, FileFormat.PDF);
            doc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("word\u8f6cpdf\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static WordFillDTO getWordFIll(String key, final String value) {
        WordFillDTO dto = new WordFillDTO();
        dto.setKey(key);
        dto.setValueList((List<WordValDTO>)new ArrayList<WordValDTO>(){
            {
                this.add(WordValDTO.builder().value(value).build());
            }
        });
        return dto;
    }

    public static WordFillDTO getWordFIll(String key, final String value, final int length) {
        WordFillDTO dto = new WordFillDTO();
        dto.setKey(key);
        dto.setValueList((List<WordValDTO>)new ArrayList<WordValDTO>(){
            {
                this.add(WordValDTO.builder().value(value).fillLength(length).build());
            }
        });
        return dto;
    }

    public static void wordFill(String path, String outPath, Map<String, Object> dict) throws Exception {
        File f;
        FileInputStream is = new FileInputStream(path);
        XWPFDocument document = new XWPFDocument((InputStream)is);
        if (dict != null) {
            WordManageUtil.compileText(document, dict);
            WordManageUtil.compileTable(document, dict);
        }
        if (!(f = new File(outPath.substring(0, outPath.lastIndexOf(File.separator)))).exists()) {
            f.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(outPath);
        document.write((OutputStream)out);
    }

    private static void compileText(XWPFDocument document, Map<String, Object> dict) throws Exception {
        Iterator iterator = document.getParagraphsIterator();
        XWPFParagraph paragraph = null;
        while (iterator.hasNext()) {
            paragraph = (XWPFParagraph)iterator.next();
            if (!WordManageUtil.checkText(paragraph.getText())) continue;
            WordManageUtil.replaceValue(paragraph, dict);
        }
    }

    private static void compileTable(XWPFDocument document, Map<String, Object> dict) throws Exception {
        Iterator tableList = document.getTablesIterator();
        while (tableList.hasNext()) {
            XWPFTable table = (XWPFTable)tableList.next();
            if (!WordManageUtil.checkText(table.getText())) continue;
            List rows = table.getRows();
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                for (XWPFTableCell cell : cells) {
                    if (!WordManageUtil.checkText(cell.getText())) continue;
                    List paragraphs = cell.getParagraphs();
                    for (XWPFParagraph paragraph : paragraphs) {
                        WordManageUtil.replaceValue(paragraph, dict);
                    }
                }
            }
        }
    }

    private static void replaceValue(XWPFParagraph paragraph, Map<String, Object> dict) throws Exception {
        List runs = paragraph.getRuns();
        for (int i = 0; i < runs.size(); ++i) {
            XWPFRun xwpfRun = (XWPFRun)runs.get(i);
            String readLine = xwpfRun.text();
            if (StringUtils.isEmpty((CharSequence)readLine) || !readLine.contains("$")) continue;
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, Object> entry : dict.entrySet()) {
                if (!readLine.contains("${" + entry.getKey() + "}")) continue;
                readLine = readLine.replace("${" + entry.getKey() + "}", entry.getValue() == null ? "" : entry.getValue().toString());
                xwpfRun.setText(readLine, 0);
                xwpfRun.setUnderline(UnderlinePatterns.THICK);
            }
        }
    }

    public static void wordFill(String path, String outPath, List<WordFillDTO> list) throws Exception {
        File f;
        FileInputStream is = new FileInputStream(path);
        XWPFDocument document = new XWPFDocument((InputStream)is);
        if (!list.isEmpty()) {
            WordManageUtil.compileText(document, list);
        }
        if (!(f = new File(outPath.substring(0, outPath.lastIndexOf(File.separator)))).exists()) {
            f.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(outPath);
        document.write((OutputStream)out);
        is.close();
    }

    private static void compileText(XWPFDocument document, List<WordFillDTO> list) throws Exception {
        Iterator iterator = document.getParagraphsIterator();
        XWPFParagraph paragraph = null;
        while (iterator.hasNext()) {
            paragraph = (XWPFParagraph)iterator.next();
            if (!WordManageUtil.checkText(paragraph.getText())) continue;
            WordManageUtil.replaceValue(paragraph, list);
        }
    }

    private static void replaceValue(XWPFParagraph paragraph, List<WordFillDTO> list) throws Exception {
        List runs = paragraph.getRuns();
        StringBuffer sbf = new StringBuffer();
        Boolean flag = false;
        ArrayList<Integer> deleteRuns = new ArrayList<Integer>();
        for (int i = 0; i < runs.size(); ++i) {
            XWPFRun xwpfRun = (XWPFRun)runs.get(i);
            String readLine = xwpfRun.text();
            if (StringUtils.isEmpty((CharSequence)readLine) || !readLine.contains("$")) continue;
            for (WordFillDTO dto : list) {
                if (!readLine.contains("${" + dto.getKey() + "}")) continue;
                if (dto.getValueList().size() > 1) {
                    deleteRuns.add(i);
                    WordManageUtil.addText(dto.getValueList(), paragraph);
                    continue;
                }
                WordManageUtil.replaceText(dto, readLine, xwpfRun);
            }
        }
        deleteRuns.forEach(f -> paragraph.removeRun(f.intValue()));
    }

    private static void replaceText(WordFillDTO dto, String readLine, XWPFRun xwpfRun) {
        WordValDTO valDTO = dto.getValueList().get(0);
        readLine = readLine.replace("${" + dto.getKey() + "}", valDTO.getValue() == null ? "" : valDTO.getValue().toString());
        if (valDTO.getFillLength() > 0 && readLine.length() < valDTO.getFillLength()) {
            readLine = WordManageUtil.textFill(readLine, valDTO.getFillLength());
        }
        xwpfRun.setText(readLine, 0);
        if (valDTO.getUnderlinePatterns() != null) {
            xwpfRun.setUnderline(valDTO.getUnderlinePatterns());
        }
    }

    private static void addText(List<WordValDTO> valueList, XWPFParagraph paragraph) {
        for (WordValDTO dto : valueList) {
            XWPFRun run = paragraph.createRun();
            String text = dto.getValue();
            if (dto.getFillLength() > 0 && text.length() < dto.getFillLength()) {
                text = WordManageUtil.textFill(text, dto.getFillLength());
            }
            run.setText(text, 0);
            run.setFontSize(dto.getFontSize());
            run.setFontFamily("\u4eff\u5b8b");
            if (dto.getUnderlinePatterns() == null) continue;
            run.setUnderline(dto.getUnderlinePatterns());
        }
    }

    private static String textFill(String text, int length) {
        StringBuffer sbf = new StringBuffer(text);
        int size = length - text.length();
        if (size % 2 != 0) {
            ++size;
        }
        int fill = size / 2;
        for (int i = 0; i < fill; ++i) {
            sbf.insert(0, " ");
            sbf.append(" ");
        }
        return sbf.toString();
    }

    private static boolean checkText(String text) {
        return text.contains("$");
    }
}

