/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.biz.aop;

import com.alibaba.fastjson.JSON;
import com.geoway.onemap.biz.aop.OpLog;
import com.geoway.onemap.biz.domain.system.OperateLog;
import com.geoway.onemap.biz.service.system.OperateLogService;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.dto.MyLoginResponse;
import com.geoway.onemap.core.service.SysConfigService;
import com.geoway.onemap.core.service.system.LoginServiceUIS;
import com.geoway.onemap.core.service.system.MyTokenService;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Service
public class OpLogAspect {
    private Logger logger = Logger.getLogger(OpLogAspect.class);
    @Autowired
    OperateLogService opLogService;
    @Autowired
    MyTokenService myTokenService;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    LoginServiceUIS loginServiceUIS;

    @AfterReturning(value="@annotation(com.geoway.onemap.biz.aop.OpLog)", returning="rvt")
    public void afterExec(JoinPoint joinPoint, Object rvt) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String token = request.getParameter("token");
            if (token == null || StringUtils.isBlank((CharSequence)token)) {
                token = request.getHeader("access_token");
            }
            if (token == null || StringUtils.isBlank((CharSequence)token)) {
                token = request.getSession().getAttribute("access_token").toString();
            }
            Class<?> clazz = joinPoint.getTarget().getClass();
            String methodName = joinPoint.getSignature().getName();
            String targetName = clazz.getSimpleName();
            Class<?>[] parameterTypes = ((MethodSignature)joinPoint.getSignature()).getMethod().getParameterTypes();
            Method methdo = clazz.getMethod(methodName, parameterTypes);
            OpLog oplog = methdo.getAnnotation(OpLog.class);
            if (oplog == null) {
                return;
            }
            if (oplog.opType().ordinal() == OpLog.OpType.login.ordinal()) {
                MyLoginResponse resp = (MyLoginResponse)rvt;
                token = resp.getToken();
            }
            SysUser sysUser = null;
            sysUser = this.loginServiceUIS.isUISEnable() ? this.loginServiceUIS.querySysUserByToken(token) : this.myTokenService.querySysUserByToken(token);
            String methodFullName = joinPoint.getSignature().getDeclaringTypeName() + "." + methodName;
            Map map = request.getParameterMap();
            String params = JSON.toJSONString((Object)map);
            OperateLog operatelog = new OperateLog();
            operatelog.setName(oplog.name());
            operatelog.setDetail(oplog.detail());
            operatelog.setOptype(oplog.opType().toString());
            operatelog.setMethod(methodFullName);
            operatelog.setParam(params);
            operatelog.setCreateTime(new Date());
            String ip = this.getRemoteHost(request);
            operatelog.setIp(ip);
            operatelog.setSystemId(oplog.systemId().ordinal());
            operatelog.setUserId(sysUser.getId().toString());
            operatelog.setUsername(sysUser.getUsername());
            this.opLogService.save(operatelog);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
    }

    private String getRemoteHost(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }
}

