/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.biz.support;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class MyCommentGenerator
implements CommentGenerator {
    private Properties properties = new Properties();
    private boolean suppressDate = false;
    private boolean suppressAllComments = false;
    private boolean addRemarkComments = false;
    private SimpleDateFormat dateFormat;

    public void addJavaFileComment(CompilationUnit compilationUnit) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        compilationUnit.addFileCommentLine("/*");
        compilationUnit.addFileCommentLine("* " + compilationUnit.getType().getShortName() + ".java");
        compilationUnit.addFileCommentLine("* Copyright(C) 2017-2020 geoway\u516c\u53f8");
        compilationUnit.addFileCommentLine("* @date " + sdf.format(new Date()) + "");
        compilationUnit.addFileCommentLine("*/");
    }

    public void addComment(XmlElement xmlElement) {
        if (this.suppressAllComments) {
            return;
        }
    }

    public void addRootComment(XmlElement rootElement) {
    }

    public void addConfigurationProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        this.suppressDate = StringUtility.isTrue((String)properties.getProperty("suppressDate"));
        this.suppressAllComments = StringUtility.isTrue((String)properties.getProperty("suppressAllComments"));
        this.addRemarkComments = StringUtility.isTrue((String)properties.getProperty("addRemarkComments"));
        String dateFormatString = properties.getProperty("dateFormat");
        if (StringUtility.stringHasValue((String)dateFormatString)) {
            this.dateFormat = new SimpleDateFormat(dateFormatString);
        }
    }

    protected void addJavadocTag(JavaElement javaElement, boolean markAsDoNotDelete) {
        String s;
        javaElement.addJavaDocLine(" *");
        StringBuilder sb = new StringBuilder();
        sb.append(" * ");
        sb.append("@mbg.generated");
        if (markAsDoNotDelete) {
            sb.append(" do_not_delete_during_merge");
        }
        if ((s = this.getDateString()) != null) {
            sb.append(' ');
            sb.append(s);
        }
        javaElement.addJavaDocLine(sb.toString());
    }

    protected String getDateString() {
        if (this.suppressDate) {
            return null;
        }
        if (this.dateFormat != null) {
            return this.dateFormat.format(new Date());
        }
        return new Date().toString();
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        innerClass.addJavaDocLine("/**");
        innerClass.addJavaDocLine(" * @Title " + introspectedTable.getFullyQualifiedTable() + "\u8868\u7684\u5b9e\u4f53\u7c7b");
        innerClass.addJavaDocLine(" * @Description " + introspectedTable.getRemarks());
        innerClass.addJavaDocLine(" * @version 1.0");
        innerClass.addJavaDocLine(" * @Author fendo");
        innerClass.addJavaDocLine(" * @Date " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        innerClass.addJavaDocLine(" */");
    }

    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments || !this.addRemarkComments) {
            return;
        }
    }

    public void addEnumComment(InnerEnum innerEnum, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        innerEnum.addJavaDocLine("/**");
        innerEnum.addJavaDocLine(" * This enum was generated by MyBatis Generator.");
        sb.append(" * This enum corresponds to the database table ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        innerEnum.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)innerEnum, false);
        innerEnum.addJavaDocLine(" */");
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        field.addJavaDocLine("/**");
        field.addJavaDocLine(" * @Fields " + field.getName() + " " + introspectedColumn.getRemarks());
        field.addJavaDocLine(" */");
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
    }

    public void addGeneralMethodComment(Method method, IntrospectedTable introspectedTable) {
        String method_name;
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.append(" * ");
        if (method.isConstructor()) {
            sb.append(" \u6784\u9020\u67e5\u8be2\u6761\u4ef6");
        }
        if ("setOrderByClause".equals(method_name = method.getName())) {
            sb.append(" \u8bbe\u7f6e\u6392\u5e8f\u5b57\u6bb5");
        } else if ("setDistinct".equals(method_name)) {
            sb.append(" \u8bbe\u7f6e\u8fc7\u6ee4\u91cd\u590d\u6570\u636e");
        } else if ("getOredCriteria".equals(method_name)) {
            sb.append(" \u83b7\u53d6\u5f53\u524d\u7684\u67e5\u8be2\u6761\u4ef6\u5b9e\u4f8b");
        } else if ("isDistinct".equals(method_name)) {
            sb.append(" \u662f\u5426\u8fc7\u6ee4\u91cd\u590d\u6570\u636e");
        } else if ("getOrderByClause".equals(method_name)) {
            sb.append(" \u83b7\u53d6\u6392\u5e8f\u5b57\u6bb5");
        } else if ("createCriteria".equals(method_name)) {
            sb.append(" \u521b\u5efa\u4e00\u4e2a\u67e5\u8be2\u6761\u4ef6");
        } else if ("createCriteriaInternal".equals(method_name)) {
            sb.append(" \u5185\u90e8\u6784\u5efa\u67e5\u8be2\u6761\u4ef6\u5bf9\u8c61");
        } else if ("clear".equals(method_name)) {
            sb.append(" \u6e05\u9664\u67e5\u8be2\u6761\u4ef6");
        } else if ("countByExample".equals(method_name)) {
            sb.append(" \u6839\u636e\u6307\u5b9a\u7684\u6761\u4ef6\u83b7\u53d6\u6570\u636e\u5e93\u8bb0\u5f55\u6570");
        } else if ("deleteByExample".equals(method_name)) {
            sb.append(" \u6839\u636e\u6307\u5b9a\u7684\u6761\u4ef6\u5220\u9664\u6570\u636e\u5e93\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55");
        } else if ("deleteByPrimaryKey".equals(method_name)) {
            sb.append(" \u6839\u636e\u4e3b\u952e\u5220\u9664\u6570\u636e\u5e93\u7684\u8bb0\u5f55");
        } else if ("insert".equals(method_name)) {
            sb.append(" \u65b0\u5199\u5165\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("insertSelective".equals(method_name)) {
            sb.append(" \u52a8\u6001\u5b57\u6bb5,\u5199\u5165\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("selectByExample".equals(method_name)) {
            sb.append(" \u6839\u636e\u6307\u5b9a\u7684\u6761\u4ef6\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("selectByPrimaryKey".equals(method_name)) {
            sb.append(" \u6839\u636e\u6307\u5b9a\u4e3b\u952e\u83b7\u53d6\u4e00\u6761\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("updateByExampleSelective".equals(method_name)) {
            sb.append(" \u52a8\u6001\u6839\u636e\u6307\u5b9a\u7684\u6761\u4ef6\u6765\u66f4\u65b0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("updateByExample".equals(method_name)) {
            sb.append(" \u6839\u636e\u6307\u5b9a\u7684\u6761\u4ef6\u6765\u66f4\u65b0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("updateByPrimaryKeySelective".equals(method_name)) {
            sb.append(" \u52a8\u6001\u5b57\u6bb5,\u6839\u636e\u4e3b\u952e\u6765\u66f4\u65b0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("updateByPrimaryKey".equals(method_name)) {
            sb.append(" \u6839\u636e\u4e3b\u952e\u6765\u66f4\u65b0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u8bb0\u5f55");
        }
        sb.append(":");
        sb.append(introspectedTable.getFullyQualifiedTable());
        method.addJavaDocLine(sb.toString());
        List parameterList = method.getParameters();
        if (!parameterList.isEmpty()) {
            method.addJavaDocLine(" *");
            if ("or".equals(method_name)) {
                sb.append(" \u589e\u52a0\u6216\u8005\u7684\u67e5\u8be2\u6761\u4ef6,\u7528\u4e8e\u6784\u5efa\u6216\u8005\u67e5\u8be2");
            }
        } else if ("or".equals(method_name)) {
            sb.append(" \u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u6216\u8005\u67e5\u8be2\u6761\u4ef6");
        }
        for (Parameter parameter : parameterList) {
            sb.setLength(0);
            sb.append(" * @param ");
            String paramterName = parameter.getName();
            sb.append(paramterName);
            if ("orderByClause".equals(paramterName)) {
                sb.append(" \u6392\u5e8f\u5b57\u6bb5");
            } else if ("distinct".equals(paramterName)) {
                sb.append(" \u662f\u5426\u8fc7\u6ee4\u91cd\u590d\u6570\u636e");
            } else if ("criteria".equals(paramterName)) {
                sb.append(" \u8fc7\u6ee4\u6761\u4ef6\u5b9e\u4f8b");
            }
            method.addJavaDocLine(sb.toString());
        }
        method.addJavaDocLine(" */");
    }

    public void addGetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.append(" * \u83b7\u53d6 ");
        sb.append(introspectedColumn.getRemarks()).append(" \u5b57\u6bb5:");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        method.addJavaDocLine(sb.toString());
        method.addJavaDocLine(" *");
        sb.setLength(0);
        sb.append(" * @return ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        sb.append(", ");
        sb.append(introspectedColumn.getRemarks());
        method.addJavaDocLine(sb.toString());
        method.addJavaDocLine(" */");
    }

    public void addSetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.append(" * \u8bbe\u7f6e ");
        sb.append(introspectedColumn.getRemarks()).append(" \u5b57\u6bb5:");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        method.addJavaDocLine(sb.toString());
        method.addJavaDocLine(" *");
        Parameter parm = (Parameter)method.getParameters().get(0);
        sb.setLength(0);
        sb.append(" * @param ");
        sb.append(parm.getName());
        sb.append(" the value for ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        sb.append(", ");
        sb.append(introspectedColumn.getRemarks());
        method.addJavaDocLine(sb.toString());
        method.addJavaDocLine(" */");
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable, boolean markAsDoNotDelete) {
        if (this.suppressAllComments) {
            return;
        }
        innerClass.addJavaDocLine("/**");
        innerClass.addJavaDocLine(" * @Title " + introspectedTable.getFullyQualifiedTable() + "\u8868\u7684\u5b9e\u4f53\u7c7b");
        innerClass.addJavaDocLine(" * @Description " + introspectedTable.getRemarks());
        innerClass.addJavaDocLine(" * @version 1.0");
        innerClass.addJavaDocLine(" * @Author fendo");
        innerClass.addJavaDocLine(" * @Date " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        innerClass.addJavaDocLine(" */");
    }
}

