/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.config;

import java.time.Duration;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Component
public class RedisLockUtil {
    @Autowired
    private RedisTemplate redisTemplate;
    private static final Long LOCK_REDIS_TIMEOUT = 10L;
    public static final Long LOCK_REDIS_WAIT = 500L;

    public Boolean getLock(String key, String value) {
        Boolean lockStatus = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, Duration.ofSeconds(LOCK_REDIS_TIMEOUT));
        return lockStatus;
    }

    public Long releaseLock(String key, String value) {
        String luaScript = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        DefaultRedisScript redisScript = new DefaultRedisScript(luaScript, Long.class);
        Long releaseStatus = (Long)this.redisTemplate.execute((RedisScript)redisScript, Collections.singletonList(key), new Object[]{value});
        return releaseStatus;
    }
}

