/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.metadata.service.ModelFieldsService;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.onemap.biz.service.system.RedisService;
import com.geoway.onemap.core.domain.Region;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.service.RegionService;
import com.geoway.onemap.stxf.dto.FLZygdDTO;
import com.geoway.onemap.stxf.dto.FNZygdDTO;
import com.geoway.onemap.stxf.dto.UpBlockDTO;
import com.geoway.onemap.stxf.dto.UploadAttach;
import com.geoway.onemap.stxf.service.BaseFileService;
import com.geoway.onemap.stxf.service.GtyService;
import com.geoway.onemap.stxf.service.ProjectManageService;
import com.geoway.onemap.stxf.utils.ShpUtils;
import com.geoway.onemap.stxf.utils.SqlliteConnTool;
import com.geoway.onemap.zbph.constant.base.EnumLshType;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKType;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKInputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKSpatialDetail;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKInputDTO;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.supoort.FileManageUtil;
import com.geoway.onemap.zbph.supoort.LockUtil;
import com.geoway.onemap.zbph.supoort.PdfManageUtil;
import com.geoway.zhgd.dao.OutCheckGtyDao;
import com.geoway.zhgd.dao.ProjectGdbhCbbcgdYjkRepository;
import com.geoway.zhgd.dao.VerifyTaskDao;
import com.geoway.zhgd.domain.BaseFile;
import com.geoway.zhgd.domain.OutCheckGty;
import com.geoway.zhgd.domain.ProjectGdbhCbbcgdYjk;
import com.geoway.zhgd.dto.GdBlockDTO;
import com.geoway.zhgd.dto.XmqBlockDTO;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.criteria.Predicate;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Transactional(rollbackFor={Exception.class})
@Service
public class GdbhService {
    private static final Logger log = LoggerFactory.getLogger(GdbhService.class);
    @Autowired
    ModelManageService modelManageService;
    @Autowired
    ModelFieldsService modelFieldsService;
    @Autowired
    BaseFileService baseFileService;
    @Autowired
    RedisService redisService;
    @Autowired
    ProjectManageService projectManageService;
    @Autowired
    OutCheckGtyDao outCheckGtyDao;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private ZBKManagerService zbkManagerService;
    @Autowired
    private GtyService getGtyService;
    @Autowired
    private BaseLshService baseSidService;
    @Value(value="${project.gty.dir}")
    protected String gtyDir;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${project.fnzbk:true}")
    protected boolean fnzbk;
    @Autowired
    protected GtyService gtyService;
    @Autowired
    RegionService regionService;
    @Autowired
    private ProjectGdbhCbbcgdYjkRepository yjkRepository;
    @Autowired
    private VerifyTaskDao verifyTaskDao;
    @Autowired
    private ZBKDKDetailService zbkdkDetailService;
    @Autowired
    private LockUtil lockUtil;

    @Transactional(rollbackFor={Exception.class})
    public void updateJhk(String data, String attach, SysUser user) throws Exception {
        Map xmxx = (Map)JSON.parseObject((String)data, Map.class);
        String projectId = xmxx.get("f_id").toString();
        xmxx.remove("f_code");
        this.modelManageService.updateModel(xmxx, "tb_project_gdbh_cbbcgd_jhk");
        if (StringUtils.isNotEmpty((CharSequence)attach)) {
            List attachs = JSON.parseArray((String)attach, UploadAttach.class);
            UploadAttach attachXZGDOpt = attachs.stream().filter(f -> f.getType().equals("XZGD")).findAny().orElse(null);
            UploadAttach attachXMFWOpt = attachs.stream().filter(f -> f.getType().equals("XMFW")).findAny().orElse(null);
            UploadAttach attachImgOpt = attachs.stream().filter(f -> f.getType().equals("GDYX")).findAny().orElse(null);
            UploadAttach attachPFWJOpt = attachs.stream().filter(f -> f.getType().equals("PFWJ")).findAny().orElse(null);
            if (attachXZGDOpt != null) {
                this.saveJHKXZGD(xmxx, user, projectId, attachXZGDOpt);
            }
            if (attachXMFWOpt != null) {
                this.saveJHKXMFW(xmxx, user, projectId, attachXMFWOpt);
            }
            if (attachImgOpt != null) {
                this.saveFj(user, projectId, "GDYX", attachImgOpt);
            }
            if (attachPFWJOpt != null) {
                this.saveFj(user, projectId, "PFWJ", attachPFWJOpt);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateFhk(String data, String attach, SysUser user) throws Exception {
        Map xmxx = (Map)JSON.parseObject((String)data, Map.class);
        String projectId = xmxx.get("f_id").toString();
        xmxx.remove("f_code");
        this.modelManageService.updateModel(xmxx, "tb_project_gdbh_cbbcgd_fhk");
        if (StringUtils.isNotEmpty((CharSequence)attach)) {
            List attachs = JSON.parseArray((String)attach, UploadAttach.class);
            UploadAttach attachXZGDOpt = attachs.stream().filter(f -> f.getType().equals("XZGD")).findAny().orElse(null);
            UploadAttach attachXMFWOpt = attachs.stream().filter(f -> f.getType().equals("XMFW")).findAny().orElse(null);
            UploadAttach attachImgOpt = attachs.stream().filter(f -> f.getType().equals("GDYX")).findAny().orElse(null);
            UploadAttach attachYSPFWJOpt = attachs.stream().filter(f -> f.getType().equals("YSPFWJ")).findAny().orElse(null);
            UploadAttach attachZLDBPDOpt = attachs.stream().filter(f -> f.getType().equals("ZLDBPD")).findAny().orElse(null);
            UploadAttach attachXZGDHDOpt = attachs.stream().filter(f -> f.getType().equals("XZGDHD")).findAny().orElse(null);
            if (attachXZGDOpt != null) {
                this.saveFHKXZGD(xmxx, user, projectId, attachXZGDOpt);
            }
            if (attachXMFWOpt != null) {
                this.saveFHKXMFW(xmxx, user, projectId, attachXMFWOpt);
            }
            if (attachImgOpt != null) {
                this.saveFj(user, projectId, "GDYX", attachImgOpt);
            }
            if (attachYSPFWJOpt != null) {
                this.saveFj(user, projectId, "YSPFWJ", attachYSPFWJOpt);
            }
            if (attachZLDBPDOpt != null) {
                this.saveFj(user, projectId, "ZLDBPD", attachZLDBPDOpt);
            }
            if (attachXZGDHDOpt != null) {
                this.saveFj(user, projectId, "XZGDHD", attachXZGDHDOpt);
            }
        }
    }

    public List queryBlocks(String projectId, String type) {
        String table = XmxxType.LX.type.equals(type) ? "tb_project_gdbh_cbbcgd_jhk_xzgdfw" : (XmxxType.YS.type.equals(type) ? "tb_project_gdbh_cbbcgd_fhk_xzgdfw" : "tb_project_gdbh_cbbcgd_yjk_xzgdfw");
        return this.modelManageService.findList(table, null, " and f_project_id = '" + projectId + "' ");
    }

    public void updateBlocks(String blockStr, String type) throws Exception {
        List blocks = JSON.parseArray((String)blockStr).toJavaList(UpBlockDTO.class);
        String table = XmxxType.LX.type.equals(type) ? "tb_project_gdbh_cbbcgd_jhk_xzgdfw" : "tb_project_gdbh_cbbcgd_fhk_xzgdfw";
        for (UpBlockDTO block : blocks) {
            this.modelManageService.updateModel(BeanUtil.beanToMap((Object)block, (String[])new String[0]), table);
        }
    }

    public void inputZbk(String projectId, SysUser user) {
        List<String> pids = Arrays.asList(projectId.split(","));
        for (String pid : pids) {
            Map xmxx = this.modelManageService.findOne("tb_project_gdbh_cbbcgd_fhk", String.format("and f_id='%s'", pid));
            ZBKInputDetail zbkInputDetail = new ZBKInputDetail();
            zbkInputDetail.setZbxzqdm(String.valueOf(xmxx.get("f_xzqhdm")));
            zbkInputDetail.setZbxzqmc(String.valueOf(xmxx.get("f_xzqmc")));
            zbkInputDetail.setCzxzqdm(user.getXzqdm());
            zbkInputDetail.setCzxzqmc(user.getFullXzqmc());
            zbkInputDetail.setCzlx(EnumZBKInputType.ZBBBRK.toValue());
            zbkInputDetail.setZblx(EnumZBKType.XFSRKBCGDZB.toValue());
            zbkInputDetail.setXmbh(String.valueOf(xmxx.get("f_code")));
            zbkInputDetail.setXmmc(String.valueOf(xmxx.get("f_name")));
            zbkInputDetail.setXmjgysrq((Date)xmxx.get("f_ys_ysrq"));
            zbkInputDetail.setDate(new Date());
            zbkInputDetail.setUserid(String.valueOf(user.getId()));
            zbkInputDetail.setUsername(String.valueOf(user.getAlisname()));
            zbkInputDetail.setLsh(zbkInputDetail.getXmbh());
            List gdList = this.modelManageService.findList("tb_project_gdbh_cbbcgd_fhk_xzgdfw", null, String.format("and f_project_id='%s'", pid));
            ArrayList<ZBKInputDTO> zbkInputDTOS = new ArrayList<ZBKInputDTO>();
            for (Map dk : gdList) {
                ZBKInputDTO zbkInputDTO = new ZBKInputDTO();
                ZBKInputDetail inputDetail = new ZBKInputDetail();
                BeanUtil.copyProperties((Object)zbkInputDetail, (Object)inputDetail, (String[])new String[0]);
                inputDetail.setGdmj(this.toDouble(dk.get("f_xzgdmj")));
                inputDetail.setStmj(this.toDouble(dk.get("f_xzstmj")));
                inputDetail.setGddb(this.toDouble(dk.get("f_gzhpjzldb")));
                inputDetail.setDkbh(String.valueOf(dk.get("f_dkbh")));
                inputDetail.setDkid(String.valueOf(dk.get("f_id")));
                inputDetail.setDkmc(String.valueOf(dk.get("f_dkmc")));
                inputDetail.setDkxzqdm(String.valueOf(dk.get("xzqdm")));
                inputDetail.setDkxzqmc(String.valueOf(dk.get("xzqmc")));
                inputDetail.setCnzb(0.0);
                ZBKSpatialDetail detail = new ZBKSpatialDetail();
                String wkt = String.valueOf(dk.get("wkt"));
                org.locationtech.jts.geom.Geometry geo = this.getGeo(wkt);
                detail.setShape(geo);
                detail.setDlmc(String.valueOf(dk.get("f_dlbm")));
                detail.setDlbm(this.getDlbm(detail.getDlmc()));
                detail.setTbmj(this.toDouble(dk.get("f_dkmj")));
                zbkInputDTO.setZbkInputDetail(inputDetail);
                zbkInputDTO.setZbkSpatialDetail(detail);
                zbkInputDTOS.add(zbkInputDTO);
            }
            this.zbkManagerService.input(zbkInputDTOS);
        }
    }

    public void inputZbkZygd(SysUser user, String projectId) {
        if (this.fnzbk) {
            FLZygdDTO detail = this.getZYGDDetail(projectId);
            Map<String, Object> xmxx = detail.getXmxx();
            ZBKInputDetail zbkInputDetail = new ZBKInputDetail();
            zbkInputDetail.setZbxzqdm(String.valueOf(xmxx.get("f_xzqdm")));
            zbkInputDetail.setZbxzqmc(String.valueOf(xmxx.get("f_xzqmc")));
            zbkInputDetail.setCzxzqdm(user.getXzqdm());
            zbkInputDetail.setCzxzqmc(user.getFullXzqmc());
            zbkInputDetail.setZblx(EnumZBKType.FFGDZB.toValue());
            zbkInputDetail.setCzlx(EnumZBKInputType.ZBBBRK.toValue());
            zbkInputDetail.setDate(new Date());
            zbkInputDetail.setUserid(String.valueOf(user.getId()));
            zbkInputDetail.setUsername(String.valueOf(user.getAlisname()));
            zbkInputDetail.setLsh(String.valueOf(xmxx.get("f_code")));
            zbkInputDetail.setXmbh(String.valueOf(xmxx.get("f_code")));
            zbkInputDetail.setXmmc(String.valueOf(xmxx.get("f_name")));
            zbkInputDetail.setCnzb(0.0);
            List<Map<String, Object>> bcgdDetails = detail.getBcgdDetails();
            if (bcgdDetails != null && !bcgdDetails.isEmpty()) {
                ArrayList<ZBKInputDTO> zbkInputDTOS = new ArrayList<ZBKInputDTO>();
                for (Map<String, Object> dk : bcgdDetails) {
                    String dkbh = String.valueOf(dk.get("f_dikuai_no"));
                    ZBKInputDTO zbkInputDTO = new ZBKInputDTO();
                    ZBKInputDetail inputDetail = new ZBKInputDetail();
                    BeanUtil.copyProperties((Object)zbkInputDetail, (Object)inputDetail, (String[])new String[0]);
                    inputDetail.setGddb(this.toDouble(dk.get("f_gddb")));
                    inputDetail.setDkbh(dkbh);
                    inputDetail.setDkid(String.valueOf(dk.get("f_id")));
                    inputDetail.setDkmc(ObjectUtil.isEmpty((Object)dk.get("f_pl_name")) ? dkbh : String.valueOf(dk.get("f_pl_name")));
                    inputDetail.setDkxzqdm(String.valueOf(dk.get("xzqdm")));
                    inputDetail.setDkxzqmc(String.valueOf(dk.get("xzqmc")));
                    ZBKSpatialDetail dkDetail = new ZBKSpatialDetail();
                    String wkt = String.valueOf(dk.get("wkt"));
                    org.locationtech.jts.geom.Geometry geo = this.getGeo(wkt);
                    dkDetail.setShape(geo);
                    dkDetail.setDlmc(String.valueOf(dk.get("f_dlmc")));
                    dkDetail.setDlbm(String.valueOf(dk.get("f_dlbm")));
                    dkDetail.setTbmj(this.toDouble(dk.get("f_bcmj")));
                    inputDetail.setGdmj(this.toDouble(dk.get("f_gdmj")));
                    inputDetail.setStmj(0.0);
                    zbkInputDTO.setZbkInputDetail(inputDetail);
                    zbkInputDTO.setZbkSpatialDetail(dkDetail);
                    zbkInputDTOS.add(zbkInputDTO);
                }
                this.zbkManagerService.input(zbkInputDTOS);
            }
        }
    }

    private org.locationtech.jts.geom.Geometry getGeo(String wkt) {
        org.locationtech.jts.io.WKTReader reader = new org.locationtech.jts.io.WKTReader();
        try {
            org.locationtech.jts.geom.Geometry geometry = reader.read(wkt);
            geometry.setSRID(4490);
            return geometry;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private double toDouble(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof String) {
            return Double.valueOf(obj.toString());
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).doubleValue();
        }
        return (Double)obj;
    }

    private BigDecimal toBigDecima(Object obj) {
        double val = 0.0;
        if (obj == null) {
            val = 0.0;
        }
        if (obj instanceof String) {
            val = Double.valueOf(obj.toString());
        } else {
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            if (obj instanceof Number) {
                val = ((Number)obj).doubleValue();
            }
        }
        return BigDecimal.valueOf(val);
    }

    private String getDlbm(String dlmc) {
        return "\u6c34\u7530".equals(dlmc) ? "0101" : ("\u65f1\u5730".equals(dlmc) ? "0103" : "0102");
    }

    private void saveJHKXMFW(Map<String, Object> data, SysUser user, String projectId, UploadAttach attachXMFW) {
        block7: {
            try {
                String xzqmc = data.get("f_xzqmc").toString();
                String xzqdm = data.get("xzqdm").toString();
                this.modelManageService.delObject("tb_project_gdbh_cbbcgd_jhk_xmfw", String.format("and f_project_id='%s'", projectId));
                if ("txt".equalsIgnoreCase(attachXMFW.getFileType())) {
                    Map<String, Object> geoJsonMap = attachXMFW.getGeoJsonMap();
                    List geometries = (List)geoJsonMap.get("geometries");
                    Map map = (Map)geometries.get(0);
                    HashMap<String, Object> gd = new HashMap<String, Object>();
                    gd.put("f_project_id", projectId);
                    gd.put("xzqmc", xzqmc);
                    gd.put("xzqdm", xzqdm);
                    gd.put("f_jbxx_xmmc", data.get("f_name"));
                    gd.put("f_jbxx_xzqmc", xzqmc);
                    gd.put("f_jbxx_xzqdm", xzqdm);
                    gd.put("f_ys_xmbh", data.get("f_code"));
                    gd.put("f_xmlx", data.get("f_type"));
                    gd.put("f_shape", map.get("wkt"));
                    gd.put("f_dkmj", map.get("dkmj"));
                    gd.put("f_dkbh", map.get("dkbh"));
                    gd.put("f_dkmc", map.get("dkmc"));
                    gd.put("f_dkyt", map.get("dkyt"));
                    gd.put("f_tfh", map.get("tfh"));
                    gd.put("f_bz", map.get("bz"));
                    gd.put("f_shp_name", attachXMFW.getFileName());
                    this.modelManageService.saveModel(gd, "tb_project_gdbh_cbbcgd_jhk_xmfw", user.getId(), true);
                    break block7;
                }
                String base64 = this.redisService.get(attachXMFW.getUuid());
                String shpPathXZGD = new String(Base64.decodeBase64((String)base64));
                for (String path : shpPathXZGD.split(";")) {
                    if (!path.toLowerCase().endsWith(".shp")) continue;
                    List<Map<String, Object>> shpInfo = ShpUtils.getShpGCSProperties(path);
                    if (shpInfo == null) {
                        BaseResponse.buildFailuaResponse((String)"\u5730\u5757shape\u6587\u4ef6\u89e3\u6790\u5931\u8d25!");
                    } else {
                        for (Map<String, Object> map : shpInfo) {
                            HashMap<String, Object> gd = new HashMap<String, Object>();
                            gd.put("f_project_id", projectId);
                            gd.put("xzqmc", xzqmc);
                            gd.put("xzqdm", xzqdm);
                            gd.put("f_jbxx_xmmc", data.get("f_name"));
                            gd.put("f_jbxx_xzqmc", xzqmc);
                            gd.put("f_jbxx_xzqdm", xzqdm);
                            gd.put("f_ys_xmbh", data.get("f_code"));
                            gd.put("f_xmlx", data.get("f_type"));
                            gd.put("f_shape", map.get("the_geom"));
                            gd.put("f_dkmj", 0);
                            gd.put("f_shp_name", new File(path).getName());
                            this.modelManageService.saveModel(gd, "tb_project_gdbh_cbbcgd_jhk_xmfw", user.getId(), true);
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void saveJHKXZGD(Map<String, Object> data, SysUser user, String projectId, UploadAttach attachXZGD) {
        block7: {
            try {
                String xzqmc = data.get("f_xzqmc").toString();
                String xzqdm = data.get("xzqdm").toString();
                int cordCount = 0;
                WKTReader wktReader = new WKTReader();
                this.modelManageService.delObject("tb_project_gdbh_cbbcgd_jhk_xzgdfw", String.format("and f_project_id='%s'", projectId));
                if ("txt".equalsIgnoreCase(attachXZGD.getFileType())) {
                    Map<String, Object> geoJsonMap = attachXZGD.getGeoJsonMap();
                    List geometries = (List)geoJsonMap.get("geometries");
                    for (Map map : geometries) {
                        HashMap<String, Object> gd = new HashMap<String, Object>();
                        gd.put("f_project_id", projectId);
                        gd.put("xzqmc", xzqmc);
                        gd.put("xzqdm", xzqdm);
                        gd.put("f_ys_xmbh", data.get("f_code"));
                        gd.put("f_jbxx_xmmc", data.get("f_name"));
                        gd.put("f_shape", map.get("wkt"));
                        gd.put("f_dkbh", map.get("dkbh"));
                        gd.put("f_dkmc", map.get("dkmc"));
                        gd.put("f_dkmj", map.get("dkmj"));
                        gd.put("f_dkyt", map.get("dkyt"));
                        gd.put("f_tfh", map.get("tfh"));
                        gd.put("f_tblx", map.get("tblx"));
                        gd.put("f_dlbm", map.get("dlbm"));
                        gd.put("f_gzqpjzldb", map.get("gzqpjzldb"));
                        gd.put("f_gzhpjzldb", map.get("gzhpjzldb"));
                        gd.put("f_xzgdmj", map.get("f_xzgdmj"));
                        gd.put("f_xzstmj", map.get("f_xzstmj"));
                        gd.put("f_yuliu", map.get("yuliu"));
                        gd.put("f_shp_name", attachXZGD.getFileName());
                        this.modelManageService.saveModel(gd, "tb_project_gdbh_cbbcgd_jhk_xzgdfw", user.getId(), true);
                        Geometry geometry = wktReader.read(map.get("wkt").toString());
                        int np = geometry.getNumPoints();
                        cordCount += np;
                    }
                    geoJsonMap.remove("geometries");
                    HashMap<String, Object> upProject = new HashMap<String, Object>();
                    upProject.put("f_id", projectId);
                    upProject.put("f_xzgd_shp_meta", JSON.toJSONString(geoJsonMap));
                    upProject.put("f_xzgd_cord_count", cordCount);
                    this.modelManageService.updateModel(upProject, "tb_project_gdbh_cbbcgd_jhk");
                    break block7;
                }
                String base64 = this.redisService.get(attachXZGD.getUuid());
                String shpPathXZGD = new String(Base64.decodeBase64((String)base64));
                for (String path : shpPathXZGD.split(";")) {
                    if (!path.toLowerCase().endsWith(".shp")) continue;
                    List<Map<String, Object>> shpInfo = ShpUtils.getShpGCSProperties(path);
                    if (shpInfo == null) {
                        throw new RuntimeException("\u5730\u5757shape\u6587\u4ef6\u89e3\u6790\u5931\u8d25!");
                    }
                    for (Map<String, Object> map : shpInfo) {
                        HashMap<String, Object> gd = new HashMap<String, Object>();
                        gd.put("f_project_id", projectId);
                        gd.put("xzqmc", xzqmc);
                        gd.put("xzqdm", xzqdm);
                        gd.put("f_ys_xmbh", data.get("f_code"));
                        gd.put("f_jbxx_xmmc", data.get("f_name"));
                        gd.put("f_shape", map.get("the_geom"));
                        gd.put("f_dkbh", map.get("DIKUAI_NO"));
                        gd.put("f_dkmc", map.get("PL_NAME"));
                        gd.put("f_dkmj", map.get("DIKUAIAREA"));
                        gd.put("f_dkyt", map.get("PURPOSE"));
                        gd.put("f_tfh", map.get("MAP_NO"));
                        gd.put("f_tblx", map.get("PATCHTYPE"));
                        gd.put("f_dlbm", map.get("LANDTYPE"));
                        gd.put("f_gzqpjzldb", map.get("AVGGRADE1"));
                        gd.put("f_gzhpjzldb", map.get("AVGGRADE2"));
                        gd.put("f_shp_name", new File(path).getName());
                        this.modelManageService.saveModel(gd, "tb_project_gdbh_cbbcgd_jhk_xzgdfw", user.getId(), true);
                        Geometry geometry = wktReader.read(map.get("the_geom").toString());
                        int np = geometry.getNumPoints();
                        cordCount += np;
                    }
                    Map<String, Object> crs = ShpUtils.getShpCRSInfo(path);
                    String csrJson = JSONObject.toJSONString(crs);
                    HashMap<String, Object> upProject = new HashMap<String, Object>();
                    upProject.put("f_id", projectId);
                    upProject.put("f_xzgd_shp_meta", csrJson);
                    upProject.put("f_xzgd_cord_count", cordCount);
                    this.modelManageService.updateModel(upProject, "tb_project_gdbh_cbbcgd_jhk");
                    break;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private void saveFHKXMFW(Map<String, Object> data, SysUser user, String projectId, UploadAttach attachXMFW) {
        block7: {
            try {
                String xzqmc = data.get("xzqmc").toString();
                String xzqdm = data.get("xzqdm").toString();
                this.modelManageService.delObject("tb_project_gdbh_cbbcgd_fhk_xmfw", String.format("and f_project_id='%s'", projectId));
                if ("txt".equalsIgnoreCase(attachXMFW.getFileType())) {
                    Map<String, Object> geoJsonMap = attachXMFW.getGeoJsonMap();
                    List geometries = (List)geoJsonMap.get("geometries");
                    Map map = (Map)geometries.get(0);
                    HashMap<String, Object> gd = new HashMap<String, Object>();
                    gd.put("f_project_id", projectId);
                    gd.put("xzqmc", xzqmc);
                    gd.put("xzqdm", xzqdm);
                    gd.put("f_jbxx_xmmc", data.get("f_name"));
                    gd.put("f_jbxx_xzqmc", xzqmc);
                    gd.put("f_jbxx_xzqdm", xzqdm);
                    gd.put("f_ys_xmbh", data.get("f_code"));
                    gd.put("f_xmlx", data.get("f_type"));
                    gd.put("f_shape", map.get("wkt"));
                    gd.put("f_dkmj", map.get("dkmj"));
                    gd.put("f_dkbh", map.get("dkbh"));
                    gd.put("f_dkmc", map.get("dkmc"));
                    gd.put("f_dkyt", map.get("dkyt"));
                    gd.put("f_tfh", map.get("tfh"));
                    gd.put("f_bz", map.get("bz"));
                    gd.put("f_shp_name", attachXMFW.getFileName());
                    this.modelManageService.saveModel(gd, "tb_project_gdbh_cbbcgd_fhk_xmfw", user.getId(), true);
                    break block7;
                }
                String base64 = this.redisService.get(attachXMFW.getUuid());
                String shpPathXZGD = new String(Base64.decodeBase64((String)base64));
                for (String path : shpPathXZGD.split(";")) {
                    if (!path.toLowerCase().endsWith(".shp")) continue;
                    List<Map<String, Object>> shpInfo = ShpUtils.getShpGCSProperties(path);
                    if (shpInfo == null) {
                        BaseResponse.buildFailuaResponse((String)"\u5730\u5757shape\u6587\u4ef6\u89e3\u6790\u5931\u8d25!");
                    } else {
                        for (Map<String, Object> map : shpInfo) {
                            HashMap<String, Object> gd = new HashMap<String, Object>();
                            gd.put("f_project_id", projectId);
                            gd.put("xzqmc", xzqmc);
                            gd.put("xzqdm", xzqdm);
                            gd.put("f_jbxx_xmmc", data.get("f_name"));
                            gd.put("f_jbxx_xzqmc", xzqmc);
                            gd.put("f_jbxx_xzqdm", xzqdm);
                            gd.put("f_ys_xmbh", data.get("f_code"));
                            gd.put("f_xmlx", data.get("f_type"));
                            gd.put("f_shape", map.get("the_geom"));
                            gd.put("f_dkmj", 0);
                            gd.put("f_shp_name", new File(path).getName());
                            this.modelManageService.saveModel(gd, "tb_project_gdbh_cbbcgd_fhk_xmfw", user.getId(), true);
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void saveFHKXZGD(Map<String, Object> data, SysUser user, String projectId, UploadAttach attachXZGD) {
        block7: {
            try {
                String xzqmc = data.get("f_xzqmc").toString();
                String xzqdm = data.get("xzqdm").toString();
                int cordCount = 0;
                WKTReader wktReader = new WKTReader();
                this.modelManageService.delObject("tb_project_gdbh_cbbcgd_jhk_xzgdfw", String.format("and f_project_id='%s'", projectId));
                if ("txt".equalsIgnoreCase(attachXZGD.getFileType())) {
                    Map<String, Object> geoJsonMap = attachXZGD.getGeoJsonMap();
                    List geometries = (List)geoJsonMap.get("geometries");
                    for (Map map : geometries) {
                        HashMap<String, Object> gd = new HashMap<String, Object>();
                        gd.put("f_project_id", projectId);
                        gd.put("xzqmc", xzqmc);
                        gd.put("xzqdm", xzqdm);
                        gd.put("f_ys_xmbh", data.get("f_code"));
                        gd.put("f_jbxx_xmmc", data.get("f_name"));
                        gd.put("f_shape", map.get("wkt"));
                        gd.put("f_dkbh", map.get("dkbh"));
                        gd.put("f_dkmc", map.get("dkmc"));
                        gd.put("f_dkmj", map.get("dkmj"));
                        gd.put("f_dkyt", map.get("dkyt"));
                        gd.put("f_tfh", map.get("tfh"));
                        gd.put("f_tblx", map.get("tblx"));
                        gd.put("f_dlbm", map.get("dlbm"));
                        gd.put("f_gzqpjzldb", map.get("gzqpjzldb"));
                        gd.put("f_gzhpjzldb", map.get("gzhpjzldb"));
                        gd.put("f_xzgdmj", map.get("f_xzgdmj"));
                        gd.put("f_xzstmj", map.get("f_xzstmj"));
                        gd.put("f_yuliu", map.get("yuliu"));
                        gd.put("f_shp_name", attachXZGD.getFileName());
                        this.modelManageService.saveModel(gd, "tb_project_gdbh_cbbcgd_fhk_xzgdfw", user.getId(), true);
                        Geometry geometry = wktReader.read(map.get("wkt").toString());
                        int np = geometry.getNumPoints();
                        cordCount += np;
                    }
                    geoJsonMap.remove("geometries");
                    HashMap<String, Object> upProject = new HashMap<String, Object>();
                    upProject.put("f_id", projectId);
                    upProject.put("f_xzgd_shp_meta", JSON.toJSONString(geoJsonMap));
                    upProject.put("f_xzgd_cord_count", cordCount);
                    this.modelManageService.updateModel(upProject, "tb_project_gdbh_cbbcgd_fhk");
                    break block7;
                }
                String base64 = this.redisService.get(attachXZGD.getUuid());
                String shpPathXZGD = new String(Base64.decodeBase64((String)base64));
                this.modelManageService.delObject("tb_project_gdbh_cbbcgd_fhk_xzgdfw", String.format("and f_project_id='%s'", projectId));
                for (String path : shpPathXZGD.split(";")) {
                    if (!path.toLowerCase().endsWith(".shp")) continue;
                    List<Map<String, Object>> shpInfo = ShpUtils.getShpGCSProperties(path);
                    if (shpInfo == null) {
                        throw new RuntimeException("\u5730\u5757shape\u6587\u4ef6\u89e3\u6790\u5931\u8d25!");
                    }
                    for (Map<String, Object> map : shpInfo) {
                        HashMap<String, Object> gd = new HashMap<String, Object>();
                        gd.put("f_project_id", projectId);
                        gd.put("xzqmc", xzqmc);
                        gd.put("xzqdm", xzqdm);
                        gd.put("f_ys_xmbh", data.get("f_code"));
                        gd.put("f_jbxx_xmmc", data.get("f_name"));
                        gd.put("f_shape", map.get("the_geom"));
                        gd.put("f_dkbh", map.get("DIKUAI_NO"));
                        gd.put("f_dkmc", map.get("PL_NAME"));
                        gd.put("f_dkmj", map.get("DIKUAIAREA"));
                        gd.put("f_dkyt", map.get("PURPOSE"));
                        gd.put("f_tfh", map.get("MAP_NO"));
                        gd.put("f_tblx", map.get("PATCHTYPE"));
                        gd.put("f_dlbm", map.get("LANDTYPE"));
                        gd.put("f_gzqpjzldb", map.get("AVGGRADE1"));
                        gd.put("f_gzhpjzldb", map.get("AVGGRADE2"));
                        gd.put("f_shp_name", new File(path).getName());
                        this.modelManageService.saveModel(gd, "tb_project_gdbh_cbbcgd_fhk_xzgdfw", user.getId(), true);
                        Geometry geometry = wktReader.read(map.get("the_geom").toString());
                        int np = geometry.getNumPoints();
                        cordCount += np;
                    }
                    Map<String, Object> crs = ShpUtils.getShpCRSInfo(path);
                    String csrJson = JSONObject.toJSONString(crs);
                    HashMap<String, Object> upProject = new HashMap<String, Object>();
                    upProject.put("f_id", projectId);
                    upProject.put("f_xzgd_shp_meta", csrJson);
                    upProject.put("f_xzgd_cord_count", cordCount);
                    this.modelManageService.updateModel(upProject, "tb_project_gdbh_cbbcgd_fhk");
                    break;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private void saveFj(SysUser user, String projectId, String fjType, UploadAttach fj) {
        String path = new String(this.redisService.get(fj.getUuid()));
        this.addBaseFile(projectId, "GDYX", path, fjType, user);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse importJHK(Map<String, Object> data, List<UploadAttach> attach, SysUser user) {
        try {
            String sid = this.baseSidService.generateLsh(user.getXzqdm(), EnumLshType.BCGDLX);
            data.put("f_code", sid);
            Optional<UploadAttach> attachXZGDOpt = attach.stream().filter(f -> f.getType().equals("XZGD")).findAny();
            Optional<UploadAttach> attachXMFWOpt = attach.stream().filter(f -> f.getType().equals("XMFW")).findAny();
            Optional<UploadAttach> attachImgOpt = attach.stream().filter(f -> f.getType().equals("GDYX")).findAny();
            Optional<UploadAttach> attachPFWJOpt = attach.stream().filter(f -> f.getType().equals("PFWJ")).findAny();
            if (!attachXZGDOpt.isPresent()) {
                return BaseResponse.buildFailuaResponse((String)"\u83b7\u53d6\u8015\u5730\u5730\u5757\u6570\u636e\u5931\u8d25!");
            }
            String xmbh = data.get("f_code").toString();
            String xzqmc = data.get("f_xzqmc").toString();
            String xzqdm = data.get("xzqdm").toString();
            data.put("xzqmc", xzqmc);
            data.put("xzqdm", xzqdm);
            data.put("f_xzqhdm", xzqdm);
            List existProject = this.modelManageService.findList("tb_project_gdbh_cbbcgd_jhk", null, "and f_code='" + xmbh + "'");
            String projectId = "";
            if (existProject.size() > 0) {
                projectId = ((Map)existProject.get(0)).get("f_id").toString();
                data.put("f_id", projectId);
                this.modelManageService.updateModel(data, "tb_project_gdbh_cbbcgd_jhk");
            } else {
                projectId = this.modelManageService.saveModel(data, "tb_project_gdbh_cbbcgd_jhk", user.getId(), false).toString();
            }
            this.saveJHKXZGD(data, user, projectId, attachXZGDOpt.get());
            this.saveJHKXMFW(data, user, projectId, attachXMFWOpt.get());
            if (attachImgOpt.isPresent()) {
                this.saveFj(user, projectId, "GDYX", attachImgOpt.get());
            }
            if (attachPFWJOpt.isPresent()) {
                this.saveFj(user, projectId, "PFWJ", attachPFWJOpt.get());
            }
            return BaseResponse.buildSuccessResponse((String)projectId);
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse importFNZYGD(FNZygdDTO fnZygdDTO, SysUser user) {
        try {
            Map<String, Object> xmxx = fnZygdDTO.getXmxx();
            xmxx.put("f_create_time", new Date());
            xmxx.put("f_user_id", user.getId());
            xmxx.put("f_tbrxm", user.getAlisname());
            xmxx.put("f_tbrdh", user.getTel());
            String projectId = "";
            if (!ObjectUtil.isEmpty((Object)xmxx.get("f_id"))) {
                projectId = xmxx.get("f_id").toString();
                this.modelManageService.updateModel(xmxx, "tb_project_gdbh_cbbcgd_zygd");
            } else {
                xmxx.put("f_id", "");
                projectId = this.modelManageService.saveModel(xmxx, "tb_project_gdbh_cbbcgd_fnzygd", user.getId(), false).toString();
            }
            String where = String.format(" and relation_id='%s' ", projectId);
            this.modelManageService.delObject("tb_base_file", where);
            if (fnZygdDTO.getFjDetails() != null) {
                for (UploadAttach uploadAttach : fnZygdDTO.getFjDetails()) {
                    this.baseFileService.uploadFile2(new File(this.uploadDir + File.separator + uploadAttach.getPath()), projectId, "1", user, uploadAttach.getType());
                }
            }
            where = String.format(" and f_procjectid='%s' ", projectId);
            this.modelManageService.delObject("tb_project_gdbh_cbbcgd_fnzygd_bcgddetail", where);
            for (Map map : fnZygdDTO.getBcgdDetails()) {
                HashMap<String, String> tempDetail = new HashMap<String, String>();
                tempDetail.put("f_id", "");
                tempDetail.put("f_procjectid", projectId);
                tempDetail.put("f_bcgdmj", (String)map.get("f_bcgdmj"));
                tempDetail.put("f_bcstmj", (String)map.get("f_bcstmj"));
                tempDetail.put("f_bcgdcn", (String)map.get("f_bcgdcn"));
                tempDetail.put("f_zbkid", (String)map.get("f_zbkid"));
                this.modelManageService.saveModel(tempDetail, "tb_project_gdbh_cbbcgd_fnzygd_bcgddetail", user.getId(), false);
            }
            where = String.format(" and f_procjectid='%s' ", projectId);
            this.modelManageService.delObject("tb_project_gdbh_cbbcgd_fnzygd_zygddetail", where);
            for (Map map : fnZygdDTO.getZygdDetails()) {
                map.put("f_id", "");
                map.put("f_procjectid", projectId);
                this.modelManageService.saveModel(map, "tb_project_gdbh_cbbcgd_fnzygd_zygddetail", user.getId(), false);
            }
            return BaseResponse.buildSuccessResponse((String)projectId);
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
    }

    public BaseResponse detailFNZYGD(String projectId) {
        try {
            FNZygdDTO fnZygdDTO = this.getFNZYGDDetail(projectId);
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)fnZygdDTO);
            return baseObjectResponse;
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void lockAllZygd() {
        List existProject = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zygd", null, "");
        for (Map project : existProject) {
            String projectId = project.get("f_id").toString();
            FLZygdDTO exsitFLZygdDTO = this.getZYGDDetail(projectId);
            exsitFLZygdDTO.getBcgdDetails().forEach(f -> this.lockZYGD((Map<String, Object>)f));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse importZYGDBF(FLZygdDTO FLZygdDTO2, SysUser user) {
        try {
            log.error(String.format("\u7ebf\u7a0bid:%s,\u7ebf\u7a0b\u540d\u79f0\uff1a%s,importZYGD\u65b9\u6cd5\u5f00\u59cb\u6267\u884c\u65f6\u95f4:%s", Thread.currentThread().getId(), Thread.currentThread().getName(), DateUtil.now()));
            long start = System.currentTimeMillis();
            Map<String, Object> xmxx = FLZygdDTO2.getXmxx();
            xmxx.put("f_create_time", DateUtil.now());
            xmxx.put("f_user_id", user.getId());
            xmxx.put("f_tbrxm", user.getAlisname());
            xmxx.put("f_tbrdh", user.getTel());
            xmxx.put("f_id", "");
            String xmbh = xmxx.get("f_code").toString();
            List existProject = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zygd", null, "and f_code='" + xmbh + "'");
            String projectId = "";
            if (existProject.size() > 0) {
                projectId = ((Map)existProject.get(0)).get("f_id").toString();
                xmxx.put("f_id", projectId);
                this.modelManageService.updateModel(xmxx, "tb_project_gdbh_cbbcgd_zygd");
                FLZygdDTO exsitFLZygdDTO = this.getZYGDDetail(projectId);
                exsitFLZygdDTO.getBcgdDetails().forEach(f -> this.unLockZYGD((Map<String, Object>)f));
            } else {
                projectId = this.modelManageService.saveModel(xmxx, "tb_project_gdbh_cbbcgd_zygd", user.getId(), false).toString();
            }
            String where = String.format(" and relation_id='%s' ", xmbh);
            this.modelManageService.delObject("tb_base_file", where);
            if (FLZygdDTO2.getFjDetails() != null) {
                for (UploadAttach uploadAttach : FLZygdDTO2.getFjDetails()) {
                    this.baseFileService.uploadFile2(new File(this.uploadDir + File.separator + uploadAttach.getPath()), xmbh, "1", user, uploadAttach.getType());
                }
            }
            where = String.format(" and f_code='%s' ", xmbh);
            this.modelManageService.delObject("tb_project_gdbh_cbbcgd_zygd_bcgd", where);
            for (Map map : FLZygdDTO2.getBcgdDetails()) {
                HashMap<String, String> tempDetail = new HashMap<String, String>();
                tempDetail.put("f_id", "");
                tempDetail.put("f_code", xmbh);
                tempDetail.put("f_dikuai_no", (String)map.get("f_dikuai_no"));
                tempDetail.put("f_bcmj", (String)map.get("f_bcmj"));
                this.modelManageService.saveModel(tempDetail, "tb_project_gdbh_cbbcgd_zygd_bcgd", user.getId(), false);
                this.lockZYGD(map);
            }
            long end = System.currentTimeMillis();
            log.error(String.format("\u7ebf\u7a0bid:%s,\u7ebf\u7a0b\u540d\u79f0\uff1a%s,importZYGD\u65b9\u6cd5\u7ed3\u675f\u6267\u884c\u65f6\u95f4:%s\uff0c\u603b\u8017\u65f6:%s", Thread.currentThread().getId(), Thread.currentThread().getName(), DateUtil.now(), end - start));
            return BaseResponse.buildSuccessResponse((String)projectId);
        }
        catch (Exception ex) {
            log.error(String.format("\u7ebf\u7a0bid:%s,\u7ebf\u7a0b\u540d\u79f0\uff1a%s,importZYGD\u65b9\u6cd5\u5f02\u5e38", Thread.currentThread().getId(), Thread.currentThread().getName()), (Throwable)ex);
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public BaseResponse importZYGD(FLZygdDTO FLZygdDTO2, SysUser user) {
        String code = "lock-xm-" + FLZygdDTO2.getXmxx().get("f_code").toString();
        if (!this.redisTemplate.opsForValue().setIfAbsent((Object)code, (Object)"2").booleanValue()) {
            return BaseResponse.buildFailuaResponse((String)"\u9879\u76ee\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9879\u76ee\uff01");
        }
        List<String> ids = FLZygdDTO2.getBcgdDetails().stream().map(m -> "lock-block-" + m.get("f_dikuai_no").toString()).collect(Collectors.toList());
        try {
            log.error(String.format("\u7ebf\u7a0bid:%s,\u7ebf\u7a0b\u540d\u79f0\uff1a%s,importZYGD\u65b9\u6cd5\u5f00\u59cb\u6267\u884c\u65f6\u95f4:%s", Thread.currentThread().getId(), Thread.currentThread().getName(), DateUtil.now()));
            long start = System.currentTimeMillis();
            if (FLZygdDTO2.getXmxx().get("f_id") == null) {
                this.checkXm(FLZygdDTO2.getXmxx().get("f_code").toString());
                this.checkDk(FLZygdDTO2.getBcgdDetails());
            }
            for (String id : ids) {
                if (this.redisTemplate.opsForValue().setIfAbsent((Object)id, (Object)"1").booleanValue()) continue;
                BaseResponse baseResponse = BaseResponse.buildFailuaResponse((String)"\u9009\u62e9\u7684\u5730\u5757\u6b63\u5728\u88ab\u4f7f\u7528\uff0c\u8bf7\u7a0d\u540e\u4fdd\u5b58");
                return baseResponse;
            }
            Map<String, Object> xmxx = FLZygdDTO2.getXmxx();
            xmxx.put("f_create_time", DateUtil.now());
            xmxx.put("f_user_id", user.getId());
            xmxx.put("f_tbrxm", user.getAlisname());
            xmxx.put("f_tbrdh", user.getTel());
            xmxx.put("f_id", "");
            String xmbh = xmxx.get("f_code").toString();
            List existProject = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zygd", null, "and f_code='" + xmbh + "'");
            String projectId = "";
            if (existProject.size() > 0) {
                projectId = ((Map)existProject.get(0)).get("f_id").toString();
                xmxx.put("f_id", projectId);
                this.modelManageService.updateModel(xmxx, "tb_project_gdbh_cbbcgd_zygd");
                FLZygdDTO exsitFLZygdDTO = this.getZYGDDetail(projectId);
                exsitFLZygdDTO.getBcgdDetails().forEach(f -> this.unLockZYGD((Map<String, Object>)f));
            } else {
                projectId = this.modelManageService.saveModel(xmxx, "tb_project_gdbh_cbbcgd_zygd", user.getId(), false).toString();
            }
            String where = String.format(" and relation_id='%s' ", xmbh);
            this.modelManageService.delObject("tb_base_file", where);
            if (FLZygdDTO2.getFjDetails() != null) {
                for (UploadAttach uploadAttach : FLZygdDTO2.getFjDetails()) {
                    this.baseFileService.uploadFile2(new File(this.uploadDir + File.separator + uploadAttach.getPath()), xmbh, "1", user, uploadAttach.getType());
                }
            }
            where = String.format(" and f_code='%s' ", xmbh);
            this.modelManageService.delObject("tb_project_gdbh_cbbcgd_zygd_bcgd", where);
            for (Map map : FLZygdDTO2.getBcgdDetails()) {
                HashMap<String, String> tempDetail = new HashMap<String, String>();
                tempDetail.put("f_id", "");
                tempDetail.put("f_code", xmbh);
                tempDetail.put("f_dikuai_no", (String)map.get("f_dikuai_no"));
                tempDetail.put("f_bcmj", (String)map.get("f_bcmj"));
                this.modelManageService.saveModel(tempDetail, "tb_project_gdbh_cbbcgd_zygd_bcgd", user.getId(), false);
                this.lockZYGD(map);
            }
            long end = System.currentTimeMillis();
            log.error(String.format("\u7ebf\u7a0bid:%s,\u7ebf\u7a0b\u540d\u79f0\uff1a%s,importZYGD\u65b9\u6cd5\u7ed3\u675f\u6267\u884c\u65f6\u95f4:%s\uff0c\u603b\u8017\u65f6:%s", Thread.currentThread().getId(), Thread.currentThread().getName(), DateUtil.now(), end - start));
            BaseResponse baseResponse = BaseResponse.buildSuccessResponse((String)projectId);
            return baseResponse;
        }
        catch (Exception ex) {
            log.error(String.format("\u7ebf\u7a0bid:%s,\u7ebf\u7a0b\u540d\u79f0\uff1a%s,importZYGD\u65b9\u6cd5\u5f02\u5e38", Thread.currentThread().getId(), Thread.currentThread().getName()), (Throwable)ex);
            BaseResponse baseResponse = BaseResponse.buildFailuaResponse((Exception)ex);
            return baseResponse;
        }
        finally {
            this.redisTemplate.delete((Object)code);
            ids.forEach(f -> this.redisTemplate.delete(f));
        }
    }

    private void checkXm(String code) {
        List list = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zygd", null, " and f_code = '" + code + "' ");
        if (list.size() > 0) {
            throw new RuntimeException("\u9879\u76ee\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9879\u76ee\uff01");
        }
    }

    private void checkDk(List<Map<String, Object>> dkList) {
        Map map = dkList.stream().collect(Collectors.toMap(a -> a.get("f_id").toString(), Function.identity()));
        Set<String> ids = map.keySet();
        String join = String.join((CharSequence)"','", ids);
        List list = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zbk", null, " and f_id in ('" + join + "')");
        for (Map m : list) {
            double kyzb;
            Map objectMap = (Map)map.get(m.get("f_id"));
            double bcmj = this.toDouble(objectMap.get("f_bcmj"));
            if (!(bcmj >= (kyzb = this.toDouble(m.get("f_kyzb"))))) continue;
            throw new RuntimeException("\u3010" + m.get("f_dikuai_no") + "\u3011\u5730\u5757\u53ef\u7528\u6307\u6807\u5df2\u88ab\u4ed6\u4eba\u4f7f\u7528\uff0c\u5f53\u524d\u53ef\u7528\u6307\u6807\u5df2\u5c0f\u4e8e\u672c\u6b21\u51bb\u7ed3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u56fe\u6591\uff01");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public synchronized void deleteZYGD(String projectId) {
        FLZygdDTO exsitFLZygdDTO = this.getZYGDDetail(projectId);
        String xmbh = exsitFLZygdDTO.getXmxx().get("f_code").toString();
        exsitFLZygdDTO.getBcgdDetails().forEach(f -> this.unLockZYGD((Map<String, Object>)f));
        String where = String.format(" and relation_id='%s' ", xmbh);
        this.modelManageService.delObject("tb_base_file", where);
        where = String.format(" and f_id='%s' ", projectId);
        this.modelManageService.delObject("tb_project_gdbh_cbbcgd_zygd", where);
        where = String.format(" and f_code='%s' ", xmbh);
        this.modelManageService.delObject("tb_project_gdbh_cbbcgd_zygd_bcgd", where);
    }

    public FNZygdDTO getFNZYGDDetail(String projectId) {
        Map xmxx = this.modelManageService.findObject("tb_project_gdbh_cbbcgd_fnzygd", projectId, "");
        if (xmxx == null) {
            throw new RuntimeException("\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        ArrayList<UploadAttach> uploadAttaches = new ArrayList<UploadAttach>();
        List fileInfos = this.modelManageService.findList("tb_base_file", "", String.format(" and relation_id='%s' ", projectId));
        if (fileInfos != null) {
            for (Map fileInfo : fileInfos) {
                UploadAttach uploadAttach = new UploadAttach();
                uploadAttach.setType(fileInfo.get("media_type").toString());
                uploadAttach.setName(fileInfo.get("file_name").toString());
                uploadAttach.setPath(fileInfo.get("create_path").toString());
                uploadAttach.setFile_id(fileInfo.get("file_id").toString());
                uploadAttaches.add(uploadAttach);
            }
        }
        List bcgdInfos = this.modelManageService.findList("tb_project_gdbh_cbbcgd_fnzygd_bcgddetail", "", String.format(" and f_procjectid='%s' ", projectId));
        ArrayList<Map<String, Object>> bcgdDetails = new ArrayList<Map<String, Object>>();
        if (bcgdInfos != null) {
            for (Map bcgdInfo : bcgdInfos) {
                HashMap tempBcgd = new HashMap();
                tempBcgd.putAll(bcgdInfo);
                List zbks = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zbk", "", String.format(" and f_id='%s' ", bcgdInfo.get("f_zbkid")));
                if (zbks != null & zbks.size() > 0) {
                    tempBcgd.putAll((Map)zbks.get(0));
                }
                bcgdDetails.add(tempBcgd);
            }
        }
        List zygdDetails = this.modelManageService.findList("tb_project_gdbh_cbbcgd_fnzygd_zygddetail", "", String.format(" and f_procjectid='%s' ", projectId));
        FNZygdDTO fnZygdDTO = new FNZygdDTO();
        fnZygdDTO.setBcgdDetails(bcgdDetails);
        fnZygdDTO.setFjDetails(uploadAttaches);
        fnZygdDTO.setXmxx(xmxx);
        fnZygdDTO.setZygdDetails(zygdDetails);
        return fnZygdDTO;
    }

    public FLZygdDTO getZYGDDetail(String projectId) {
        Map xmxx = this.modelManageService.findObject("tb_project_gdbh_cbbcgd_zygd", projectId, "");
        if (xmxx == null) {
            throw new RuntimeException("\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        String xmbh = xmxx.get("f_code").toString();
        ArrayList<UploadAttach> uploadAttaches = new ArrayList<UploadAttach>();
        List fileInfos = this.modelManageService.findList("tb_base_file", "", String.format(" and relation_id='%s' ", xmbh));
        if (fileInfos != null) {
            for (Map fileInfo : fileInfos) {
                UploadAttach uploadAttach = new UploadAttach();
                uploadAttach.setType(fileInfo.get("media_type").toString());
                uploadAttach.setName(fileInfo.get("file_name").toString());
                uploadAttach.setPath(fileInfo.get("create_path").toString());
                uploadAttach.setFile_id(fileInfo.get("file_id").toString());
                uploadAttaches.add(uploadAttach);
            }
        }
        List bcgdInfos = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zygd_bcgd", "", String.format(" and f_code='%s' ", xmbh));
        ArrayList<Map<String, Object>> bcgdDetails = new ArrayList<Map<String, Object>>();
        if (bcgdInfos != null) {
            for (Map bcgdInfo : bcgdInfos) {
                HashMap tempBcgd = new HashMap();
                tempBcgd.put("f_bcmj", bcgdInfo.get("f_bcmj"));
                List zbks = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zbk", "", String.format(" and f_dikuai_no='%s' ", bcgdInfo.get("f_dikuai_no")));
                assert (zbks != null);
                if (zbks != null & zbks.size() > 0) {
                    tempBcgd.putAll((Map)zbks.get(0));
                }
                bcgdDetails.add(tempBcgd);
            }
        }
        FLZygdDTO FLZygdDTO2 = new FLZygdDTO();
        FLZygdDTO2.setBcgdDetails(bcgdDetails);
        FLZygdDTO2.setFjDetails(uploadAttaches);
        FLZygdDTO2.setXmxx(xmxx);
        return FLZygdDTO2;
    }

    public BaseResponse detailZYGD(String projectId) {
        try {
            FLZygdDTO FLZygdDTO2 = this.getZYGDDetail(projectId);
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)FLZygdDTO2);
            return baseObjectResponse;
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse checkFNZYGD(String userId, List<Map<String, Object>> datas) {
        try {
            block14: for (Map<String, Object> data : datas) {
                String projectId = data.get("f_id").toString();
                String checkState = "";
                if (data.get("f_check_state") != null) {
                    checkState = data.get("f_check_state").toString();
                }
                if (data.get("f_checkstate") != null) {
                    checkState = data.get("f_checkstate").toString();
                }
                FNZygdDTO fnZygdDTO = this.getFNZYGDDetail(projectId);
                switch (checkState.toLowerCase()) {
                    case "p0": {
                        break;
                    }
                    case "p3": {
                        HashMap<String, Object> zbk;
                        double f_kyzb_st;
                        double f_kyzb_cn;
                        double f_kyzb;
                        double f_yyzb_st;
                        double f_yyzb_cn;
                        double f_yyzb;
                        double f_bcstmj;
                        double f_bcgdcn;
                        String f_id;
                        for (Map<String, Object> map : fnZygdDTO.getBcgdDetails()) {
                            f_id = map.get("f_id").toString();
                            double f_bcgdmj = Double.parseDouble(map.get("f_bcgdmj").toString());
                            f_bcgdcn = Double.parseDouble(map.get("f_bcgdcn").toString());
                            f_bcstmj = Double.parseDouble(map.get("f_bcstmj").toString());
                            f_yyzb = Double.parseDouble(map.get("f_yyzb").toString());
                            f_yyzb_cn = Double.parseDouble(map.get("f_yyzb_cn").toString());
                            f_yyzb_st = Double.parseDouble(map.get("f_yyzb_st").toString());
                            f_kyzb = Double.parseDouble(map.get("f_kyzb").toString());
                            f_kyzb_cn = Double.parseDouble(map.get("f_kyzb_cn").toString());
                            f_kyzb_st = Double.parseDouble(map.get("f_kyzb_st").toString());
                            f_yyzb += f_bcgdmj;
                            f_kyzb -= f_bcgdmj;
                            f_yyzb_cn += f_bcgdcn;
                            f_kyzb_cn -= f_bcgdcn;
                            f_yyzb_st += f_bcstmj;
                            f_kyzb_st -= f_bcstmj;
                            zbk = new HashMap<String, Object>();
                            zbk.put("f_id", f_id);
                            zbk.put("f_yyzb", f_yyzb);
                            zbk.put("f_kyzb", f_kyzb);
                            zbk.put("f_yyzb_cn", f_yyzb_cn);
                            zbk.put("f_kyzb_cn", f_kyzb_cn);
                            zbk.put("f_yyzb_st", f_yyzb_st);
                            zbk.put("f_kyzb_st", f_kyzb_st);
                            this.modelManageService.updateModel(zbk, "tb_project_gdbh_cbbcgd_zbk");
                        }
                        continue block14;
                    }
                    case "p31": {
                        HashMap<String, Object> zbk;
                        double f_kyzb_st;
                        double f_kyzb_cn;
                        double f_kyzb;
                        double f_yyzb_st;
                        double f_yyzb_cn;
                        double f_yyzb;
                        double f_bcstmj;
                        double f_bcgdcn;
                        String f_id;
                        for (Map<String, Object> map : fnZygdDTO.getBcgdDetails()) {
                            f_id = map.get("f_id").toString();
                            double f_bcgdmj = Double.parseDouble(map.get("f_bcgdmj").toString());
                            f_bcgdcn = Double.parseDouble(map.get("f_bcgdcn").toString());
                            f_bcstmj = Double.parseDouble(map.get("f_bcstmj").toString());
                            f_yyzb = Double.parseDouble(map.get("f_yyzb").toString());
                            f_yyzb_cn = Double.parseDouble(map.get("f_yyzb_cn").toString());
                            f_yyzb_st = Double.parseDouble(map.get("f_yyzb_st").toString());
                            f_kyzb = Double.parseDouble(map.get("f_kyzb").toString());
                            f_kyzb_cn = Double.parseDouble(map.get("f_kyzb_cn").toString());
                            f_kyzb_st = Double.parseDouble(map.get("f_kyzb_st").toString());
                            f_yyzb -= f_bcgdmj;
                            f_kyzb += f_bcgdmj;
                            f_yyzb_cn -= f_bcgdcn;
                            f_kyzb_cn += f_bcgdcn;
                            f_yyzb_st -= f_bcstmj;
                            f_kyzb_st += f_bcstmj;
                            zbk = new HashMap();
                            zbk.put("f_id", f_id);
                            zbk.put("f_id", f_id);
                            zbk.put("f_yyzb", f_yyzb);
                            zbk.put("f_kyzb", f_kyzb);
                            zbk.put("f_yyzb_cn", f_yyzb_cn);
                            zbk.put("f_kyzb_cn", f_kyzb_cn);
                            zbk.put("f_yyzb_st", f_yyzb_st);
                            zbk.put("f_kyzb_st", f_kyzb_st);
                            this.modelManageService.updateModel(zbk, "tb_project_gdbh_cbbcgd_zbk");
                        }
                        continue block14;
                    }
                    case "p51": {
                        Map<String, Object> xmxx = fnZygdDTO.getXmxx();
                        for (Map<String, Object> bcdgDetail : fnZygdDTO.getBcgdDetails()) {
                            Map zbkOut = this.modelManageService.findObject("tb_project_gdbh_cbbcgd_zbk", bcdgDetail.get("f_zbkid").toString(), null);
                            double f_bcgdmj = Double.parseDouble(bcdgDetail.get("f_bcgdmj").toString());
                            double f_bcgdcn = Double.parseDouble(bcdgDetail.get("f_bcgdcn").toString());
                            double f_bcstmj = Double.parseDouble(bcdgDetail.get("f_bcstmj").toString());
                            HashMap<String, Object> zbk = new HashMap<String, Object>();
                            zbk.put("f_id", "");
                            zbk.put("xzqdm", xmxx.get("f_xzqdm"));
                            zbk.put("xzqmc", xmxx.get("f_xzqmc"));
                            zbk.put("f_date", new Date());
                            zbk.put("f_type", "\u6302\u94a9\u6307\u6807");
                            zbk.put("f_zy", "\u5efa\u8bbe\u9879\u76ee\u540d\u79f0\uff1a" + xmxx.get("f_name"));
                            zbk.put("f_gdmj", 0.0 - f_bcgdmj);
                            zbk.put("f_yyzb", 0);
                            zbk.put("f_kyzb", 0);
                            zbk.put("f_stmj", 0.0 - f_bcstmj);
                            zbk.put("f_cnzb", 0.0 - f_bcgdcn);
                            zbk.put("f_state", 0);
                            zbk.put("f_userid", xmxx.get("f_user_id"));
                            zbk.put("f_iscountry", 0);
                            zbk.put("f_isprovince", 0);
                            zbk.put("f_ishistory", 0);
                            zbk.put("f_sid", "");
                            zbk.put("f_dikuai_no", "");
                            zbk.put("f_pl_name", "");
                            zbk.put("f_gddb", "");
                            zbk.put("f_shape", "");
                            zbk.put("f_dlmc", "");
                            zbk.put("f_dlbm", "");
                            zbk.put("f_dikuai_no_out", zbkOut.get("f_dikuai_no"));
                            zbk.put("f_code", xmxx.get("f_code"));
                            zbk.put("f_code_out", zbkOut.get("f_code"));
                            zbk.put("f_yyzb_st", 0);
                            zbk.put("f_yyzb_cn", 0);
                            zbk.put("f_kyzb_st", 0);
                            zbk.put("f_kyzb_cn", 0);
                            zbk.put("f_zbkid_out", zbkOut.get("f_id"));
                            this.modelManageService.saveModel(zbk, "tb_project_gdbh_cbbcgd_zbk", xmxx.get("f_user_id").toString(), false);
                        }
                        continue block14;
                    }
                    default: {
                        return BaseResponse.buildSuccessResponse();
                    }
                }
            }
            return BaseResponse.buildSuccessResponse();
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
    }

    private void unLockZYGD(Map<String, Object> bcgdDetail) {
        try {
            Map zbk = null;
            List zbks = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zbk", "", String.format(" and f_dikuai_no='%s' ", bcgdDetail.get("f_dikuai_no")));
            if (zbks == null || zbks.size() == 0) {
                throw new RuntimeException(String.format("\u4e0d\u5b58\u5728\u5730\u5757id\u4e3a\u3010%s\u3011\u7684\u8865\u5145\u8015\u5730\u6307\u6807", bcgdDetail.get("f_dikuai_no")));
            }
            if (zbks != null & zbks.size() > 0) {
                zbk = (Map)zbks.get(0);
            }
            double f_bcmj = Double.parseDouble(bcgdDetail.get("f_bcmj").toString());
            double f_kyzb = Double.parseDouble(zbk.get("f_kyzb").toString());
            double f_yyzb = Double.parseDouble(zbk.get("f_yyzb").toString());
            f_yyzb -= f_bcmj;
            HashMap tempZbk = new HashMap();
            tempZbk.put("f_id", zbk.get("f_id"));
            tempZbk.put("f_kyzb", f_kyzb += f_bcmj);
            tempZbk.put("f_yyzb", f_yyzb);
            this.modelManageService.updateModel(tempZbk, "tb_project_gdbh_cbbcgd_zbk");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void lockZYGD(Map<String, Object> bcgdDetail) {
        try {
            Map zbk = null;
            List zbks = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zbk", "", String.format(" and f_dikuai_no='%s' ", bcgdDetail.get("f_dikuai_no")));
            if (zbks == null || zbks.size() == 0) {
                throw new RuntimeException(String.format("\u4e0d\u5b58\u5728\u5730\u5757id\u4e3a\u3010%s\u3011\u7684\u8865\u5145\u8015\u5730\u6307\u6807", bcgdDetail.get("f_dikuai_no")));
            }
            if (zbks != null & zbks.size() > 0) {
                zbk = (Map)zbks.get(0);
            }
            double f_bcmj = Double.parseDouble(bcgdDetail.get("f_bcmj").toString());
            double f_kyzb = Double.parseDouble(zbk.get("f_kyzb").toString());
            if (f_kyzb + 1.0E-4 < f_bcmj) {
                throw new RuntimeException(String.format("\u5730\u5757id\u4e3a\u3010%s\u3011\u7684\u8865\u5145\u8015\u5730\u6307\u6807,\u53ef\u7528\u6307\u6807\u53ea\u6709%s\uff0c\u5c0f\u4e8e\u7533\u8bf7\u6307\u6807%s", bcgdDetail.get("f_dikuai_no"), f_kyzb, f_bcmj));
            }
            double f_yyzb = Double.parseDouble(zbk.get("f_yyzb").toString());
            f_yyzb += f_bcmj;
            HashMap tempZbk = new HashMap();
            tempZbk.put("f_id", zbk.get("f_id"));
            tempZbk.put("f_kyzb", f_kyzb -= f_bcmj);
            tempZbk.put("f_yyzb", f_yyzb);
            this.modelManageService.updateModel(tempZbk, "tb_project_gdbh_cbbcgd_zbk");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public String bacthCheckZYGD(String userId, String userName, MultipartFile excelFile) {
        try {
            List list = EasyExcel.read((InputStream)excelFile.getInputStream()).headRowNumber(Integer.valueOf(1)).sheet().doReadSync();
            ArrayList codes = new ArrayList();
            for (Map map : list) {
                if (codes.contains(map.get(1))) continue;
                codes.add(map.get(1));
            }
            String dateStr = DateUtil.now();
            ArrayList<String> notExsitsCode = new ArrayList<String>();
            long now = System.currentTimeMillis();
            int index = 20000;
            for (String code : codes) {
                List existProjects = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zygd", null, "and f_code like '%" + code + "%'");
                System.out.println(++index);
                if (existProjects == null || existProjects.size() == 0) {
                    notExsitsCode.add(code);
                    continue;
                }
                Map project = (Map)existProjects.get(0);
                if (project.get("f_check_state").equals("p51")) continue;
                project.put("f_check_state", "p51");
                project.put("f_check_remark", "\u5ba1\u6838\u901a\u8fc7");
                project.put("f_check_user_name", userName);
                project.put("f_check_time", dateStr);
                this.modelManageService.updateModel(project, "tb_project_gdbh_cbbcgd_zygd");
                FLZygdDTO zygdDTO = this.getZYGDDetail(project.get("f_id").toString());
                Map<String, Object> xmxx = zygdDTO.getXmxx();
                ++index;
                for (Map<String, Object> bcdgDetail : zygdDTO.getBcgdDetails()) {
                    HashMap<String, Object> zbk = new HashMap<String, Object>();
                    zbk.put("f_id", "");
                    zbk.put("f_code", xmxx.get("f_code"));
                    zbk.put("xzqdm", xmxx.get("f_xzqdm"));
                    zbk.put("xzqmc", xmxx.get("f_xzqmc"));
                    zbk.put("f_date", dateStr);
                    zbk.put("f_type", "\u6062\u590d\u8015\u5730\u51fa\u5e93");
                    zbk.put("f_zy", "");
                    zbk.put("f_gdmj", 0.0 - Double.parseDouble(bcdgDetail.get("f_bcmj").toString()));
                    zbk.put("f_yyzb", 0);
                    zbk.put("f_kyzb", 0);
                    zbk.put("f_stmj", 0);
                    zbk.put("f_cnzb", 0);
                    zbk.put("f_userid", xmxx.get("f_user_id"));
                    zbk.put("f_iscountry", 0);
                    zbk.put("f_isprovince", 0);
                    zbk.put("f_gddb", null);
                    zbk.put("f_dikuai_no_out", bcdgDetail.get("f_dikuai_no"));
                    this.modelManageService.saveModel(zbk, "tb_project_gdbh_cbbcgd_zbk", xmxx.get("f_user_id").toString(), false);
                }
                HashMap<String, Object> checkObject = new HashMap<String, Object>();
                checkObject.put("f_id", new Long(index).toString());
                checkObject.put("f_checkdate", now);
                checkObject.put("f_checkcomment", "\u5ba1\u6838\u901a\u8fc7");
                checkObject.put("f_checkstate", "p51");
                checkObject.put("f_checkuserlevel", "1");
                checkObject.put("f_checkuserid", userId);
                checkObject.put("f_checkusername", userName);
                checkObject.put("f_projectid", project.get("f_id").toString());
                this.modelManageService.saveModel(checkObject, "tb_project_gdbh_cbbcgd_zygd_check", userId, false);
            }
            return String.join((CharSequence)";", notExsitsCode);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse checkZYGD(SysUser user, List<Map<String, Object>> datas) {
        try {
            block16: for (Map<String, Object> data : datas) {
                String projectId = data.get("f_id").toString();
                String checkState = "";
                if (data.get("f_check_state") != null) {
                    checkState = data.get("f_check_state").toString();
                }
                if (data.get("f_checkstate") != null) {
                    checkState = data.get("f_checkstate").toString();
                }
                FLZygdDTO zygdDTO = this.getZYGDDetail(projectId);
                Map<String, Object> xmxx = zygdDTO.getXmxx();
                switch (checkState.toLowerCase()) {
                    case "p0": {
                        continue block16;
                    }
                    case "p2": 
                    case "p3": {
                        continue block16;
                    }
                    case "p21": 
                    case "p31": {
                        continue block16;
                    }
                    case "p51": {
                        for (Map<String, Object> bcdgDetail : zygdDTO.getBcgdDetails()) {
                            HashMap<String, Object> zbk = new HashMap<String, Object>();
                            zbk.put("f_id", "");
                            zbk.put("f_code", xmxx.get("f_code"));
                            zbk.put("xzqdm", xmxx.get("f_xzqdm"));
                            zbk.put("xzqmc", xmxx.get("f_xzqmc"));
                            zbk.put("f_date", new Date());
                            zbk.put("f_type", "\u6062\u590d\u8015\u5730\u51fa\u5e93");
                            zbk.put("f_zy", "");
                            zbk.put("f_gdmj", 0.0 - Double.parseDouble(bcdgDetail.get("f_bcmj").toString()));
                            zbk.put("f_yyzb", 0);
                            zbk.put("f_kyzb", 0);
                            zbk.put("f_stmj", 0);
                            zbk.put("f_cnzb", 0);
                            zbk.put("f_userid", xmxx.get("f_user_id"));
                            zbk.put("f_iscountry", 0);
                            zbk.put("f_isprovince", 0);
                            zbk.put("f_gddb", null);
                            zbk.put("f_dikuai_no_out", bcdgDetail.get("f_dikuai_no"));
                            this.modelManageService.saveModel(zbk, "tb_project_gdbh_cbbcgd_zbk", xmxx.get("f_user_id").toString(), false);
                        }
                        this.inputZbkZygd(user, projectId);
                        this.saveNumber(zygdDTO);
                        continue block16;
                    }
                }
                return BaseResponse.buildSuccessResponse();
            }
            return BaseResponse.buildSuccessResponse();
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
    }

    private String saveNumber(FLZygdDTO zygdDTO) throws Exception {
        String checkCode = "";
        Map<String, Object> xmxx = zygdDTO.getXmxx();
        String xzqdm = (String)xmxx.get("xzqdm");
        checkCode = xzqdm.substring(0, 2) + "0000";
        LocalDateTime date = LocalDateTime.now();
        checkCode = checkCode + date.getYear() + "" + (date.getMonthValue() < 10 ? "0" + date.getMonthValue() : Integer.valueOf(date.getMonthValue()));
        String key = checkCode.substring(0, 10);
        this.lockUtil.getLock(key);
        JdbcTemplate jdbc = this.modelManageService.getJdbcTemplate();
        Integer counts = (Integer)jdbc.queryForObject("select count(*) from tb_project_gdbh_cbbcgd_zygd where f_check_code like '" + key + "%'", Integer.class);
        String code = "00000" + (counts + 1);
        checkCode = checkCode + code.substring(code.length() - 6, code.length());
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("f_check_code", checkCode);
        m.put("f_id", xmxx.get("f_id"));
        this.modelManageService.updateModel(m, "tb_project_gdbh_cbbcgd_zygd");
        return checkCode;
    }

    @Transactional(rollbackFor={Exception.class})
    public void downloadCheckCode(String projectId, HttpServletResponse response) throws Exception {
        HashMap<String, String> pdfForm = new HashMap<String, String>();
        FLZygdDTO detail = this.getZYGDDetail(projectId);
        pdfForm.put("xmmc", detail.getXmxx().get("f_name").toString());
        String txm = ObjectUtil.isEmpty((Object)detail.getXmxx().get("f_check_code")) ? this.saveNumber(detail) : String.valueOf(detail.getXmxx().get("f_check_code"));
        pdfForm.put("txm", txm);
        pdfForm.put("hfgd", String.valueOf(detail.getXmxx().get("f_xdjzbmj")));
        BigDecimal dkmj = new BigDecimal(0.0);
        List list = this.modelManageService.findList("tb_project_gdbh_cbbcgd_zygd_zyfw", null, " and f_code ='" + detail.getXmxx().get("f_code") + "' ");
        for (Map map : list) {
            BigDecimal mj = this.toBigDecima(map.get("f_dikuaimj"));
            dkmj = dkmj.add(mj);
        }
        pdfForm.put("ydmj", dkmj.setScale(4, 4).toString());
        dkmj = new BigDecimal(0.0);
        for (Map map : detail.getBcgdDetails()) {
            BigDecimal bcmj = this.toBigDecima(map.get("f_bcmj"));
            dkmj = dkmj.add(bcmj);
        }
        pdfForm.put("yhfgd", dkmj.setScale(4, 4).toString());
        Map check = this.modelManageService.findOne("tb_project_gdbh_cbbcgd_zygd_check", " and f_projectid = '" + projectId + "' and f_checkstate = 'p51' limit 1");
        Long l = (Long)check.get("f_checkdate");
        LocalDate date = Instant.ofEpochMilli(l).atZone(ZoneOffset.ofHours(8)).toLocalDate();
        pdfForm.put("yyyy", String.valueOf(date.getYear()));
        pdfForm.put("mm", String.valueOf(date.getMonthValue()));
        pdfForm.put("dd", String.valueOf(date.getDayOfMonth()));
        pdfForm.put("hfst", "--");
        pdfForm.put("hfsjd", "--");
        pdfForm.put("pjgdzl", "--");
        pdfForm.put("yhfst", "--");
        pdfForm.put("yhfsjd", "--");
        pdfForm.put("ypjgdzl", "--");
        String pdfPath = PdfManageUtil.fillPdf(pdfForm, (String)pdfForm.get("xmmc"), null, "\u5360\u8015\u586b\u62a5");
        FileManageUtil.downloadFile(pdfPath, response);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse importFHK(Map<String, Object> data, List<UploadAttach> attach, SysUser user) {
        try {
            String type = data.get("f_type").toString();
            String sid = this.baseSidService.generateLsh(user.getXzqdm(), EnumLshType.fromValue(type));
            data.put("f_code", sid);
            Optional<UploadAttach> attachXZGDOpt = attach.stream().filter(f -> f.getType().equals("XZGD")).findAny();
            Optional<UploadAttach> attachXMFWOpt = attach.stream().filter(f -> f.getType().equals("XMFW")).findAny();
            Optional<UploadAttach> attachImgOpt = attach.stream().filter(f -> f.getType().equals("GDYX")).findAny();
            Optional<UploadAttach> attachYSPFWJOpt = attach.stream().filter(f -> f.getType().equals("YSPFWJ")).findAny();
            Optional<UploadAttach> attachZLDBPDOpt = attach.stream().filter(f -> f.getType().equals("ZLDBPD")).findAny();
            Optional<UploadAttach> attachXZGDHDOpt = attach.stream().filter(f -> f.getType().equals("XZGDHD")).findAny();
            String xmbh = data.get("f_code").toString();
            List existProject = this.modelManageService.findList("tb_project_gdbh_cbbcgd_fhk", null, "and f_code='" + xmbh + "'");
            String projectId = "";
            if (existProject.size() > 0) {
                projectId = ((Map)existProject.get(0)).get("f_id").toString();
                data.put("f_id", projectId);
                this.modelManageService.updateModel(data, "tb_project_gdbh_cbbcgd_fhk");
            } else {
                projectId = this.modelManageService.saveModel(data, "tb_project_gdbh_cbbcgd_fhk", user.getId(), false).toString();
            }
            this.saveFHKXMFW(data, user, projectId, attachXMFWOpt.get());
            this.saveFHKXZGD(data, user, projectId, attachXZGDOpt.get());
            if (attachImgOpt.isPresent()) {
                this.saveFj(user, projectId, "GDYX", attachImgOpt.get());
            }
            if (attachYSPFWJOpt.isPresent()) {
                this.saveFj(user, projectId, "YSPFWJ", attachYSPFWJOpt.get());
            }
            if (attachZLDBPDOpt.isPresent()) {
                this.saveFj(user, projectId, "ZLDBPD", attachZLDBPDOpt.get());
            }
            if (attachXZGDHDOpt.isPresent()) {
                this.saveFj(user, projectId, "XZGDHD", attachXZGDHDOpt.get());
            }
            return BaseResponse.buildSuccessResponse((String)projectId);
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse importLSK(File[] shps, String userId, String datatype) {
        try {
            for (File one : shps) {
                if (!one.getName().endsWith(".shp")) continue;
                List<Map<String, Object>> list = ShpUtils.getShpGCSProperties(one.getAbsolutePath());
                if ("XMFW".equals(datatype)) {
                    for (Map<String, Object> map : list) {
                        String xmbh = map.get("YS_XMBH").toString();
                        List projects = this.modelManageService.findList("tb_project_gdbh_cbbcgd_lsk", null, " and f_ys_xmbh='" + xmbh + "'");
                        if (projects.size() > 0) {
                            for (Map project : projects) {
                                this.modelManageService.delObject("tb_project_gdbh_cbbcgd_lsk_xmfw", " and f_project_id='" + project.get("f_id").toString() + "'");
                                this.modelManageService.delObjectById("tb_project_gdbh_cbbcgd_lsk", project.get("f_id").toString());
                            }
                        }
                        String xzqmc = this.getXzqmc(map.get("JBXX_XZQMC").toString());
                        HashMap<String, Object> tb = new HashMap<String, Object>();
                        tb.put("f_xmmc", map.get("JBXX_XMMC"));
                        tb.put("f_jbxx_xzqmc", map.get("JBXX_XZQMC"));
                        tb.put("f_jbxx_xzqdm", map.get("JBXX_XZQDM"));
                        tb.put("xzqmc", xzqmc);
                        tb.put("xzqdm", map.get("JBXX_XZQDM"));
                        tb.put("f_type", map.get("JBXX_XMLX"));
                        tb.put("f_jbxx_xmlx", map.get("JBXX_XMLX"));
                        tb.put("f_sfgbz", map.get("SFGBZ"));
                        tb.put("f_ys_xmbh", map.get("YS_XMBH"));
                        tb.put("f_ys_ysdw", map.get("YS_YSDW"));
                        tb.put("f_ys_ysrq", map.get("YS_YSRQ"));
                        tb.put("f_ys_yswh", map.get("YS_YSWH"));
                        tb.put("f_ys_gm_zgm", map.get("YS_GM_ZGM"));
                        tb.put("f_ys_tz_ztz", map.get("YS_TZ_ZTZ"));
                        tb.put("f_ys_cx_jsqg", map.get("YS_CX_JSQG"));
                        tb.put("f_ys_cx_jshg", map.get("YS_CX_JSHG"));
                        tb.put("f_ys_gm_xzgd", map.get("YS_GM_XZGD"));
                        tb.put("f_xmfl", map.get("XMFL"));
                        tb.put("f_tzf", map.get("TZF"));
                        tb.put("f_wtlx", map.get("WTLX"));
                        tb.put("f_cnzb", map.get("CNZB"));
                        tb.put("f_gdmj", map.get("GDMJ"));
                        tb.put("f_stmj", map.get("STMJ"));
                        tb.put("f_fhjg", map.get("FHJG"));
                        tb.put("f_hjmj", map.get("HJMJ"));
                        tb.put("f_objectid", map.get("OBJECTID"));
                        String projectId = this.modelManageService.saveModel(tb, "tb_project_gdbh_cbbcgd_lsk", userId, true).toString();
                        HashMap<String, Object> shape = new HashMap<String, Object>();
                        shape.put("f_project_id", projectId);
                        shape.put("f_shape", map.get("the_geom"));
                        this.modelManageService.saveModel(shape, "tb_project_gdbh_cbbcgd_lsk_xmfw", userId, true);
                        if (map.get("WTLX").toString().equals("\u5220\u9664\u9879\u76ee") || map.get("XMFL").toString().equals("\u91cd\u5927\u5de5\u7a0b") || map.get("XMFL").toString().equals("\u57fa\u672c\u519c\u7530\u6574\u7406\u9879\u76ee")) continue;
                        String summary = this.getProjectSummary("LSK", map);
                        this.modelManageService.delObject("tb_project_gdbh_cbbcgd_zbk", " and f_zy='" + summary + "'");
                        HashMap<String, Object> zb = new HashMap<String, Object>();
                        zb.put("xzqdm", map.get("JBXX_XZQDM"));
                        zb.put("xzqmc", xzqmc);
                        zb.put("f_date", map.get("YS_YSRQ"));
                        zb.put("f_type", "\u5386\u53f2\u9879\u76ee\u5165\u5e93");
                        zb.put("f_zy", summary);
                        zb.put("f_gdmj", map.get("GDMJ"));
                        zb.put("f_stmj", map.get("STMJ"));
                        zb.put("f_cnzb", map.get("CNZB"));
                        zb.put("f_state", "1");
                        zb.put("f_iscountry", 0);
                        zb.put("f_isprovince", 1);
                        this.modelManageService.saveModel(zb, "tb_project_gdbh_cbbcgd_zbk", userId, true);
                    }
                } else {
                    if (!"XZGD".equals(datatype)) break;
                    ArrayList<String> xmbhs = new ArrayList<String>();
                    for (Map<String, Object> xzgd : list) {
                        if (xmbhs.contains(xzgd.get("YS_XMBH").toString())) continue;
                        xmbhs.add(xzgd.get("YS_XMBH").toString());
                    }
                    WKTReader wktReader = new WKTReader();
                    for (String xmbh : xmbhs) {
                        List oneXM = list.stream().filter(f -> f.get("YS_XMBH").toString().equals(xmbh)).collect(Collectors.toList());
                        int cordCount = 0;
                        Map project = null;
                        for (Map map : oneXM) {
                            List projects = this.modelManageService.findList("tb_project_gdbh_cbbcgd_lsk", null, " and f_ys_xmbh='" + xmbh + "'");
                            if (projects.size() == 0) continue;
                            project = (Map)projects.get(0);
                            String dikuaino = map.get("DIKUAI_NO").toString();
                            String where = " and f_ys_xmbh='" + xmbh + "' and f_dikuai_no='" + dikuaino + "'";
                            this.modelManageService.delObject("tb_project_gdbh_cbbcgd_lsk_xzgdfw", where);
                            HashMap gd = new HashMap();
                            gd.put("f_project_id", project.get("f_id"));
                            gd.put("xzqmc", project.get("xzqmc"));
                            gd.put("xzqdm", project.get("xzqdm"));
                            gd.put("f_ys_xmbh", map.get("YS_XMBH"));
                            gd.put("f_jbxx_xmmc", map.get("JBXX_XMMC"));
                            gd.put("f_shape", map.get("the_geom"));
                            gd.put("f_dikuai_no", map.get("DIKUAI_NO"));
                            gd.put("f_pl_name", map.get("PL_NAME"));
                            gd.put("f_dikuai_area", map.get("DIKUAIAREA"));
                            gd.put("f_purpose", map.get("PURPOSE"));
                            gd.put("f_map_no", map.get("MAP_NO"));
                            gd.put("f_patchtype", map.get("PATCHTYPE"));
                            gd.put("f_landtype", map.get("LANDTYPE"));
                            gd.put("f_avggrade1", map.get("AVGGRADE1"));
                            gd.put("f_avggrade2", map.get("AVGGRADE2"));
                            gd.put("f_shp_name", one.getName());
                            this.modelManageService.saveModel(gd, "tb_project_gdbh_cbbcgd_lsk_xzgdfw", userId, true);
                            Geometry geometry = wktReader.read(map.get("the_geom").toString());
                            int np = geometry.getNumPoints();
                            cordCount += np;
                        }
                        Map<String, Object> crs = ShpUtils.getShpCRSInfo(one.getAbsolutePath());
                        String csrJson = JSONObject.toJSONString(crs);
                        HashMap upProject = new HashMap();
                        upProject.put("f_id", project.get("f_id"));
                        upProject.put("f_xzgd_shp_meta", csrJson);
                        upProject.put("f_xzgd_cord_count", cordCount);
                        this.modelManageService.updateModel(upProject, "tb_project_gdbh_cbbcgd_lsk");
                    }
                }
                break;
            }
            return BaseObjectResponse.buildSuccessResponse();
        }
        catch (Exception ex) {
            return BaseObjectResponse.buildFailuaResponse((Exception)ex);
        }
    }

    private void addBaseFile(String projectId, String mediaType, String path, String relationType, SysUser user) {
        String where = String.format(" and relation_id='%s' and media_type='%s'", projectId, mediaType);
        this.modelManageService.delObject("tb_base_file", where);
        this.baseFileService.uploadFile2(new File(path), projectId, relationType, user, mediaType);
    }

    private void addBatchBaseFiles(String projectId, String mediaType, String path, String relationType, SysUser user) {
        String where = String.format(" and relation_id='%s' and media_type='%s'", projectId, mediaType);
        this.modelManageService.delObject("tb_base_file", where);
        this.baseFileService.uploadFile2(new File(path), projectId, relationType, user, mediaType);
    }

    @Transactional(rollbackFor={Exception.class})
    public String importShpFile(File[] files, String fileUri, String userId, String type, Boolean check) throws Exception {
        if (files == null) {
            throw new Exception("\u5bfc\u5165\u6587\u4ef6\u5939\u5c42\u7ea7\u89e3\u6790\u9519\u8bef");
        }
        Object projectId = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if ("JHK".equalsIgnoreCase(type)) {
            for (File file : files) {
                if (!file.getName().endsWith("JHK")) continue;
                projectId = this.parseShpJHK(file.listFiles(), userId);
            }
        } else if ("FHK".equalsIgnoreCase(type)) {
            for (File file : files) {
                if (file.getName().endsWith("FHK_XMFW")) {
                    Map<String, String> map1 = this.parseShpFHK(file.listFiles(), userId, 1, projectId, check);
                    if (map1.containsKey("projectId")) {
                        projectId = map1.get("projectId");
                    }
                    map.putAll(map1);
                    continue;
                }
                if (!file.getName().endsWith("FHK_XZGDFW")) continue;
                Map<String, String> map2 = this.parseShpFHK(file.listFiles(), userId, 2, projectId, check);
                if (map2.containsKey("projectId")) {
                    projectId = map2.get("projectId");
                }
                map.putAll(map2);
            }
        }
        if (projectId == null) {
            throw new Exception("shp\u6587\u4ef6\u89e3\u6790\u9519\u8bef");
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            String fileName = file.getName();
            if (fileName.endsWith(".db")) {
                this.parseDB(file.getAbsolutePath(), fileUri, projectId.toString(), userId, type, map);
                continue;
            }
            this.saveBaseFile(file.getAbsolutePath(), fileUri, projectId.toString(), userId);
        }
        return projectId.toString();
    }

    public void saveBaseFile(String fileName, String fileUri, String projectId, String userId) {
        BaseFile baseFile = new BaseFile();
        baseFile.setRelationId(projectId);
        baseFile.setUploadEmplId(userId);
        baseFile.setUploadTime(new Date());
        baseFile.setCreatePath(fileName.substring(fileName.indexOf(fileUri)));
        baseFile.setFileName(fileName.substring(fileName.lastIndexOf("\\") + 1));
        baseFile.setFileFormat(fileName.substring(fileName.lastIndexOf(".") + 1));
        baseFile.setFileType(Integer.valueOf(1));
        baseFile.setRelationType("SHFJ");
        baseFile.setMediaType("WJ");
        this.baseFileService.saveBaseFile(baseFile);
    }

    public void parseDB(String fileName, String fileUri, String projectId, String userId, String type, Map<String, String> map) throws Exception {
        if (fileName.indexOf("db") != -1) {
            Connection conn = null;
            Statement statement = null;
            ResultSet rs = null;
            try {
                SqlliteConnTool tool = new SqlliteConnTool(fileName);
                conn = tool.getConnection();
                statement = conn.createStatement();
                String sql = "select * from media_Info";
                rs = statement.executeQuery(sql);
                ArrayList<BaseFile> listPrj = new ArrayList<BaseFile>();
                while (rs.next()) {
                    BaseFile baseFile = new BaseFile();
                    if (map == null || map.size() == 0) {
                        baseFile.setRelationId(projectId);
                    } else {
                        try {
                            String dkbh = rs.getString("DIKUAI_NO");
                            if (!map.containsKey(dkbh) || dkbh == null) continue;
                            baseFile.setRelationId(map.get(dkbh));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            baseFile.setRelationId(projectId);
                        }
                    }
                    baseFile.setUploadEmplId(userId);
                    baseFile.setUploadTime(new Date());
                    String path = rs.getString("mediaPath");
                    baseFile.setCreatePath(fileUri + path);
                    String name = path.substring(path.lastIndexOf("\\") + 1);
                    baseFile.setFileName(name);
                    baseFile.setFileFormat(rs.getString("mediaFormat"));
                    String mediaType = rs.getString("mediaType");
                    baseFile.setMediaType(mediaType);
                    if ("SP".equalsIgnoreCase(mediaType)) {
                        baseFile.setFileType(Integer.valueOf(3));
                    } else if ("ZP".equalsIgnoreCase(mediaType)) {
                        baseFile.setFileType(Integer.valueOf(1));
                    }
                    baseFile.setMetaData(rs.getString("mediaMeta"));
                    if ("JHK".equalsIgnoreCase(type)) {
                        baseFile.setRelationType("JHK1");
                    } else if ("FHK".equalsIgnoreCase(type)) {
                        baseFile.setRelationType("FHK1");
                    } else if ("LSK".equalsIgnoreCase(type)) {
                        baseFile.setRelationType("LSK1");
                    } else if ("RCJG".equalsIgnoreCase(type)) {
                        baseFile.setRelationType("RCJG");
                    } else {
                        baseFile.setRelationType(type);
                    }
                    listPrj.add(baseFile);
                }
                this.baseFileService.saveBaseFile(listPrj);
                tool.closeAll(conn, statement, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e.getMessage());
            }
        }
    }

    private Object parseShpJHK(File[] shps, String userId) throws Exception {
        Object projectId = "";
        for (File one : shps) {
            if (!one.getName().endsWith(".shp")) continue;
            List<Map<String, Object>> list = ShpUtils.getShpProperties(one.getAbsolutePath(), null);
            ArrayList tbList = new ArrayList();
            HashMap<String, Object> project = new HashMap<String, Object>();
            for (Map<String, Object> map : list) {
                if (!project.containsKey("f_name")) {
                    project.put("f_name", map.get("JBXX_XMMC"));
                }
                if (!project.containsKey("f_type")) {
                    project.put("f_type", map.get("XMLX"));
                }
                if (!project.containsKey("f_code")) {
                    project.put("f_code", map.get("YS_XMBH"));
                }
                if (!project.containsKey("f_xzqhdm")) {
                    project.put("f_xzqhdm", map.get("xzqhdm"));
                }
                if (!project.containsKey("f_xzqmc")) {
                    project.put("f_xzqmc", map.get("JBXX_XZQMC"));
                }
                HashMap<String, Object> tb = new HashMap<String, Object>();
                tb.put("f_shape", map.get("the_geom"));
                tbList.add(tb);
            }
            projectId = this.modelManageService.saveModel(project, "tb_project_gdbh_cbbcgd_jhk", userId, true);
            for (Map<String, Object> map : tbList) {
                map.put("f_project_id", projectId);
                this.modelManageService.saveModel(map, "tb_project_gdbh_cbbcgd_jhk_xmfw", userId, true);
            }
        }
        return projectId;
    }

    private Map<String, String> parseShpFHK(File[] shps, String userId, Integer tag, Object projectId, Boolean check) throws Exception {
        if (check == null) {
            check = true;
        }
        String tableName = "tb_project_gdbh_cbbcgd_fhk";
        List fields = this.modelFieldsService.findFieldNameByTableName(tableName);
        HashMap<String, String> result = new HashMap<String, String>();
        for (File one : shps) {
            if (!one.getName().endsWith(".shp")) continue;
            List<Map<String, Object>> list = ShpUtils.getShpProperties(one.getAbsolutePath(), null);
            ArrayList tbList = new ArrayList();
            HashMap<String, Object> project = new HashMap<String, Object>();
            for (Map<String, Object> map : list) {
                if (projectId == null) {
                    for (String key : map.keySet()) {
                        String f = ("f_" + key).toLowerCase();
                        if (key.equalsIgnoreCase("JBXX_XMMC")) {
                            project.put("f_name", map.get(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("JBXX_XZQMC")) {
                            project.put("f_xzqmc", map.get(key));
                            continue;
                        }
                        if (key.equalsIgnoreCase("YS_XMBH")) {
                            project.put("f_code", map.get(key));
                            continue;
                        }
                        if (!fields.contains(f) || project.containsKey(f) || map.get(key) == null) continue;
                        project.put(f, map.get(key));
                    }
                }
                HashMap<String, Object> tb = new HashMap<String, Object>();
                tb.put("f_shape", map.get("the_geom"));
                if (map.containsKey("DIKUAI_NO")) {
                    tb.put("f_dkbh", map.get("DIKUAI_NO"));
                }
                if (map.containsKey("PL_NAME")) {
                    tb.put("f_dkmc", map.get("PL_NAME"));
                }
                if (map.containsKey("PATCHTYPE")) {
                    tb.put("f_patch_type", map.get("PATCHTYPE"));
                }
                if (map.containsKey("LANDTYPE")) {
                    tb.put("f_land_type", map.get("LANDTYPE"));
                }
                if (map.containsKey("AVGGRADE1")) {
                    tb.put("f_avggrade", map.get("AVGGRADE1"));
                }
                if (map.containsKey("AVGGRADE2")) {
                    tb.put("f_avggrade2", map.get("AVGGRADE2"));
                }
                tbList.add(tb);
            }
            if (projectId == null) {
                projectId = this.modelManageService.saveModel(project, tableName, userId, check.booleanValue());
            }
            for (Map<String, Object> map : tbList) {
                map.put("f_project_id", projectId);
                map.put("f_tag", tag);
                Object dbId = this.modelManageService.saveModel(map, "tb_project_gdbh_cbbcgd_fhk_xmfw", userId, true);
                if (!map.containsKey("f_dkbh")) continue;
                result.put(map.get("f_dkbh").toString(), dbId.toString());
            }
        }
        if (projectId != null) {
            result.put("projectId", projectId.toString());
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public String saveFHK2ZBK(String projectId, String userId) {
        try {
            Map dbMap = this.modelManageService.findObject("tb_project_gdbh_cbbcgd_fhk", projectId, null);
            Double gdmj = dbMap.get("f_rk_xzslzb") == null ? 0.0 : Double.parseDouble(dbMap.get("f_rk_xzslzb").toString());
            Double stmj = dbMap.get("f_rk_xzstzb") == null ? 0.0 : Double.parseDouble(dbMap.get("f_rk_xzstzb").toString());
            Double rkcl = dbMap.get("f_rk_xzclzb") == null ? 0.0 : Double.parseDouble(dbMap.get("f_rk_xzclzb").toString());
            Double gddb = dbMap.get("f_rk_bcgdpjzldb") == null ? 0.0 : Double.parseDouble(dbMap.get("f_rk_bcgdpjzldb").toString());
            HashMap<String, Object> zbk = new HashMap<String, Object>();
            Date date = new Date();
            zbk.put("f_type", "\u9879\u76ee\u5165\u5e93");
            String xzqdm = dbMap.get("f_xzqhdm") == null ? dbMap.get("xzqdm").toString() : dbMap.get("f_xzqhdm").toString();
            zbk.put("xzqdm", xzqdm);
            zbk.put("xzqmc", dbMap.get("f_xzqmc"));
            zbk.put("f_zy", String.format("\u6307\u6807\u6765\u6e90\uff1a%s\uff0c\u9879\u76ee\u7f16\u53f7\uff1a%s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%s", zbk.get("f_type"), dbMap.get("f_code"), dbMap.get("f_name")));
            zbk.put("f_state", "0");
            zbk.put("f_iscountry", 0);
            zbk.put("f_isprovince", 0);
            zbk.put("f_ishistory", 0);
            zbk.put("f_userid", userId);
            zbk.put("f_gdmj", gdmj);
            zbk.put("f_stmj", stmj);
            zbk.put("f_cnzb", rkcl);
            zbk.put("f_yyzb", 0);
            zbk.put("f_kyzb", gdmj);
            zbk.put("f_dikuai_no", "");
            zbk.put("f_pl_name", "");
            zbk.put("f_date", new Date());
            zbk.put("f_sid", "");
            zbk.put("f_gddb", gddb);
            zbk.put("f_dlmc", "");
            zbk.put("f_dlbm", "");
            zbk.put("f_dikuai_no_out", "");
            zbk.put("f_code", dbMap.get("f_code"));
            zbk.put("f_code_out", "");
            zbk.put("f_name", dbMap.get("f_name"));
            zbk.put("f_yyzb_st", 0);
            zbk.put("f_yyzb_cn", 0);
            zbk.put("f_kyzb_st", stmj);
            zbk.put("f_kyzb_cn", rkcl);
            zbk.put("f_zbkid_out", "");
            return this.modelManageService.saveModel(zbk, "tb_project_gdbh_cbbcgd_zbk", userId, true).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void saveFHK2ZBK(String projectId, String userId, String optionType, String type, Long oid) throws Exception {
        Map dbMap = this.modelManageService.findObject("tb_project_gdbh_cbbcgd_fhk", projectId, null);
        Double bcgdmj = dbMap.get("f_bcgdmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_bcgdmj").toString());
        Double jzgdmj = dbMap.get("f_jzgdmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_jzgdmj").toString());
        Double jzstmj = dbMap.get("f_jzstmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_jzstmj").toString());
        Double tzgzgdmj = dbMap.get("f_tzgzgdmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_tzgzgdmj").toString());
        Double tzgzstmj = dbMap.get("f_tzgzstmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_tzgzstmj").toString());
        Integer bcgdpjzldb = dbMap.get("f_bcgdpjzldb") == null ? 0 : Integer.parseInt(dbMap.get("f_bcgdpjzldb").toString());
        Integer tzgzqzldb = dbMap.get("f_tzgzqzldb") == null ? 0 : Integer.parseInt(dbMap.get("f_tzgzqzldb").toString());
        Integer tzgzhzldb = dbMap.get("f_tzgzhzldb") == null ? 0 : Integer.parseInt(dbMap.get("f_tzgzhzldb").toString());
        HashMap<String, Object> zbk = new HashMap<String, Object>();
        if ("-".equals(optionType)) {
            zbk.put("f_gdmj", -1.0 * jzgdmj);
            zbk.put("f_stmj", -1.0 * (jzstmj + tzgzstmj));
            zbk.put("f_cnzb", -1.0 * (jzgdmj * (double)(16 - bcgdpjzldb) * 1500.0 + (tzgzgdmj + tzgzstmj) * (double)(tzgzqzldb - tzgzhzldb) * 1500.0));
            zbk.put("f_ishistory", 0);
        } else {
            zbk.put("f_gdmj", jzgdmj);
            zbk.put("f_stmj", jzstmj + tzgzstmj);
            zbk.put("f_cnzb", jzgdmj * (double)(16 - bcgdpjzldb) * 1500.0 + (tzgzgdmj + tzgzstmj) * (double)(tzgzqzldb - tzgzhzldb) * 1500.0);
            zbk.put("f_ishistory", 1);
            if (oid != null) {
                this.modelManageService.updateZBKState(oid);
            }
        }
        zbk.put("f_type", type);
        String xzqdm = dbMap.get("f_xzqhdm") == null ? dbMap.get("xzqdm").toString() : dbMap.get("f_xzqhdm").toString();
        zbk.put("xzqdm", xzqdm);
        zbk.put("xzqmc", dbMap.get("f_xzqmc"));
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            zbk.put("f_zy", String.format("\u6307\u6807\u6765\u6e90\uff1a%s\uff0c\u9879\u76ee\u7f16\u53f7\uff1a%s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%s", type, dbMap.get("f_code"), dbMap.get("f_name")));
        } else {
            zbk.put("f_zy", String.format("\u6307\u6807\u6765\u6e90\uff1a\u65e5\u5e38\u76d1\u7ba1\uff0c\u9879\u76ee\u7f16\u53f7\uff1a%s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%s", dbMap.get("f_code"), dbMap.get("f_name")));
        }
        zbk.put("f_state", "0");
        zbk.put("f_iscountry", 0);
        zbk.put("f_isprovince", 1);
        zbk.put("f_userid", userId);
        zbk.put("f_sid", oid);
        this.modelManageService.saveModel(zbk, "tb_project_gdbh_cbbcgd_zbk", userId, true);
    }

    public void saveLSK2ZBK(String projectId, String userId, String optionType, String type, Long oid) throws Exception {
        Map dbMap = this.modelManageService.findObject("tb_project_gdbh_cbbcgd_lsk", projectId, null);
        Double gdmj = dbMap.get("f_gdmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_gdmj").toString());
        Double stmj = dbMap.get("f_stmj") == null ? 0.0 : Double.parseDouble(dbMap.get("f_stmj").toString());
        Double cnzb = dbMap.get("f_cnzb") == null ? 0.0 : Double.parseDouble(dbMap.get("f_cnzb").toString());
        HashMap<String, Object> zbk = new HashMap<String, Object>();
        if ("-".equals(optionType)) {
            zbk.put("f_gdmj", -1.0 * gdmj);
            zbk.put("f_stmj", -1.0 * stmj);
            zbk.put("f_cnzb", -1.0 * cnzb);
            zbk.put("f_ishistory", 0);
        } else {
            zbk.put("f_gdmj", gdmj);
            zbk.put("f_stmj", stmj);
            zbk.put("f_cnzb", cnzb);
            zbk.put("f_ishistory", 1);
            this.modelManageService.updateZBKState(oid);
        }
        zbk.put("f_type", type);
        zbk.put("xzqdm", dbMap.get("f_xzqhdm"));
        zbk.put("xzqmc", dbMap.get("f_jbxx_xzqmc"));
        zbk.put("f_zy", String.format("\u6307\u6807\u6765\u6e90\uff1a\u65e5\u5e38\u76d1\u7ba1\uff0c\u9879\u76ee\u7f16\u53f7\uff1a%s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%s", dbMap.get("f_ys_xmbh"), dbMap.get("f_xmmc")));
        zbk.put("f_state", "0");
        zbk.put("f_iscountry", 0);
        zbk.put("f_isprovince", 1);
        zbk.put("f_userid", userId);
        zbk.put("f_sid", oid);
        this.modelManageService.saveModel(zbk, "tb_project_gdbh_cbbcgd_zbk", userId, true);
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateJhkGty(String projectIds) throws Exception {
        String xmjd = "jhk";
        String[] projectIdArr = projectIds.split(",");
        ArrayList<Map<String, Object>> XZGDFW = new ArrayList<Map<String, Object>>();
        ArrayList<OutCheckGty> outCheckGties = new ArrayList<OutCheckGty>();
        ArrayList<Map<String, Object>> PZD = new ArrayList<Map<String, Object>>();
        for (String projectId : projectIdArr) {
            Map projectMap;
            List existProject = this.modelManageService.findList("tb_project_gdbh_cbbcgd_jhk", null, "and f_id='" + projectId + "'");
            if (existProject == null || existProject.size() == 0 || (projectMap = (Map)existProject.get(0)) == null) continue;
            String ys_xmbh = projectMap.get("f_code").toString();
            String jbxx_xmmc = projectMap.get("f_name").toString();
            String sql = "select f_id as f_bsm, xzqdm as f_xzqdm, xzqmc, f_dkbh as dikuai_no, f_dkmc as pl_name, f_dkmj as dikuaiarea, f_dkyt as purpose, f_tfh as map_no, f_tblx as patchtype, f_dlbm as landtype, f_gzqpjzldb as avggrade1, f_gzhpjzldb as avggrade2, f_jbxx_xmmc as jbxx_xmmc, st_astext(f_shape) as wkt from tb_project_gdbh_cbbcgd_jhk_xzgdfw where f_project_id = '" + projectId + "'";
            List xzdks = this.jdbcTemplate.queryForList(sql);
            for (Map xzdk : xzdks) {
                HashMap map = new HashMap();
                for (String key : xzdk.keySet()) {
                    if (!Arrays.asList("f_bsm", "f_xzqdm", "xzqmc").contains(key)) {
                        map.put(key.toUpperCase(Locale.ROOT), xzdk.get(key));
                        continue;
                    }
                    map.put(key, xzdk.get(key));
                }
                map.put("xmjd", xmjd);
                map.put("YS_XMBH", ys_xmbh);
                XZGDFW.add(map);
                OutCheckGty outCheckGty = OutCheckGty.builder().bsm(xzdk.get("f_bsm").toString()).yxxmbh(ys_xmbh).dikuaiNO(xzdk.get("dikuai_no").toString()).projectId(projectId).xmjd(xmjd).state(Integer.valueOf(1)).createTime(new Date()).build();
                outCheckGties.add(outCheckGty);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = sdf.format(new Date());
        String dir = this.gtyDir + "/jhk/JHK_" + time;
        File file = this.gtyService.generateGty(XZGDFW, PZD, dir);
        if (file == null) {
            throw new IOException("\u751f\u6210\u5916\u4e1a\u6838\u67e5\u5305\u5931\u8d25\uff01");
        }
        JSONObject importResult = this.gtyService.uploadFile(file);
        if (importResult.getInteger("code") != 200) {
            throw new Exception("gty\u4e0a\u4f20\u5230\u56fd\u571f\u4e91\u51fa\u9519\uff01");
        }
        String logId = importResult.getString("data");
        if (outCheckGties.size() > 0) {
            outCheckGties.forEach(f -> f.setImportId(logId));
            this.outCheckGtyDao.saveAll(outCheckGties);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse generateFhkGty(String projectIds) throws Exception {
        String xmjd = "fhk";
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        String[] projectIdArr = projectIds.split(",");
        ArrayList<Map<String, Object>> XZGDFW = new ArrayList<Map<String, Object>>();
        ArrayList<OutCheckGty> outCheckGties = new ArrayList<OutCheckGty>();
        ArrayList<Map<String, Object>> PZD = new ArrayList<Map<String, Object>>();
        for (String projectId : projectIdArr) {
            Map projectMap;
            List existProject = this.modelManageService.findList("tb_project_gdbh_cbbcgd_fhk", null, "and f_id='" + projectId + "'");
            if (existProject == null || existProject.size() == 0 || (projectMap = (Map)existProject.get(0)) == null) continue;
            String ys_xmbh = projectMap.get("f_code").toString();
            String jbxx_xmmc = projectMap.get("f_name").toString();
            String sql = "select f_id as f_bsm, xzqdm as f_xzqdm, xzqmc, f_dkbh as dikuai_no, f_dkmc as pl_name, f_dkmj as dikuaiarea, f_dkyt as purpose, f_tfh as map_no, f_tblx as patchtype, f_dlbm as landtype, f_gzqpjzldb as avggrade1, f_gzhpjzldb as avggrade2, f_jbxx_xmmc as jbxx_xmmc, st_astext(f_shape) as wkt from tb_project_gdbh_cbbcgd_fhk_xzgdfw where f_project_id = '" + projectId + "'";
            List xzdks = this.jdbcTemplate.queryForList(sql);
            for (Map xzdk : xzdks) {
                HashMap map = new HashMap();
                for (String key : xzdk.keySet()) {
                    if (!Arrays.asList("f_bsm", "f_xzqdm", "xzqmc").contains(key)) {
                        map.put(key.toUpperCase(Locale.ROOT), xzdk.get(key));
                        continue;
                    }
                    map.put(key, xzdk.get(key));
                }
                map.put("xmjd", xmjd);
                map.put("YS_XMBH", ys_xmbh);
                XZGDFW.add(map);
                OutCheckGty outCheckGty = OutCheckGty.builder().bsm(xzdk.get("f_bsm").toString()).yxxmbh(ys_xmbh).dikuaiNO(xzdk.get("dikuai_no").toString()).projectId(projectId).xmjd(xmjd).state(Integer.valueOf(1)).createTime(new Date()).build();
                outCheckGties.add(outCheckGty);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = sdf.format(new Date());
        String dir = this.gtyDir + "/fhk/FHK_" + time;
        if (XZGDFW.size() == 0) {
            return BaseObjectResponse.buildFailuaResponse((String)"\u65b0\u589e\u8015\u5730\u8303\u56f4\u5750\u6807\u6ca1\u6709\u4e0a\u4f20!");
        }
        File file = this.gtyService.generateGty(XZGDFW, PZD, dir);
        JSONObject importResult = this.gtyService.uploadFile(file);
        if (importResult.getInteger("code") != 200) {
            throw new Exception("gty\u4e0a\u4f20\u5230\u56fd\u571f\u4e91\u51fa\u9519\uff01");
        }
        String logId = importResult.getString("data");
        if (outCheckGties.size() > 0) {
            outCheckGties.forEach(f -> f.setImportId(logId));
            this.outCheckGtyDao.saveAll(outCheckGties);
        }
        return baseObjectResponse;
    }

    public Map<String, Object> getDkByPzdWkt(String projectId, String wkt, String tableName) {
        String sql = "select f_dikuai_no from " + tableName + " where ST_Intersects(f_shape,ST_GeomFromText('" + wkt + "')) and f_project_id='" + projectId + "'";
        List list = this.jdbcTemplate.queryForList(sql);
        if (list.size() == 0) {
            sql = "select f_dikuai_no from " + tableName + " where f_project_id='" + projectId + "'";
            list = this.jdbcTemplate.queryForList(sql);
        }
        if (list.size() > 0) {
            return (Map)list.get(0);
        }
        return null;
    }

    public Map<String, Object> getDkByPzd(String projectId, String tableName, Double lng, Double lat, Double radius) {
        String wkt = "POINT(" + lng + " " + lat + ")";
        String sql = "select f_dikuai_no from " + tableName + " where ST_Intersects(f_shape,ST_GeomFromText('" + wkt + "')) and f_project_id='" + projectId + "'";
        List list = this.jdbcTemplate.queryForList(sql);
        if (list.size() == 0) {
            String around = this.getAround(lng, lat, radius);
            sql = "select f_dikuai_no from " + tableName + " where ST_Intersects(f_shape,ST_GeomFromText('" + around + "')) and f_project_id='" + projectId + "'";
            list = this.jdbcTemplate.queryForList(sql);
        }
        if (list.size() > 0) {
            return (Map)list.get(0);
        }
        return null;
    }

    private String getAround(Double lng, Double lat, Double radius) {
        Double degree = 111293.63611111112;
        Double mpdLng = degree * Math.cos(lat * 0.017453292516666667);
        Double dpmLng = 1.0 / mpdLng;
        Double radiusLng = dpmLng * radius;
        Double minLng = lng - radiusLng;
        Double maxLng = lng + radiusLng;
        Double dpmLat = 1.0 / degree;
        Double radiusLat = dpmLat * radius;
        Double minLat = lat - radiusLat;
        Double maxLat = lat + radiusLat;
        return "POLYGON((" + minLng + " " + minLat + "," + maxLng + " " + minLat + "," + maxLng + " " + maxLat + "," + minLng + " " + maxLat + "," + minLng + " " + minLat + "))";
    }

    public Map<String, String> cretaeJhkProject(SysUser user) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        if (user == null || user.getXzqdm() == null) {
            throw new Exception("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        String userXzq = user.getXzqdm();
        Region userRegion = this.regionService.queryRegionByCode(userXzq, null);
        Region parentRegion = this.regionService.queryRegionByCode(userXzq.substring(0, 4) + "00", null);
        Region rootRegion = this.regionService.queryRegionByCode(userXzq.substring(0, 2) + "0000", null);
        result.put("code", "\u4fdd\u5b58\u540e\u751f\u6210");
        result.put("xzqdm", userXzq);
        result.put("xzqmc", rootRegion.getName() + "\u00b7" + parentRegion.getName() + "\u00b7" + userRegion.getName());
        return result;
    }

    public Map<String, String> cretaeFhkProject(SysUser user) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        if (user == null || user.getXzqdm() == null) {
            throw new Exception("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        String userXzq = user.getXzqdm();
        Region userRegion = this.regionService.queryRegionByCode(userXzq, null);
        Region parentRegion = this.regionService.queryRegionByCode(userXzq.substring(0, 4) + "00", null);
        Region rootRegion = this.regionService.queryRegionByCode(userXzq.substring(0, 2) + "0000", null);
        result.put("code", "\u4fdd\u5b58\u540e\u751f\u6210");
        result.put("xzqdm", userXzq);
        result.put("xzqmc", rootRegion.getName() + "\u00b7" + parentRegion.getName() + "\u00b7" + userRegion.getName());
        return result;
    }

    public Map<String, String> cretaeYjkProject(SysUser user) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        if (user == null || user.getXzqdm() == null) {
            throw new Exception("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        String userXzq = user.getXzqdm();
        Region userRegion = this.regionService.queryRegionByCode(userXzq, null);
        Region parentRegion = this.regionService.queryRegionByCode(userXzq.substring(0, 4) + "00", null);
        Region rootRegion = this.regionService.queryRegionByCode(userXzq.substring(0, 2) + "0000", null);
        result.put("code", "\u4fdd\u5b58\u540e\u751f\u6210");
        result.put("xzqdm", userXzq);
        result.put("xzqmc", rootRegion.getName() + "\u00b7" + parentRegion.getName() + "\u00b7" + userRegion.getName());
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public ProjectGdbhCbbcgdYjk saveYjkInfo(ProjectGdbhCbbcgdYjk info) throws Exception {
        this.yjkCheck(info);
        ProjectGdbhCbbcgdYjk yjk = this.yjkRepository.findByYjbh(info.getYjbh());
        if (StringUtils.isEmpty((CharSequence)info.getId())) {
            info.setYjbh(this.baseSidService.generateLsh(info.getXzqdm(), EnumLshType.YJ));
            info.setId(UUID.randomUUID().toString());
            if (yjk != null) {
                throw new RuntimeException("\u9884\u68c0\u7f16\u53f7\u5df2\u5b58\u5728\uff01");
            }
            Integer sort = this.yjkRepository.queryMaxSort();
            info.setSort(Integer.valueOf(sort == null ? 1 : sort + 1));
            info.setCreateTime(new Date());
        } else {
            if (!info.getId().equals(yjk.getId())) {
                throw new RuntimeException("\u9884\u68c0\u7f16\u53f7\u5df2\u5b58\u5728\uff01");
            }
            this.modelManageService.delObject("tb_project_gdbh_cbbcgd_yjk_xmfw", " and f_project_id = '" + info.getId() + "' ");
            this.modelManageService.delObject("tb_project_gdbh_cbbcgd_yjk_xzgdfw", " and f_project_id = '" + info.getId() + "' ");
        }
        this.yjkRepository.save((Object)info);
        List xmqBlocks = info.getXmqBlocks();
        for (XmqBlockDTO blockDTO : xmqBlocks) {
            Map<String, Object> map = GdbhService.objToMap(blockDTO, "f_");
            map.put("f_id", UUID.randomUUID().toString());
            map.put("f_project_id", info.getId());
            map.put("f_shape", blockDTO.getWkt());
            map.remove("f_wkt");
            this.modelManageService.saveModel(map, "tb_project_gdbh_cbbcgd_yjk_xmfw", null, false);
        }
        List gdBlocks = info.getGdBlocks();
        for (GdBlockDTO blockDTO : gdBlocks) {
            Map<String, Object> map = GdbhService.objToMap(blockDTO, "f_");
            map.put("f_id", UUID.randomUUID().toString());
            map.put("f_project_id", info.getId());
            map.put("f_shape", blockDTO.getWkt());
            map.remove("f_wkt");
            this.modelManageService.saveModel(map, "tb_project_gdbh_cbbcgd_yjk_xzgdfw", null, false);
        }
        return info;
    }

    public ProjectGdbhCbbcgdYjk queryYjkById(String id) {
        ProjectGdbhCbbcgdYjk yjk = this.yjkRepository.findById((Object)id).orElse(null);
        if (yjk == null) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e\uff01");
        }
        List xmqs = this.modelManageService.findList("tb_project_gdbh_cbbcgd_yjk_xmfw", null, " and f_project_id = '" + id + "' ", XmqBlockDTO.class);
        yjk.setXmqBlocks(xmqs);
        List gds = this.modelManageService.findList("tb_project_gdbh_cbbcgd_yjk_xzgdfw", null, " and f_project_id = '" + id + "' ", GdBlockDTO.class);
        yjk.setGdBlocks(gds);
        return yjk;
    }

    public Page<ProjectGdbhCbbcgdYjk> queryPageYjk(String yjbh, String name, Integer status, Integer ruleStatus, String xzqdm, Integer page, Integer size) {
        Specification & Serializable specification = (Specification & Serializable)(entry, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> list = new ArrayList<Predicate>();
            if (StringUtils.isNotEmpty((CharSequence)yjbh)) {
                list.add(criteriaBuilder.like(entry.get("yjbh").as(String.class), "%" + yjbh + "%"));
            }
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                list.add(criteriaBuilder.like(entry.get("name").as(String.class), "%" + name + "%"));
            }
            if (status != null) {
                list.add(criteriaBuilder.equal(entry.get("status").as(Integer.class), (Object)status));
            }
            if (ruleStatus != null) {
                list.add(criteriaBuilder.equal(entry.get("ruleStatus").as(Integer.class), (Object)ruleStatus));
            }
            if (StringUtils.isNotEmpty((CharSequence)xzqdm)) {
                String dm = xzqdm;
                if (xzqdm.endsWith("0000")) {
                    dm = xzqdm.substring(0, 2);
                } else if (xzqdm.endsWith("00")) {
                    dm = xzqdm.substring(0, 4);
                }
                list.add(criteriaBuilder.like(entry.get("xzqdm").as(String.class), "%" + dm + "%"));
            }
            return criteriaBuilder.and(list.toArray(new Predicate[list.size()]));
        };
        PageRequest pageRequest = PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"sort"}));
        return this.yjkRepository.findAll((Specification)specification, (Pageable)pageRequest);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteYjkById(String id) {
        this.yjkRepository.deleteById((Object)id);
        this.modelManageService.delObject("tb_project_gdbh_cbbcgd_yjk_xmfw", " and f_project_id = '" + id + "' ");
        this.modelManageService.delObject("tb_project_gdbh_cbbcgd_yjk_xzgdfw", " and f_project_id = '" + id + "' ");
        this.verifyTaskDao.deleteByPid(id);
    }

    private void yjkCheck(ProjectGdbhCbbcgdYjk info) {
        if (StringUtils.isEmpty((CharSequence)info.getName())) {
            throw new RuntimeException("\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (info.getXmnf() == null) {
            throw new RuntimeException("\u9879\u76ee\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (info.getXmqBlocks() == null || info.getXmqBlocks().isEmpty()) {
            throw new RuntimeException("\u9879\u76ee\u533a\u5730\u5757\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (info.getGdBlocks() == null || info.getGdBlocks().isEmpty()) {
            throw new RuntimeException("\u8015\u5730\u5730\u5757\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private String getXzqmc(String jbxx_xzqmc) {
        String[] split = jbxx_xzqmc.split("\\.");
        return split[split.length - 1];
    }

    private String getNextCode(String str) {
        String numStr = str.substring(str.length() - 4);
        if (!StringUtils.isEmpty((CharSequence)numStr)) {
            int n = numStr.length();
            int num = Integer.parseInt(numStr) + 1;
            String added = String.valueOf(num);
            n = Math.min(n, added.length());
            return str.subSequence(0, str.length() - n) + added;
        }
        throw new NumberFormatException();
    }

    private String getProjectSummary(String type, Map<String, Object> map) {
        if (type.equals("LSK")) {
            return String.format("\u6307\u6807\u6765\u6e90\uff1a\u5386\u53f2\u9879\u76ee\u5165\u5e93\uff0c\u9879\u76ee\u540d\u79f0\uff1a%s\uff0c\u9879\u76ee\u7f16\u53f7\uff1a%s", map.get("JBXX_XMMC"), map.get("YS_XMBH"));
        }
        return null;
    }

    private static String getCurrentYear() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        return sdf.format(date);
    }

    private static Map<String, Object> objToMap(Object obj, String prefix) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = StringUtils.isEmpty((CharSequence)prefix) ? field.getName() : prefix + field.getName();
            map.put(fieldName, field.get(obj));
        }
        return map;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteWyFileById(List<Map<String, Object>> list) {
        if (list != null && list.size() > 0) {
            ArrayList<String> relationIds = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> map = list.get(i);
                String id = map.get("f_id").toString();
                relationIds.add(id);
            }
            this.baseFileService.deleteByRelationIds(relationIds);
        }
    }
}

