/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.support.util.Md5Util;
import com.geoway.onemap.core.support.FileUtil;
import com.geoway.onemap.core.support.HttpsUtil;
import com.geoway.onemap.core.support.ShapeUtil;
import com.geoway.onemap.core.support.Zip4jUtil;
import com.geoway.onemap.core.support.http.HttpConnectionUtil;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class GtyService {
    @Value(value="${project.zipPass}")
    protected String zipPass;
    @Resource
    RedisTemplate redisTemplate;
    @Value(value="${gty.base.url}")
    protected String gtyBase;
    @Value(value="${gty.token.url}")
    protected String gtyTokenUrl;
    @Value(value="${gty.ak}")
    protected String ak;
    @Value(value="${gty.sk}")
    protected String sk;
    @Value(value="${gty.store.url}")
    protected String gtyStore;
    @Value(value="${gty.notice.url}")
    protected String noticeStore;
    @Value(value="${gty.queryresult.url}")
    protected String queryResult;
    @Value(value="${gty.bizId}")
    protected String bizId;
    @Value(value="${gty.import.log.url}")
    protected String importLog;
    @Value(value="${gty.sign.url}")
    protected String signUrl;
    private final String GTY_TOKEN = "gty_token";

    public String getToken() {
        String token = null;
        Object obj = this.redisTemplate.opsForValue().get((Object)"gty_token");
        if (obj != null) {
            JSONObject jsonObject = JSON.parseObject((String)obj.toString());
            Long currTime = System.currentTimeMillis();
            Long expireTime = jsonObject.getLong("expireTime");
            if (currTime > expireTime) {
                JSONObject tokenInfo = this.httpGetToken();
                if (tokenInfo != null) {
                    token = tokenInfo.getString("accessToken");
                    this.redisTemplate.opsForValue().set((Object)"gty_token", (Object)JSON.toJSONString((Object)tokenInfo));
                }
            } else {
                token = jsonObject.getString("accessToken");
            }
        } else {
            JSONObject tokenInfo = this.httpGetToken();
            token = tokenInfo.getString("accessToken");
            this.redisTemplate.opsForValue().set((Object)"gty_token", (Object)JSON.toJSONString((Object)tokenInfo));
        }
        return token;
    }

    public JSONObject uploadFile(File file) throws Exception {
        JSONObject tempUrlObj = this.getTempUrl();
        String writeUrl = tempUrlObj.getString("writeUrl");
        byte[] bytes = FileUtil.fileConvertToByteArray((File)file);
        String uploadResult = HttpsUtil.httpsRequestPost((String)writeUrl, (String)"PUT", (byte[])bytes);
        String readUrl = tempUrlObj.getString("readUrl");
        String md5 = Md5Util.getFileMd5Str((File)file);
        String token = this.getToken();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("sysToken", token);
        JSONObject formParams = new JSONObject();
        formParams.put("bizId", (Object)this.bizId);
        String path = readUrl.split("\\?")[0];
        formParams.put("filePath", (Object)readUrl);
        String fileName = file.getName().substring(0, file.getName().lastIndexOf("."));
        formParams.put("fileName", (Object)fileName);
        formParams.put("hash", (Object)md5);
        formParams.put("updateType", (Object)"0");
        String result = HttpConnectionUtil.doPostOKHttpJson((String)(this.gtyBase + this.noticeStore), (JSONObject)formParams, headerParams);
        return JSON.parseObject((String)result);
    }

    public JSONObject getImportResult(String id) {
        String token = this.getToken();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("sysToken", token);
        JSONObject formParams = new JSONObject();
        formParams.put("id", (Object)id);
        String result = HttpConnectionUtil.doGetOKHttp((String)(this.gtyBase + this.importLog), (Map)formParams, headerParams);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String status = jsonObject.getString("status");
        if ("true".equalsIgnoreCase(status)) {
            return jsonObject.getJSONObject("data");
        }
        return new JSONObject();
    }

    public JSONObject queryResult(String bsm) {
        String token = this.getToken();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("sysToken", token);
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("bizId", this.bizId);
        formParams.put("bsm", bsm);
        String result = HttpConnectionUtil.doPostOKHttp((String)(this.gtyBase + this.queryResult), formParams, headerParams);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        return jsonObject;
    }

    public JSONObject getSignUrl(String url) {
        String token = this.getToken();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("sysToken", token);
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("url", url);
        String result = HttpConnectionUtil.doPostOKHttp((String)(this.gtyBase + this.signUrl), formParams, headerParams);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        return jsonObject;
    }

    private JSONObject getTempUrl() {
        String token = this.getToken();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("sysToken", token);
        JSONObject formParams = new JSONObject();
        formParams.put("type", (Object)"gty");
        String result = HttpConnectionUtil.doPostOKHttpJson((String)(this.gtyBase + this.gtyStore), (JSONObject)formParams, headerParams);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String status = jsonObject.getString("status");
        if ("true".equalsIgnoreCase(status)) {
            return jsonObject.getJSONObject("data");
        }
        return new JSONObject();
    }

    private JSONObject httpGetToken() {
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("appKey", this.ak);
        headerParams.put("appSecret", this.sk);
        String result = HttpConnectionUtil.doPostOKHttp((String)(this.gtyBase + this.gtyTokenUrl), null, headerParams);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String status = jsonObject.getString("status");
        if ("true".equalsIgnoreCase(status)) {
            return jsonObject.getJSONObject("data");
        }
        return null;
    }

    public File generateGty(List<Map<String, Object>> XZGDFW, List<Map<String, Object>> PZD, String dir) throws IOException, SQLException {
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        if (XZGDFW.size() > 0) {
            String path = dir + "/XZGDFW.shp";
            ArrayList<String> attrKeys = new ArrayList<String>(XZGDFW.get(0).keySet());
            attrKeys.remove("WKT");
            ShapeUtil.write2Shape((String)path, (String)"UTF-8", (String)"MultiPolygon", (String)"WKT", attrKeys, XZGDFW);
        }
        String zipUrl = dir;
        zipUrl = Zip4jUtil.zip((String)zipUrl, (boolean)false, (String)"");
        File zipFile = new File(zipUrl);
        String gtyPath = zipUrl.substring(0, zipUrl.lastIndexOf(".")) + ".gty";
        File gtyFile = new File(gtyPath);
        zipFile.renameTo(gtyFile);
        FileUtils.forceDelete((File)dirFile);
        return gtyFile;
    }
}

