/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.service;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.stxf.constant.ProjectRcjgAnalyStateConstant;
import com.geoway.onemap.stxf.dto.ProjectRcjgAnalyDto;
import com.geoway.onemap.stxf.service.ProjectRcjgVoService;
import com.geoway.zhgd.dao.ProjectRcjgAnalyDao;
import com.geoway.zhgd.dao.ProjectRcjgAnalyItemDao;
import com.geoway.zhgd.dao.ProjectRcjgAnalyRecordDao;
import com.geoway.zhgd.domain.ProjectRcjgAnaly;
import com.geoway.zhgd.domain.ProjectRcjgAnalyItem;
import com.geoway.zhgd.domain.ProjectRcjgAnalyRecord;
import com.geoway.zhgd.domain.ProjectRcjgVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ProjectRcjgAnalyRecordService {
    @Autowired
    private ProjectRcjgAnalyRecordDao projectRcjgAnalyRecordDao;
    @Autowired
    private ProjectRcjgAnalyItemDao projectRcjgAnalyItemDao;
    @Autowired
    private ProjectRcjgAnalyDao projectRcjgAnalyDao;
    @Autowired
    private ProjectRcjgVoService projectRcjgVoService;
    @Autowired
    ModelManageService modelManageService;

    public Page<ProjectRcjgAnalyRecord> getPageList(String filterParam, String sortParam, Integer page, Integer pageSize) {
        return this.projectRcjgAnalyRecordDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)(page - 1), (int)pageSize, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
    }

    public void addOne(ProjectRcjgAnalyRecord projectRcjgAnaly) {
        this.projectRcjgAnalyRecordDao.save((Object)projectRcjgAnaly);
    }

    public void deleteOne(String id) {
        this.projectRcjgAnalyRecordDao.deleteById((Object)id);
    }

    public ProjectRcjgAnalyRecord queryOne(String id) {
        return this.projectRcjgAnalyRecordDao.queryById(id);
    }

    public void doAnaly(ProjectRcjgAnalyDto projectRcjgAnalyDto) {
        Boolean isAllChecked = projectRcjgAnalyDto.getIsAllChecked();
        if (isAllChecked.booleanValue()) {
            String filterParam = projectRcjgAnalyDto.getFilterParam();
            List<ProjectRcjgVo> list = this.projectRcjgVoService.findByFilter(filterParam);
            this.batchAnaly(list, "rcjg");
        } else {
            List<String> projectIds = projectRcjgAnalyDto.getProjectIds();
            this.addAnaly(projectIds, "rcjg");
        }
    }

    public void doAnalyJhk(ProjectRcjgAnalyDto projectRcjgAnalyDto) {
        Boolean isAllChecked = projectRcjgAnalyDto.getIsAllChecked();
        if (isAllChecked.booleanValue()) {
            String filterParam = projectRcjgAnalyDto.getFilterParam();
            ArrayList<ProjectRcjgVo> projectRcjgVoList = new ArrayList<ProjectRcjgVo>();
            List jhkList = this.modelManageService.findList("tb_project_gdbh_cbbcgd_jhk", "", filterParam);
            for (Map data : jhkList) {
                if (!ObjectUtil.isNotNull((Object)data)) continue;
                ProjectRcjgVo projectRcjgVo = new ProjectRcjgVo();
                projectRcjgVo.setProjectVoId(data.get("f_id").toString());
                projectRcjgVo.setCode(data.get("f_code").toString());
                projectRcjgVo.setName(data.get("f_name").toString());
                projectRcjgVoList.add(projectRcjgVo);
            }
            this.batchAnaly(projectRcjgVoList, "jhk");
        } else {
            List<String> projectIds = projectRcjgAnalyDto.getProjectIds();
            this.addAnaly(projectIds, "jhk");
        }
    }

    private void addAnaly(List<String> projectIds, String projectType) {
        if (projectIds.size() > 0) {
            ArrayList<ProjectRcjgAnalyRecord> saveProjectRcjgAnalyRecoreds = new ArrayList<ProjectRcjgAnalyRecord>();
            List projectRcjgAnalyItems = this.projectRcjgAnalyItemDao.getAll();
            for (String projectId : projectIds) {
                this.projectRcjgAnalyDao.deleteByProjectId(projectId);
                this.projectRcjgAnalyRecordDao.deleteByProjectId(projectId);
                ProjectRcjgAnaly projectRcjgAnaly = new ProjectRcjgAnaly();
                projectRcjgAnaly.setProjectId(projectId);
                projectRcjgAnaly.setAnalyState(Integer.valueOf(0));
                projectRcjgAnaly.setCreateTime(new Date());
                projectRcjgAnaly.setUpdateTime(new Date());
                projectRcjgAnaly.setProjectType(projectType);
                this.projectRcjgAnalyDao.save((Object)projectRcjgAnaly);
                for (ProjectRcjgAnalyItem projectRcjgAnalyItem : projectRcjgAnalyItems) {
                    ProjectRcjgAnalyRecord projectRcjgAnalyRecord = new ProjectRcjgAnalyRecord();
                    projectRcjgAnalyRecord.setAnalyId(projectRcjgAnaly.getId());
                    projectRcjgAnalyRecord.setAnalyItemId(projectRcjgAnalyItem.getId());
                    projectRcjgAnalyRecord.setAnalyState(ProjectRcjgAnalyStateConstant.INIT);
                    projectRcjgAnalyRecord.setProjectId(projectId);
                    projectRcjgAnalyRecord.setAnalyItemKey(projectRcjgAnalyItem.getLayerName());
                    saveProjectRcjgAnalyRecoreds.add(projectRcjgAnalyRecord);
                }
            }
            this.projectRcjgAnalyRecordDao.saveAll(saveProjectRcjgAnalyRecoreds);
        }
    }

    private void batchAnaly(List<ProjectRcjgVo> projectList, String projectType) {
        if (projectList.size() > 0) {
            ArrayList<ProjectRcjgAnalyRecord> saveProjectRcjgAnalyRecoreds = new ArrayList<ProjectRcjgAnalyRecord>();
            List projectRcjgAnalyItems = this.projectRcjgAnalyItemDao.getAll();
            List projectIds = projectList.stream().map(project -> project.getProjectVoId()).collect(Collectors.toList());
            this.projectRcjgAnalyDao.batchDeleteByIds(projectIds);
            this.projectRcjgAnalyRecordDao.batchDeleteByIds(projectIds);
            for (ProjectRcjgVo project2 : projectList) {
                String proId = project2.getProjectVoId();
                ProjectRcjgAnaly projectRcjgAnaly = new ProjectRcjgAnaly();
                projectRcjgAnaly.setProjectId(proId);
                projectRcjgAnaly.setAnalyState(Integer.valueOf(0));
                projectRcjgAnaly.setCreateTime(new Date());
                projectRcjgAnaly.setUpdateTime(new Date());
                projectRcjgAnaly.setProjectType(projectType);
                this.projectRcjgAnalyDao.save((Object)projectRcjgAnaly);
                for (ProjectRcjgAnalyItem projectRcjgAnalyItem : projectRcjgAnalyItems) {
                    ProjectRcjgAnalyRecord projectRcjgAnalyRecord = new ProjectRcjgAnalyRecord();
                    projectRcjgAnalyRecord.setAnalyId(projectRcjgAnaly.getId());
                    projectRcjgAnalyRecord.setAnalyItemId(projectRcjgAnalyItem.getId());
                    projectRcjgAnalyRecord.setAnalyState(ProjectRcjgAnalyStateConstant.INIT);
                    projectRcjgAnalyRecord.setProjectId(proId);
                    projectRcjgAnalyRecord.setAnalyItemKey(projectRcjgAnalyItem.getLayerName());
                    saveProjectRcjgAnalyRecoreds.add(projectRcjgAnalyRecord);
                }
            }
            this.projectRcjgAnalyRecordDao.saveAll(saveProjectRcjgAnalyRecoreds);
        }
    }

    public List<ProjectRcjgAnalyRecord> queryByState(Integer state) {
        return this.projectRcjgAnalyRecordDao.queryByState(state);
    }

    public List<ProjectRcjgAnalyRecord> queryByAnalyId(String analyId) {
        return this.projectRcjgAnalyRecordDao.queryByAnalyId(analyId);
    }

    public Map<String, Object> queryByProjectId(String projectId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ProjectRcjgAnaly projectRcjgAnaly = this.projectRcjgAnalyDao.queryByProjectId(projectId);
        map.put("base", projectRcjgAnaly);
        if (projectRcjgAnaly != null) {
            List records = this.projectRcjgAnalyRecordDao.queryByRecordByProjectId(projectRcjgAnaly.getId());
            map.put("records", records);
        }
        return map;
    }
}

