/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

public class Convertor {
    public static void main(String[] args) {
        double lon = 116.0;
        double lat = 39.0;
        double[] xy = Convertor.GaussToBLToGauss(lon, lat);
        System.out.println("x:" + xy[0] + " y:" + xy[1]);
    }

    public static double[] GaussToBL(double X, double Y) {
        double[] output = new double[2];
        double iPI = 0.0174532925199433;
        double a = 6378140.0;
        double f = 0.0033528131778969143;
        int ZoneWide = 6;
        int ProjNo = (int)(X / 1000000.0);
        double longitude0 = (ProjNo - 1) * ZoneWide + ZoneWide / 2;
        longitude0 *= iPI;
        double X0 = (long)ProjNo * 1000000L + 500000L;
        double Y0 = 0.0;
        double xval = X - X0;
        double yval = Y - Y0;
        double e2 = 2.0 * f - f * f;
        double e1 = (1.0 - Math.sqrt(1.0 - e2)) / (1.0 + Math.sqrt(1.0 - e2));
        double ee = e2 / (1.0 - e2);
        double M = yval;
        double u = M / (a * (1.0 - e2 / 4.0 - 3.0 * e2 * e2 / 64.0 - 5.0 * e2 * e2 * e2 / 256.0));
        double fai = u + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * u) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * u) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * u) + 1097.0 * e1 * e1 * e1 * e1 / 512.0 * Math.sin(8.0 * u);
        double C = ee * Math.cos(fai) * Math.cos(fai);
        double T = Math.tan(fai) * Math.tan(fai);
        double NN = a / Math.sqrt(1.0 - e2 * Math.sin(fai) * Math.sin(fai));
        double R = a * (1.0 - e2) / Math.sqrt((1.0 - e2 * Math.sin(fai) * Math.sin(fai)) * (1.0 - e2 * Math.sin(fai) * Math.sin(fai)) * (1.0 - e2 * Math.sin(fai) * Math.sin(fai)));
        double D = xval / NN;
        double longitude1 = longitude0 + (D - (1.0 + 2.0 * T + C) * D * D * D / 6.0 + (5.0 - 2.0 * C + 28.0 * T - 3.0 * C * C + 8.0 * ee + 24.0 * T * T) * D * D * D * D * D / 120.0) / Math.cos(fai);
        double latitude1 = fai - NN * Math.tan(fai) / R * (D * D / 2.0 - (5.0 + 3.0 * T + 10.0 * C - 4.0 * C * C - 9.0 * ee) * D * D * D * D / 24.0 + (61.0 + 90.0 * T + 298.0 * C + 45.0 * T * T - 256.0 * ee - 3.0 * C * C) * D * D * D * D * D * D / 720.0);
        output[0] = longitude1 / iPI;
        output[1] = latitude1 / iPI;
        return output;
    }

    public static double[] GaussToBLToGauss(double longitude, double latitude) {
        double[] output = new double[2];
        int ProjNo = 0;
        double iPI = 0.0174532925199433;
        int ZoneWide = 6;
        double a = 6378245.0;
        double f = 0.003352329869259135;
        ProjNo = (int)(longitude / (double)ZoneWide);
        double longitude0 = ProjNo * ZoneWide + ZoneWide / 2;
        longitude0 *= iPI;
        double latitude0 = 0.0;
        System.out.println(latitude0);
        double longitude1 = longitude * iPI;
        double latitude1 = latitude * iPI;
        double e2 = 2.0 * f - f * f;
        double ee = e2 * (1.0 - e2);
        double NN = a / Math.sqrt(1.0 - e2 * Math.sin(latitude1) * Math.sin(latitude1));
        double T = Math.tan(latitude1) * Math.tan(latitude1);
        double C = ee * Math.cos(latitude1) * Math.cos(latitude1);
        double A = (longitude1 - longitude0) * Math.cos(latitude1);
        double M = a * ((1.0 - e2 / 4.0 - 3.0 * e2 * e2 / 64.0 - 5.0 * e2 * e2 * e2 / 256.0) * latitude1 - (3.0 * e2 / 8.0 + 3.0 * e2 * e2 / 32.0 + 45.0 * e2 * e2 * e2 / 1024.0) * Math.sin(2.0 * latitude1) + (15.0 * e2 * e2 / 256.0 + 45.0 * e2 * e2 * e2 / 1024.0) * Math.sin(4.0 * latitude1) - 35.0 * e2 * e2 * e2 / 3072.0 * Math.sin(6.0 * latitude1));
        double xval = NN * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * ee) * A * A * A * A * A / 120.0);
        double yval = M + NN * Math.tan(latitude1) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * ee) * A * A * A * A * A * A / 720.0);
        double X0 = 1000000L * (long)(ProjNo + 1) + 500000L;
        double Y0 = 0.0;
        output[0] = xval += X0;
        output[1] = yval += Y0;
        return output;
    }
}

