/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtils {
    public static void unpack(String zip, String charsetName) {
        FileUtils.unpack(new File(zip), charsetName);
    }

    public static void unpack(String zip, String outputDir, String charsetName) {
        FileUtils.unpack(new File(zip), new File(outputDir), charsetName);
    }

    public static void unpack(File zip, String charsetName) {
        FileUtils.unpack(zip, null, charsetName);
    }

    public static void unpack(File zip, File outputDir) {
        FileUtils.unpack(zip, outputDir, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(File zip, File outputDir, String charsetName) {
        FileOutputStream out = null;
        InputStream in = null;
        ZipFile zipFileData = null;
        ZipFile zipFile = null;
        try {
            if (outputDir != null && !outputDir.exists()) {
                outputDir.mkdirs();
            }
            zipFile = charsetName != null && charsetName != "" ? new ZipFile(zip.getPath(), Charset.forName(charsetName)) : new ZipFile(zip.getPath(), Charset.forName("utf8"));
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String filePath = "";
                filePath = outputDir == null ? zip.getParentFile().getPath() + File.separator + entry.getName() : outputDir.getPath() + File.separator + entry.getName();
                File file = new File(filePath);
                File parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                if (!parentFile.isDirectory()) continue;
            }
            zipFileData = charsetName != null && charsetName != "" ? new ZipFile(zip.getPath(), Charset.forName(charsetName)) : new ZipFile(zip.getPath(), Charset.forName("utf8"));
            Enumeration<? extends ZipEntry> entriesData = zipFileData.entries();
            while (entriesData.hasMoreElements()) {
                ZipEntry entry = entriesData.nextElement();
                in = zipFile.getInputStream(entry);
                String filePath = "";
                filePath = outputDir == null ? zip.getParentFile().getPath() + File.separator + entry.getName() : outputDir.getPath() + File.separator + entry.getName();
                File file = new File(filePath);
                if (file.isDirectory()) continue;
                out = new FileOutputStream(filePath);
                int len = -1;
                byte[] bytes = new byte[1024];
                while ((len = in.read(bytes)) != -1) {
                    out.write(bytes, 0, len);
                }
                out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
                in.close();
                zipFile.close();
                zipFileData.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompletelyWritten(File file) {
        RandomAccessFile stream = null;
        try {
            stream = new RandomAccessFile(file, "rw");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("Skipping file " + file.getName() + " for this iteration due it's not completely written");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    System.out.println("Exception during closing file " + file.getName());
                }
            }
        }
        return false;
    }
}

