/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils2 {
    private static final Logger log = LoggerFactory.getLogger(FileUtils2.class);
    private static Logger logger = LoggerFactory.getLogger(FileUtils2.class);
    private static final String winrarPath = "C:\\Program Files\\WinRAR\\WinRAR.exe";

    public static void copyDir(String oldPath, String newPath) throws IOException {
        File file = new File(oldPath);
        if (!file.exists()) {
            return;
        }
        String[] filePath = file.list();
        if (!new File(newPath).exists()) {
            new File(newPath).mkdirs();
        }
        for (int i = 0; i < filePath.length; ++i) {
            if (new File(oldPath + File.separator + filePath[i]).isDirectory()) {
                FileUtils2.copyDir(oldPath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
            }
            if (!new File(oldPath + File.separator + filePath[i]).isFile()) continue;
            FileUtils2.copyFile(oldPath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
        }
    }

    public static String copyFiles(String filePath, String destFolder) throws IOException {
        String destPath = null;
        File folderF = new File(destFolder);
        if (!folderF.exists()) {
            folderF.mkdirs();
        }
        int sIndex = filePath.lastIndexOf(".");
        String fileName = filePath.substring(0, sIndex);
        File file = new File(filePath);
        File folderP = file.getParentFile();
        for (File item : folderP.listFiles()) {
            if (item.isDirectory()) continue;
            String itemPath = item.getAbsolutePath();
            if (itemPath.startsWith(fileName)) {
                FileUtils2.copyFileUsingFileChannels(item, new File(destFolder + File.separator + item.getName()));
            }
            if (!item.getName().equalsIgnoreCase(file.getName())) continue;
            destPath = destFolder + File.separator + item.getName();
        }
        return destPath;
    }

    public static String copyFiles(String filePath, String destFolder, String newName) throws IOException {
        String destPath = null;
        int sIndex = filePath.lastIndexOf(".");
        String fileName = filePath.substring(0, sIndex);
        File file = new File(filePath);
        File folderP = file.getParentFile();
        for (File item : folderP.listFiles()) {
            if (item.isDirectory()) continue;
            String itemPath = item.getAbsolutePath();
            String newPath = destFolder + File.separator + newName + itemPath.substring(sIndex);
            if (itemPath.startsWith(fileName)) {
                FileUtils2.copyFileUsingFileChannels(item, new File(newPath));
            }
            if (!itemPath.equals(filePath)) continue;
            destPath = newPath;
        }
        return destPath;
    }

    public static void copyFile(String oldPath, String newPath) throws IOException {
        FileUtils2.copyFileUsingFileChannels(new File(oldPath), new File(newPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingFileChannels(File source, File dest) throws IOException {
        AbstractInterruptibleChannel inputChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(source).getChannel();
            outputChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)outputChannel).transferFrom((ReadableByteChannel)((Object)inputChannel), 0L, ((FileChannel)inputChannel).size());
        }
        finally {
            inputChannel.close();
            outputChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile2(String oldPath, String newPath) {
        Class<FileUtils2> clazz = FileUtils2.class;
        synchronized (FileUtils2.class) {
            try {
                int bytesum = 0;
                int byteread = 0;
                File oldfile = new File(oldPath);
                if (oldfile.exists()) {
                    FileInputStream inStream = new FileInputStream(oldPath);
                    FileOutputStream fs = new FileOutputStream(newPath);
                    byte[] buffer = new byte[1024];
                    while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                        bytesum += byteread;
                        fs.write(buffer, 0, byteread);
                    }
                    ((InputStream)inStream).close();
                    fs.close();
                }
            }
            catch (Exception e) {
                System.out.println("\u590d\u5236\u5355\u4e2a\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
                e.printStackTrace();
            }
            return;
        }
    }

    public static boolean delFile(String path) {
        return FileUtils2.delFile(new File(path));
    }

    public static boolean delFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                FileUtils2.delFile(f);
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToBase64(File file) {
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        ByteArrayOutputStream baos = null;
        FilterOutputStream bout = null;
        try {
            fin = new FileInputStream(file);
            bin = new BufferedInputStream(fin);
            baos = new ByteArrayOutputStream();
            bout = new BufferedOutputStream(baos);
            byte[] buffer = new byte[1024];
            int len = bin.read(buffer);
            while (len != -1) {
                ((BufferedOutputStream)bout).write(buffer, 0, len);
                len = bin.read(buffer);
            }
            ((BufferedOutputStream)bout).flush();
            byte[] bytes = baos.toByteArray();
            String string = Base64.encodeBase64String((byte[])bytes);
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fin.close();
                bin.close();
                bout.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File file) {
        File f = file;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)f.length());
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            int buf_size = 1024;
            byte[] buffer = new byte[buf_size];
            int len = 0;
            while (-1 != (len = in.read(buffer, 0, buf_size))) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String codeString(String fileName) throws Exception {
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(fileName));
        int p = (bin.read() << 8) + bin.read();
        bin.close();
        String code = null;
        switch (p) {
            case 61371: {
                code = "UTF-8";
                break;
            }
            case 65534: {
                code = "Unicode";
                break;
            }
            case 65279: {
                code = "UTF-16BE";
                break;
            }
            default: {
                code = "GBK";
            }
        }
        return code;
    }

    public static List<File> searchFiles(File folder, final String fileName, final Long size) {
        File[] subFolders;
        ArrayList<File> result = new ArrayList<File>();
        if (folder.isFile()) {
            result.add(folder);
        }
        if ((subFolders = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                Long length;
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().equals(fileName) && (length = Long.valueOf(file.length())).equals(size);
            }
        })) != null) {
            for (File file : subFolders) {
                if (file.isFile()) {
                    result.add(file);
                    continue;
                }
                result.addAll(FileUtils2.searchFiles(file, fileName, size));
            }
        }
        return result;
    }

    public static void findFiles(String baseFolder, String fileName, List<File> result) {
        File baseDir = new File(baseFolder);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.out.println("\u6587\u4ef6\u67e5\u627e\u5931\u8d25\uff0c" + baseFolder + "\u4e0d\u662f\u4e2a\u76ee\u5f55\uff01");
        }
        File[] files = baseDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String tempName;
            File tempFile = files[i];
            if (tempFile.isDirectory()) {
                FileUtils2.findFiles(tempFile.getAbsolutePath(), fileName, result);
                continue;
            }
            if (!tempFile.isFile() || !FileUtils2.wildCharMatch(fileName, tempName = tempFile.getName())) continue;
            result.add(tempFile);
        }
    }

    private static boolean wildCharMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIdex = 0; patternIdex < patternLength; ++patternIdex) {
            char ch = pattern.charAt(patternIdex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (FileUtils2.wildCharMatch(pattern.substring(patternIdex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public static void appendFileHead(String sourcePath, String destPath) {
        try {
            FileInputStream fileInputStream = new FileInputStream(sourcePath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String content = bufferedReader.readLine();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                content = content + "\r\n" + line;
            }
            fileInputStream.close();
            fileInputStream = new FileInputStream(destPath);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((line = bufferedReader.readLine()) != null) {
                content = content + "\r\n" + line;
            }
            fileInputStream.close();
            FileOutputStream fileOutputStream = new FileOutputStream(destPath);
            fileOutputStream.write(content.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void unzip(String zipUrl, String outDir) {
        String OS_NAME;
        boolean isMakDir;
        File outFileDir = new File(outDir);
        if (!outFileDir.exists() && (isMakDir = outFileDir.mkdirs())) {
            logger.info("\u521b\u5efa\u538b\u7f29\u76ee\u5f55\u6210\u529f");
        }
        if ((OS_NAME = System.getProperty("os.name")) == null || OS_NAME.toLowerCase().contains("windows")) {
            // empty if block
        }
    }

    public static void main(String[] args) {
        FileUtils2.appendFileHead("V:\\HXPTModel\\ResultData\\2020\\09\\09\\633.log", "V:\\HXPTModel\\ResultData\\2020\\09\\25\\2284.log");
    }
}

