/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class GeoJsonUtil {
    public static final GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), 4326);
    public static final WKTReader wktReader = new WKTReader(geometryFactory);

    public static Geometry toGeometry(String wkt) throws ParseException {
        Geometry read = wktReader.read(wkt);
        return read;
    }

    public static JSONObject parsePolygon2Geojson(Geometry geom) throws ParseException {
        JSONObject jsonObject = new JSONObject();
        String type = geom.getGeometryType();
        jsonObject.put((Object)"type", (Object)geom.getGeometryType());
        if ("MultiPolygon".equalsIgnoreCase(type)) {
            JSONArray coordJson = new JSONArray();
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                coordJson.add((Object)GeoJsonUtil.parsePolygon(geom.getGeometryN(i)));
            }
            jsonObject.put((Object)"coordinates", (Object)coordJson);
        } else if ("Polygon".equalsIgnoreCase(type)) {
            jsonObject.put((Object)"coordinates", (Object)GeoJsonUtil.parsePolygon(geom));
        } else if ("MultiLineString".equalsIgnoreCase(type)) {
            JSONArray coordJson = new JSONArray();
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                ArrayList<List<Double>> line = new ArrayList<List<Double>>();
                for (Coordinate coordinate : geom.getGeometryN(i).getCoordinates()) {
                    line.add(GeoJsonUtil.getPoint(coordinate));
                }
                coordJson.add(line);
            }
            jsonObject.put((Object)"coordinates", (Object)coordJson);
        } else if ("Point".equalsIgnoreCase(type)) {
            jsonObject.put((Object)"coordinates", GeoJsonUtil.getPoint(geom.getCoordinate()));
        } else if ("MultiPoint".equalsIgnoreCase(type) || "LineString".equalsIgnoreCase(type)) {
            ArrayList<List<Double>> coordJson = new ArrayList<List<Double>>();
            for (Coordinate coordinate : geom.getCoordinates()) {
                coordJson.add(GeoJsonUtil.getPoint(coordinate));
            }
            jsonObject.put((Object)"coordinates", coordJson);
        } else {
            jsonObject.put((Object)"coordinates", (Object)new JSONArray());
        }
        return jsonObject;
    }

    private static JSONArray parsePolygon(Geometry geom) {
        JSONArray coordJson = new JSONArray();
        Polygon polygon = (Polygon)geom;
        LineString exteriorRing = polygon.getExteriorRing();
        exteriorRing.getCoordinateSequence();
        ArrayList<List<Double>> line = new ArrayList<List<Double>>();
        for (Coordinate exterior : exteriorRing.getCoordinates()) {
            line.add(GeoJsonUtil.getPoint(exterior));
        }
        coordJson.add(line);
        for (int j = 0; j < polygon.getNumInteriorRing(); ++j) {
            ArrayList<List<Double>> lineIn = new ArrayList<List<Double>>();
            for (Coordinate internal : polygon.getInteriorRingN(j).getCoordinates()) {
                lineIn.add(GeoJsonUtil.getPoint(internal));
            }
            coordJson.add(lineIn);
        }
        return coordJson;
    }

    private static List<Double> getPoint(Coordinate exterior) {
        ArrayList<Double> point = new ArrayList<Double>();
        point.add(exterior.x);
        point.add(exterior.y);
        return point;
    }
}

