/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import com.geoway.onemap.stxf.utils.CoordinateReferenceUtil;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.MathTransform;

public class GeometryUtil {
    public static final double MixGeometryArea = 0.01;
    public static final double tolerance = 8.983153E-9;
    private static final double scale = Math.pow(10.0, 8.0);
    private static PrecisionModel precisionModel = new PrecisionModel(scale);
    private static GeometryFactory geometryFactory = new GeometryFactory(precisionModel, 4490);

    public static Geometry simplify(Geometry geometry) {
        Geometry newGeometry = geometry;
        if (!newGeometry.isValid()) {
            newGeometry = DouglasPeuckerSimplifier.simplify((Geometry)newGeometry, (double)8.983153E-9);
            newGeometry.setSRID(geometry.getSRID());
        }
        if (!newGeometry.isValid()) {
            newGeometry = TopologyPreservingSimplifier.simplify((Geometry)newGeometry, (double)8.983153E-9);
            newGeometry.setSRID(geometry.getSRID());
        }
        return newGeometry;
    }

    public static Geometry wkt2Geometry(String wkt) {
        WKTReader wktReader = new WKTReader();
        Geometry geom = null;
        try {
            geom = wktReader.read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException("Not a WKT string:" + wkt);
        }
        return geom;
    }

    public static String geometry2WKT(Geometry geom) {
        WKTWriter writer = new WKTWriter();
        return writer.write(geom);
    }

    public static Geometry intersection(Geometry geo1, Geometry geo2) {
        Geometry geo1Valid = GeometryUtil.simplify(geo1);
        Geometry geo2Valid = GeometryUtil.simplify(geo2);
        Geometry intersectGeo = null;
        try {
            intersectGeo = geo1Valid.intersection(geo2Valid);
        }
        catch (Exception e) {
            intersectGeo = geo2Valid.intersection(geo1Valid);
        }
        if (intersectGeo == null || intersectGeo.isEmpty()) {
            return null;
        }
        intersectGeo.setSRID(geo1Valid.getSRID());
        return intersectGeo;
    }

    public static Geometry intersectionEx(Geometry geo1, Geometry geo2) {
        Geometry geo2ValidCopy;
        Geometry geo1Valid = GeometryUtil.simplify(geo1);
        Geometry geo2Valid = GeometryUtil.simplify(geo2);
        Geometry geo1ValidCopy = geometryFactory.createGeometry(geo1Valid);
        Geometry intersectGeo = geo1ValidCopy.intersection(geo2ValidCopy = geometryFactory.createGeometry(geo2Valid));
        if (intersectGeo != null && !intersectGeo.isEmpty()) {
            intersectGeo.setSRID(geo1Valid.getSRID());
        } else {
            intersectGeo = null;
        }
        geo1ValidCopy = null;
        geo2ValidCopy = null;
        return intersectGeo;
    }

    public static Geometry union(Geometry geo1, Geometry geo2) {
        Geometry geo1Valid = GeometryUtil.simplify(geo1);
        Geometry geo2Valid = GeometryUtil.simplify(geo2);
        Geometry unionGeo = null;
        try {
            unionGeo = geo1Valid.union(geo2Valid);
        }
        catch (Exception e) {
            unionGeo = geo2Valid.union(geo1Valid);
        }
        if (unionGeo == null || unionGeo.isEmpty()) {
            return null;
        }
        unionGeo.setSRID(geo1Valid.getSRID());
        return unionGeo;
    }

    public static Geometry difference(Geometry geo1, Geometry geo2) {
        Geometry geo2Valid;
        Geometry geo1Valid = GeometryUtil.simplify(geo1);
        Geometry returnGeo = geo1Valid.difference(geo2Valid = GeometryUtil.simplify(geo2));
        if (returnGeo == null || returnGeo.isEmpty()) {
            return null;
        }
        returnGeo.setSRID(geo1Valid.getSRID());
        return returnGeo;
    }

    public static Geometry mergeCollection(Geometry geo, int dimension, int srid) {
        if (geo == null || geo.isEmpty() || geo.getDimension() != dimension) {
            return null;
        }
        Geometry resultGeo = null;
        for (int i = 0; i < geo.getNumGeometries(); ++i) {
            Geometry tempGeo = geo.getGeometryN(i);
            if (tempGeo == null || tempGeo.isEmpty() || tempGeo.getDimension() != dimension) continue;
            tempGeo.setSRID(srid);
            double tempArea = GeometryUtil.getProjectArea(tempGeo);
            if (dimension == 2 && tempArea < 0.01) continue;
            if (resultGeo == null) {
                resultGeo = tempGeo;
                continue;
            }
            resultGeo = resultGeo.union(tempGeo);
            resultGeo.setSRID(srid);
        }
        return resultGeo;
    }

    public static Geometry projectGeometry(Geometry geom, CoordinateReferenceSystem prjCSR) {
        try {
            CoordinateReferenceSystem srourceCRS = CoordinateReferenceUtil.getCoordinateReferenceSystemForSRID(geom.getSRID());
            if (srourceCRS == null) {
                System.out.println();
            }
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)srourceCRS, (CoordinateReferenceSystem)prjCSR);
            Geometry prjGeo = JTS.transform((Geometry)geom, (MathTransform)transform);
            return prjGeo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Geometry projectGeometry(Geometry geom, int tarSRID) {
        CoordinateReferenceSystem targetCRS = CoordinateReferenceUtil.getCoordinateReferenceSystemForSRID(geom.getSRID());
        return GeometryUtil.projectGeometry(geom, targetCRS);
    }

    public static boolean disjointEx(Geometry geo1, Geometry geo2) {
        Geometry geo1Valid = GeometryUtil.simplify(geo1);
        Geometry geo2Valid = GeometryUtil.simplify(geo2);
        Geometry geo1ValidCopy = geometryFactory.createGeometry(geo1Valid);
        Geometry geo2ValidCopy = geometryFactory.createGeometry(geo2Valid);
        return geo1ValidCopy.disjoint(geo2ValidCopy);
    }

    public static double getProjectArea(Geometry geom) {
        try {
            int srid = geom.getSRID();
            CoordinateReferenceSystem crs = CoordinateReferenceUtil.getCoordinateReferenceSystemForSRID(srid);
            if (crs instanceof ProjectedCRS) {
                return geom.getArea();
            }
            int[] lstDHs = GeometryUtil.caculateDH3(geom);
            if (lstDHs == null || lstDHs.length == 0) {
                return 0.0;
            }
            double totalArea = 0.0;
            for (int i = 0; i < lstDHs.length; ++i) {
                CoordinateReferenceSystem prjCSR = CoordinateReferenceUtil.getCoordinateReferenceSystemForDH(lstDHs[i]);
                if (prjCSR == null) continue;
                if (lstDHs.length == 1) {
                    Geometry prjGeometry = GeometryUtil.projectGeometry(geom, prjCSR);
                    prjGeometry.setSRID(CoordinateReferenceUtil.getSRID(lstDHs[i]));
                    totalArea = prjGeometry.getArea();
                    prjGeometry = null;
                    return totalArea;
                }
                Geometry dhPolygon = GeometryUtil.getDHPolygon(lstDHs[i], geom.getSRID());
                Geometry interGeom = geom.intersection(dhPolygon);
                if (interGeom == null || interGeom.isEmpty() || !interGeom.isValid()) {
                    dhPolygon = null;
                    continue;
                }
                interGeom.setSRID(geom.getSRID());
                Geometry prjGeometry = GeometryUtil.projectGeometry(interGeom, prjCSR);
                prjGeometry.setSRID(CoordinateReferenceUtil.getSRID(lstDHs[i]));
                double area = prjGeometry.getArea();
                interGeom = null;
                prjGeometry = null;
                totalArea += area;
            }
            lstDHs = null;
            return totalArea;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double getProjectArea(Geometry geom, int dh) {
        try {
            CoordinateReferenceSystem prjCSR = CoordinateReferenceUtil.getCoordinateReferenceSystemForDH(dh);
            Geometry prjGeometry = GeometryUtil.projectGeometry(geom, prjCSR);
            double area = prjGeometry.getArea();
            prjGeometry = null;
            return area;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double getProjectLength(Geometry geom) {
        try {
            int srid = geom.getSRID();
            CoordinateReferenceSystem crs = CoordinateReferenceUtil.getCoordinateReferenceSystemForSRID(srid);
            if (crs instanceof ProjectedCRS) {
                return geom.getLength();
            }
            int[] lstDHs = GeometryUtil.caculateDH3(geom);
            if (lstDHs == null || lstDHs.length == 0) {
                return 0.0;
            }
            double totalLength = 0.0;
            for (int i = 0; i < lstDHs.length; ++i) {
                CoordinateReferenceSystem prjCSR = CoordinateReferenceUtil.getCoordinateReferenceSystemForDH(lstDHs[i]);
                if (prjCSR == null) continue;
                if (lstDHs.length == 1) {
                    Geometry prjGeometry = GeometryUtil.projectGeometry(geom, prjCSR);
                    prjGeometry.setSRID(CoordinateReferenceUtil.getSRID(lstDHs[i]));
                    totalLength = prjGeometry.getLength();
                    prjGeometry = null;
                    return totalLength;
                }
                Geometry dhPolygon = GeometryUtil.getDHPolygon(lstDHs[i], geom.getSRID());
                Geometry interGeom = geom.intersection(dhPolygon);
                if (interGeom == null || interGeom.isEmpty() || !interGeom.isValid()) {
                    dhPolygon = null;
                    continue;
                }
                interGeom.setSRID(geom.getSRID());
                Geometry prjGeometry = GeometryUtil.projectGeometry(interGeom, prjCSR);
                prjGeometry.setSRID(CoordinateReferenceUtil.getSRID(lstDHs[i]));
                double length = prjGeometry.getLength();
                totalLength += length;
                dhPolygon = null;
                prjGeometry = null;
            }
            lstDHs = null;
            return totalLength;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double getProjectLength(Geometry geom, int dh) {
        try {
            CoordinateReferenceSystem prjCSR = CoordinateReferenceUtil.getCoordinateReferenceSystemForDH(dh);
            Geometry prjGeometry = GeometryUtil.projectGeometry(geom, prjCSR);
            double length = prjGeometry.getLength();
            prjGeometry = null;
            return length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private static int[] caculateDH3(Geometry geom) {
        Envelope geoEnv = geom.getEnvelopeInternal();
        int minDH = (int)((geoEnv.getMinX() + 1.5) / 3.0);
        int maxDH = (int)((geoEnv.getMaxX() + 1.5) / 3.0);
        int[] lstDH = new int[maxDH - minDH + 1];
        for (int i = minDH; i <= maxDH; ++i) {
            lstDH[i - minDH] = i;
        }
        return lstDH;
    }

    private static Geometry getDHPolygon(int dh, int srid) {
        double centerX = dh * 3;
        double xmin = centerX - 1.5;
        double xmax = centerX + 1.5;
        double ymin = 0.0;
        double ymax = 60.0;
        Coordinate p1 = new Coordinate(xmin, ymax);
        Coordinate p2 = new Coordinate(xmin, ymin);
        Coordinate p3 = new Coordinate(xmax, ymin);
        Coordinate p4 = new Coordinate(xmax, ymax);
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        Coordinate[] coords = new Coordinate[]{p1, p2, p3, p4, p1};
        LinearRing ring = geometryFactory.createLinearRing(coords);
        LinearRing[] holes = null;
        Polygon polygon = geometryFactory.createPolygon(ring, holes);
        polygon.setSRID(srid);
        return polygon;
    }

    public static Geometry BufferBlockGeometry(Geometry blockGeo, double bufferMeter) {
        Envelope blockEnv = blockGeo.getEnvelopeInternal();
        int blockDH = (int)(((blockEnv.getMinX() + blockEnv.getMaxX()) / 2.0 + 1.5) / 3.0);
        CoordinateReferenceSystem cgcs2000 = CoordinateReferenceUtil.getCoordinateReferenceSystemForSRID(4490);
        CoordinateReferenceSystem prjCSR = CoordinateReferenceUtil.getCoordinateReferenceSystemForDH(blockDH);
        int cgcs2000SRID = blockGeo.getSRID();
        int prjSRID = CoordinateReferenceUtil.getSRID(blockDH);
        Geometry prjGeometry = GeometryUtil.projectGeometry(blockGeo, prjCSR);
        prjGeometry.setSRID(prjSRID);
        String type = prjGeometry.getGeometryType();
        Geometry bufferGeoPrj = type.toUpperCase().equals("POINT") || type.toUpperCase().equals("MULTIPOINT") ? prjGeometry.buffer(bufferMeter) : prjGeometry.buffer(bufferMeter, 8, 2);
        bufferGeoPrj.setSRID(prjSRID);
        Geometry bufferGeo = GeometryUtil.projectGeometry(bufferGeoPrj, cgcs2000);
        bufferGeo.setSRID(cgcs2000SRID);
        bufferGeoPrj = null;
        prjGeometry = null;
        prjCSR = null;
        cgcs2000 = null;
        return bufferGeo;
    }
}

