/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import com.geoway.onemap.stxf.utils.ShpUtils;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class SRWKTTemplate {
    public static void main(String[] args) {
        try {
            ShpFiles sf = new ShpFiles(new File("D:\\temp\\JHK_XMFW\\65010220210001_JHK_XMFW.shp"));
            ShapefileReader r = new ShapefileReader(sf, false, false, new GeometryFactory());
            while (r.hasNext()) {
                ShapefileReader.Record record = r.nextRecord();
                Geometry shape = (Geometry)record.shape();
                int projNo = 29;
                MathTransform transform = SRWKTTemplate.findTransFormByLon(projNo);
                if (transform == null) continue;
                Geometry geomNew = JTS.transform((Geometry)shape, (MathTransform)transform);
                System.out.println(geomNew.toText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test() {
        try {
            String filePath = "D:\\temp\\JHK_XMFW\\65010220210001_JHK_XMFW.shp";
            Map<String, Object> mm = ShpUtils.getShpCRSInfo(filePath);
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            ShapefileDataStore shpDataStore = (ShapefileDataStore)dataStoreFactory.createDataStore(new File(filePath).toURI().toURL());
            shpDataStore.setCharset(Charset.forName("gb2312"));
            ContentFeatureSource simpleFeatureSource = shpDataStore.getFeatureSource();
            SimpleFeatureCollection simpleFeatureCollection = simpleFeatureSource.getFeatures();
            int featureSize = simpleFeatureCollection.size();
            SimpleFeatureIterator featureIterator = simpleFeatureCollection.features();
            if (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                List propertyList = (List)feature.getValue();
                for (Property property : propertyList) {
                    System.out.println("\u5c5e\u6027\u540d\u79f0\uff1a" + property.getName());
                    System.out.println("\u5c5e\u6027\u503c\uff1a" + property.getValue());
                    System.out.println("\u5c5e\u6027\u7c7b\u578b\uff1a" + property.getType());
                    System.out.println();
                }
                List featureAttributes = feature.getAttributes();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                int degressNo = Integer.parseInt(mm.get("degressno").toString());
                MathTransform transform = SRWKTTemplate.findTransFormByLon(degressNo);
                if (transform != null) {
                    Geometry geomNew = JTS.transform((Geometry)geometry, (MathTransform)transform);
                    System.out.println(geomNew.toText());
                }
                GeometryAttribute geometryAttribute = feature.getDefaultGeometryProperty();
                CoordinateReferenceSystem coordinateReferenceSystem = geometryAttribute.getDescriptor().getCoordinateReferenceSystem();
                GeometryType geometryType = geometryAttribute.getType();
                Name name = geometryType.getName();
                System.out.println("\u8981\u7d20\u6570\u91cf\uff1a" + featureSize);
                System.out.println("\u8981\u7d20\u5c5e\u6027\uff1a" + featureAttributes);
                System.out.println("\u8981\u7d20geometry\u4f4d\u7f6e\u4fe1\u606f\uff1a" + geometry.toText());
                System.out.println("\u8981\u7d20geometry\u7c7b\u578b\u540d\u79f0\uff1a" + name);
                System.out.println("shp\u6587\u4ef6\u4f7f\u7528\u7684\u5750\u6807\u53c2\u8003\u7cfb\uff1a\n" + coordinateReferenceSystem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MathTransform findTransFormByLon(int projNo) {
        if (projNo > 60) {
            return null;
        }
        String wkt = SRWKTTemplate.findCGS2000GaussPrjSRWKTWithPrjNo(projNo);
        MathTransform transform = null;
        try {
            CoordinateReferenceSystem destCRS = CRS.parseWKT((String)wkt);
            transform = CRS.findMathTransform((CoordinateReferenceSystem)destCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        return transform;
    }

    public static String findCGS2000GaussWithPrjNoWKTTemplate() {
        String srWkt = "PROJCS[\"CGCS2000_3_Degree_GK_Zone_%d\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",%d500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",%d],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]";
        return srWkt;
    }

    public static String findCGS2000GaussWKTTemplate() {
        String srWkt = "PROJCS[\"CGCS2000_3_Degree_CM__%d E\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",%d],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]";
        return srWkt;
    }

    public static String findXian80GaussWithPrjNoWKTTemplate() {
        String srWkt = "PROJCS[\"Xian80_3_Degree_GK_Zone_%d\",GEOGCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",6378140,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",%d500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",%d],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]";
        return srWkt;
    }

    public static String findXian80GaussWKTTemplate() {
        String srWkt = "PROJCS[\"Xian80_3_Degree_CM__%d E\",GEOGCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",6378140,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",%d],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]";
        return srWkt;
    }

    public static String findCGS2000GaussPrjSRWKTWithPrjNo(int projNo) {
        int centerlongitude = projNo * 3;
        String srWktTemplate = SRWKTTemplate.findCGS2000GaussWithPrjNoWKTTemplate();
        String srWKT = String.format(srWktTemplate, projNo, projNo, centerlongitude);
        return srWKT;
    }

    public static String findXian80GaussWithPrjNoWKTTemplate(int projNo) {
        int centerlongitude = projNo * 3;
        String srWktTemplate = SRWKTTemplate.findCGS2000GaussWithPrjNoWKTTemplate();
        String srWKT = String.format(srWktTemplate, projNo, projNo, centerlongitude);
        return srWKT;
    }
}

