/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.utils;

import com.geoway.onemap.stxf.utils.ResultSetInfo;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class SqlliteConnTool {
    private Connection connection = null;
    private String _dbPath;

    public SqlliteConnTool(String dbPath) {
        try {
            this._dbPath = dbPath;
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Dispose() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResultSetInfo doQuery(String sql) {
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        ResultSetInfo result = null;
        try {
            connection = this.CreateConnection();
            statement = this.CreateStatement(connection);
            resultSet = statement.executeQuery(sql);
            result = new ResultSetInfo(resultSet, statement);
            return result;
        }
        catch (SQLException e) {
            System.out.println(sql);
            System.out.println("Exception:" + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public int doSql(String sql) {
        int count = 0;
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.CreateConnection();
            statement = this.CreateStatement(connection);
            count = statement.executeUpdate(sql);
            this.closeAll(null, statement, null);
            return count;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return count;
        }
    }

    public Object queryScale(String sql) {
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        Object result = "";
        try {
            connection = this.CreateConnection();
            statement = this.CreateStatement(connection);
            resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                result = resultSet.getObject(1);
            }
            this.closeAll(null, statement, resultSet);
            return result;
        }
        catch (SQLException e) {
            System.out.println(sql);
            System.out.println("Exception:" + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public boolean isTableExist(String tableName) {
        String sql = "select count(*) from " + tableName + " where 1 = 2";
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.CreateConnection();
            statement = this.CreateStatement(connection);
            resultSet = statement.executeQuery(sql);
            this.closeAll(null, statement, resultSet);
            return true;
        }
        catch (SQLException e) {
            System.out.println(sql);
            System.out.println("Exception:" + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public ArrayList<String> getTables() {
        try {
            ArrayList<String> tables = new ArrayList<String>();
            String sql = "select name from sqlite_master where type='table' order by name";
            ResultSetInfo resultSetInfo = this.doQuery(sql);
            ResultSet resultSet = null;
            if (resultSetInfo != null) {
                resultSet = resultSetInfo.getResultSet();
                while (resultSet.next()) {
                    String tableName = resultSet.getString("name");
                    tables.add(tableName);
                }
                resultSetInfo.Close();
            }
            return tables;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    public void closeAll(Connection con, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static boolean isTableExists(Statement statement, String tableName) throws SQLException {
        String sql = String.format("select count(1) from sqlite_master where type = 'table' and name = '%s'", tableName);
        ResultSet rs = statement.executeQuery(sql);
        int iResult = 0;
        while (rs.next()) {
            iResult = rs.getInt(1);
        }
        return iResult > 0;
    }

    private Statement CreateStatement(Connection connection) {
        try {
            return connection.createStatement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Connection CreateConnection() {
        try {
            if (this.connection == null) {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + this._dbPath);
            }
            return this.connection;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

