/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.zbph.constant.base.EnumGdType;
import com.geoway.onemap.zbph.domain.base.TempBlock;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDkUseDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKSpatialDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKUseDetail;
import com.geoway.onemap.zbph.dto.base.SplitDTO;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKOutputDTO;
import com.geoway.onemap.zbph.service.base.BlockSplitService;
import com.geoway.onemap.zbph.service.base.TempBlockService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKSpatialDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDkUseDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKUseDetailService;
import com.geoway.onemap.zbph.supoort.GeoserverUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BlockSplitServiceImpl
implements BlockSplitService {
    @Autowired
    private TempBlockService zbkTempBlockService;
    @Autowired
    private GeoserverUtil geoserverUtil;
    @Autowired
    private ZBKDKSpatialDetailService zbkdkSpatialDetailService;
    @Autowired
    private ZBKDkUseDetailService zbkdkUseDetailService;
    @Autowired
    private ZBKUseDetailService zbkUseDetailService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, SplitDTO> blockSplit(List<SplitDTO> list) {
        List<String> zbIds = list.stream().map(m -> m.getZbId()).collect(Collectors.toList());
        ArrayList<TaskBlockDTO> taskList = new ArrayList<TaskBlockDTO>();
        ArrayList<String> deleteTemps = new ArrayList<String>();
        ArrayList<TempBlock> tempBlocks = new ArrayList<TempBlock>();
        Map rkMap = this.zbkdkSpatialDetailService.findByZbids(zbIds).stream().collect(Collectors.toMap(ZBKSpatialDetail::getDkid, Function.identity()));
        Map tempMap = this.zbkTempBlockService.findTempByZbids(zbIds).stream().collect(Collectors.toMap(TempBlock::getId, Function.identity()));
        double ratio = 0.0;
        double dkmj = 0.0;
        for (SplitDTO dto : list) {
            ZBKSpatialDetail detail = (ZBKSpatialDetail)rkMap.get(dto.getZbId());
            TempBlock tempBlock = (TempBlock)tempMap.get(dto.getZbId());
            dkmj = detail.getTbmj();
            if (tempBlock != null) {
                dkmj = tempBlock.getSymj();
            }
            ratio = dto.getArea() / dkmj;
            if ((ratio = BigDecimal.valueOf(ratio).setScale(6, 1).doubleValue()) < 1.0) {
                TaskBlockDTO taskBlockDTO = new TaskBlockDTO();
                taskBlockDTO.setDk_id(dto.getZbId());
                taskBlockDTO.setSplitRatio(ratio);
                taskBlockDTO.setWkt(detail.getShape().toText());
                taskBlockDTO.setWkid("4490");
                if (tempBlock != null) {
                    taskBlockDTO.setWkt(tempBlock.getShape().toText());
                } else {
                    tempBlock = new TempBlock(dto.getZbId());
                }
                tempBlock.setSymj(dkmj - dto.getArea());
                tempBlocks.add(tempBlock);
                taskList.add(taskBlockDTO);
                continue;
            }
            if (tempBlock != null) {
                dto.setWkt(tempBlock.getShape());
                deleteTemps.add(tempBlock.getId());
                tempMap.remove(tempBlock.getId());
                continue;
            }
            dto.setWkt(detail.getShape());
        }
        Map<String, SplitDTO> dtoMap = list.stream().collect(Collectors.toMap(SplitDTO::getZbId, Function.identity()));
        JSONObject object = null;
        JSONArray array = this.geoserverUtil.httpSplitByRatios(taskList);
        for (Object o : array) {
            object = (JSONObject)o;
            TaskBlockDTO ratioPart = (TaskBlockDTO)object.getObject("ratioPart", TaskBlockDTO.class);
            TaskBlockDTO unRatioPart = (TaskBlockDTO)object.getObject("unRatioPart", TaskBlockDTO.class);
            String dkId = object.getString("DK_ID");
            SplitDTO dto = dtoMap.get(dkId);
            dto.setWkt(GeoserverUtil.wktToGeo(ratioPart.getWkt()));
            TempBlock tempBlock = tempBlocks.stream().filter(f -> dkId.equals(f.getId())).findFirst().orElse(null);
            if (tempBlock == null) continue;
            tempBlock.setShape(GeoserverUtil.wktToGeo(unRatioPart.getWkt()));
        }
        this.zbkTempBlockService.saves(tempBlocks);
        if (deleteTemps.size() > 0) {
            this.zbkTempBlockService.deletes(deleteTemps);
        }
        return dtoMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void blockReduction(List<SplitDTO> list) {
        ArrayList<TempBlock> blocks = new ArrayList<TempBlock>();
        List<String> zbIds = list.stream().map(m -> m.getZbId()).collect(Collectors.toList());
        Map tempMap = this.zbkTempBlockService.findTempByZbids(zbIds).stream().collect(Collectors.toMap(TempBlock::getId, Function.identity()));
        for (SplitDTO dto : list) {
            TempBlock tempBlock = (TempBlock)tempMap.get(dto.getZbId());
            if (tempBlock == null) {
                tempBlock = new TempBlock();
                tempBlock.setId(dto.getZbId());
                tempBlock.setShape(dto.getWkt());
                tempBlock.setSymj(dto.getArea());
            } else {
                tempBlock.setSymj(tempBlock.getSymj() + dto.getArea());
                Geometry geometry = GeoserverUtil.unionGeometry(tempBlock.getShape(), dto.getWkt());
                tempBlock.setShape(geometry);
            }
            blocks.add(tempBlock);
        }
        this.zbkTempBlockService.saves(blocks);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, SplitDTO> blockSplitFromSytjdk(List<SplitDTO> list, String gdType) {
        TaskBlockDTO taskBlockDTO;
        ZBKDkUseDetail detailDk;
        ZBKUseDetail detail;
        double dkmj;
        double ratio;
        List<String> zbIds = list.stream().map(m -> m.getZbId()).collect(Collectors.toList());
        ArrayList<TaskBlockDTO> taskList = new ArrayList<TaskBlockDTO>();
        Map rkMap = this.zbkUseDetailService.findByZbids(zbIds).stream().collect(Collectors.toMap(ZBKUseDetail::getZbid, Function.identity()));
        Map rkDkMap = this.zbkdkUseDetailService.findByZbids(zbIds).stream().collect(Collectors.toMap(ZBKDkUseDetail::getZbid, Function.identity()));
        if (gdType.equalsIgnoreCase(EnumGdType.Gd.toValue())) {
            ratio = 0.0;
            dkmj = 0.0;
            for (SplitDTO dto : list) {
                detail = (ZBKUseDetail)rkMap.get(dto.getZbId());
                detailDk = (ZBKDkUseDetail)rkDkMap.get(dto.getZbId());
                dkmj = detail.getGdmj();
                if (detail.getGdmjsy() != null) {
                    dkmj = detail.getGdmjsy();
                }
                if (!(dto.getArea() > 0.0)) continue;
                dkmj = dto.getArea() + dkmj;
                ratio = dto.getArea() / dkmj;
                if ((ratio = BigDecimal.valueOf(ratio).setScale(6, 1).doubleValue()) < 1.0) {
                    taskBlockDTO = new TaskBlockDTO();
                    taskBlockDTO.setDk_id(dto.getZbId());
                    taskBlockDTO.setSplitRatio(ratio);
                    if (detailDk != null && detailDk.getGdShape() != null) {
                        taskBlockDTO.setWkt(detailDk.getGdShape().toText());
                    }
                    taskBlockDTO.setWkid("4490");
                    if (detailDk != null && detailDk.getGdShapeSy() != null) {
                        taskBlockDTO.setWkt(detailDk.getGdShapeSy().toText());
                    }
                    taskList.add(taskBlockDTO);
                    continue;
                }
                if (detailDk == null || detailDk.getGdShapeSy() == null) continue;
                dto.setWkt(detailDk.getGdShapeSy());
            }
        } else if (gdType.equalsIgnoreCase(EnumGdType.St.toValue())) {
            ratio = 0.0;
            dkmj = 0.0;
            for (SplitDTO dto : list) {
                detail = (ZBKUseDetail)rkMap.get(dto.getZbId());
                detailDk = (ZBKDkUseDetail)rkDkMap.get(dto.getZbId());
                dkmj = detail.getStmj();
                if (detail.getStmjsy() != null) {
                    dkmj = detail.getStmjsy();
                }
                if (!(dto.getArea() > 0.0)) continue;
                dkmj = dto.getArea() + dkmj;
                ratio = dto.getArea() / dkmj;
                if ((ratio = BigDecimal.valueOf(ratio).setScale(6, 1).doubleValue()) < 1.0) {
                    taskBlockDTO = new TaskBlockDTO();
                    taskBlockDTO.setDk_id(dto.getZbId());
                    taskBlockDTO.setSplitRatio(ratio);
                    taskBlockDTO.setWkid("4490");
                    if (detailDk != null && detailDk.getStShapeSy() != null) {
                        taskBlockDTO.setWkt(detailDk.getStShapeSy().toText());
                    }
                    taskList.add(taskBlockDTO);
                    continue;
                }
                if (detailDk == null || detailDk.getStShapeSy() == null) continue;
                dto.setWkt(detailDk.getStShapeSy());
            }
        } else if (gdType.equalsIgnoreCase(EnumGdType.Cn.toValue())) {
            ratio = 0.0;
            dkmj = 0.0;
            for (SplitDTO dto : list) {
                detail = (ZBKUseDetail)rkMap.get(dto.getZbId());
                detailDk = (ZBKDkUseDetail)rkDkMap.get(dto.getZbId());
                dkmj = detail.getCnzb();
                if (detail.getCnzbsy() != null) {
                    dkmj = detail.getCnzbsy();
                }
                if (!(dto.getArea() > 0.0)) continue;
                dkmj = dto.getArea() + dkmj;
                ratio = dto.getArea() / dkmj;
                if ((ratio = BigDecimal.valueOf(ratio).setScale(6, 1).doubleValue()) < 1.0) {
                    taskBlockDTO = new TaskBlockDTO();
                    taskBlockDTO.setDk_id(dto.getZbId());
                    taskBlockDTO.setSplitRatio(ratio);
                    taskBlockDTO.setWkid("4490");
                    if (detailDk != null && detailDk.getCnzbShapeSy() != null) {
                        taskBlockDTO.setWkt(detailDk.getCnzbShapeSy().toText());
                    }
                    taskList.add(taskBlockDTO);
                    continue;
                }
                if (detailDk == null || detailDk.getCnzbShapeSy() == null) continue;
                dto.setWkt(detailDk.getCnzbShapeSy());
            }
        }
        Map<String, SplitDTO> dtoMap = list.stream().collect(Collectors.toMap(SplitDTO::getZbId, Function.identity()));
        JSONObject object = null;
        if (taskList.size() > 0) {
            JSONArray array = this.geoserverUtil.httpSplitByRatios(taskList);
            for (Object o : array) {
                object = (JSONObject)o;
                TaskBlockDTO ratioPart = (TaskBlockDTO)object.getObject("ratioPart", TaskBlockDTO.class);
                TaskBlockDTO unRatioPart = (TaskBlockDTO)object.getObject("unRatioPart", TaskBlockDTO.class);
                String dkId = object.getString("DK_ID");
                SplitDTO dto = dtoMap.get(dkId);
                dto.setWkt(GeoserverUtil.wktToGeo(ratioPart.getWkt()));
            }
        }
        return dtoMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ZBKOutputDTO> blockSplitForOutputDk(List<ZBKOutputDTO> outputDTOS) {
        ArrayList<ZBKOutputDTO> ZBKOutputDTOResult = new ArrayList<ZBKOutputDTO>();
        if (outputDTOS != null && outputDTOS.size() > 0) {
            ArrayList<SplitDTO> gdList = new ArrayList<SplitDTO>();
            ArrayList<SplitDTO> stList = new ArrayList<SplitDTO>();
            ArrayList<SplitDTO> cnList = new ArrayList<SplitDTO>();
            Map<Object, Object> gdSplitMap = new HashMap();
            Map<Object, Object> stSplitMap = new HashMap();
            Map<Object, Object> cnSplitMap = new HashMap();
            for (ZBKOutputDTO zbkOutputDTO : outputDTOS) {
                if (zbkOutputDTO.getGdmj() > 0.0) {
                    SplitDTO gd = new SplitDTO();
                    gd.setZbId(zbkOutputDTO.getZbid());
                    gd.setArea(zbkOutputDTO.getGdmj());
                    gdList.add(gd);
                }
                if (zbkOutputDTO.getStmj() > 0.0) {
                    SplitDTO st = new SplitDTO();
                    st.setZbId(zbkOutputDTO.getZbid());
                    st.setArea(zbkOutputDTO.getStmj());
                    stList.add(st);
                }
                if (!(zbkOutputDTO.getCnzb() > 0.0)) continue;
                SplitDTO cn = new SplitDTO();
                cn.setZbId(zbkOutputDTO.getZbid());
                cn.setArea(zbkOutputDTO.getCnzb());
                cnList.add(cn);
            }
            if (gdList.size() > 0) {
                gdSplitMap = this.blockSplitFromSytjdk(gdList, EnumGdType.Gd.toValue());
            }
            if (stList.size() > 0) {
                stSplitMap = this.blockSplitFromSytjdk(stList, EnumGdType.St.toValue());
            }
            if (cnList.size() > 0) {
                cnSplitMap = this.blockSplitFromSytjdk(cnList, EnumGdType.Cn.toValue());
            }
            for (ZBKOutputDTO zbkOutputDTO : outputDTOS) {
                SplitDTO cnSplitDTO;
                SplitDTO stSplitDTO;
                SplitDTO gdSplitDTO;
                String zbid = zbkOutputDTO.getZbid();
                if (gdSplitMap.get(zbid) != null && (gdSplitDTO = (SplitDTO)gdSplitMap.get(zbid)).getWkt() != null) {
                    zbkOutputDTO.setGdShape(gdSplitDTO.getWkt());
                }
                if (stSplitMap.get(zbid) != null && (stSplitDTO = (SplitDTO)stSplitMap.get(zbid)).getWkt() != null) {
                    zbkOutputDTO.setStShape(stSplitDTO.getWkt());
                }
                if (cnSplitMap.get(zbid) != null && (cnSplitDTO = (SplitDTO)cnSplitMap.get(zbid)).getWkt() != null) {
                    zbkOutputDTO.setCnzbShape(cnSplitDTO.getWkt());
                }
                ZBKOutputDTOResult.add(zbkOutputDTO);
            }
        }
        return ZBKOutputDTOResult;
    }
}

