/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.stxf.utils.FileUnZipRar;
import com.geoway.onemap.stxf.utils.ShpUtils;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.dto.base.GraphicAnalysisDTO;
import com.geoway.onemap.zbph.service.base.GraphicAnalysisService;
import com.geoway.onemap.zbph.supoort.ExceptionCustomUtil;
import com.geoway.onemap.zbph.supoort.GeoserverUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GraphicAnalysisServiceImpl
implements GraphicAnalysisService {
    @Value(value="${project.xzgdfw.field:}")
    protected String xzgdfwField;
    @Autowired
    private GeoserverUtil geoserverUtil;

    @Override
    public GraphicAnalysisDTO analysis(MultipartFile mfile, String type) throws Exception {
        GraphicAnalysisDTO dto = new GraphicAnalysisDTO();
        ExceptionCustomUtil.isNull(mfile, "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String fileName = mfile.getOriginalFilename();
        String suf = fileName.substring(fileName.lastIndexOf(".") + 1);
        String tempFileName = ConfigConstant.FileConfig.uploadDir + File.separator + "txjx" + File.separator + UUID.randomUUID() + File.separator + fileName;
        File tempFile = new File(tempFileName);
        tempFile.mkdirs();
        try {
            mfile.transferTo(tempFile);
            Map map = new HashMap();
            if ("txt".equals(suf)) {
                map = this.txtManage(ShpUtils.readTxt2WKT(tempFile));
            } else if ("zip".equals(suf)) {
                String destName = tempFileName.toLowerCase().replace(".zip", "");
                FileUnZipRar.unZipFiles(tempFileName, destName);
                File dir = new File(destName);
                String shpPath = FileUnZipRar.seachFirstFileBySuffix(dir);
                String prjPath = FileUnZipRar.seachFirstPrjBySuffix(dir);
                String cpgPath = FileUnZipRar.seachFirstCpgBySuffix(dir);
                ExceptionCustomUtil.isNull(shpPath, "\u538b\u7f29\u5305\u4e2d\u6ca1\u627e\u5230\u6709\u6548 .shp \u6587\u4ef6\uff01");
                ExceptionCustomUtil.isNull(prjPath, "\u538b\u7f29\u5305\u4e2d\u7f3a\u5c11\u7a7a\u95f4\u5b9a\u4e49 .prj \u6587\u4ef6\uff01\uff01");
                this.verifyProjcs(prjPath);
                List<String> propList = null;
                if (StrUtil.isNotEmpty((CharSequence)this.xzgdfwField)) {
                    propList = Arrays.asList(this.xzgdfwField.replaceAll(" ", "").split(","));
                }
                map = this.shpManage(ShpUtils.readValidShp2WKT2(shpPath, prjPath, cpgPath, propList), type);
                FileUtil.del((File)dir);
            } else {
                throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u7c7b\u578b\uff01");
            }
            dto.setGeoJsonMap(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errMsg = e.getMessage();
            if (errMsg.indexOf("LinearRing") > 0) {
                errMsg = "\u9762\u72b6\u56fe\u5f62\u5750\u6807\u6709\u4e0d\u5c01\u95ed\u60c5\u51b5\uff0c\u8bf7\u6838\u5b9e\uff01";
            }
            throw new RuntimeException(errMsg);
        }
        dto.setFileName(fileName);
        dto.setFileType(suf);
        dto.setCreatePath(tempFile.getAbsolutePath().substring(ConfigConstant.FileConfig.uploadDir.length()));
        return dto;
    }

    @Override
    public List<JSONObject> queryRepeatBlocks(List<String> wkts) {
        return this.queryRepeatBlocks(wkts, "zygd");
    }

    @Override
    public List<JSONObject> queryRepeatBlocks(final List<String> wkts, String type) {
        if (!ConfigConstant.TbrkConfig.blockRepeatVerify.booleanValue()) {
            return Collections.emptyList();
        }
        String serviceName = this.getServiceName(type);
        final AtomicInteger index = new AtomicInteger(1);
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("Blocks", wkts.stream().map(m -> TaskBlockDTO.builder().wkt((String)m).wkid("4490").dk_id(String.valueOf(index.incrementAndGet())).build()).collect(Collectors.toList()));
                this.put("ApplicationGUID", ConfigConstant.GeoServerConfig.Service_Key);
            }
        };
        JSONObject object = this.geoserverUtil.httpCreateByType(serviceName, "yzfx", JSON.toJSONString((Object)map));
        return object.getJSONArray("Results").toJavaList(JSONObject.class);
    }

    private String getServiceName(String type) {
        return ConfigConstant.GeoServerConfig.Block_verify_zgck;
    }

    private Map txtManage(Map<String, JSONObject> map) {
        return (Map)map.get("geoJsonMap");
    }

    private Map shpManage(Map<String, Object> map, String type) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList result = new ArrayList();
        List list = (List)map.get("properties");
        for (Map res : list) {
            HashMap hashMap = new HashMap();
            if ("zygdfw".equals(type)) {
                hashMap.put("wkt", res.get("wkt"));
                hashMap.put("dkmj", this.toDouble(res.get("dkmj")));
                hashMap.put("dkbh", res.get("dkbh"));
                hashMap.put("dkmc", res.get("dkmc"));
                hashMap.put("tfh", res.get("tfh"));
                hashMap.put("yuliu", res.get("tbdlmj"));
                hashMap.put("gddb", res.get("gjlyd"));
                hashMap.put("tblx", res.get("dlmc"));
                hashMap.put("dkyt", res.get("dkyt"));
                hashMap.put("jzds", res.get("jzds"));
                hashMap.put("txsx", res.get("txsx"));
                hashMap.put("DKAREA", res.get("DKAREA"));
                hashMap.put("dlbm", res.get("dlbm"));
                hashMap.put("gzqpjzldb", this.toInt(res.get("gddb")));
                hashMap.put("gzhpjzldb", this.toInt(res.get("gdpdjb")));
            } else {
                hashMap.put("wkt", res.get("wkt"));
                hashMap.put("dkbh", res.get("DIKUAI_NO"));
                hashMap.put("dkmc", res.get("PL_NAME"));
                hashMap.put("dkmj", this.toDouble(res.get("DIKUAIAREA")));
                hashMap.put("dkyt", res.get("PURPOSE"));
                hashMap.put("tfh", res.get("MAP_NO"));
                hashMap.put("txsx", res.get("TXSX"));
                hashMap.put("xmq".equals(type) ? "bz" : "yuliu", res.get("BZ"));
                if (!"xmq".equals(type)) {
                    hashMap.put("tblx", res.get("PATCHTYPE"));
                    hashMap.put("dlbm", res.get("LANDTYPE"));
                    hashMap.put("gzqpjzldb", this.toInt(res.get("AVGGRADE1")));
                    hashMap.put("gzhpjzldb", this.toInt(res.get("AVGGRADE2")));
                }
            }
            result.add(hashMap);
        }
        resultMap.put("geometries", result);
        resultMap.put("\u5750\u6807\u7cfb", "2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb");
        resultMap.put("\u51e0\u5ea6\u5206\u5e26", "3");
        resultMap.put("\u8ba1\u91cf\u5355\u4f4d", null);
        resultMap.put("\u6570\u636e\u4ea7\u751f\u5355\u4f4d", null);
        resultMap.put("\u8f6c\u6362\u53c2\u6570", null);
        resultMap.put("\u7cbe\u5ea6", null);
        resultMap.put("\u683c\u5f0f\u7248\u672c\u53f7", null);
        resultMap.put("\u6295\u5f71\u7c7b\u578b", null);
        resultMap.put("\u5e26\u53f7", null);
        resultMap.put("\u6570\u636e\u4ea7\u751f\u65e5\u671f", null);
        return resultMap;
    }

    private Double toDouble(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof String) {
            return Double.valueOf((String)obj);
        }
        return ((BigDecimal)obj).doubleValue();
    }

    private Integer toInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Double) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            if (StringUtils.isEmpty((CharSequence)((String)obj))) {
                return 0;
            }
            return Integer.valueOf((String)obj);
        }
        return ((BigDecimal)obj).intValue();
    }

    private void verifyProjcs(String filePath) {
        if (!ConfigConstant.TbrkConfig.verifyProjcs.booleanValue()) {
            return;
        }
        try {
            Path path = Paths.get(filePath, new String[0]);
            List<String> list = Files.readAllLines(path);
            for (String s : list) {
                if (!s.contains("PROJC")) continue;
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u5e73\u9762\u76f4\u89d2\u5750\u6807\u683c\u5f0f\u6587\u4ef6\uff01");
    }
}

