/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import com.geoway.onemap.zbph.dao.base.ProcesStateDictRepository;
import com.geoway.onemap.zbph.domain.base.ProcessStateDict;
import com.geoway.onemap.zbph.service.base.ProcessStateDictService;
import com.google.api.client.util.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;
import org.springframework.web.context.support.ServletRequestHandledEvent;

@Service
public class ProcessStateDictServiceImpl
implements ProcessStateDictService,
ApplicationListener<ServletRequestHandledEvent> {
    @Autowired
    private ProcesStateDictRepository procesStateDictRepository;
    private ThreadLocal<List<ProcessStateDict>> threadDicts = new ThreadLocal();

    @Override
    public List<ProcessStateDict> findAll() {
        if (this.threadDicts.get() == null) {
            this.threadDicts.set(Lists.newArrayList((Iterable)this.procesStateDictRepository.findAll()));
        }
        return this.threadDicts.get();
    }

    @Override
    public ProcessStateDict findByState(String state) {
        List<ProcessStateDict> dictList = this.findAll();
        return dictList.stream().filter(f -> f.getProcessState().toUpperCase().equals(state.toUpperCase())).findFirst().orElse(null);
    }

    public void onApplicationEvent(ServletRequestHandledEvent event) {
        this.threadDicts.set(null);
    }
}

