/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.xfsbcgdlx.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.excel.util.IoUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.metadata.service.ModelFieldsService;
import com.geoway.onemap.core.domain.system.SimpleRole;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.stxf.dto.TaskXmxxDTO;
import com.geoway.onemap.stxf.service.BaseFileService;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.EnumLshType;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.domain.base.BaseCheckDetail;
import com.geoway.onemap.zbph.domain.base.ProcessStep;
import com.geoway.onemap.zbph.domain.base.ProcessTaskEvent;
import com.geoway.onemap.zbph.domain.xfsbcgdlx.XfsbcgdLxXmfw;
import com.geoway.onemap.zbph.domain.xfsbcgdlx.XfsbcgdLxXmxx;
import com.geoway.onemap.zbph.domain.xfsbcgdlx.XfsbcgdLxXzgdfw;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXmxx;
import com.geoway.onemap.zbph.dto.wyhc.BusinessPushDTO;
import com.geoway.onemap.zbph.dto.xfsbcgdlx.XfsbcgdlxDTO;
import com.geoway.onemap.zbph.service.base.BaseCheckService;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.service.base.DataVerifyTaskService;
import com.geoway.onemap.zbph.service.base.ProcessInstanceService;
import com.geoway.onemap.zbph.service.base.impl.AbstractXmxxManagerServiceImpl;
import com.geoway.onemap.zbph.service.wyhc.BusinessVerifyPushService;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxManageService;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxXmfwService;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxXmxxService;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxXzgdfwService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXmxxService;
import com.geoway.onemap.zbph.supoort.EasyShpUtil;
import com.geoway.onemap.zbph.supoort.ExceptionCustomUtil;
import com.geoway.onemap.zbph.supoort.PFWHUtil;
import com.geoway.onemap.zbph.supoort.TempFileUtil;
import com.geoway.zhgd.domain.BaseFile;
import com.geoway.zhgd.domain.VerifyTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jodd.io.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class XfsbcgdLxManageServiceImpl
extends AbstractXmxxManagerServiceImpl<XfsbcgdlxDTO, XfsbcgdLxXmxx, XfsbcgdLxXmxxService>
implements XfsbcgdLxManageService {
    @Value(value="${project.fxfw.service.lx:'GDZBPH_LX'}")
    private String serviceName;
    @Autowired
    private XfsbcgdLxXmxxService xmxxService;
    @Autowired
    private XfsbcgdLxXmfwService xmfwService;
    @Autowired
    private XfsbcgdLxXzgdfwService xzgdfwService;
    @Autowired
    private BaseFileService baseFileService;
    @Autowired
    private BusinessVerifyPushService businessVerifyPushService;
    @Autowired
    private DataVerifyTaskService dataVerifyTaskService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private BaseCheckService baseCheckService;
    @Autowired
    private XfsbcgdYsXmxxService ysXmxxService;
    @Autowired
    private BaseLshService sidService;
    @Autowired
    private ModelFieldsService modelFieldsService;

    public XfsbcgdLxManageServiceImpl(XfsbcgdLxXmxxService service) {
        super(service);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdate(XfsbcgdlxDTO dto, SysUser sysUser) {
        PFWHUtil.ValidationResult validationResult;
        if (ConfigConstant.PfwhConfig.verify && !(validationResult = PFWHUtil.validate(((XfsbcgdLxXmxx)dto.getXmxx()).getPfwh(), DateUtil.year((Date)((XfsbcgdLxXmxx)dto.getXmxx()).getPfrq()))).isValid()) {
            throw new RuntimeException(validationResult.getMessage());
        }
        XfsbcgdLxXmxx xmxx = (XfsbcgdLxXmxx)dto.getXmxx();
        xmxx.setUpdateDate(DateUtil.now());
        XfsbcgdLxXmxx xfsbcgdLxXmxx = (XfsbcgdLxXmxx)this.xmxxService.findByName(xmxx.getXmmc());
        if (StringUtils.isEmpty((CharSequence)xmxx.getXmid())) {
            ExceptionCustomUtil.isNotNull(xfsbcgdLxXmxx, "\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            xmxx.setLsh(this.sidService.generateLsh(sysUser.getXzqdm(), EnumLshType.BCGDLX, xmxx.getPfrq()));
        } else {
            XfsbcgdLxXmxx lxXmxx = (XfsbcgdLxXmxx)this.xmxxService.findById(xmxx.getXmid());
            if (!lxXmxx.getXmmc().equals(xmxx.getXmmc())) {
                ExceptionCustomUtil.isNotNull(xfsbcgdLxXmxx, "\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            if (lxXmxx.getPfrq().getYear() != xmxx.getPfrq().getYear()) {
                xmxx.setLsh(this.sidService.generateLsh(sysUser.getXzqdm(), EnumLshType.BCGDLX, xmxx.getPfrq()));
            }
        }
        if (dto.getXzgdfwList().stream().anyMatch(f -> StringUtils.isEmpty((CharSequence)f.getId()))) {
            xmxx.setIswy(0.0);
        }
        this.xmxxService.saveOrUpdate(xmxx, sysUser);
        if (dto.getXmfwList() != null) {
            dto.getXmfwList().stream().forEach(f -> {
                f.setXmid(xmxx.getXmid());
                f.setXzqdm(xmxx.getXmXzqdm());
                f.setXzqmc(xmxx.getXmXzqmc());
                f.setJbxxXmmc(xmxx.getXmmc());
                f.setJbxxXzqdm(xmxx.getXmXzqdm());
                f.setJbxxXzqmc(xmxx.getXmXzqdm());
                f.setYsXmbh(xmxx.getLsh());
            });
            this.xmfwService.saveCover(dto.getXmfwList());
        }
        if (dto.getXzgdfwList() != null) {
            dto.getXzgdfwList().stream().forEach(f -> {
                f.setXmid(xmxx.getXmid());
                f.setXzqdm(xmxx.getXmXzqdm());
                f.setXzqmc(xmxx.getXmXzqmc());
                f.setJbxxXmmc(xmxx.getXmmc());
                f.setYsXmbh(xmxx.getLsh());
            });
            this.xzgdfwService.saveCover(dto.getXzgdfwList());
        }
        if (dto.getFjList() != null) {
            for (BaseFile file : dto.getFjList()) {
                if (StringUtils.isNotBlank((CharSequence)file.getId())) continue;
                file.setRelationId(xmxx.getXmid());
                this.baseFileService.fileManage(file, sysUser);
            }
            this.baseFileService.saveCover(dto.getFjList());
        }
        return xmxx.getXmid();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByXmid(String id) {
        XfsbcgdLxXmxx xmxx = (XfsbcgdLxXmxx)this.xmxxService.findById(id);
        XfsbcgdYsXmxx one = (XfsbcgdYsXmxx)this.ysXmxxService.findOne("Q_f_lx_code_S_EQ=" + xmxx.getXmbh());
        ExceptionCustomUtil.isNotNull(one, "\u8be5\u9879\u76ee\u5df2\u6302\u63a5\u81f3\u9a8c\u6536\u9879\u76ee\u3010" + one.getXmmc() + "\u3011\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        this.baseCheckService.deleteByProcessId(xmxx.getProcessId());
        this.xmfwService.deleteByPid(id);
        this.xzgdfwService.deleteByPid(id);
        this.dataVerifyTaskService.deleteByPid(id);
        this.xmxxService.deleteByXmid(id);
    }

    @Override
    public void verifyManage(VerifyTask verifyTask) {
        Integer status = verifyTask.getStatus();
        String pid = verifyTask.getPid();
        XfsbcgdLxXmxx xmxx = (XfsbcgdLxXmxx)this.xmxxService.findById(pid);
        SysUser sysUser = this.getUser(xmxx.getXzqdm(), "\u6570\u636e\u6821\u9a8c-\u7cfb\u7edf", xmxx.getProcessId());
        Integer ruleStatus = verifyTask.getRuleStatus();
        if (status == 200 && ruleStatus == 1) {
            this.xmxxService.pass(Arrays.asList(xmxx.getXmid().split(",")), sysUser, "\u6570\u636e\u67e5\u9a8c\u901a\u8fc7", "", "", null);
        } else {
            this.xmxxService.refuse(Arrays.asList(xmxx.getXmid().split(",")), sysUser, "\u6570\u636e\u67e5\u9a8c\u4e0d\u901a\u8fc7", "", "", null);
        }
    }

    @Override
    public XfsbcgdlxDTO detailByXmid(String id) {
        XfsbcgdlxDTO dto = new XfsbcgdlxDTO();
        XfsbcgdLxXmxx xmxx = (XfsbcgdLxXmxx)this.xmxxService.findById(id);
        List<XfsbcgdLxXmfw> xmfws = this.xmfwService.findByPid(id);
        List<XfsbcgdLxXzgdfw> xzgdfws = this.xzgdfwService.findByPid(id);
        List<BaseFile> baseFileList = this.baseFileService.findByRelationId(id);
        List<BaseCheckDetail> checkDetails = this.baseCheckService.findByProcessId(xmxx.getProcessId());
        dto.setXmxx(xmxx);
        dto.setXmfwList(xmfws);
        dto.setXzgdfwList(xzgdfws);
        dto.setFjList(baseFileList);
        dto.setCheckList(checkDetails);
        return dto;
    }

    @Override
    public void dataVerify(String id) {
        XfsbcgdlxDTO detail = this.detailByXmid(id);
        TaskXmxxDTO xxmx = new TaskXmxxDTO();
        xxmx.setXmlx(((XfsbcgdLxXmxx)detail.getXmxx()).getType());
        xxmx.setXmjszgm(((XfsbcgdLxXmxx)detail.getXmxx()).getJhjszgm());
        SimpleDateFormat sbf = new SimpleDateFormat("yyyy-MM-dd");
        xxmx.setLxsj(sbf.format(((XfsbcgdLxXmxx)detail.getXmxx()).getPfrq()));
        xxmx.setXzgdmj(((XfsbcgdLxXmxx)detail.getXmxx()).getJhxzgdmj());
        xxmx.setXzstmj(((XfsbcgdLxXmxx)detail.getXmxx()).getJhxzstmj());
        xxmx.setXzsjdmj(((XfsbcgdLxXmxx)detail.getXmxx()).getJhxzsjdmj());
        xxmx.setTzgzgdmj(((XfsbcgdLxXmxx)detail.getXmxx()).getJhtzgzgdmj());
        xxmx.setTzgzstmj(((XfsbcgdLxXmxx)detail.getXmxx()).getJhtzgzstmj());
        List<TaskBlockDTO> xmq = detail.getXmfwList().stream().map(m -> {
            TaskBlockDTO dto = new TaskBlockDTO();
            dto.setWkt(m.getShape().toText());
            dto.setDk_id("1");
            Map map = BeanUtil.beanToMap((Object)m, (String[])new String[0]);
            map.put("isAnalysis", false);
            map.put("xmdklx", "xmq");
            map.remove("shape");
            dto.setAttributes(map);
            return dto;
        }).collect(Collectors.toList());
        List gdfw = detail.getXzgdfwList().stream().map(m -> {
            TaskBlockDTO dto = new TaskBlockDTO();
            dto.setWkt(m.getShape().toText());
            dto.setDk_id(UUID.randomUUID().toString());
            Map map = BeanUtil.beanToMap((Object)m, (String[])new String[0]);
            map.put("isImage", false);
            map.remove("shape");
            dto.setAttributes(map);
            return dto;
        }).collect(Collectors.toList());
        xmq.addAll(gdfw);
        Map map = BeanUtil.beanToMap((Object)xxmx, (String[])new String[0]);
        Class<?> aClass = this.getClass();
        this.dataVerifyTaskService.createTask(map, xmq, null, this.serviceName, VerifyTask.builder().pid(id).type(XmxxType.LX.type).customClass(aClass.getName()).build());
    }

    @Override
    public XfsbcgdlxDTO detailByXmbh(String xmbh) {
        XfsbcgdLxXmxx xmxx = this.xmxxService.findByXmbh(xmbh);
        return this.detailByXmid(xmxx.getXmid());
    }

    @Override
    public void exportShp(String xmid, HttpServletResponse response) {
        List<XfsbcgdLxXmfw> lxXmfws = this.xmfwService.findByPid(xmid);
        List<XfsbcgdLxXzgdfw> lxXzgdfws = this.xzgdfwService.findByPid(xmid);
        if (lxXmfws.size() == 0 || lxXzgdfws.size() == 0) {
            throw new RuntimeException("\u672a\u4e0a\u4f20\u9879\u76ee\u8303\u56f4\u6216\u8005\u8865\u5145\u8015\u5730\u8303\u56f4\uff01");
        }
        TempFileUtil tempFileUtil = (TempFileUtil)SpringContextUtil.getBean(TempFileUtil.class);
        File tempFile = tempFileUtil.getTempDir();
        EasyShpUtil<Serializable> easyShpUtil = new EasyShpUtil<Serializable>();
        String xmmc = lxXmfws.get(0).getJbxxXmmc();
        try {
            easyShpUtil.write(lxXmfws, xmmc + "\u9879\u76ee\u8303\u56f4", tempFile.getPath());
            easyShpUtil.write(lxXzgdfws, xmmc + "\u8865\u5145\u8015\u5730\u8303\u56f4\u8303\u56f4", tempFile.getPath());
            File zipFile = ZipUtil.zip((String)tempFile.getPath(), (String)(tempFile.getPath() + xmmc + ".zip"), (Charset)Charset.forName("UTF-8"), (boolean)false);
            response.setContentType("application/zip");
            response.setCharacterEncoding("utf-8");
            String utf8fileName = URLEncoder.encode(xmmc, "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + utf8fileName + ".zip");
            ServletOutputStream myout = response.getOutputStream();
            FileInputStream input = new FileInputStream(zipFile);
            myout.write(IoUtils.toByteArray((InputStream)input));
            ((InputStream)input).close();
            myout.flush();
            myout.close();
            FileUtil.deleteDir((File)tempFile);
            FileUtil.deleteFile((String)(tempFile.getPath() + xmmc + ".zip"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165shp\u5931\u8d25");
        }
    }

    @Override
    public void notify(ProcessTaskEvent event) {
        String type;
        XfsbcgdLxXmxx xmxx = (XfsbcgdLxXmxx)this.xmxxService.findByProcessId(event.getInstance().getId());
        String tag = event.getTag();
        JSONObject object = JSON.parseObject((String)tag);
        String string = type = object == null ? "cy" : object.getString("type");
        if ("wy".equals(type)) {
            Boolean isReuse = object.getBoolean("isReuse");
            this.generateJhkGty(xmxx.getXmid(), event.getSysUser(), isReuse);
        } else {
            String comemnt = event.getComemnt();
            if (comemnt == null || comemnt.equals("\u6570\u636e\u67e5\u9a8c")) {
                this.dataVerify(xmxx.getXmid());
            }
        }
    }

    @Override
    public void notify(List<ProcessTaskEvent> processTaskEvent) {
        processTaskEvent.forEach(f -> this.notify((ProcessTaskEvent)f));
    }

    private void generateJhkGty(String xmid, SysUser user, Boolean isReuse) {
        XfsbcgdlxDTO detail = this.detailByXmid(xmid);
        XfsbcgdLxXmxx xmxx = (XfsbcgdLxXmxx)detail.getXmxx();
        Double iswy = xmxx.getIswy();
        if (iswy != 0.0) {
            if (isReuse.booleanValue()) {
                this.xmxxService.forcePass(Arrays.asList(xmid.split(",")), user, "\u6210\u679c\u590d\u7528", "", "", "");
                return;
            }
            this.xmxxService.updateWy(xmid, 0.0);
        }
        try {
            this.businessVerifyPushService.generateStart(BusinessPushDTO.builder().xmid(xmid).type(XmxxType.LX.gtyType).build());
        }
        catch (Exception e) {
            throw new RuntimeException("\u5916\u4e1a\u6838\u67e5\u5931\u8d25\uff1a" + e);
        }
    }

    private SysUser getUser(String xzqdm, String name, String processId) {
        ProcessStep processStep = this.processInstanceService.getCurrentStep(processId);
        SysUser sysUser = new SysUser();
        sysUser.setAlisname(name);
        sysUser.setUsername(name);
        sysUser.setXzqdm(xzqdm);
        sysUser.setId(name);
        HashSet<SimpleRole> roles = new HashSet<SimpleRole>();
        SimpleRole simpleRole = new SimpleRole();
        simpleRole.setRolename(processStep.getRelatedRoles().get(0));
        roles.add(simpleRole);
        sysUser.setRoles(roles);
        return sysUser;
    }
}

