/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.xfstbrk.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.EnumStatType;
import com.geoway.onemap.zbph.constant.base.EnumStatusType;
import com.geoway.onemap.zbph.dao.xfsgdtbrk.XfsgdtbrkBxtRepository;
import com.geoway.onemap.zbph.domain.base.BaseTaskManage;
import com.geoway.onemap.zbph.domain.xfsgdtbrk.ZbkTbrkDetail;
import com.geoway.onemap.zbph.domain.xfsgdtbrk.ZbkTbrkDetailBxt;
import com.geoway.onemap.zbph.dto.xfstbrk.TbrkInputDataCheckValidInfo;
import com.geoway.onemap.zbph.dto.xfstbrk.TbrkTaskParam;
import com.geoway.onemap.zbph.dto.xfstbrk.ZbkTbrkDTO;
import com.geoway.onemap.zbph.service.base.BaseTaskManageService;
import com.geoway.onemap.zbph.service.base.impl.AbstractXmxxManagerServiceImpl;
import com.geoway.onemap.zbph.service.xfstbrk.ZbkTbrkDetailService;
import com.geoway.onemap.zbph.service.xfstbrk.ZbkTbrkManagerService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKConfigDetailService;
import com.geoway.onemap.zbph.supoort.EasyExcelUtil;
import com.geoway.onemap.zbph.supoort.EasyShpUtil;
import com.geoway.onemap.zbph.supoort.TempFileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ZbkTbrkManagerServiceImpl
extends AbstractXmxxManagerServiceImpl<ZbkTbrkDTO, ZbkTbrkDetail, ZbkTbrkDetailService>
implements ZbkTbrkManagerService {
    @Value(value="${project.uploadDir:''}")
    private String uploadPath;
    @Autowired
    private ZBKConfigDetailService zbkConfigDetailService;
    @Autowired
    private BaseTaskManageService baseTaskManageService;
    @Autowired
    XfsgdtbrkBxtRepository xfsgdtbrkBxtRepository;

    public ZbkTbrkManagerServiceImpl(ZbkTbrkDetailService service) {
        super(service);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String input(MultipartFile file, String processGroup, SysUser sysUser) throws Exception {
        String filePath = this.saveFile(file);
        TbrkTaskParam param = new TbrkTaskParam();
        param.setType(processGroup);
        param.setProcessGroup(processGroup);
        param.setFilePath(filePath);
        return this.baseTaskManageService.create(BeanUtil.beanToMap((Object)param, (String[])new String[0]), sysUser);
    }

    @Override
    public void downloadDataByTaskId(String id, HttpServletResponse response) {
        BaseTaskManage info = this.baseTaskManageService.queryInfo(id);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            TbrkTaskParam param = TbrkTaskParam.convertFromString(info.getParam(), TbrkTaskParam.class);
            File file = new File(param.getFilePath());
            String fileName = file.getName();
            FileInputStream fileInputStream = new FileInputStream(file);
            inputStream = new BufferedInputStream(fileInputStream);
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            response.reset();
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("Content-Length", "" + file.length());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            outputStream.write(buffer);
            outputStream.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void downloadLogByTaskId(String id, HttpServletResponse response) {
        final BaseTaskManage info = this.baseTaskManageService.queryInfo(id);
        try {
            TbrkTaskParam param = TbrkTaskParam.convertFromString(info.getParam(), TbrkTaskParam.class);
            String fileName = "\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + DateUtil.format((Date)info.getCreateTime(), (String)"yyyy-MM-dd-hh-mm-ss");
            if (EnumStatusType.SUCCESS.value.equals(info.getStatus())) {
                ArrayList<List<String>> headers = new ArrayList<List<String>>();
                headers.add(new ArrayList<String>(){
                    {
                        this.add("\u65e5\u5fd7\u4fe1\u606f");
                    }
                });
                ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
                datas.add(new ArrayList<Object>(){
                    {
                        this.add(info.getMsg());
                    }
                });
                EasyExcelUtil.createExcel(response, fileName, headers, datas);
            } else if (EnumStatusType.FAILED.value.equals(info.getStatus())) {
                if (JSON.isValidArray((String)info.getMsg())) {
                    List infos = JSON.parseArray((String)info.getMsg(), TbrkInputDataCheckValidInfo.class);
                    String templatePath = ConfigConstant.FileConfig.templateDir + File.separator + "\u56fe\u6591\u5165\u5e93-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7.xlsx";
                    EasyExcelUtil.createExcel(response, fileName, templatePath, infos);
                } else {
                    ArrayList<List<String>> headers = new ArrayList<List<String>>();
                    headers.add(new ArrayList<String>(){
                        {
                            this.add("\u5f02\u5e38\u4fe1\u606f");
                        }
                    });
                    ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
                    datas.add(new ArrayList<Object>(){
                        {
                            this.add(info.getMsg());
                        }
                    });
                    EasyExcelUtil.createExcel(response, fileName, headers, datas);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Map<String, Object> getStat(String xzq, String processGroup) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        xzq = this.getCutXzqDm(xzq);
        ZbkTbrkDetail t = (ZbkTbrkDetail)((ZbkTbrkDetailService)this.service).getDefault();
        String filterParam = String.format("Q_%s_S_LK=%s", t.getXmXzqdmFieldName(), this.getCutXzqDm(xzq));
        if (StrUtil.isNotBlank((CharSequence)processGroup)) {
            filterParam = filterParam + String.format(";Q_%s_S_EQ=%s", "processgroup", processGroup);
        }
        HashMap<String, EnumStatType> statFields = new HashMap<String, EnumStatType>();
        statFields.put("tbdlmj", EnumStatType.Sum);
        statFields.put("totalgddj", EnumStatType.Sum);
        result.put("stat", ((ZbkTbrkDetailService)this.service).stat(filterParam, statFields, "rklx"));
        result.put("threshold", this.zbkConfigDetailService.findByXzqdm(xzq));
        return result;
    }

    @Override
    public Map<String, Map<String, Object>> getStat(List<String> xzqdms, String processGroup) {
        HashMap<String, Map<String, Object>> results = new HashMap<String, Map<String, Object>>();
        for (String xzq : xzqdms) {
            results.put(xzq, this.getStat(xzq, processGroup));
        }
        return results;
    }

    @Override
    public List<List<String>> readExcel(MultipartFile multipartFile) {
        try {
            return EasyExcelUtil.readWithoutHead(multipartFile.getInputStream());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    private String getCutXzqDm(String xzqDm) {
        if (xzqDm.endsWith("0000")) {
            xzqDm = this.getCutXzqDm(xzqDm.substring(0, xzqDm.length() - 4));
        } else if (xzqDm.endsWith("00")) {
            xzqDm = this.getCutXzqDm(xzqDm.substring(0, xzqDm.length() - 2));
        }
        return xzqDm;
    }

    private String saveFile(MultipartFile multipartFile) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String name = multipartFile.getOriginalFilename();
            name = name.replace(".", "-" + UUID.randomUUID() + ".");
            String path = File.separator + "tbrk" + File.separator + sdf.format(new Date()) + File.separator + name;
            String filePath = this.uploadPath + path;
            File file = new File(filePath);
            InputStream inputStream = multipartFile.getInputStream();
            if (!FileUtil.exist((File)file)) {
                file = FileUtil.file((String)filePath);
            }
            FileUtil.writeFromStream((InputStream)inputStream, (File)file);
            return filePath;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public File exportHfgdShpForBxt(List<Map<String, Object>> tbrkRksidList) {
        TempFileUtil tempFileUtil = (TempFileUtil)SpringContextUtil.getBean(TempFileUtil.class);
        File tempFile = tempFileUtil.getTempDir();
        if (tbrkRksidList.size() > 0) {
            for (Map<String, Object> ysxm : tbrkRksidList) {
                String rksid = ysxm.get("rksid").toString();
                String lsh = ysxm.get("bxt_lsh").toString();
                List<ZbkTbrkDetailBxt> lxXzgdfws = this.xfsgdtbrkBxtRepository.findByRksid(rksid);
                if (lxXzgdfws.size() == 0) {
                    throw new RuntimeException("\u672a\u4e0a\u4f20\u6062\u590d\u8015\u5730\u56fe\u6591\uff01");
                }
                lxXzgdfws.forEach(obj -> {
                    obj.setXtbsm(lsh);
                    obj.setGdlx("\u65b0\u589e");
                    obj.setPchxmmc("2024");
                    obj.setSftgzlys("\u662f");
                    if (obj.getGdpdjb() != null) {
                        obj.setGdpdjbStr(String.valueOf(obj.getGdpdjb()));
                    }
                });
                EasyShpUtil<ZbkTbrkDetailBxt> easyShpUtil = new EasyShpUtil<ZbkTbrkDetailBxt>();
                try {
                    String lxXzgdfwsDir = tempFile.getPath() + File.separator + "lsh-" + lsh;
                    if (!new File(lxXzgdfwsDir).exists()) {
                        new File(lxXzgdfwsDir).mkdirs();
                    }
                    easyShpUtil.write(lxXzgdfws, "lsh-" + lsh, lxXzgdfwsDir);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u5199\u5165shp\u5931\u8d25");
                }
            }
        }
        File zipFile = ZipUtil.zip((String)tempFile.getPath(), (String)(tempFile.getPath() + ".zip"), (Charset)Charset.forName("UTF-8"), (boolean)false);
        return zipFile;
    }
}

