/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkmanager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKBaseDetailRepository;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKBaseDetail;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKBaseService;
import com.geoway.onemap.zbph.service.zbsync.ZbsyncService;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ZBKBaseServiceImpl
implements ZBKBaseService {
    @Autowired
    private ZBKBaseDetailRepository repository;
    @Autowired
    private ZbsyncService zbsyncService;

    @Override
    public void syncInfo(String xzqdm, String year) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("xzqdm", (Object)xzqdm);
        paramJson.put("zbnd", (Object)year);
        JSONObject info = this.zbsyncService.createHttp(paramJson, "/index/getAllzb");
        List datas = info.getJSONArray("data").toJavaList(ZBKBaseDetail.class);
        for (ZBKBaseDetail data : datas) {
            ZBKBaseDetail detail = this.repository.queryByXzqdmAndZbnd(data.getXzqdm(), data.getZbnd());
            if (detail == null) {
                data.setId(UUID.randomUUID().toString());
                detail = data;
            } else {
                BeanUtil.copyProperties((Object)data, (Object)detail, (String[])new String[]{"id"});
            }
            detail.setUpdatetime(new Date());
            this.repository.save(detail);
        }
    }

    @Override
    public ZBKBaseDetail queryInfo(String id) {
        return this.repository.findById(id).orElse(null);
    }

    @Override
    public List<ZBKBaseDetail> queryList(String filterParam, String sortParam) {
        if (StringUtils.isEmpty((CharSequence)sortParam)) {
            sortParam = "SORT_updatetime_DESC";
        }
        return this.repository.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
    }

    @Override
    public Page<ZBKBaseDetail> queryPage(String filterParam, String sortParam, int page, int size) {
        if (StringUtils.isEmpty((CharSequence)sortParam)) {
            sortParam = "SORT_updatetime_DESC";
        }
        return this.repository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
    }
}

