/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkmanager.impl;

import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKDKDetailRepository;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDKDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKSpatialDetail;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKSpatialDetailService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ZBKDKDetailServiceImpl
implements ZBKDKDetailService {
    @Autowired
    private ZBKDKDetailRepository zbkdkDetailRepository;
    @Autowired
    private ZBKDKSpatialDetailService zbkdkSpatialDetailService;

    @Override
    public List<ZBKDKDetail> findListByXmbh(String xmbh) {
        return this.zbkdkDetailRepository.findListByXmbh(xmbh);
    }

    @Override
    public List<ZBKDKDetail> findListByXmbhs(List<String> xmbhs) {
        return this.zbkdkDetailRepository.findListByXmbhs(xmbhs);
    }

    @Override
    public List<ZBKDKDetail> sumListByXmbhs(List<String> xmbhs) {
        return this.zbkdkDetailRepository.sumListByXmbhs(xmbhs);
    }

    @Override
    public ZBKDKDetail findById(String zbid) {
        return this.findById(zbid, true);
    }

    @Override
    public ZBKDKDetail findById(String zbid, boolean withspatial) {
        ZBKDKDetail zbkdkDetail = this.zbkdkDetailRepository.findById(zbid).orElse(null);
        if (zbkdkDetail == null) {
            return null;
        }
        if (withspatial) {
            zbkdkDetail.setSpatialDetail(this.zbkdkSpatialDetailService.findByDkId(zbkdkDetail.getDkid()));
        }
        return zbkdkDetail;
    }

    @Override
    public List<ZBKDKDetail> findByIds(List<String> zbid) {
        return this.findByIds(zbid, true);
    }

    @Override
    public List<ZBKDKDetail> findByIds(List<String> zbid, boolean withspatial) {
        List zbidGroups = Lists.partition(zbid, (int)999);
        ArrayList<ZBKDKDetail> listZbkDetail = new ArrayList<ZBKDKDetail>();
        zbidGroups.forEach(f -> listZbkDetail.addAll(IterableUtils.toList((Iterable)this.zbkdkDetailRepository.findAllById((Iterable)f))));
        if (withspatial) {
            List dkidGroups = Lists.partition(listZbkDetail.stream().map(f -> f.getDkid()).collect(Collectors.toList()), (int)999);
            ArrayList zbkSpatialDetails = new ArrayList();
            dkidGroups.stream().forEach(f -> zbkSpatialDetails.addAll(this.zbkdkSpatialDetailService.findByDkIds((List<String>)f)));
            listZbkDetail.forEach(f -> {
                ZBKSpatialDetail zbkSpatialDetail = zbkSpatialDetails.stream().filter(g -> g.getDkid().equals(f.getDkid())).findFirst().orElse(null);
                f.setSpatialDetail(zbkSpatialDetail);
            });
        }
        return listZbkDetail;
    }

    @Override
    public Page<ZBKDKDetail> queryByFilter(String filterParam, String sortParam, int start, int limit, boolean withSpatail) {
        Page results = this.zbkdkDetailRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)(start - 1), (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        if (!withSpatail) {
            return results;
        }
        results.getContent().forEach(f -> f.setSpatialDetail(this.zbkdkSpatialDetailService.findByDkId(f.getDkid())));
        return results;
    }

    @Override
    public Iterator<ZBKDKDetail> queryByFilter(final String filterParam, final String sortParam, final boolean withSpatail) {
        return new Iterator<ZBKDKDetail>(){
            long totalCount = 0L;
            int currentIndex = 0;
            int page = 0;
            int size = 1000;
            Page<ZBKDKDetail> results = null;

            @Override
            public boolean hasNext() {
                if (this.results == null) {
                    this.results = ZBKDKDetailServiceImpl.this.zbkdkDetailRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)this.page, (int)this.size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
                    System.out.println("\u7b2c" + this.page + "\u6b21\u67e5\u8be2;\u603b\u5171\u67e5\u8be2\u5230" + this.results.getContent().size());
                    this.totalCount = this.results.getTotalElements();
                }
                return this.totalCount > (long)this.currentIndex;
            }

            @Override
            public ZBKDKDetail next() {
                ZBKDKDetail result = (ZBKDKDetail)this.results.getContent().get(this.currentIndex % this.size);
                if (withSpatail) {
                    result.setSpatialDetail(ZBKDKDetailServiceImpl.this.zbkdkSpatialDetailService.findByDkId(result.getDkid()));
                }
                ++this.currentIndex;
                if (this.currentIndex % this.size == 0) {
                    ++this.page;
                    System.out.println("\u7b2c" + this.page + "\u6b21\u67e5\u8be2");
                    this.results = ZBKDKDetailServiceImpl.this.zbkdkDetailRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)this.page, (int)this.size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
                    System.out.println("\u7b2c" + this.page + "\u6b21\u67e5\u8be2;\u603b\u5171\u67e5\u8be2\u5230" + this.results.getContent().size());
                }
                return result;
            }
        };
    }

    @Override
    public boolean exsitByDkbh(String dkbh) {
        return this.zbkdkDetailRepository.findListByDkbh(dkbh).size() > 0;
    }

    @Override
    public List<ZBKDKDetail> findListByDkbh(String dkbh) {
        return this.zbkdkDetailRepository.findListByDkbh(dkbh);
    }

    @Override
    public List<ZBKDKDetail> findListByLsh(String lsh) {
        return this.zbkdkDetailRepository.findListByLsh(lsh);
    }

    @Override
    public boolean exsitByXmbh(String xmbh) {
        return this.zbkdkDetailRepository.findListByXmbh(xmbh).size() > 0;
    }
}

