/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkmanager.impl;

import com.geoway.onemap.zbph.dao.zbkmanager.ZBKDkOutputDetailGCRepository;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKDkOutputDetailRepository;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKDkUseDetailRepository;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDkOutputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDkOutputDetailGC;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDkUseDetail;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDkUseDetailService;
import com.geoway.onemap.zbph.supoort.GeoserverUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZBKDkUseDetailServiceImpl
implements ZBKDkUseDetailService {
    @Autowired
    private ZBKDkUseDetailRepository zbkDkUseDetailRepository;
    @Autowired
    ZBKDkOutputDetailGCRepository zbkDkOutputDetailGCRepository;
    @Autowired
    ZBKDkOutputDetailRepository zbkDkOutputDetailRepository;
    @Autowired
    private GeoserverUtil geoserverUtil;

    @Override
    public List<ZBKDkUseDetail> findByZbids(List<String> zbIds) {
        return this.zbkDkUseDetailRepository.findByZbids(zbIds);
    }

    @Override
    public void outputDkByLsh(String lsh) {
        List<ZBKDkOutputDetail> zbkDkOutputDetails = this.zbkDkOutputDetailRepository.findListBySid(lsh);
        ArrayList<String> zbIds = new ArrayList<String>();
        if (zbkDkOutputDetails != null && zbkDkOutputDetails.size() > 0) {
            for (ZBKDkOutputDetail detail2 : zbkDkOutputDetails) {
                if (detail2 == null) continue;
                String string = detail2.getZbid();
                zbIds.add(string);
            }
            List<Object> zbkDkUseDetails = new ArrayList();
            zbkDkUseDetails = this.findByZbids(zbIds);
            if (zbkDkUseDetails.size() > 0) {
                for (ZBKDkUseDetail zBKDkUseDetail : zbkDkUseDetails) {
                    ZBKDkOutputDetail zbkDkOutputDetail = zbkDkOutputDetails.stream().filter(detail -> detail != null && Objects.equals(zbkDkUseDetail.getZbid(), detail.getZbid())).findFirst().orElse(null);
                    if (zbkDkOutputDetail != null) {
                        if (zbkDkOutputDetail.getGdShape() != null) {
                            if (zBKDkUseDetail.getGdShapeSy() != null) {
                                Geometry gdShapeSy = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getGdShapeSy(), zbkDkOutputDetail.getGdShape());
                                zBKDkUseDetail.setGdShapeSy(gdShapeSy);
                            }
                            if (zBKDkUseDetail.getGdShapeYy() != null) {
                                Geometry gdShapeYy = zBKDkUseDetail.getGdShapeYy().union(zbkDkOutputDetail.getGdShape());
                                zBKDkUseDetail.setGdShapeYy(gdShapeYy);
                            } else {
                                zBKDkUseDetail.setGdShapeYy(zbkDkOutputDetail.getGdShape());
                            }
                        }
                        if (zbkDkOutputDetail.getStShape() != null) {
                            if (zBKDkUseDetail.getStShapeSy() != null) {
                                Geometry stShapeSy = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getStShapeSy(), zbkDkOutputDetail.getStShape());
                                zBKDkUseDetail.setStShapeSy(stShapeSy);
                            }
                            if (zBKDkUseDetail.getStShapeYy() != null) {
                                Geometry stShapeYy = zBKDkUseDetail.getStShapeYy().union(zbkDkOutputDetail.getStShape());
                                zBKDkUseDetail.setStShapeYy(stShapeYy);
                            } else {
                                zBKDkUseDetail.setStShapeYy(zbkDkOutputDetail.getStShape());
                            }
                        }
                        if (zbkDkOutputDetail.getCnzbShape() != null) {
                            if (zBKDkUseDetail.getCnzbShapeSy() != null) {
                                Geometry cnzbShapeSy = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getCnzbShapeSy(), zbkDkOutputDetail.getCnzbShape());
                                zBKDkUseDetail.setCnzbShapeSy(cnzbShapeSy);
                            }
                            if (zBKDkUseDetail.getCnzbShapeYy() != null) {
                                Geometry cnzbShapeYy = zBKDkUseDetail.getCnzbShapeYy().union(zbkDkOutputDetail.getCnzbShape());
                                zBKDkUseDetail.setCnzbShapeYy(cnzbShapeYy);
                            } else {
                                zBKDkUseDetail.setCnzbShapeYy(zbkDkOutputDetail.getCnzbShape());
                            }
                        }
                    }
                    this.zbkDkUseDetailRepository.updateZbkDkUseDetailById(zBKDkUseDetail.getId(), zBKDkUseDetail.getGdShapeSd(), zBKDkUseDetail.getGdShapeSy(), zBKDkUseDetail.getGdShapeYy(), zBKDkUseDetail.getStShapeSd(), zBKDkUseDetail.getStShapeSy(), zBKDkUseDetail.getStShapeYy(), zBKDkUseDetail.getCnzbShapeSd(), zBKDkUseDetail.getCnzbShapeSy(), zBKDkUseDetail.getCnzbShapeYy());
                }
            }
        }
    }

    @Override
    public void lockDkByLsh(String lsh) {
        List<ZBKDkOutputDetailGC> zbkDkOutputDetailGCs = this.zbkDkOutputDetailGCRepository.findListBySid(lsh);
        ArrayList<String> zbIds = new ArrayList<String>();
        if (zbkDkOutputDetailGCs != null && zbkDkOutputDetailGCs.size() > 0) {
            for (ZBKDkOutputDetailGC detail2 : zbkDkOutputDetailGCs) {
                if (detail2 == null) continue;
                String string = detail2.getZbid();
                zbIds.add(string);
            }
            List<Object> zbkDkUseDetails = new ArrayList();
            zbkDkUseDetails = this.findByZbids(zbIds);
            if (zbkDkUseDetails.size() > 0) {
                for (ZBKDkUseDetail zBKDkUseDetail : zbkDkUseDetails) {
                    ZBKDkOutputDetailGC zbkDkOutputDetailGC = zbkDkOutputDetailGCs.stream().filter(detail -> detail != null && Objects.equals(zbkDkUseDetail.getZbid(), detail.getZbid())).findFirst().orElse(null);
                    if (zbkDkOutputDetailGC != null) {
                        if (zbkDkOutputDetailGC.getGdShape() != null) {
                            if (zBKDkUseDetail.getGdShapeSd() != null) {
                                Geometry gdShapeSd = zBKDkUseDetail.getGdShapeSd().union(zbkDkOutputDetailGC.getGdShape());
                                zBKDkUseDetail.setGdShapeSd(gdShapeSd);
                            } else {
                                zBKDkUseDetail.setGdShapeSd(zbkDkOutputDetailGC.getGdShape());
                            }
                            if (zBKDkUseDetail.getGdShapeSy() != null) {
                                Geometry gdShapeSy = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getGdShapeSy(), zbkDkOutputDetailGC.getGdShape());
                                zBKDkUseDetail.setGdShapeSy(gdShapeSy);
                            }
                        }
                        if (zbkDkOutputDetailGC.getStShape() != null) {
                            if (zBKDkUseDetail.getStShapeSd() != null) {
                                Geometry stShapeSd = zBKDkUseDetail.getStShapeSd().union(zbkDkOutputDetailGC.getStShape());
                                zBKDkUseDetail.setStShapeSd(stShapeSd);
                            } else {
                                zBKDkUseDetail.setStShapeSd(zbkDkOutputDetailGC.getStShape());
                            }
                            if (zBKDkUseDetail.getStShapeSy() != null) {
                                Geometry stShapeSy = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getStShapeSy(), zbkDkOutputDetailGC.getStShape());
                                zBKDkUseDetail.setStShapeSy(stShapeSy);
                            }
                        }
                        if (zbkDkOutputDetailGC.getCnzbShape() != null) {
                            if (zBKDkUseDetail.getCnzbShapeSd() != null) {
                                Geometry cnzbShapeSd = zBKDkUseDetail.getCnzbShapeSd().union(zbkDkOutputDetailGC.getCnzbShape());
                                zBKDkUseDetail.setCnzbShapeSd(cnzbShapeSd);
                            } else {
                                zBKDkUseDetail.setCnzbShapeSd(zbkDkOutputDetailGC.getCnzbShape());
                            }
                            if (zBKDkUseDetail.getCnzbShapeSy() != null) {
                                Geometry cnzbShapeSy = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getCnzbShapeSy(), zbkDkOutputDetailGC.getCnzbShape());
                                zBKDkUseDetail.setCnzbShapeSy(cnzbShapeSy);
                            }
                        }
                    }
                    this.zbkDkUseDetailRepository.updateZbkDkUseDetailById(zBKDkUseDetail.getId(), zBKDkUseDetail.getGdShapeSd(), zBKDkUseDetail.getGdShapeSy(), zBKDkUseDetail.getGdShapeYy(), zBKDkUseDetail.getStShapeSd(), zBKDkUseDetail.getStShapeSy(), zBKDkUseDetail.getStShapeYy(), zBKDkUseDetail.getCnzbShapeSd(), zBKDkUseDetail.getCnzbShapeSy(), zBKDkUseDetail.getCnzbShapeYy());
                }
            }
        }
    }

    @Override
    public void unLockDkNotOutputByLsh(String lsh) {
        List<ZBKDkOutputDetailGC> zbkDkOutputDetailGCs = this.zbkDkOutputDetailGCRepository.findListBySid(lsh);
        ArrayList<String> zbIds = new ArrayList<String>();
        if (zbkDkOutputDetailGCs != null && zbkDkOutputDetailGCs.size() > 0) {
            for (ZBKDkOutputDetailGC detail2 : zbkDkOutputDetailGCs) {
                if (detail2 == null) continue;
                String string = detail2.getZbid();
                zbIds.add(string);
            }
            List<Object> zbkDkUseDetails = new ArrayList();
            zbkDkUseDetails = this.findByZbids(zbIds);
            if (zbkDkUseDetails.size() > 0) {
                for (ZBKDkUseDetail zBKDkUseDetail : zbkDkUseDetails) {
                    ZBKDkOutputDetailGC zbkDkOutputDetailGC = zbkDkOutputDetailGCs.stream().filter(detail -> detail != null && Objects.equals(zbkDkUseDetail.getZbid(), detail.getZbid())).findFirst().orElse(null);
                    if (zbkDkOutputDetailGC != null) {
                        if (zbkDkOutputDetailGC.getGdShape() != null) {
                            if (zBKDkUseDetail.getGdShapeSd() != null) {
                                Geometry gdShapeSd = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getGdShapeSd(), zbkDkOutputDetailGC.getGdShape());
                                zBKDkUseDetail.setGdShapeSd(gdShapeSd);
                            }
                            if (zBKDkUseDetail.getGdShapeSy() != null) {
                                Geometry gdShapeSy = zBKDkUseDetail.getGdShapeSy().union(zbkDkOutputDetailGC.getGdShape());
                                zBKDkUseDetail.setGdShapeSy(gdShapeSy);
                            } else {
                                zBKDkUseDetail.setGdShapeSy(zbkDkOutputDetailGC.getGdShape());
                            }
                        }
                        if (zbkDkOutputDetailGC.getStShape() != null) {
                            if (zBKDkUseDetail.getStShapeSd() != null) {
                                Geometry stShapeSd = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getStShapeSd(), zbkDkOutputDetailGC.getStShape());
                                zBKDkUseDetail.setStShapeSd(stShapeSd);
                            }
                            if (zBKDkUseDetail.getStShapeSy() != null) {
                                Geometry stShapeSy = zBKDkUseDetail.getStShapeSy().union(zbkDkOutputDetailGC.getStShape());
                                zBKDkUseDetail.setStShapeSy(stShapeSy);
                            } else {
                                zBKDkUseDetail.setStShapeSy(zbkDkOutputDetailGC.getStShape());
                            }
                        }
                        if (zbkDkOutputDetailGC.getCnzbShape() != null) {
                            if (zBKDkUseDetail.getCnzbShapeSd() != null) {
                                Geometry cnzbShapeSd = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getCnzbShapeSd(), zbkDkOutputDetailGC.getCnzbShape());
                                zBKDkUseDetail.setCnzbShapeSd(cnzbShapeSd);
                            }
                            if (zBKDkUseDetail.getCnzbShapeSy() != null) {
                                Geometry cnzbShapeSy = zBKDkUseDetail.getCnzbShapeSy().union(zbkDkOutputDetailGC.getCnzbShape());
                                zBKDkUseDetail.setCnzbShapeSy(cnzbShapeSy);
                            } else {
                                zBKDkUseDetail.setCnzbShapeSy(zbkDkOutputDetailGC.getCnzbShape());
                            }
                        }
                    }
                    this.zbkDkUseDetailRepository.updateZbkDkUseDetailById(zBKDkUseDetail.getId(), zBKDkUseDetail.getGdShapeSd(), zBKDkUseDetail.getGdShapeSy(), zBKDkUseDetail.getGdShapeYy(), zBKDkUseDetail.getStShapeSd(), zBKDkUseDetail.getStShapeSy(), zBKDkUseDetail.getStShapeYy(), zBKDkUseDetail.getCnzbShapeSd(), zBKDkUseDetail.getCnzbShapeSy(), zBKDkUseDetail.getCnzbShapeYy());
                }
            }
        }
    }

    @Override
    public void unLockDkOutputByLsh(String lsh) {
        List<ZBKDkOutputDetailGC> zbkDkOutputDetailGCs = this.zbkDkOutputDetailGCRepository.findListBySid(lsh);
        ArrayList<String> zbIds = new ArrayList<String>();
        if (zbkDkOutputDetailGCs != null && zbkDkOutputDetailGCs.size() > 0) {
            for (ZBKDkOutputDetailGC detail2 : zbkDkOutputDetailGCs) {
                if (detail2 == null) continue;
                String string = detail2.getZbid();
                zbIds.add(string);
            }
            List<Object> zbkDkUseDetails = new ArrayList();
            zbkDkUseDetails = this.findByZbids(zbIds);
            if (zbkDkUseDetails.size() > 0) {
                for (ZBKDkUseDetail zBKDkUseDetail : zbkDkUseDetails) {
                    ZBKDkOutputDetailGC zbkDkOutputDetailGC = zbkDkOutputDetailGCs.stream().filter(detail -> detail != null && Objects.equals(zbkDkUseDetail.getZbid(), detail.getZbid())).findFirst().orElse(null);
                    if (zbkDkOutputDetailGC != null) {
                        if (zbkDkOutputDetailGC.getGdShape() != null) {
                            if (zBKDkUseDetail.getGdShapeSd() != null) {
                                Geometry gdShapeSd = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getGdShapeSd(), zbkDkOutputDetailGC.getGdShape());
                                zBKDkUseDetail.setGdShapeSd(gdShapeSd);
                            }
                            if (zBKDkUseDetail.getGdShapeYy() != null) {
                                Geometry gdShapeYy = zBKDkUseDetail.getGdShapeYy().union(zbkDkOutputDetailGC.getGdShape());
                                zBKDkUseDetail.setGdShapeYy(gdShapeYy);
                            } else {
                                zBKDkUseDetail.setGdShapeYy(zbkDkOutputDetailGC.getGdShape());
                            }
                        }
                        if (zbkDkOutputDetailGC.getStShape() != null) {
                            if (zBKDkUseDetail.getStShapeSd() != null) {
                                Geometry stShapeSd = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getStShapeSd(), zbkDkOutputDetailGC.getStShape());
                                zBKDkUseDetail.setStShapeSd(stShapeSd);
                            }
                            if (zBKDkUseDetail.getStShapeYy() != null) {
                                Geometry stShapeYy = zBKDkUseDetail.getStShapeYy().union(zbkDkOutputDetailGC.getStShape());
                                zBKDkUseDetail.setStShapeYy(stShapeYy);
                            } else {
                                zBKDkUseDetail.setStShapeYy(zbkDkOutputDetailGC.getStShape());
                            }
                        }
                        if (zbkDkOutputDetailGC.getCnzbShape() != null) {
                            if (zBKDkUseDetail.getCnzbShapeSd() != null) {
                                Geometry cnzbShapeSd = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getCnzbShapeSd(), zbkDkOutputDetailGC.getCnzbShape());
                                zBKDkUseDetail.setCnzbShapeSd(cnzbShapeSd);
                            }
                            if (zBKDkUseDetail.getCnzbShapeYy() != null) {
                                Geometry cnzbShapeYy = zBKDkUseDetail.getCnzbShapeYy().union(zbkDkOutputDetailGC.getCnzbShape());
                                zBKDkUseDetail.setCnzbShapeYy(cnzbShapeYy);
                            } else {
                                zBKDkUseDetail.setCnzbShapeYy(zbkDkOutputDetailGC.getCnzbShape());
                            }
                        }
                    }
                    this.zbkDkUseDetailRepository.updateZbkDkUseDetailById(zBKDkUseDetail.getId(), zBKDkUseDetail.getGdShapeSd(), zBKDkUseDetail.getGdShapeSy(), zBKDkUseDetail.getGdShapeYy(), zBKDkUseDetail.getStShapeSd(), zBKDkUseDetail.getStShapeSy(), zBKDkUseDetail.getStShapeYy(), zBKDkUseDetail.getCnzbShapeSd(), zBKDkUseDetail.getCnzbShapeSy(), zBKDkUseDetail.getCnzbShapeYy());
                }
            }
        }
    }

    @Override
    public void un0utputDkLockByLsh(String lsh) {
        List<ZBKDkOutputDetailGC> zbkDkOutputDetailGCs = this.zbkDkOutputDetailGCRepository.findListBySid(lsh);
        ArrayList<String> zbIds = new ArrayList<String>();
        if (zbkDkOutputDetailGCs != null && zbkDkOutputDetailGCs.size() > 0) {
            for (ZBKDkOutputDetailGC detail2 : zbkDkOutputDetailGCs) {
                if (detail2 == null) continue;
                String string = detail2.getZbid();
                zbIds.add(string);
            }
            List<Object> zbkDkUseDetails = new ArrayList();
            zbkDkUseDetails = this.findByZbids(zbIds);
            if (zbkDkUseDetails.size() > 0) {
                for (ZBKDkUseDetail zBKDkUseDetail : zbkDkUseDetails) {
                    ZBKDkOutputDetailGC zbkDkOutputDetailGC = zbkDkOutputDetailGCs.stream().filter(detail -> detail != null && Objects.equals(zbkDkUseDetail.getZbid(), detail.getZbid())).findFirst().orElse(null);
                    if (zbkDkOutputDetailGC != null) {
                        if (zbkDkOutputDetailGC.getGdShape() != null) {
                            if (zBKDkUseDetail.getGdShapeSd() != null) {
                                Geometry gdShapeSd = zBKDkUseDetail.getGdShapeSd().union(zbkDkOutputDetailGC.getGdShape());
                                zBKDkUseDetail.setGdShapeSd(gdShapeSd);
                            } else {
                                zBKDkUseDetail.setGdShapeSd(zbkDkOutputDetailGC.getGdShape());
                            }
                            if (zBKDkUseDetail.getGdShapeYy() != null) {
                                Geometry gdShapeYy = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getGdShapeYy(), zbkDkOutputDetailGC.getGdShape());
                                zBKDkUseDetail.setGdShapeYy(gdShapeYy);
                            }
                        }
                        if (zbkDkOutputDetailGC.getStShape() != null) {
                            if (zBKDkUseDetail.getStShapeSd() != null) {
                                Geometry stShapeSd = zBKDkUseDetail.getStShapeSd().union(zbkDkOutputDetailGC.getStShape());
                                zBKDkUseDetail.setStShapeSd(stShapeSd);
                            } else {
                                zBKDkUseDetail.setStShapeSd(zbkDkOutputDetailGC.getStShape());
                            }
                            if (zBKDkUseDetail.getStShapeYy() != null) {
                                Geometry stShapeYy = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getStShapeYy(), zbkDkOutputDetailGC.getStShape());
                                zBKDkUseDetail.setStShapeYy(stShapeYy);
                            }
                        }
                        if (zbkDkOutputDetailGC.getCnzbShape() != null) {
                            if (zBKDkUseDetail.getCnzbShapeSd() != null) {
                                Geometry cnzbShapeSd = zBKDkUseDetail.getCnzbShapeSd().union(zbkDkOutputDetailGC.getCnzbShape());
                                zBKDkUseDetail.setCnzbShapeSd(cnzbShapeSd);
                            } else {
                                zBKDkUseDetail.setCnzbShapeSd(zbkDkOutputDetailGC.getCnzbShape());
                            }
                            if (zBKDkUseDetail.getCnzbShapeYy() != null) {
                                Geometry cnzbShapeYy = this.geoserverUtil.KjccByFxfw(zBKDkUseDetail.getCnzbShapeYy(), zbkDkOutputDetailGC.getCnzbShape());
                                zBKDkUseDetail.setCnzbShapeYy(cnzbShapeYy);
                            }
                        }
                    }
                    this.zbkDkUseDetailRepository.updateZbkDkUseDetailById(zBKDkUseDetail.getId(), zBKDkUseDetail.getGdShapeSd(), zBKDkUseDetail.getGdShapeSy(), zBKDkUseDetail.getGdShapeYy(), zBKDkUseDetail.getStShapeSd(), zBKDkUseDetail.getStShapeSy(), zBKDkUseDetail.getStShapeYy(), zBKDkUseDetail.getCnzbShapeSd(), zBKDkUseDetail.getCnzbShapeSy(), zBKDkUseDetail.getCnzbShapeYy());
                }
            }
        }
    }
}

