/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkmanager.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.core.support.RegionServiceUtil;
import com.geoway.onemap.zbph.constant.base.EnumLshType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputMethod;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKOperateDetailRepository;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKInputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOperateDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetail;
import com.geoway.onemap.zbph.service.base.BaseLshService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKInputDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOperateDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOutputDetailService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ZBKOperateDetailServiceImpl
implements ZBKOperateDetailService {
    @Autowired
    private ZBKOperateDetailRepository zbkOperateDetailRepository;
    @Autowired
    private ZBKOutputDetailService zbkOutputDetailService;
    @Autowired
    private ZBKInputDetailService zbkInputDetailService;
    @Autowired
    protected BaseLshService baseSidService;

    @Override
    public Page<ZBKOperateDetail> queryByFilter(String filterParam, String sortParam, int start, int limit) {
        Page results = this.zbkOperateDetailRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)(start - 1), (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    @Override
    public List<ZBKOperateDetail> getOutputOperateDetail(List<ZBKOutputDetail> outputDetails1) {
        Map<String, Map<String, List<ZBKOutputDetail>>> group = outputDetails1.stream().collect(Collectors.groupingBy(ZBKOutputDetail::getZbxzqdm, Collectors.groupingBy(ZBKOutputDetail::getZblx)));
        ArrayList<ZBKOperateDetail> result = new ArrayList<ZBKOperateDetail>();
        for (Map.Entry<String, Map<String, List<ZBKOutputDetail>>> subGroup : group.entrySet()) {
            for (Map.Entry<String, List<ZBKOutputDetail>> subSubGroup : subGroup.getValue().entrySet()) {
                List<ZBKOutputDetail> outputDetails = subSubGroup.getValue();
                ZBKOperateDetail zbkOperateDetail = new ZBKOperateDetail();
                List<ZBKInputDetail> zbkInputDetails = this.zbkInputDetailService.findByZbids(outputDetails.stream().map(f -> f.getZbid()).collect(Collectors.toList()));
                ZBKOutputDetail zbkOutputDetail = outputDetails.get(0);
                zbkOperateDetail.setId(UUID.randomUUID().toString());
                zbkOperateDetail.setLsh(zbkOutputDetail.getSid());
                zbkOperateDetail.setCzxzqdm(zbkOutputDetail.getCzxzqdm());
                zbkOperateDetail.setCzxzqmc(RegionServiceUtil.getFullRegionName((String)zbkOutputDetail.getCzxzqdm()));
                zbkOperateDetail.setZbxzqdm(zbkOutputDetail.getZbxzqdm());
                zbkOperateDetail.setZbxzqmc(RegionServiceUtil.getFullRegionName((String)zbkOutputDetail.getZbxzqdm()));
                zbkOperateDetail.setZblx(zbkOutputDetail.getZblx());
                zbkOperateDetail.setCzlx(zbkOutputDetail.getCzlx());
                zbkOperateDetail.setGdmj(outputDetails.stream().mapToDouble(f -> f.getGdmj()).sum());
                for (ZBKOutputDetail zBKOutputDetail : outputDetails) {
                    String dlbm = zbkInputDetails.stream().filter(f -> f.getId().toLowerCase().equals(zBKOutputDetail.getZbid())).findFirst().get().getDlbm();
                    if (StrUtil.isBlank((CharSequence)dlbm)) {
                        dlbm = "0103";
                    }
                    switch (dlbm) {
                        case "0101": {
                            zbkOperateDetail.setGdmj_0101(zbkOperateDetail.getGdmj_0101() + zBKOutputDetail.getGdmj());
                            break;
                        }
                        case "0102": {
                            zbkOperateDetail.setGdmj_0102(zbkOperateDetail.getGdmj_0102() + zBKOutputDetail.getGdmj());
                            break;
                        }
                        case "0103": {
                            zbkOperateDetail.setGdmj_0103(zbkOperateDetail.getGdmj_0103() + zBKOutputDetail.getGdmj());
                        }
                    }
                }
                zbkOperateDetail.setLsh_2(this.baseSidService.generateLsh(zbkOperateDetail.getZbxzqdm(), EnumLshType.ZBK));
                zbkOperateDetail.setStmj(outputDetails.stream().mapToDouble(f -> f.getStmj()).sum());
                zbkOperateDetail.setCnzb(outputDetails.stream().mapToDouble(f -> f.getCnzb()).sum());
                zbkOperateDetail.setDate(new Date());
                zbkOperateDetail.setUserid(zbkOutputDetail.getUserid());
                zbkOperateDetail.setUsername(zbkOutputDetail.getUsername());
                zbkOperateDetail.setRkck("ck");
                HashMap<String, String> xmbhXmmcMap = new HashMap<String, String>();
                for (ZBKOutputDetail outputDetail : outputDetails) {
                    xmbhXmmcMap.put(outputDetail.getXmbh(), outputDetail.getXmmc());
                }
                EnumZBKOutputType enumZBKOutputType = EnumZBKOutputType.fromValue(zbkOperateDetail.getCzlx());
                ArrayList<String> zyList = new ArrayList<String>();
                String zy_2 = "";
                String gllsh = "";
                ZBKInputDetail zbkInputDetail = null;
                switch (enumZBKOutputType) {
                    case JSXMGGCK: {
                        for (Map.Entry entry : xmbhXmmcMap.entrySet()) {
                            zyList.add(String.format("\u8865\u5145\u8015\u5730\u786e\u8ba4\u4fe1\u606f\u7f16\u53f7\uff1a%s\uff0c\u5efa\u8bbe\u9879\u76ee\u540d\u79f0\uff1a%s", entry.getKey(), entry.getValue()));
                        }
                        zy_2 = String.join((CharSequence)"|", zyList);
                        break;
                    }
                    case SNKXTJCK: 
                    case SNKSTJCK: 
                    case KSTJCK: {
                        zy_2 = String.format("\u6307\u6807\u8c03\u5165\u5230\uff1a%s", RegionServiceUtil.getFullRegionName((String)zbkOutputDetail.getCkxzqdm()));
                        break;
                    }
                    case CXTJCK: {
                        zbkInputDetail = this.zbkInputDetailService.findByZbid(zbkOutputDetail.getZbid());
                        zy_2 = String.format("\u6307\u6807\u8c03\u5165\u5230\uff1a%s", RegionServiceUtil.getFullRegionName((String)zbkOutputDetail.getCkxzqdm()));
                        gllsh = this.zbkOperateDetailRepository.findByLsh(zbkInputDetail.getLsh(), zbkInputDetail.getZbxzqdm(), zbkInputDetail.getZblx()).getLsh_2();
                        break;
                    }
                    case BCGDHJCK: {
                        switch (EnumZBKInputMethod.fromValue(zbkInputDetails.get(0).getRklx())) {
                            case TBRK: {
                                for (ZBKOutputDetail zBKOutputDetail : outputDetails) {
                                    zbkInputDetail = zbkInputDetails.stream().filter(f -> f.getId().equals(outputDetail.getZbid())).findFirst().get();
                                    zyList.add(String.format("\u6838\u51cf\u5730\u5757\u7f16\u53f7\uff1a%s\uff0c\u5730\u5757\u7c7b\u578b\uff1a%s", zBKOutputDetail.getZbdkbh(), zbkInputDetail.getDlmc()));
                                }
                                break;
                            }
                            case XMRK: 
                            case BJZZBRK: {
                                xmbhXmmcMap.clear();
                                for (ZBKOutputDetail zBKOutputDetail : outputDetails) {
                                    xmbhXmmcMap.put(zBKOutputDetail.getZbxmbh(), zBKOutputDetail.getZbxmmc());
                                }
                                for (Map.Entry entry : xmbhXmmcMap.entrySet()) {
                                    zyList.add(String.format("\u6838\u51cf\u9879\u76ee\u7f16\u53f7\uff1a%s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%s", entry.getKey(), entry.getValue()));
                                }
                                break;
                            }
                        }
                        zy_2 = String.join((CharSequence)"|", zyList);
                        break;
                    }
                    case WFYDDJCK: 
                    case QTDJCK: {
                        switch (EnumZBKInputMethod.fromValue(zbkInputDetails.get(0).getRklx())) {
                            case TBRK: {
                                for (ZBKOutputDetail zBKOutputDetail : outputDetails) {
                                    zbkInputDetail = zbkInputDetails.stream().filter(f -> f.getId().equals(outputDetail.getZbid())).findFirst().get();
                                    zyList.add(String.format("\u5730\u5757\u7f16\u53f7\uff1a%s\uff0c\u5730\u5757\u7c7b\u578b\uff1a%s", zBKOutputDetail.getZbdkbh(), zbkInputDetail.getDlmc()));
                                }
                                break;
                            }
                            case XMRK: 
                            case BJZZBRK: {
                                for (Map.Entry entry : xmbhXmmcMap.entrySet()) {
                                    zyList.add(String.format("\u9879\u76ee\u7f16\u53f7\uff1a%s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%s", entry.getKey(), entry.getValue()));
                                }
                                break;
                            }
                        }
                        zy_2 = String.join((CharSequence)"|", zyList);
                        break;
                    }
                    case GHCNZBCK: {
                        zy_2 = "\u5f52\u8fd8\u627f\u8bfa\u6307\u6807\u51fa\u5e93";
                        break;
                    }
                    case CDFZCK: {
                        break;
                    }
                }
                zbkOperateDetail.setGllsh(gllsh);
                zbkOperateDetail.setZy_2(zy_2);
                if (zy_2.length() >= 500) {
                    zbkOperateDetail.setZy_2(zy_2.substring(0, 500));
                } else {
                    zbkOperateDetail.setZy(zy_2);
                }
                result.add(zbkOperateDetail);
            }
        }
        return result;
    }

    @Override
    public List<ZBKOperateDetail> getInputOperateDetail(List<ZBKInputDetail> inputDetails1) {
        Map<String, Map<String, List<ZBKInputDetail>>> group = inputDetails1.stream().collect(Collectors.groupingBy(ZBKInputDetail::getZbxzqdm, Collectors.groupingBy(ZBKInputDetail::getZblx)));
        ArrayList<ZBKOperateDetail> result = new ArrayList<ZBKOperateDetail>();
        for (Map.Entry<String, Map<String, List<ZBKInputDetail>>> subGroup : group.entrySet()) {
            for (Map.Entry<String, List<ZBKInputDetail>> subSubGroup : subGroup.getValue().entrySet()) {
                List<ZBKInputDetail> inputDetails = subSubGroup.getValue();
                ZBKOperateDetail zbkOperateDetail = new ZBKOperateDetail();
                ZBKInputDetail inputDetail = inputDetails.get(0);
                zbkOperateDetail.setId(UUID.randomUUID().toString());
                zbkOperateDetail.setLsh(inputDetail.getLsh());
                zbkOperateDetail.setCzxzqdm(inputDetail.getCzxzqdm());
                zbkOperateDetail.setCzxzqmc(RegionServiceUtil.getFullRegionName((String)inputDetail.getCzxzqdm()));
                zbkOperateDetail.setZbxzqdm(inputDetail.getZbxzqdm());
                zbkOperateDetail.setZbxzqmc(RegionServiceUtil.getFullRegionName((String)inputDetail.getZbxzqdm()));
                zbkOperateDetail.setZblx(inputDetail.getZblx());
                zbkOperateDetail.setCzlx(inputDetail.getCzlx());
                zbkOperateDetail.setGdmj(inputDetails.stream().mapToDouble(f -> f.getGdmj()).sum());
                for (ZBKInputDetail zBKInputDetail : inputDetails) {
                    String dlbm = zBKInputDetail.getDlbm();
                    if (StrUtil.isBlank((CharSequence)dlbm)) {
                        dlbm = "0103";
                    }
                    switch (dlbm) {
                        case "0101": {
                            zbkOperateDetail.setGdmj_0101(zbkOperateDetail.getGdmj_0101() + zBKInputDetail.getGdmj());
                            break;
                        }
                        case "0102": {
                            zbkOperateDetail.setGdmj_0102(zbkOperateDetail.getGdmj_0102() + zBKInputDetail.getGdmj());
                            break;
                        }
                        case "0103": {
                            zbkOperateDetail.setGdmj_0103(zbkOperateDetail.getGdmj_0103() + zBKInputDetail.getGdmj());
                        }
                    }
                }
                zbkOperateDetail.setLsh_2(this.baseSidService.generateLsh(zbkOperateDetail.getZbxzqdm(), EnumLshType.ZBK));
                zbkOperateDetail.setStmj(inputDetails.stream().mapToDouble(f -> f.getStmj()).sum());
                zbkOperateDetail.setCnzb(inputDetails.stream().mapToDouble(f -> f.getCnzb()).sum());
                zbkOperateDetail.setDate(new Date());
                zbkOperateDetail.setUserid(inputDetail.getUserid());
                zbkOperateDetail.setUsername(inputDetail.getUsername());
                zbkOperateDetail.setRkck("rk");
                HashMap<String, String> xmbhXmmcMap = new HashMap<String, String>();
                for (ZBKInputDetail outputDetail : inputDetails) {
                    xmbhXmmcMap.put(outputDetail.getXmbh(), outputDetail.getXmmc());
                }
                EnumZBKInputType enumZBKInputType = EnumZBKInputType.fromValue(inputDetail.getCzlx());
                ArrayList<String> zyList = new ArrayList<String>();
                String zy2 = "";
                String gllsh = "";
                ZBKOutputDetail zbkOutputDetail = null;
                switch (enumZBKInputType) {
                    case ZBBBRK: {
                        switch (EnumZBKInputMethod.fromValue(inputDetail.getRklx())) {
                            case TBRK: {
                                for (ZBKInputDetail zBKInputDetail : inputDetails) {
                                    zyList.add(String.format("\u5730\u5757\u7f16\u53f7\uff1a%s\uff0c\u5730\u5757\u7c7b\u578b\uff1a%s", zBKInputDetail.getDkbh(), zBKInputDetail.getDlmc()));
                                }
                                break;
                            }
                            case XMRK: 
                            case BJZZBRK: {
                                for (Map.Entry entry : xmbhXmmcMap.entrySet()) {
                                    zyList.add(String.format("\u9879\u76ee\u7f16\u53f7\uff1a%s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%s", entry.getKey(), entry.getValue()));
                                }
                                break;
                            }
                        }
                        zy2 = String.join((CharSequence)"|", zyList);
                        break;
                    }
                    case SNKXTJRK: 
                    case SNKSTJRK: 
                    case KSTJRK: {
                        zbkOutputDetail = this.zbkOutputDetailService.findById(inputDetail.getSrcid());
                        zy2 = String.format("\u6307\u6807\u6765\u6e90\u4e8e\uff1a%s", RegionServiceUtil.getFullRegionName((String)zbkOutputDetail.getZbxzqdm()));
                        break;
                    }
                    case CXTJRK: {
                        zbkOutputDetail = this.zbkOutputDetailService.findById(inputDetail.getSrcid());
                        ZBKOperateDetail glZBKOperateDetail = this.zbkOperateDetailRepository.findByLsh(zbkOutputDetail.getSid(), zbkOutputDetail.getZbxzqdm(), zbkOutputDetail.getZblx());
                        zy2 = String.format("\u6307\u6807\u6765\u6e90\u4e8e\uff1a%s", RegionServiceUtil.getFullRegionName((String)zbkOutputDetail.getCkxzqdm()));
                        gllsh = glZBKOperateDetail.getLsh_2();
                        break;
                    }
                    case QXZBHJRK: 
                    case WFYDJDRK: 
                    case QTDJJDRK: 
                    case FNJSZYGDJGRK: {
                        switch (EnumZBKInputMethod.fromValue(inputDetail.getRklx())) {
                            case TBRK: {
                                for (ZBKInputDetail zBKInputDetail : inputDetails) {
                                    zyList.add(String.format("\u5730\u5757\u7f16\u53f7\uff1a%s\uff0c\u5730\u5757\u7c7b\u578b\uff1a%s", zBKInputDetail.getDkbh(), zBKInputDetail.getDlmc()));
                                }
                                break;
                            }
                            case XMRK: 
                            case BJZZBRK: {
                                for (Map.Entry entry : xmbhXmmcMap.entrySet()) {
                                    zyList.add(String.format("\u9879\u76ee\u7f16\u53f7\uff1a%s\uff0c\u9879\u76ee\u540d\u79f0\uff1a%s", entry.getKey(), entry.getValue()));
                                }
                                break;
                            }
                        }
                        zbkOutputDetail = this.zbkOutputDetailService.findById(inputDetail.getSrcid());
                        gllsh = this.zbkOperateDetailRepository.findByLsh(zbkOutputDetail.getSid(), zbkOutputDetail.getZbxzqdm(), zbkOutputDetail.getZblx()).getLsh_2();
                        zy2 = String.join((CharSequence)"|", zyList);
                        break;
                    }
                }
                zbkOperateDetail.setGllsh(gllsh);
                zbkOperateDetail.setZy_2(zy2);
                if (zy2.length() >= 500) {
                    zbkOperateDetail.setZy_2(zy2.substring(0, 500));
                } else {
                    zbkOperateDetail.setZy(zy2);
                }
                result.add(zbkOperateDetail);
            }
        }
        return result;
    }

    @Override
    public void saveOrUpdate(ZBKOperateDetail detail) {
        this.zbkOperateDetailRepository.save(detail);
    }

    @Override
    public void saveOrUpdate(List<ZBKOperateDetail> details) {
        this.zbkOperateDetailRepository.saveAll(details);
    }

    @Override
    public Long queryTotal(String filterParam) {
        return this.zbkOperateDetailRepository.count((Specification)new QuerySpecification(filterParam));
    }

    @Override
    public void deleteByLsh(String lsh) {
        this.zbkOperateDetailRepository.deleteByLsh(lsh);
    }
}

