/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkmanager.impl;

import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDKDetail;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKOutputDTO;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ZBKOutputUtil {
    public static List<ZBKOutputDTO> getZBKOutputDTOs(List<ZBKOutputParam> zbkOutputParams, double cnzb) {
        ZBKDKDetailService zbkdkDetailService = (ZBKDKDetailService)SpringContextUtil.getBean(ZBKDKDetailService.class);
        ArrayList<ZBKOutputDTO> zbkOutputDTOS = new ArrayList<ZBKOutputDTO>();
        int size = cnzb >= 1.0E-7 ? zbkOutputParams.size() - 1 : zbkOutputParams.size();
        for (int i = 0; i < size; ++i) {
            ZBKOutputParam zbkOutputParam = zbkOutputParams.get(i);
            String filterParam = zbkOutputParam.getFilterParam();
            String sortParam = zbkOutputParam.getSortParam();
            if (zbkOutputParam.getGdmj() > 0.0) {
                filterParam = filterParam + ";Q_gdmjsy_N_GT=0";
            }
            if (zbkOutputParam.getStmj() > 0.0) {
                filterParam = filterParam + ";Q_stmjsy_N_GT=0";
            }
            long start = System.currentTimeMillis();
            Iterator<ZBKDKDetail> zbkdkDetails = zbkdkDetailService.queryByFilter(filterParam, sortParam, false);
            System.out.println("\u51fa\u5e93\u8017\u65f621:" + (System.currentTimeMillis() - start) + "    " + filterParam + "    " + sortParam);
            start = System.currentTimeMillis();
            List<ZBKOutputDTO> tempOutputDTOS = ZBKOutputUtil.getZBKOutputDTOs(zbkdkDetails, zbkOutputDTOS, zbkOutputParam.getGdmj(), zbkOutputParam.getStmj(), cnzb);
            System.out.println("\u51fa\u5e93\u8017\u65f622:" + (System.currentTimeMillis() - start) + "    " + zbkOutputParam.getFilterParam() + "    " + zbkOutputParam.getSortParam());
            cnzb = BigDecimal.valueOf(cnzb).subtract(BigDecimal.valueOf(tempOutputDTOS.stream().mapToDouble(f -> f.getCnzb()).sum())).doubleValue();
            zbkOutputDTOS.addAll(tempOutputDTOS);
        }
        if (cnzb >= 1.0E-7) {
            ZBKOutputParam zbkOutputParam = zbkOutputParams.get(zbkOutputParams.size() - 1);
            String filterParam = zbkOutputParam.getFilterParam();
            String sortParam = zbkOutputParam.getSortParam();
            filterParam = filterParam + ";Q_cnzbsy_N_GT=0";
            Iterator<ZBKDKDetail> zbkdkDetails = zbkdkDetailService.queryByFilter(filterParam, sortParam, false);
            List<ZBKOutputDTO> tempOutputDTOS = ZBKOutputUtil.getZBKOutputDTOs(zbkdkDetails, zbkOutputDTOS, cnzb);
            zbkOutputDTOS.addAll(tempOutputDTOS);
        }
        return zbkOutputDTOS;
    }

    public static List<ZBKOutputDTO> getZBKOutputDTOs(String filterParam, String sortParam, double gdmj, double stmj) {
        ZBKDKDetailService zbkdkDetailService = (ZBKDKDetailService)SpringContextUtil.getBean(ZBKDKDetailService.class);
        if (gdmj > 0.0) {
            filterParam = filterParam + ";Q_gdmjsy_N_GT=0";
        }
        if (stmj > 0.0) {
            filterParam = filterParam + ";Q_stmjsy_N_GT=0";
        }
        long start = System.currentTimeMillis();
        return ZBKOutputUtil.getZBKOutputDTOs(zbkdkDetailService.queryByFilter(filterParam, sortParam, false), gdmj, stmj);
    }

    public static List<ZBKOutputDTO> getZBKOutputDTOs(List<ZBKDKDetail> zbkdkDetails, double gdmj, double stmj) {
        return ZBKOutputUtil.getZBKOutputDTOs(zbkdkDetails.iterator(), gdmj, stmj);
    }

    public static List<ZBKOutputDTO> getZBKOutputDTOs(Iterator<ZBKDKDetail> zbkdkDetails, double gdmj, double stmj) {
        ArrayList<ZBKOutputDTO> result = new ArrayList<ZBKOutputDTO>();
        while (!(!zbkdkDetails.hasNext() || gdmj <= 1.0E-7 && stmj <= 1.0E-7)) {
            ZBKDKDetail zbkdkDetail = zbkdkDetails.next();
            if (zbkdkDetail.getStmjsy() <= 1.0E-7 && zbkdkDetail.getGdmjsy() <= 1.0E-7 || gdmj <= 1.0E-7 && zbkdkDetail.getStmjsy() <= 1.0E-7 || stmj <= 1.0E-7 && zbkdkDetail.getGdmjsy() <= 1.0E-7) continue;
            double outStmj = ZBKOutputUtil.getOutValue(stmj, zbkdkDetail.getStmjsy());
            double outGdmj = ZBKOutputUtil.getOutValue(gdmj, zbkdkDetail.getGdmjsy());
            gdmj = BigDecimal.valueOf(gdmj).subtract(BigDecimal.valueOf(outGdmj)).doubleValue();
            stmj = BigDecimal.valueOf(stmj).subtract(BigDecimal.valueOf(outStmj)).doubleValue();
            ZBKOutputDTO zbkOutputDTO = new ZBKOutputDTO();
            zbkOutputDTO.setZbid(zbkdkDetail.getId());
            zbkOutputDTO.setGdmj(outGdmj);
            zbkOutputDTO.setStmj(outStmj);
            zbkOutputDTO.setCnzb(0.0);
            zbkOutputDTO.setZbkdkDetail(zbkdkDetail);
            result.add(zbkOutputDTO);
        }
        if (gdmj > 1.0E-7 || stmj > 1.0E-7) {
            throw new RuntimeException("\u6307\u6807\u5e93\u5e93\u5b58\u4e0d\u8db3\uff01");
        }
        return result;
    }

    private static List<ZBKOutputDTO> getZBKOutputDTOs(Iterator<ZBKDKDetail> zbkdkDetails, List<ZBKOutputDTO> tempOutputDTOS, double gdmj, double stmj, double lscn) {
        ArrayList<ZBKOutputDTO> result = new ArrayList<ZBKOutputDTO>();
        while (!(!zbkdkDetails.hasNext() || gdmj <= 1.0E-7 && stmj <= 1.0E-7)) {
            ZBKDKDetail zbkdkDetail = zbkdkDetails.next();
            if (tempOutputDTOS.stream().filter(f -> f.getZbid().equals(zbkdkDetail.getId())).count() > 0L || zbkdkDetail.getStmjsy() <= 1.0E-7 && zbkdkDetail.getGdmjsy() <= 1.0E-7 || gdmj <= 1.0E-7 && zbkdkDetail.getStmjsy() <= 1.0E-7 || stmj <= 1.0E-7 && zbkdkDetail.getGdmjsy() <= 1.0E-7) continue;
            double outStmj = ZBKOutputUtil.getOutValue(stmj, zbkdkDetail.getStmjsy());
            double outGdmj = ZBKOutputUtil.getOutValue(gdmj, zbkdkDetail.getGdmjsy());
            double outLscn = ZBKOutputUtil.getOutValue(lscn, zbkdkDetail.getCnzbsy());
            gdmj = BigDecimal.valueOf(gdmj).subtract(BigDecimal.valueOf(outGdmj)).doubleValue();
            stmj = BigDecimal.valueOf(stmj).subtract(BigDecimal.valueOf(outStmj)).doubleValue();
            lscn = BigDecimal.valueOf(lscn).subtract(BigDecimal.valueOf(outLscn)).doubleValue();
            ZBKOutputDTO zbkOutputResult = new ZBKOutputDTO();
            zbkOutputResult.setZbid(zbkdkDetail.getId());
            zbkOutputResult.setGdmj(outGdmj);
            zbkOutputResult.setStmj(outStmj);
            zbkOutputResult.setCnzb(outLscn);
            zbkOutputResult.setZbkdkDetail(zbkdkDetail);
            result.add(zbkOutputResult);
        }
        if (gdmj > 1.0E-7 || stmj > 1.0E-7) {
            throw new RuntimeException("\u6307\u6807\u5e93\u5e93\u5b58\u4e0d\u8db3\uff01");
        }
        return result;
    }

    private static List<ZBKOutputDTO> getZBKOutputDTOs(Iterator<ZBKDKDetail> zbkdkDetails, List<ZBKOutputDTO> zbkOutputDTOS, double lscn) {
        ArrayList<ZBKOutputDTO> result = new ArrayList<ZBKOutputDTO>();
        while (zbkdkDetails.hasNext() && !(lscn <= 1.0E-7)) {
            ZBKDKDetail zbkdkDetail = zbkdkDetails.next();
            if (zbkdkDetail.getCnzbsy() <= 1.0E-7 || zbkOutputDTOS.stream().filter(f -> f.getZbid().equals(zbkdkDetail.getId())).count() > 0L) continue;
            double outLscn = ZBKOutputUtil.getOutValue(lscn, zbkdkDetail.getCnzbsy());
            lscn = BigDecimal.valueOf(lscn).subtract(BigDecimal.valueOf(outLscn)).doubleValue();
            ZBKOutputDTO zbkOutputResult = new ZBKOutputDTO();
            zbkOutputResult.setZbid(zbkdkDetail.getId());
            zbkOutputResult.setGdmj(0.0);
            zbkOutputResult.setStmj(0.0);
            zbkOutputResult.setCnzb(outLscn);
            zbkOutputResult.setZbkdkDetail(zbkdkDetail);
            result.add(zbkOutputResult);
        }
        if (lscn > 1.0E-7) {
            throw new RuntimeException("\u6307\u6807\u5e93\u5e93\u5b58\u4e0d\u8db3\uff01");
        }
        return result;
    }

    private static double getOutValue(double outputZb, double syZb) {
        if (syZb >= outputZb) {
            return outputZb;
        }
        return syZb;
    }

    public static class ZBKOutputParam {
        String filterParam;
        String sortParam;
        double gdmj;
        double stmj;

        public String getFilterParam() {
            return this.filterParam;
        }

        public String getSortParam() {
            return this.sortParam;
        }

        public double getGdmj() {
            return this.gdmj;
        }

        public double getStmj() {
            return this.stmj;
        }

        public void setFilterParam(String filterParam) {
            this.filterParam = filterParam;
        }

        public void setSortParam(String sortParam) {
            this.sortParam = sortParam;
        }

        public void setGdmj(double gdmj) {
            this.gdmj = gdmj;
        }

        public void setStmj(double stmj) {
            this.stmj = stmj;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZBKOutputParam)) {
                return false;
            }
            ZBKOutputParam other = (ZBKOutputParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$filterParam = this.getFilterParam();
            String other$filterParam = other.getFilterParam();
            if (this$filterParam == null ? other$filterParam != null : !this$filterParam.equals(other$filterParam)) {
                return false;
            }
            String this$sortParam = this.getSortParam();
            String other$sortParam = other.getSortParam();
            if (this$sortParam == null ? other$sortParam != null : !this$sortParam.equals(other$sortParam)) {
                return false;
            }
            if (Double.compare(this.getGdmj(), other.getGdmj()) != 0) {
                return false;
            }
            return Double.compare(this.getStmj(), other.getStmj()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ZBKOutputParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $filterParam = this.getFilterParam();
            result = result * 59 + ($filterParam == null ? 43 : $filterParam.hashCode());
            String $sortParam = this.getSortParam();
            result = result * 59 + ($sortParam == null ? 43 : $sortParam.hashCode());
            long $gdmj = Double.doubleToLongBits(this.getGdmj());
            result = result * 59 + (int)($gdmj >>> 32 ^ $gdmj);
            long $stmj = Double.doubleToLongBits(this.getStmj());
            result = result * 59 + (int)($stmj >>> 32 ^ $stmj);
            return result;
        }

        public String toString() {
            return "ZBKOutputUtil.ZBKOutputParam(filterParam=" + this.getFilterParam() + ", sortParam=" + this.getSortParam() + ", gdmj=" + this.getGdmj() + ", stmj=" + this.getStmj() + ")";
        }
    }
}

