/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbsync;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SM4;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.biz.service.system.RedisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UsermanageService {
    @Value(value="${project.zbsync.url:''}")
    protected String url;
    @Value(value="${project.zbsync.login:''}")
    protected String login;
    @Value(value="${project.zbsync.password:''}")
    protected String password;
    @Value(value="${project.zbsync.appId:''}")
    protected String appId;
    @Value(value="${project.zbsync.appSecret:''}")
    protected String appSecret;
    @Autowired
    private RedisService redisService;

    private JSONObject login() {
        JSONObject paramJson = new JSONObject();
        paramJson.put("login", (Object)this.login);
        paramJson.put("password", (Object)SmUtil.sm3((String)this.password));
        paramJson.put("appId", (Object)this.appId);
        paramJson.put("appSecret", (Object)this.appSecret);
        JSONObject data = new JSONObject();
        data.put("data", (Object)paramJson);
        String params = JSONObject.toJSONString((Object)data);
        HttpResponse result = ((HttpRequest)HttpUtil.createPost((String)(this.url + "/auth/validate")).header("Content-Type", "application/json")).body(params).execute();
        JSONObject object = JSON.parseObject((String)result.body()).getJSONObject("data");
        Long expire = object.getLong("expire");
        this.redisService.set(this.login, JSONObject.toJSONString((Object)object), expire);
        return object;
    }

    public JSONObject getUserInfo() {
        return this.redisService.get(this.login) != null && this.redisService.ttl(this.login) > 30L ? JSON.parseObject((String)this.redisService.get(this.login)) : this.login();
    }

    public JSONObject resetPassword(String oldPassword, String newPassword) {
        JSONObject userinfo = this.getUserInfo();
        String key = userinfo.getString("key");
        String token = userinfo.getString("token");
        String authorization = userinfo.getString("authorization");
        JSONObject paramJson = new JSONObject();
        paramJson.put("oldPassword", (Object)SmUtil.sm3((String)oldPassword));
        paramJson.put("newPassword", (Object)SmUtil.sm3((String)newPassword));
        String encryptBase64Str = this.getEncryptBase64Str(paramJson, key);
        HttpResponse result1 = ((HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.url + "/auth/resetPassword")).header("Content-Type", "application/json")).header("Token-Auth", token)).header("Authorization", authorization)).body(encryptBase64Str).execute();
        JSONObject object1 = JSON.parseObject((String)result1.body()).getJSONObject("data");
        return object1;
    }

    public String getEncryptBase64Str(JSONObject param, String key) {
        JSONObject data = new JSONObject();
        data.put("data", (Object)param);
        String paramsStr = JSONObject.toJSONString((Object)data);
        SM4 sm4 = new SM4(Mode.ECB, Padding.PKCS5Padding, key.getBytes(CharsetUtil.CHARSET_UTF_8));
        String encryptBase64Str = sm4.encryptBase64(paramsStr);
        return encryptBase64Str;
    }
}

