/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.onemap.core.domain.Dict;
import com.geoway.onemap.core.domain.DictValue;
import com.geoway.onemap.core.service.DictService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dict"})
public class DictAction {
    private Logger logger = Logger.getLogger(DictAction.class);
    @Autowired
    DictService dictService;

    @RequestMapping(value={"/addDict.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse addDict(HttpServletRequest request, @ModelAttribute Dict dict) {
        BaseResponse response = new BaseResponse();
        try {
            this.dictService.addOneDict(dict);
        }
        catch (Exception ex) {
            this.logger.info((Object)ex, (Throwable)ex);
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/listDicts.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public EasyUIResponse listDicts(HttpServletRequest request, String filterParam, String sortParam, String page, String rows) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            int start = Integer.valueOf(page) - 1;
            int limit = Integer.valueOf(rows);
            if (StringUtils.isEmpty((String)filterParam)) {
                filterParam = "";
            }
            String newSortParam = "SORT_creattime_DESC";
            if (!StringUtils.isEmpty((String)sortParam)) {
                newSortParam = ";" + sortParam;
            }
            Page pager = this.dictService.queryDictByFilter(filterParam, newSortParam, start, limit);
            response.setTotal(Long.valueOf(pager.getTotalElements()));
            response.setRows(pager.getContent());
        }
        catch (Exception ex) {
            this.logger.info((Object)ex, (Throwable)ex);
            return EasyUIResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/deleteDict.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteNav(HttpServletRequest request, String ids) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.dictService.deleteDict(ids);
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/addDictValue.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse addDictValue(HttpServletRequest request, @ModelAttribute DictValue dictValue) {
        BaseResponse response = new BaseResponse();
        try {
            this.dictService.addOneDictValue(dictValue);
        }
        catch (Exception ex) {
            this.logger.info((Object)ex, (Throwable)ex);
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/listDictValues.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public EasyUIResponse listDicts(HttpServletRequest request, String dictId, String page, String rows) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            int start = Integer.valueOf(page) - 1;
            int limit = Integer.valueOf(rows);
            Page pager = this.dictService.queryDictValueByDictId(dictId, start, limit);
            response.setTotal(Long.valueOf(pager.getTotalElements()));
            response.setRows(pager.getContent());
        }
        catch (Exception ex) {
            this.logger.info((Object)ex, (Throwable)ex);
            return EasyUIResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/deleteDictValue.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteDictValue(HttpServletRequest request, String ids) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.dictService.deleteDictValue(ids);
        }
        catch (Exception ex) {
            this.logger.info((Object)ex, (Throwable)ex);
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/findDictById.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findDictById(HttpServletRequest request, String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            Dict dict = this.dictService.findDictById(id);
            response.setData((Object)dict);
        }
        catch (Exception ex) {
            this.logger.info((Object)ex, (Throwable)ex);
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/findDictValueById.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findDictValueById(HttpServletRequest request, String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            DictValue dictValue = this.dictService.findDictValueByValue(id);
            response.setData((Object)dictValue);
        }
        catch (Exception ex) {
            this.logger.info((Object)ex, (Throwable)ex);
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/findDictValuesByKey.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public EasyUIResponse findDictValuesByKey(HttpServletRequest request, String keys, String level) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            int start = 1;
            if (StringUtils.isNotEmpty((String)level)) {
                start = Integer.valueOf(level);
            }
            List dictResults = this.dictService.queryDictValuesByDictKeys(keys, Integer.valueOf(start));
            response.setTotal(Long.valueOf(dictResults.size()));
            response.setRows(dictResults);
        }
        catch (Exception ex) {
            this.logger.info((Object)ex, (Throwable)ex);
            return EasyUIResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @RequestMapping(value={"/listDictsByYw.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public EasyUIResponse listDictsByYw(HttpServletRequest request, String dictId, String page, String rows) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            int start = Integer.valueOf(page) - 1;
            int limit = Integer.valueOf(rows);
            Page pager = this.dictService.queryDictValueByDictId(dictId, start, limit);
            response.setTotal(Long.valueOf(pager.getTotalElements()));
            response.setRows(pager.getContent());
        }
        catch (Exception ex) {
            this.logger.info((Object)ex, (Throwable)ex);
            return EasyUIResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }
}

