/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action.zbph;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.http.StringUtils;
import com.geoway.onemap.core.support.http.SysUserUtil;
import com.geoway.onemap.zbph.domain.zbtj.Zbdj;
import com.geoway.onemap.zbph.dto.zbtj.ZbtjZbdjDTO;
import com.geoway.onemap.zbph.service.zbtj.dj.ZbdjManageService;
import com.geoway.onemap.zbph.service.zbtj.dj.ZbdjMxService;
import com.geoway.onemap.zbph.service.zbtj.dj.ZbdjService;
import com.geoway.stxf.action.zbph.BaseXmxxController;
import com.geoway.web.anno.RequireAuth;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@PropertySource(value={"classpath:application-project.properties"})
@Controller
@RequestMapping(value={"/zbph/zbtj/zbdj"})
public class ZBTJZbdjAction
extends BaseXmxxController<Zbdj, ZbdjService, ZbtjZbdjDTO, ZbdjManageService> {
    private static final Logger log = LoggerFactory.getLogger(ZBTJZbdjAction.class);
    @Autowired
    private ZbdjMxService zbdjMxService;

    public ZBTJZbdjAction(ZbdjService xmxxService, ZbdjManageService managerService) {
        super(xmxxService, managerService);
    }

    @RequireAuth
    @RequestMapping(value={"/changeState.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse changeState(HttpServletRequest request, String id, String state) {
        try {
            this.lockUtil.getLock(((Zbdj)((ZbdjService)this.service).getDefault()).getLshType() + id);
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            if (user == null) {
                return BaseObjectResponse.buildFailuaResponse((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)id)) {
                ((ZbdjManageService)this.managerService).changeState(id, state, user);
            }
            return BaseObjectResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            log.error("/zbph/zbtj/zbdj/changeState.do", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/batchFreeze.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse batchFreeze(HttpServletRequest request, String id) {
        try {
            List<String> ids = Arrays.stream(id.split(",")).collect(Collectors.toList());
            ids.forEach(f -> this.lockUtil.getLock(((Zbdj)((ZbdjService)this.service).getDefault()).getLshType() + f));
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            if (user == null) {
                return BaseObjectResponse.buildFailuaResponse((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)id)) {
                ((ZbdjManageService)this.managerService).batchFreeze(ids, user);
            }
            return BaseObjectResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            log.error("/zbph/zbtj/zbdj/changeState.do", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequireAuth
    @RequestMapping(value={"/getStaticNum.json"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse getStaticNum(HttpServletRequest request, String djid) {
        try {
            Map num = null;
            if (StringUtils.isNotBlank((CharSequence)djid)) {
                num = this.zbdjMxService.getStatic(djid);
            }
            BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
            baseObjectResponse.setData((Object)num);
            return baseObjectResponse;
        }
        catch (Exception e) {
            log.error("/zbph/zbtj/zbdj/getStaticNum.json", (Throwable)e);
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/listMxPage.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse listMxPage(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="page", required=false, defaultValue="1") int page, @RequestParam(value="rows", required=false, defaultValue="10") int rows) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            Page pages = this.zbdjMxService.queryByFilter(filterParam, sortParam, page, rows);
            response.setTotal(Long.valueOf(pages.getTotalElements()));
            response.setRows(pages.getContent());
        }
        catch (Exception ex) {
            log.error("/zbph/zbtj/zbdj/listMxPage.json", (Throwable)ex);
            return EasyUIResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }
}

